/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.efcbl.domain;

import de.effectivecompany.base.efcbl.domain.BOxMapper;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.XmlMappingException;

public class BOxMapperImpl
implements BOxMapper {
    private static final Logger LOG = LoggerFactory.getLogger((String)"BOxMapperImpl");
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;

    @Override
    public Object readBOFromXml(String filename) throws IOException {
        try (FileInputStream fis = new FileInputStream(filename);){
            Object object = this.readBOFromXml(fis);
            return object;
        }
    }

    @Override
    public void writeBOToXml(Object object, String filename) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(filename);){
            this.writeBOToXml(object, fos);
        }
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public Unmarshaller getUnmarshaller() {
        return this.unmarshaller;
    }

    public void setUnmarshaller(Unmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    @Override
    public void writeBOToXml(Object object, OutputStream output) throws IOException {
        try {
            this.marshaller.marshal(object, (Result)new StreamResult(output));
        }
        catch (XmlMappingException e) {
            LOG.error("Xml-Serialization failed due to an XmlMappingException.", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("Xml-Serialization failed due to an IOException.", (Throwable)e);
        }
    }

    @Override
    public Object readBOFromXml(InputStream input) throws IOException {
        try {
            return this.unmarshaller.unmarshal((Source)new StreamSource(input));
        }
        catch (IOException e) {
            LOG.error("Xml-Deserialization failed due to an IOException.", (Throwable)e);
            return null;
        }
    }
}

