/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.gui.data;

import de.effectivecompany.base.datatypes.Type;
import de.effectivecompany.base.gui.data.SearchList;
import de.effectivecompany.base.gui.data.SearchResultList;
import de.effectivecompany.base.gui.data.SearchService;
import de.effectivecompany.base.gui.filter.Filter;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DefaultSearchService
implements SearchService {
    private String id = "Not defined";
    protected Map<String, SearchList> searchlists = new LinkedHashMap<String, SearchList>();

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public SearchService.SearchMetaInfo getSearchListMetaInfo(String listId) {
        SearchService.SearchMetaInfo metaInfo = new SearchService.SearchMetaInfo();
        if (listId.equals(this.getDefaultSearchList())) {
            metaInfo.setDefault(true);
        }
        metaInfo.setArchiveSearch(this.searchlists.get(listId).allowArchiveSearch());
        metaInfo.setDeletedSearch(this.searchlists.get(listId).allowDeletedSearch());
        metaInfo.setId(this.searchlists.get(listId).getId());
        metaInfo.setFields(new LinkedList<SearchService.SearchColumnInfo>());
        LinkedList<String> fieldnames = this.searchlists.get(listId).getSearchableFieldNames();
        LinkedList<Class<? extends Type>> fieldclass = this.searchlists.get(listId).getSearchableFieldClasses();
        Map<String, String> optionClasses = this.searchlists.get(listId).getSearchableOptionClasses();
        for (int i = 0; i < fieldnames.size(); ++i) {
            SearchService.SearchColumnInfo colInfo = new SearchService.SearchColumnInfo();
            colInfo.setName(fieldnames.get(i));
            colInfo.setClazz(fieldclass.get(i));
            colInfo.setOptionClass(optionClasses.get(colInfo.getName()));
            metaInfo.getFields().add(colInfo);
        }
        return metaInfo;
    }

    @Override
    public List<String> getSearchListIds() {
        return new LinkedList<String>(this.searchlists.keySet());
    }

    @Override
    public int getSearchListCount() {
        return this.searchlists.size();
    }

    @Override
    public SearchResultList search(String listId, Filter filter) {
        return this.searchlists.get(listId).search(filter);
    }

    @Override
    public SearchResultList search(String[] orderfields, String listId, Filter filter) {
        return this.searchlists.get(listId).search(orderfields, filter);
    }

    @Override
    public void addSearchList(SearchList list) {
        this.searchlists.put(list.getId(), list);
    }

    @Override
    public void removeSearchList(String listId) {
        this.searchlists.remove(listId);
    }

    @Override
    public void removeSearchList(SearchList list) {
        this.searchlists.remove(list.getId());
    }

    @Override
    public List<SearchService.SearchMetaInfo> getSearchListMetaInfos() {
        LinkedList<SearchService.SearchMetaInfo> ret = new LinkedList<SearchService.SearchMetaInfo>();
        for (String id : this.searchlists.keySet()) {
            ret.add(this.getSearchListMetaInfo(id));
        }
        return ret;
    }

    @Override
    public String getDefaultSearchList() {
        return this.getId();
    }

    @Override
    public SearchService.DcSearchMetaInfo getDcSearchMetaInfo() {
        SearchService.DcSearchMetaInfo dcInfo = new SearchService.DcSearchMetaInfo();
        dcInfo.setId(this.getId());
        dcInfo.setSearchMetaInfos(this.getSearchListMetaInfos());
        return dcInfo;
    }
}

