/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.gui.filter;

import java.io.Serializable;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class FilterCriteria
implements Serializable {
    private static final long serialVersionUID = -7591619438910791762L;
    public static final int C_EQUAL = 0;
    public static final int C_NOT_EQUAL = 1;
    public static final int C_BIGGER = 2;
    public static final int C_BIGGER_OR_EQUAL = 3;
    public static final int C_SMALLER = 4;
    public static final int C_SMALLER_OR_EQUAL = 5;
    public static final int C_IS_LIKE = 6;
    public static final int C_STARTS_WITH = 7;
    public static final int C_ENDS_WITH = 8;
    public static final int C_CONTAINS = 9;
    public static final int C_ISNULL = 10;
    public static final int C_IS_NOT_NULL = 11;
    private String fieldname;
    private int condition;
    private Object value;

    public FilterCriteria(String fieldname, int condition, Object value) {
        this.fieldname = fieldname;
        this.condition = condition;
        this.value = value;
    }

    public FilterCriteria(Node xmldef) {
        NamedNodeMap attrib = xmldef.getAttributes();
        String con = attrib.getNamedItem("type").getTextContent();
        this.fieldname = attrib.getNamedItem("fieldname").getTextContent();
        if ("=".equalsIgnoreCase(con)) {
            this.condition = 0;
        } else if ("!=".equalsIgnoreCase(con)) {
            this.condition = 1;
        } else if ("BIG".equalsIgnoreCase(con)) {
            this.condition = 2;
        } else if ("BOE".equalsIgnoreCase(con)) {
            this.condition = 3;
        } else if ("LES".equalsIgnoreCase(con)) {
            this.condition = 4;
        } else if ("LOE".equalsIgnoreCase(con)) {
            this.condition = 5;
        } else if ("LIKE".equalsIgnoreCase(con)) {
            this.condition = 6;
        } else if ("STARTS".equalsIgnoreCase(con)) {
            this.condition = 7;
        } else if ("ENDS".equalsIgnoreCase(con)) {
            this.condition = 8;
        } else if ("CONTAINS".equalsIgnoreCase(con)) {
            this.condition = 9;
        } else if ("IS NULL".equalsIgnoreCase(con)) {
            this.condition = 10;
        } else if ("IS NOT NULL".equalsIgnoreCase(con)) {
            this.condition = 10;
        }
        this.value = xmldef.getTextContent();
    }

    public int getCondition() {
        return this.condition;
    }

    public void setCondition(int condition) {
        this.condition = condition;
    }

    public String getFieldname() {
        return this.fieldname;
    }

    public void setFieldname(String fieldname) {
        this.fieldname = fieldname;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public String getAsXML() {
        String type = "?";
        switch (this.getCondition()) {
            case 0: {
                type = "=";
                break;
            }
            case 1: {
                type = "!=";
                break;
            }
            case 2: {
                type = "BIG";
                break;
            }
            case 3: {
                type = "BOE";
                break;
            }
            case 4: {
                type = "LES";
                break;
            }
            case 5: {
                type = "LOE";
                break;
            }
            case 6: {
                type = "LIKE";
                break;
            }
            case 7: {
                type = "STARTS";
                break;
            }
            case 8: {
                type = "ENDS";
                break;
            }
            case 9: {
                type = "CONTAINS";
                break;
            }
            case 10: {
                type = "IS NULL";
                break;
            }
            case 11: {
                type = "IS NOT NULL";
            }
        }
        String st = "<criteria type=\"" + type + "\" fieldname=\"" + this.getFieldname() + "\">";
        String val = this.getValue() != null ? this.getValue().toString() : "";
        val = val.replace("<", "&lt;");
        val = val.replace(">", "&gt;");
        st = st + val;
        st = st + "</criteria>";
        return st;
    }

    public String toString() {
        String type = "?";
        switch (this.getCondition()) {
            case 0: {
                type = "=";
                break;
            }
            case 1: {
                type = "!=";
                break;
            }
            case 2: {
                type = ">";
                break;
            }
            case 3: {
                type = ">=";
                break;
            }
            case 4: {
                type = "<";
                break;
            }
            case 5: {
                type = "<=";
                break;
            }
            case 6: {
                type = "LIKE";
                break;
            }
            case 7: {
                type = "STARTS";
                break;
            }
            case 8: {
                type = "ENDS";
                break;
            }
            case 9: {
                type = "CONTAINS";
                break;
            }
            case 10: {
                type = "IS NULL";
                break;
            }
            case 11: {
                type = "IS NOT NULL";
            }
        }
        String val = this.getValue() != null ? this.getValue().toString() : "";
        return "criteria: " + this.getFieldname() + " " + type + " " + val + "\n";
    }
}

