/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.report;

import de.effectivecompany.base.data.LazyLoader;
import de.effectivecompany.base.data.StatisticDataObject;
import java.util.List;
import java.util.Vector;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EfcStatisticDataSource
implements JRRewindableDataSource {
    private static Logger logger = LoggerFactory.getLogger(EfcStatisticDataSource.class);
    public static final String F_DATASET = "dataset";
    public static final Class<?> F_DATASET_CLASS = String.class;
    public static final String F_DATASETKEY = "datasetkey";
    public static final Class<?> F_DATASETKEY_CLASS = Comparable.class;
    public static final String F_GROUP = "group";
    public static final Class<?> F_GROUP_CLASS = String.class;
    public static final String F_GROUPKEY = "groupkey";
    public static final Class<?> F_GROUPKEY_CLASS = Comparable.class;
    public static final String F_VALUE = "value";
    public static final Class<?> F_VALUE_CLASS = Number.class;
    public static final String F_VALUEMIN = "value_min";
    public static final Class<?> F_VALUEMIN_CLASS = Number.class;
    public static final String F_VALUEMAX = "value_max";
    public static final Class<?> F_VALUEMAX_CLASS = Number.class;
    public static final String F_VALUE2 = "value2";
    public static final Class<?> F_VALUE2_CLASS = Number.class;
    private List<ListEntry> listEntries;
    private int current = 0;

    public EfcStatisticDataSource(StatisticDataObject source) {
        logger.error("created new statistic datasource");
        if (source instanceof LazyLoader) {
            LazyLoader loader = (LazyLoader)((Object)source);
            loader.lock();
            if (!loader.isLoaded()) {
                ((LazyLoader)((Object)source)).load();
            }
            loader.unlock();
        }
        this.listEntries = new Vector<ListEntry>();
        for (int dataset = 0; dataset < source.getDatasetCount(); ++dataset) {
            for (int group = 0; group < source.getGroupCount(); ++group) {
                ListEntry e = new ListEntry();
                e.dataset = source.getDatasetName(dataset);
                e.datasetkey = source.getDatasetKey(dataset);
                e.group = source.getGroupName(group);
                e.groupkey = source.getGroupKey(group);
                e.values = source.getValues(dataset, group);
                this.listEntries.add(e);
            }
        }
        logger.debug("number of found entries: " + this.listEntries.size());
    }

    public Object getFieldValue(JRField field) throws JRException {
        ListEntry e = this.listEntries.get(this.current);
        if (field.getName().equals(F_DATASET)) {
            return e.dataset == null ? "" : e.dataset;
        }
        if (field.getName().equals(F_DATASETKEY)) {
            return e.datasetkey;
        }
        if (field.getName().equals(F_GROUP)) {
            return e.group;
        }
        if (field.getName().equals(F_GROUPKEY)) {
            return e.groupkey;
        }
        if (field.getName().equals(F_VALUE)) {
            return e.values[0];
        }
        if (field.getName().equals(F_VALUEMIN)) {
            return e.values[1];
        }
        if (field.getName().equals(F_VALUEMAX)) {
            return e.values[2];
        }
        if (field.getName().equals(F_VALUE2)) {
            return e.values[3];
        }
        throw new JRException("unknown field: " + field.getName());
    }

    public void moveFirst() throws JRException {
        this.current = 0;
    }

    public boolean next() throws JRException {
        if (this.current >= this.listEntries.size() - 1) {
            return false;
        }
        ++this.current;
        return true;
    }

    private class ListEntry {
        private String dataset;
        private String datasetkey;
        private String group;
        private String groupkey;
        private Number[] values;

        private ListEntry() {
        }
    }
}

