/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.security;

import de.effectivecompany.base.efcbl.error.SystemException;
import de.effectivecompany.base.security.GeneratedCert;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import java.util.Date;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;

public class SecUtils {
    private static String DELIMITER = "_W&G%DEL#";

    public static final String getUsername(UsernamePasswordAuthenticationToken token) {
        String[] splitStr = token.getName().split(DELIMITER);
        String ret = "";
        if (splitStr.length > 0) {
            ret = splitStr[0];
        }
        return ret;
    }

    public static final String getUsername(String token) {
        String[] splitStr = token.split(DELIMITER);
        String ret = "";
        if (splitStr.length > 0) {
            ret = splitStr[0];
        }
        return ret;
    }

    public static final String getCompany(UsernamePasswordAuthenticationToken token) {
        String[] splitStr = token.getName().split(DELIMITER);
        String ret = "";
        if (splitStr.length > 1) {
            ret = splitStr[1];
        }
        return ret;
    }

    public static final String getCompany(String token) {
        String[] splitStr = token.split(DELIMITER);
        String ret = "";
        if (splitStr.length > 1) {
            ret = splitStr[1];
        }
        return ret;
    }

    public static final String encodeUserAndCompany(String user, String company) {
        return user + DELIMITER + company;
    }

    public static final String encodePassword(String plainPassword) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new SystemException("0", e.getMessage());
        }
        try {
            md.update(plainPassword.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new SystemException("0", e.getMessage());
        }
        return new String(Hex.encodeHex((byte[])md.digest()));
    }

    public static String encrypt(String plainText, String key) {
        String erg = "";
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding", "SunJCE");
            SecretKeySpec secretKey = new SecretKeySpec(Base64.getDecoder().decode(key.getBytes(StandardCharsets.UTF_8)), "AES");
            String iv = "gALMpdasalkewLMC";
            cipher.init(1, (Key)secretKey, new IvParameterSpec(iv.getBytes(StandardCharsets.UTF_8)));
            erg = new String(Base64.getEncoder().encode(cipher.doFinal(plainText.getBytes(StandardCharsets.UTF_8))));
        }
        catch (Exception e) {
            throw new SystemException("0", e.getMessage());
        }
        return erg;
    }

    public static String decrypt(String cipherText, String key) {
        String erg = "";
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding", "SunJCE");
            SecretKeySpec secretKey = new SecretKeySpec(Base64.getDecoder().decode(key.getBytes(StandardCharsets.UTF_8)), "AES");
            String iv = "gALMpdasalkewLMC";
            cipher.init(2, (Key)secretKey, new IvParameterSpec(iv.getBytes(StandardCharsets.UTF_8)));
            erg = new String(cipher.doFinal(Base64.getDecoder().decode(cipherText.getBytes(StandardCharsets.UTF_8))));
        }
        catch (Exception e) {
            throw new SystemException("0", e.getMessage());
        }
        return erg;
    }

    public static byte[] generateKey() throws NoSuchAlgorithmException {
        KeyGenerator generator = KeyGenerator.getInstance("AES");
        generator.init(128);
        SecretKey encryptionKey = generator.generateKey();
        return Base64.getEncoder().encode(encryptionKey.getEncoded());
    }

    public static GeneratedCert createCertificate(String cnName, String domain, GeneratedCert issuer, boolean isCA) throws Exception {
        PrivateKey issuerKey;
        X500Name issuerName;
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        KeyPair certKeyPair = keyGen.generateKeyPair();
        X500Name name = new X500Name("CN=" + cnName);
        BigInteger serialNumber = BigInteger.valueOf(System.currentTimeMillis());
        Instant validFrom = Instant.now();
        Instant validUntil = validFrom.plus(3600L, ChronoUnit.DAYS);
        if (issuer == null) {
            issuerName = name;
            issuerKey = certKeyPair.getPrivate();
        } else {
            issuerName = new X500Name(issuer.certificate.getSubjectDN().getName());
            issuerKey = issuer.privateKey;
        }
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(issuerName, serialNumber, Date.from(validFrom), Date.from(validUntil), name, certKeyPair.getPublic());
        if (isCA) {
            builder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(isCA));
        }
        if (domain != null) {
            builder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)new GeneralNames(new GeneralName(2, domain)));
        }
        ContentSigner signer = new JcaContentSignerBuilder("SHA256WithRSA").build(issuerKey);
        X509CertificateHolder certHolder = builder.build(signer);
        X509Certificate cert = new JcaX509CertificateConverter().getCertificate(certHolder);
        return new GeneratedCert(certKeyPair.getPrivate(), cert);
    }
}

