/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.util;

import de.effectivecompany.base.datatypes.EFCMap;
import de.effectivecompany.base.util.StringUtil;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectUtil2 {
    private static Logger logger = LoggerFactory.getLogger(ObjectUtil2.class);
    public static EFCMap<String, MethodHandle> getterMethodCache = new EFCMap();
    public static EFCMap<String, MethodHandle> setterMethodCache = new EFCMap();

    public static String convertListToFirstUpper(String name) {
        if (name.endsWith("list")) {
            Object ret = name.substring(0, name.length() - 4);
            ret = (String)ret + "List";
            return ret;
        }
        return name;
    }

    public static Object getObjectAttributeByName(Object src, String attrName) {
        if (src == null) {
            throw new NullPointerException("source object is null");
        }
        if (attrName == null) {
            throw new NullPointerException("attribute name is null");
        }
        String defaultGetterName = StringUtil.getterName(attrName);
        String boolGetterName = StringUtil.getterName(attrName, Boolean.class);
        String className = src.getClass().getName() + ".";
        MethodHandle getterMethod = null;
        String getterKey = null;
        getterKey = className + defaultGetterName;
        getterMethod = (MethodHandle)getterMethodCache.get(getterKey);
        if (getterMethod == null) {
            getterKey = className + boolGetterName;
            getterMethod = (MethodHandle)getterMethodCache.get(className + boolGetterName);
        }
        if (getterMethod == null) {
            Method[] methods;
            for (Method method : methods = src.getClass().getMethods()) {
                if (method.getName().equalsIgnoreCase(defaultGetterName) && method.getParameterTypes().length == 0) {
                    try {
                        MethodType mt = MethodType.methodType(method.getReturnType());
                        getterMethod = MethodHandles.publicLookup().findVirtual(src.getClass(), method.getName(), mt);
                    }
                    catch (Throwable e) {
                        throw new RuntimeException("method call failed", e);
                    }
                    getterKey = className + defaultGetterName;
                    getterMethodCache.put(getterKey, getterMethod);
                    break;
                }
                if (!method.getName().equalsIgnoreCase(boolGetterName) || method.getParameterTypes().length != 0) continue;
                try {
                    MethodType mt = MethodType.methodType(method.getReturnType());
                    getterMethod = MethodHandles.publicLookup().findVirtual(src.getClass(), method.getName(), mt);
                }
                catch (Throwable e) {
                    throw new RuntimeException("method call failed", e);
                }
                getterKey = className + boolGetterName;
                getterMethodCache.put(getterKey, getterMethod);
                break;
            }
        }
        if (getterMethod == null) {
            throw new NullPointerException("could not find getter for attribute '" + attrName + "' on class " + src.getClass().getName());
        }
        try {
            Object returnValue = getterMethod.invoke(src);
            return returnValue;
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        catch (Throwable ex) {
            throw new RuntimeException("method call failed", ex);
        }
        return null;
    }

    public static void setObjectAttrBySetter(Object src, String attrName, Object value) {
        if (src == null) {
            throw new NullPointerException("source object is null");
        }
        if (attrName == null) {
            throw new NullPointerException("attribute name is null");
        }
        Method[] methods = src.getClass().getMethods();
        String setterName = StringUtil.setterName(attrName);
        String className = src.getClass().getName() + ".";
        MethodHandle setterMethod = null;
        setterMethod = (MethodHandle)setterMethodCache.get(className + setterName);
        if (setterMethod == null) {
            for (Method method : methods) {
                Class<?>[] params = method.getParameterTypes();
                if (!method.getName().equalsIgnoreCase(setterName) || params.length != 1 || value != null && !params[0].isAssignableFrom(value.getClass())) continue;
                try {
                    MethodType mt = null;
                    if (value == null) {
                        Class<?>[] pType = method.getParameterTypes();
                        mt = MethodType.methodType(method.getReturnType(), pType[0]);
                    } else {
                        mt = MethodType.methodType(method.getReturnType(), value.getClass());
                    }
                    setterMethod = MethodHandles.publicLookup().findVirtual(src.getClass(), method.getName(), mt);
                }
                catch (Throwable e) {
                    throw new RuntimeException("method call failed", e);
                }
                setterMethodCache.put(className + setterName, setterMethod);
                break;
            }
        }
        if (setterMethod == null) {
            throw new NullPointerException("could not find setter for attribute '" + attrName + "' on class " + src.getClass().getName());
        }
        try {
            setterMethod.invoke(src, value);
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        catch (Throwable ex) {
            throw new RuntimeException("method call failed", ex);
        }
    }

    public static Object getAttributeByDomainName(String domain, Object object) {
        Object value = null;
        if (object != null) {
            int dotindex = domain.indexOf(".");
            if (dotindex == -1) {
                return ObjectUtil2.getObjectAttributeByName(object, domain);
            }
            String newDomain = domain.substring(dotindex + 1);
            String objectName = domain.substring(0, dotindex);
            String className = object.getClass().getName() + ".";
            try {
                Object newObject;
                MethodHandle getter = (MethodHandle)getterMethodCache.get(className + objectName);
                if (getter == null) {
                    String getterName = StringUtil.getterName(objectName);
                    MethodType mt = MethodType.methodType(object.getClass().getMethod(getterName, null).getReturnType());
                    getter = MethodHandles.publicLookup().findVirtual(object.getClass(), getterName, mt);
                    getterMethodCache.put(className + objectName, getter);
                }
                if ((newObject = getter.invoke(object)) instanceof List || newObject instanceof Map) {
                    return null;
                }
                return ObjectUtil2.getAttributeByDomainName(newDomain, newObject);
            }
            catch (Throwable e) {
                try {
                    MethodHandle getter = (MethodHandle)getterMethodCache.get(className + objectName);
                    if (getter == null) {
                        String getterName = StringUtil.getterName(objectName, Boolean.class);
                        MethodType mt = MethodType.methodType(object.getClass().getMethod(getterName, null).getReturnType());
                        getter = MethodHandles.publicLookup().findVirtual(object.getClass(), getterName, mt);
                        getterMethodCache.put(className + objectName, getter);
                    }
                    Object newObject = getter.invoke(object);
                    return ObjectUtil2.getAttributeByDomainName(newDomain, newObject);
                }
                catch (NoSuchMethodException e1) {
                    e.printStackTrace();
                }
                catch (Throwable e2) {
                    e.printStackTrace();
                }
            }
        }
        return value;
    }

    public static Object getListByDomainName(String domain, Object object) {
        Object value = null;
        if (object != null) {
            int dotindex = domain.indexOf(".");
            if (dotindex == -1) {
                return ObjectUtil2.getObjectAttributeByName(object, domain);
            }
            String newDomain = domain.substring(dotindex + 1);
            String objectName = domain.substring(0, dotindex);
            String className = object.getClass().getName() + ".";
            try {
                MethodHandle getter = (MethodHandle)getterMethodCache.get(className + objectName);
                if (getter == null) {
                    String getterName = StringUtil.getterName(objectName);
                    MethodType mt = MethodType.methodType(object.getClass().getMethod(getterName, null).getReturnType());
                    getter = MethodHandles.publicLookup().findVirtual(object.getClass(), getterName, mt);
                    getterMethodCache.put(className + objectName, getter);
                }
                Object newObject = getter.invoke(object);
                return ObjectUtil2.getListByDomainName(newDomain, newObject);
            }
            catch (Throwable e) {
                try {
                    MethodHandle getter = (MethodHandle)getterMethodCache.get(className + objectName);
                    if (getter == null) {
                        String getterName = StringUtil.getterName(objectName, Boolean.class);
                        MethodType mt = MethodType.methodType(object.getClass().getMethod(getterName, null).getReturnType());
                        getter = MethodHandles.publicLookup().findVirtual(object.getClass(), getterName, mt);
                        getterMethodCache.put(className + objectName, getter);
                    }
                    Object newObject = getter.invoke(object);
                    return ObjectUtil2.getListByDomainName(newDomain, newObject);
                }
                catch (NoSuchMethodException e1) {
                    e.printStackTrace();
                }
                catch (Throwable th) {
                    e.printStackTrace();
                }
            }
        }
        return value;
    }

    public static boolean setAttrByDomainViaSetter(String domain, Object object, Object newValue) {
        logger.debug("ObjectTree.setAttrByDomainViaSetter()");
        if (object != null) {
            int dotindex = domain.indexOf(".");
            if (dotindex == -1) {
                ObjectUtil2.setObjectAttrBySetter(object, domain, newValue);
            } else {
                String newDomain = domain.substring(dotindex + 1);
                String objectName = domain.substring(0, dotindex);
                try {
                    try {
                        logger.debug("calling getter");
                        Method getter = object.getClass().getMethod(StringUtil.getterName(objectName), null);
                        Object newObject = getter.invoke(object, (Object[])null);
                        if (newObject instanceof List || newObject instanceof Map) {
                            throw new IllegalArgumentException("tree contains a list or map");
                        }
                        return ObjectUtil2.setAttrByDomainViaSetter(newDomain, newObject, newValue);
                    }
                    catch (NoSuchMethodException e) {
                        try {
                            Method getter = object.getClass().getMethod(StringUtil.getterName(objectName, Boolean.class), null);
                            Object newObject = getter.invoke(object, (Object[])null);
                            return ObjectUtil2.setAttrByDomainViaSetter(newDomain, newObject, newValue);
                        }
                        catch (NoSuchMethodException e1) {
                            return false;
                        }
                    }
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    public static void flushCaches() {
        logger.debug("ObjectUtil2: flushing caches...");
        getterMethodCache.clear();
        setterMethodCache.clear();
    }
}

