/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.model;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Objects;

public final class Interval {
    private static final LocalDate defaultDate = LocalDate.now();
    private static final LocalTime defaultStartTime = LocalTime.of(12, 0);
    private static final LocalTime defaultEndTime = LocalTime.of(13, 0);
    private static final ZoneId defaultZoneId = ZoneId.systemDefault();
    private final LocalDate startDate;
    private final LocalDate endDate;
    private final LocalTime startTime;
    private final LocalTime endTime;
    private ZonedDateTime zonedStartDateTime;
    private ZonedDateTime zonedEndDateTime;
    private LocalDateTime startDateTime;
    private LocalDateTime endDateTime;
    private final ZoneId zoneId;
    private long startMillis = Long.MIN_VALUE;
    private long endMillis = Long.MAX_VALUE;

    public Interval() {
        this(defaultDate, defaultStartTime, defaultDate, defaultEndTime, defaultZoneId);
    }

    public Interval(LocalDate startDate, LocalTime startTime, LocalDate endDate, LocalTime endTime) {
        this(startDate, startTime, endDate, endTime, defaultZoneId);
    }

    public Interval(LocalDateTime startDateTime, LocalDateTime endDateTime) {
        this(startDateTime, endDateTime, ZoneId.systemDefault());
    }

    public Interval(ZonedDateTime zonedStartDateTime, ZonedDateTime zonedEndDateTime) {
        this(zonedStartDateTime.toLocalDateTime(), zonedEndDateTime.toLocalDateTime(), zonedStartDateTime.getZone());
        if (!zonedStartDateTime.getZone().equals(zonedEndDateTime.getZone())) {
            throw new IllegalArgumentException("the zoned start and end times use different time zones, zone1 = " + zonedStartDateTime.getZone() + ", zone2 = " + zonedEndDateTime.getZone());
        }
    }

    public Interval(LocalDateTime startDateTime, LocalDateTime endDateTime, ZoneId zoneId) {
        this(startDateTime.toLocalDate(), startDateTime.toLocalTime(), endDateTime.toLocalDate(), endDateTime.toLocalTime(), zoneId);
    }

    public Interval(Instant startTime, Instant endTime, ZoneId zoneId) {
        this(ZonedDateTime.ofInstant(startTime, zoneId), ZonedDateTime.ofInstant(endTime, zoneId));
    }

    public Interval(LocalDate startDate, LocalTime startTime, LocalDate endDate, LocalTime endTime, ZoneId zoneId) {
        this.startDate = Objects.requireNonNull(startDate);
        this.startTime = Objects.requireNonNull(startTime);
        this.endDate = Objects.requireNonNull(endDate);
        this.endTime = Objects.requireNonNull(endTime);
        this.zoneId = Objects.requireNonNull(zoneId);
        if (startDate.isAfter(endDate)) {
            throw new IllegalArgumentException("the start date can never be after the end date");
        }
        if (startDate.equals(endDate) && this.getStartTime().isAfter(this.getEndTime())) {
            throw new IllegalArgumentException("the start time can not be after the end time if both are on the same date");
        }
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public LocalTime getStartTime() {
        return this.startTime;
    }

    public ZonedDateTime getStartZonedDateTime() {
        if (this.zonedStartDateTime == null) {
            this.zonedStartDateTime = ZonedDateTime.of(this.startDate, this.startTime, this.zoneId);
        }
        return this.zonedStartDateTime;
    }

    public long getStartMillis() {
        if (this.startMillis == Long.MIN_VALUE) {
            this.startMillis = this.getStartZonedDateTime().toInstant().toEpochMilli();
        }
        return this.startMillis;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public LocalTime getEndTime() {
        return this.endTime;
    }

    public ZonedDateTime getEndZonedDateTime() {
        if (this.zonedEndDateTime == null) {
            this.zonedEndDateTime = ZonedDateTime.of(this.endDate, this.endTime, this.zoneId);
        }
        return this.zonedEndDateTime;
    }

    public long getEndMillis() {
        if (this.endMillis == Long.MAX_VALUE) {
            this.endMillis = this.getEndZonedDateTime().toInstant().toEpochMilli();
        }
        return this.endMillis;
    }

    public Interval withDates(LocalDate startDate, LocalDate endDate) {
        Objects.requireNonNull(startDate);
        Objects.requireNonNull(endDate);
        return new Interval(startDate, this.startTime, endDate, this.endTime, this.zoneId);
    }

    public Interval withDates(LocalDateTime startDateTime, LocalDateTime endDateTime) {
        Objects.requireNonNull(startDateTime);
        Objects.requireNonNull(endDateTime);
        return new Interval(startDateTime, endDateTime, this.zoneId);
    }

    public Interval withTimes(LocalTime startTime, LocalTime endTime) {
        Objects.requireNonNull(startTime);
        Objects.requireNonNull(endTime);
        return new Interval(this.startDate, startTime, this.endDate, endTime, this.zoneId);
    }

    public Interval withStartDate(LocalDate date) {
        Objects.requireNonNull(date);
        return new Interval(date, this.startTime, this.endDate, this.endTime, this.zoneId);
    }

    public Interval withEndDate(LocalDate date) {
        Objects.requireNonNull(date);
        return new Interval(this.startDate, this.startTime, date, this.endTime, this.zoneId);
    }

    public Interval withStartTime(LocalTime time) {
        Objects.requireNonNull(time);
        return new Interval(this.startDate, time, this.endDate, this.endTime, this.zoneId);
    }

    public Interval withStartDateTime(LocalDateTime dateTime) {
        Objects.requireNonNull(dateTime);
        return new Interval(dateTime.toLocalDate(), dateTime.toLocalTime(), this.endDate, this.endTime);
    }

    public Interval withEndTime(LocalTime time) {
        Objects.requireNonNull(time);
        return new Interval(this.startDate, this.startTime, this.endDate, time, this.zoneId);
    }

    public Interval withEndDateTime(LocalDateTime dateTime) {
        Objects.requireNonNull(dateTime);
        return new Interval(this.startDate, this.startTime, dateTime.toLocalDate(), dateTime.toLocalTime());
    }

    public Interval withZoneId(ZoneId zone) {
        Objects.requireNonNull(zone);
        return new Interval(this.startDate, this.startTime, this.endDate, this.endTime, zone);
    }

    public Interval withDuration(Duration duration) {
        Objects.requireNonNull(duration);
        ZonedDateTime zonedDateTime = ZonedDateTime.of(this.getStartDate(), this.getStartTime(), this.getZoneId()).plus(duration);
        return new Interval(this.startDate, this.startTime, zonedDateTime.toLocalDate(), zonedDateTime.toLocalTime(), this.getZoneId());
    }

    public LocalDateTime getStartDateTime() {
        if (this.startDateTime == null) {
            this.startDateTime = LocalDateTime.of(this.getStartDate(), this.getStartTime());
        }
        return this.startDateTime;
    }

    public Duration getDuration() {
        return Duration.between(this.getStartZonedDateTime(), this.getEndZonedDateTime());
    }

    public LocalDateTime getEndDateTime() {
        if (this.endDateTime == null) {
            this.endDateTime = LocalDateTime.of(this.getEndDate(), this.getEndTime());
        }
        return this.endDateTime;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.endDate == null ? 0 : this.endDate.hashCode());
        result = 31 * result + (this.endTime == null ? 0 : this.endTime.hashCode());
        result = 31 * result + (this.startDate == null ? 0 : this.startDate.hashCode());
        result = 31 * result + (this.startTime == null ? 0 : this.startTime.hashCode());
        result = 31 * result + (this.zoneId == null ? 0 : this.zoneId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Interval other = (Interval)obj;
        if (this.endDate == null ? other.endDate != null : !this.endDate.equals(other.endDate)) {
            return false;
        }
        if (this.endTime == null ? other.endTime != null : !this.endTime.equals(other.endTime)) {
            return false;
        }
        if (this.startDate == null ? other.startDate != null : !this.startDate.equals(other.startDate)) {
            return false;
        }
        if (this.startTime == null ? other.startTime != null : !this.startTime.equals(other.startTime)) {
            return false;
        }
        if (this.zoneId == null) {
            return other.zoneId == null;
        }
        return this.zoneId.equals(other.zoneId);
    }

    public String toString() {
        return "Interval [startDate=" + this.startDate + ", endDate=" + this.endDate + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", zoneId=" + this.zoneId + "]";
    }
}

