/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.model;

import com.calendarfx.model.Entry;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

class IntervalTree<E extends Entry<?>> {
    private TreeEntry<E> root;
    private int treeSize;
    private final Set<String> entryIDs = new HashSet<String>();
    private static final boolean RED = false;
    private static final boolean BLACK = true;

    IntervalTree() {
    }

    public final Instant getEarliestTimeUsed() {
        if (this.root != null) {
            return Instant.ofEpochMilli(this.getEarliestTimeUsed(this.root));
        }
        return null;
    }

    private long getEarliestTimeUsed(TreeEntry<E> entry) {
        if (entry.getLeft() != null) {
            return this.getEarliestTimeUsed(entry.getLeft());
        }
        return entry.low;
    }

    public final Instant getLatestTimeUsed() {
        if (this.root != null) {
            return Instant.ofEpochMilli(this.getLatestTimeUsed(this.root));
        }
        return null;
    }

    private long getLatestTimeUsed(TreeEntry<E> entry) {
        if (entry.getRight() != null) {
            return this.getLatestTimeUsed(entry.getRight());
        }
        return entry.high;
    }

    public final boolean add(E entry) {
        TreeEntry<E> e = this.addEntry(entry);
        return e != null;
    }

    public final boolean remove(E entry) {
        TreeEntry<E> e = this.getEntry((Entry<?>)entry);
        if (e == null) {
            return false;
        }
        this.deleteEntry(e);
        return true;
    }

    public final boolean contains(E entry) {
        TreeEntry<E> e = this.getEntry((Entry<?>)entry);
        return e != null;
    }

    public final Collection<E> removePeriod(Instant start, Instant end) {
        Collection<E> result = this.getIntersectingObjects(start, end);
        for (Entry p : result) {
            this.deleteEntry(this.getEntry(p));
        }
        return result;
    }

    public final Collection<E> getIntersectingObjects(Instant start, Instant end) {
        ArrayList result = new ArrayList();
        if (this.root == null) {
            return result;
        }
        this.searchIntersecting(this.root, new TimeInterval(start, end), result);
        return result;
    }

    private void searchIntersecting(TreeEntry<E> entry, TimeInterval timeInterval, Collection<E> result) {
        if (entry == null) {
            return;
        }
        long pLow = this.getLow(timeInterval);
        long pHigh = this.getHigh(timeInterval);
        if (entry.maxHigh < pLow) {
            return;
        }
        if (entry.left != null) {
            this.searchIntersecting(entry.left, timeInterval, result);
        }
        if (this.checkPLow(entry, pLow) || this.checkPHigh(entry, pHigh) || pLow <= entry.low && entry.high <= pHigh) {
            result.add((Entry)entry.value);
        }
        if (pHigh < entry.low) {
            return;
        }
        if (entry.right != null) {
            this.searchIntersecting(entry.right, timeInterval, result);
        }
    }

    private boolean checkPLow(TreeEntry<E> n, long pLow) {
        return n.low <= pLow && n.high > pLow;
    }

    private boolean checkPHigh(TreeEntry<E> n, long pHigh) {
        return n.low < pHigh && n.high >= pHigh;
    }

    public final long size() {
        return this.treeSize;
    }

    public final void clear() {
        this.treeSize = 0;
        this.root = null;
    }

    private long getLow(TimeInterval obj) {
        try {
            return obj.getStartTime() == null ? Long.MIN_VALUE : obj.getStartTime().toEpochMilli();
        }
        catch (Exception e) {
            return Long.MAX_VALUE;
        }
    }

    private long getHigh(TimeInterval interval) {
        try {
            return interval.getEndTime() == null ? Long.MAX_VALUE : interval.getEndTime().toEpochMilli();
        }
        catch (ArithmeticException e) {
            return Long.MAX_VALUE;
        }
    }

    private long getLow(Entry<?> entry) {
        try {
            return entry.getStartMillis();
        }
        catch (ArithmeticException e) {
            return Long.MAX_VALUE;
        }
    }

    private long getHigh(Entry<?> entry) {
        try {
            return entry.isRecurring() ? ZonedDateTime.of(entry.getRecurrenceEnd(), LocalTime.MAX, entry.getZoneId()).toInstant().toEpochMilli() : entry.getEndMillis();
        }
        catch (ArithmeticException e) {
            return Long.MAX_VALUE;
        }
    }

    private void fixUpMaxHigh(TreeEntry<E> entry) {
        while (entry != null) {
            entry.maxHigh = Math.max(entry.high, Math.max(entry.left != null ? entry.left.maxHigh : Long.MIN_VALUE, entry.right != null ? entry.right.maxHigh : Long.MIN_VALUE));
            entry = entry.parent;
        }
    }

    private TreeEntry<E> getEntry(Entry<?> entry) {
        TreeEntry<Object> t = this.root;
        while (t != null) {
            int cmp = IntervalTree.compareLongs(this.getLow(entry), t.low);
            if (cmp == 0) {
                cmp = IntervalTree.compareLongs(this.getHigh(entry), t.high);
            }
            if (cmp == 0) {
                cmp = entry.hashCode() - ((Entry)t.value).hashCode();
            }
            if (cmp < 0) {
                t = t.left;
                continue;
            }
            if (cmp > 0) {
                t = t.right;
                continue;
            }
            return t;
        }
        return null;
    }

    private TreeEntry<E> addEntry(E entry) {
        long cmp;
        TreeEntry<E> parent;
        Objects.requireNonNull(entry, "null entry is not supported");
        String id = ((Entry)entry).getId();
        if (this.entryIDs.contains(id)) {
            // empty if block
        }
        this.entryIDs.add(id);
        TreeEntry<Object> t = this.root;
        if (t == null) {
            this.root = new TreeEntry<E>(this.getLow((Entry<?>)entry), this.getHigh((Entry<?>)entry), entry, null);
            this.treeSize = 1;
            return this.root;
        }
        do {
            parent = t;
            cmp = IntervalTree.compareLongs(this.getLow((Entry<?>)entry), t.low);
            if (cmp == 0L && (cmp = (long)IntervalTree.compareLongs(this.getHigh((Entry<?>)entry), t.high)) == 0L) {
                cmp = ((Entry)entry).hashCode() - ((Entry)t.value).hashCode();
            }
            if (cmp < 0L) {
                t = t.left;
                continue;
            }
            if (cmp > 0L) {
                t = t.right;
                continue;
            }
            return null;
        } while (t != null);
        TreeEntry<E> e = new TreeEntry<E>(this.getLow((Entry<?>)entry), this.getHigh((Entry<?>)entry), entry, parent);
        if (cmp < 0L) {
            parent.left = e;
        } else {
            parent.right = e;
        }
        this.fixAfterInsertion(e);
        ++this.treeSize;
        return e;
    }

    private static int compareLongs(long val1, long val2) {
        return val1 < val2 ? -1 : (val1 == val2 ? 0 : 1);
    }

    private static <V> TreeEntry<V> successor(TreeEntry<V> t) {
        if (t == null) {
            return null;
        }
        if (t.right != null) {
            TreeEntry p = t.right;
            while (p.left != null) {
                p = p.left;
            }
            return p;
        }
        TreeEntry p = t.parent;
        TreeEntry<V> ch = t;
        while (p != null && ch == p.right) {
            ch = p;
            p = p.parent;
        }
        return p;
    }

    private static <V> boolean colorOf(TreeEntry<V> p) {
        return p == null ? true : p.color;
    }

    private static <V> TreeEntry<V> parentOf(TreeEntry<V> p) {
        return p == null ? null : p.parent;
    }

    private static <V> void setColor(TreeEntry<V> p, boolean c) {
        if (p != null) {
            p.color = c;
        }
    }

    private static <V> TreeEntry<V> leftOf(TreeEntry<V> p) {
        return p == null ? null : p.left;
    }

    private static <V> TreeEntry<V> rightOf(TreeEntry<V> p) {
        return p == null ? null : p.right;
    }

    private void rotateLeft(TreeEntry<E> p) {
        if (p != null) {
            TreeEntry r = p.right;
            p.right = r.left;
            if (r.left != null) {
                r.left.parent = p;
            }
            r.parent = p.parent;
            if (p.parent == null) {
                this.root = r;
            } else if (p.parent.left == p) {
                p.parent.left = r;
            } else {
                p.parent.right = r;
            }
            r.left = p;
            p.parent = r;
            p.maxHigh = Math.max(p.left != null ? p.left.maxHigh : Long.MIN_VALUE, Math.max(p.right != null ? p.right.maxHigh : Long.MIN_VALUE, p.high));
            r.maxHigh = Math.max(p.maxHigh, Math.max(r.right != null ? r.right.maxHigh : Long.MIN_VALUE, r.high));
        }
    }

    private void rotateRight(TreeEntry<E> p) {
        if (p != null) {
            TreeEntry l = p.left;
            p.left = l.right;
            if (l.right != null) {
                l.right.parent = p;
            }
            l.parent = p.parent;
            if (p.parent == null) {
                this.root = l;
            } else if (p.parent.right == p) {
                p.parent.right = l;
            } else {
                p.parent.left = l;
            }
            l.right = p;
            p.parent = l;
            p.maxHigh = Math.max(p.left != null ? p.left.maxHigh : Long.MIN_VALUE, Math.max(p.right != null ? p.right.maxHigh : Long.MIN_VALUE, p.high));
            l.maxHigh = Math.max(p.maxHigh, Math.max(l.left != null ? l.left.maxHigh : Long.MIN_VALUE, l.high));
        }
    }

    private void fixAfterInsertion(TreeEntry<E> x) {
        this.fixUpMaxHigh(x.parent);
        x.color = false;
        while (x != null && x != this.root && !x.parent.color) {
            TreeEntry<E> y;
            if (IntervalTree.parentOf(x) == IntervalTree.leftOf(IntervalTree.parentOf(IntervalTree.parentOf(x)))) {
                y = IntervalTree.rightOf(IntervalTree.parentOf(IntervalTree.parentOf(x)));
                if (!IntervalTree.colorOf(y)) {
                    IntervalTree.setColor(IntervalTree.parentOf(x), true);
                    IntervalTree.setColor(y, true);
                    IntervalTree.setColor(IntervalTree.parentOf(IntervalTree.parentOf(x)), false);
                    x = IntervalTree.parentOf(IntervalTree.parentOf(x));
                    continue;
                }
                if (x == IntervalTree.rightOf(IntervalTree.parentOf(x))) {
                    x = IntervalTree.parentOf(x);
                    this.rotateLeft(x);
                }
                IntervalTree.setColor(IntervalTree.parentOf(x), true);
                IntervalTree.setColor(IntervalTree.parentOf(IntervalTree.parentOf(x)), false);
                this.rotateRight(IntervalTree.parentOf(IntervalTree.parentOf(x)));
                continue;
            }
            y = IntervalTree.leftOf(IntervalTree.parentOf(IntervalTree.parentOf(x)));
            if (!IntervalTree.colorOf(y)) {
                IntervalTree.setColor(IntervalTree.parentOf(x), true);
                IntervalTree.setColor(y, true);
                IntervalTree.setColor(IntervalTree.parentOf(IntervalTree.parentOf(x)), false);
                x = IntervalTree.parentOf(IntervalTree.parentOf(x));
                continue;
            }
            if (x == IntervalTree.leftOf(IntervalTree.parentOf(x))) {
                x = IntervalTree.parentOf(x);
                this.rotateRight(x);
            }
            IntervalTree.setColor(IntervalTree.parentOf(x), true);
            IntervalTree.setColor(IntervalTree.parentOf(IntervalTree.parentOf(x)), false);
            this.rotateLeft(IntervalTree.parentOf(IntervalTree.parentOf(x)));
        }
        this.root.color = true;
    }

    private void deleteEntry(TreeEntry<E> p) {
        TreeEntry replacement;
        this.entryIDs.remove(((Entry)p.value).getId());
        --this.treeSize;
        if (p.left != null && p.right != null) {
            TreeEntry<E> s = IntervalTree.successor(p);
            p.low = s.low;
            p.high = s.high;
            p.value = s.value;
            p.maxHigh = s.maxHigh;
            p = s;
        }
        TreeEntry treeEntry = replacement = p.left != null ? p.left : p.right;
        if (replacement != null) {
            replacement.parent = p.parent;
            if (p.parent == null) {
                this.root = replacement;
            } else if (p == p.parent.left) {
                p.parent.left = replacement;
            } else {
                p.parent.right = replacement;
            }
            p.left = null;
            p.right = null;
            p.parent = null;
            this.fixUpMaxHigh(replacement.parent);
            if (p.color) {
                this.fixAfterDeletion(replacement);
            }
        } else if (p.parent == null) {
            this.root = null;
        } else {
            if (p.color) {
                this.fixAfterDeletion(p);
            }
            if (p.parent != null) {
                if (p == p.parent.left) {
                    p.parent.left = null;
                } else if (p == p.parent.right) {
                    p.parent.right = null;
                }
                this.fixUpMaxHigh(p.parent);
                p.parent = null;
            }
        }
    }

    private void fixAfterDeletion(TreeEntry<E> x) {
        while (x != this.root && IntervalTree.colorOf(x)) {
            TreeEntry<E> sib;
            if (x == IntervalTree.leftOf(IntervalTree.parentOf(x))) {
                sib = IntervalTree.rightOf(IntervalTree.parentOf(x));
                if (!IntervalTree.colorOf(sib)) {
                    IntervalTree.setColor(sib, true);
                    IntervalTree.setColor(IntervalTree.parentOf(x), false);
                    this.rotateLeft(IntervalTree.parentOf(x));
                    sib = IntervalTree.rightOf(IntervalTree.parentOf(x));
                }
                if (IntervalTree.colorOf(IntervalTree.leftOf(sib)) && IntervalTree.colorOf(IntervalTree.rightOf(sib))) {
                    IntervalTree.setColor(sib, false);
                    x = IntervalTree.parentOf(x);
                    continue;
                }
                if (IntervalTree.colorOf(IntervalTree.rightOf(sib))) {
                    IntervalTree.setColor(IntervalTree.leftOf(sib), true);
                    IntervalTree.setColor(sib, false);
                    this.rotateRight(sib);
                    sib = IntervalTree.rightOf(IntervalTree.parentOf(x));
                }
                IntervalTree.setColor(sib, IntervalTree.colorOf(IntervalTree.parentOf(x)));
                IntervalTree.setColor(IntervalTree.parentOf(x), true);
                IntervalTree.setColor(IntervalTree.rightOf(sib), true);
                this.rotateLeft(IntervalTree.parentOf(x));
                x = this.root;
                continue;
            }
            sib = IntervalTree.leftOf(IntervalTree.parentOf(x));
            if (!IntervalTree.colorOf(sib)) {
                IntervalTree.setColor(sib, true);
                IntervalTree.setColor(IntervalTree.parentOf(x), false);
                this.rotateRight(IntervalTree.parentOf(x));
                sib = IntervalTree.leftOf(IntervalTree.parentOf(x));
            }
            if (IntervalTree.colorOf(IntervalTree.rightOf(sib)) && IntervalTree.colorOf(IntervalTree.leftOf(sib))) {
                IntervalTree.setColor(sib, false);
                x = IntervalTree.parentOf(x);
                continue;
            }
            if (IntervalTree.colorOf(IntervalTree.leftOf(sib))) {
                IntervalTree.setColor(IntervalTree.rightOf(sib), true);
                IntervalTree.setColor(sib, false);
                this.rotateLeft(sib);
                sib = IntervalTree.leftOf(IntervalTree.parentOf(x));
            }
            IntervalTree.setColor(sib, IntervalTree.colorOf(IntervalTree.parentOf(x)));
            IntervalTree.setColor(IntervalTree.parentOf(x), true);
            IntervalTree.setColor(IntervalTree.leftOf(sib), true);
            this.rotateRight(IntervalTree.parentOf(x));
            x = this.root;
        }
        IntervalTree.setColor(x, true);
    }

    private static final class TreeEntry<V> {
        private long low;
        private long high;
        private V value;
        private long maxHigh;
        private TreeEntry<V> left;
        private TreeEntry<V> right;
        private TreeEntry<V> parent;
        private boolean color = true;

        TreeEntry(long low, long high, V value, TreeEntry<V> parent) {
            this.low = low;
            this.high = high;
            this.value = value;
            this.parent = parent;
            this.maxHigh = high;
        }

        public String toString() {
            return "[" + Instant.ofEpochMilli(this.low) + " - " + Instant.ofEpochMilli(this.high) + "]=" + this.value;
        }

        public TreeEntry<V> getLeft() {
            return this.left;
        }

        public TreeEntry<V> getRight() {
            return this.right;
        }
    }

    private class TimeInterval {
        private final Instant startTime;
        private final Instant endTime;

        public TimeInterval(Instant startTime, Instant endTime) {
            Objects.requireNonNull(startTime);
            Objects.requireNonNull(endTime);
            if (startTime.isAfter(endTime)) {
                throw new IllegalArgumentException("start time can not be after end time, start = " + startTime + ", end = " + endTime);
            }
            this.startTime = startTime;
            this.endTime = endTime;
        }

        public Instant getStartTime() {
            return this.startTime;
        }

        public Instant getEndTime() {
            return this.endTime;
        }
    }
}

