/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.model;

import com.calendarfx.model.CalendarSource;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import javafx.event.Event;
import javafx.event.EventType;

public final class LoadEvent
extends Event {
    private static final long serialVersionUID = -2691268182059394731L;
    public static final EventType<LoadEvent> LOAD = new EventType(Event.ANY, "LOAD");
    private final List<CalendarSource> calendarSources;
    private final LocalDate startDate;
    private final LocalDate endDate;
    private final ZoneId zoneId;
    private final String sourceName;

    public LoadEvent(EventType<LoadEvent> eventType, String sourceName, List<CalendarSource> calendarSources, LocalDate startDate, LocalDate endDate, ZoneId zoneId) {
        super(eventType);
        this.sourceName = Objects.requireNonNull(sourceName);
        this.calendarSources = Objects.requireNonNull(calendarSources);
        this.startDate = Objects.requireNonNull(startDate);
        this.endDate = Objects.requireNonNull(endDate);
        this.zoneId = Objects.requireNonNull(zoneId);
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public List<CalendarSource> getCalendarSources() {
        return this.calendarSources;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public ZonedDateTime getStartTime() {
        return ZonedDateTime.of(this.startDate, LocalTime.MIN, this.zoneId);
    }

    public ZonedDateTime getEndTime() {
        return ZonedDateTime.of(this.endDate, LocalTime.MAX, this.zoneId);
    }

    public String toString() {
        return "LoadEvent [sourceName=" + this.sourceName + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", zoneId=" + this.zoneId + ", calendarSources=" + this.calendarSources + "]";
    }
}

