/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.model;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.CalendarSource;
import com.calendarfx.view.Messages;
import java.util.ArrayList;
import java.util.Collection;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class Resource<T> {
    private final InvalidationListener updateCalendarListListener = it -> this.updateCalendarList();
    private final WeakInvalidationListener weakUpdateCalendarListListener = new WeakInvalidationListener(this.updateCalendarListListener);
    private final ObjectProperty<T> userObject = new SimpleObjectProperty((Object)this, "userObject");
    private final ObservableList<CalendarSource> calendarSources = FXCollections.observableArrayList();
    private final ReadOnlyListWrapper<Calendar> calendars = new ReadOnlyListWrapper(FXCollections.observableArrayList());
    private final ObservableList<Calendar> unmodifiableCalendars = FXCollections.unmodifiableObservableList((ObservableList)this.calendars.get());
    public final ObjectProperty<Calendar> availabilityCalendar = new SimpleObjectProperty((Object)this, "availabilityCalendar", new Calendar());

    public Resource() {
        this.getCalendarSources().addListener((InvalidationListener)this.weakUpdateCalendarListListener);
        Calendar<Resource> defaultCalendar = new Calendar<Resource>(Messages.getString("DateControl.DEFAULT_CALENDAR_NAME"));
        defaultCalendar.setUserObject(this);
        CalendarSource defaultCalendarSource = new CalendarSource(Messages.getString("DateControl.DEFAULT_CALENDAR_SOURCE_NAME"));
        defaultCalendarSource.getCalendars().add(defaultCalendar);
        this.getCalendarSources().add((Object)defaultCalendarSource);
    }

    public Resource(T userObject) {
        this();
        this.setUserObject(userObject);
    }

    public final T getUserObject() {
        return (T)this.userObject.get();
    }

    public final ObjectProperty<T> userObjectProperty() {
        return this.userObject;
    }

    public final void setUserObject(T userObject) {
        this.userObject.set(userObject);
    }

    public final ObservableList<CalendarSource> getCalendarSources() {
        return this.calendarSources;
    }

    public final ReadOnlyListProperty<Calendar> calendarsProperty() {
        return this.calendars.getReadOnlyProperty();
    }

    public final ObservableList<Calendar> getCalendars() {
        return this.unmodifiableCalendars;
    }

    public Calendar getAvailabilityCalendar() {
        return (Calendar)this.availabilityCalendar.get();
    }

    public ObjectProperty<Calendar> availabilityCalendarProperty() {
        return this.availabilityCalendar;
    }

    public void setAvailabilityCalendar(Calendar availabilityCalendar) {
        this.availabilityCalendar.set((Object)availabilityCalendar);
    }

    private void updateCalendarList() {
        ArrayList<Calendar> removedCalendars = new ArrayList<Calendar>((Collection<Calendar>)this.calendars);
        ArrayList<Calendar> newCalendars = new ArrayList<Calendar>();
        for (CalendarSource source : this.getCalendarSources()) {
            for (Calendar calendar : source.getCalendars()) {
                if (this.calendars.contains((Object)calendar)) {
                    removedCalendars.remove(calendar);
                    continue;
                }
                newCalendars.add(calendar);
            }
            source.getCalendars().removeListener((InvalidationListener)this.weakUpdateCalendarListListener);
            source.getCalendars().addListener((InvalidationListener)this.weakUpdateCalendarListListener);
        }
        this.calendars.addAll(newCalendars);
        this.calendars.removeAll(removedCalendars);
    }

    public String toString() {
        if (this.getUserObject() != null) {
            return this.getUserObject().toString();
        }
        return super.toString();
    }
}

