/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.util;

import com.calendarfx.view.DateControl;
import com.calendarfx.view.DayViewBase;
import impl.com.calendarfx.view.DayViewScrollPane;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.stage.Screen;
import org.controlsfx.control.PopOver;

public final class ViewHelper {
    public static double getTimeLocation(DayViewBase view, LocalTime time) {
        return ViewHelper.getTimeLocation(view, ZonedDateTime.of(view.getDate(), time, view.getZoneId()));
    }

    public static double getTimeLocation(DayViewBase view, LocalTime time, boolean prefHeight) {
        return ViewHelper.getTimeLocation(view, ZonedDateTime.of(view.getDate(), time, view.getZoneId()), prefHeight);
    }

    public static double getTimeLocation(DayViewBase view, ZonedDateTime time) {
        return ViewHelper.getTimeLocation(view, time, false);
    }

    public static double getTimeLocation(DayViewBase view, Instant instant) {
        return ViewHelper.getTimeLocation(view, ZonedDateTime.ofInstant(instant, view.getZoneId()), false);
    }

    public static double getTimeLocation(DayViewBase view, ZonedDateTime zonedTime, boolean prefHeight) {
        if (view.isScrollingEnabled()) {
            Instant scrollInstant = view.getScrollTime().toInstant();
            double mpp = 3600000.0 / view.getHourHeight();
            long millis = zonedTime.toInstant().toEpochMilli() - scrollInstant.toEpochMilli();
            return (double)millis / mpp;
        }
        double availableHeight = view.getHeight();
        if (prefHeight) {
            availableHeight = view.prefHeight(-1.0);
        }
        long epochMilli = zonedTime.toInstant().toEpochMilli();
        switch (view.getEarlyLateHoursStrategy()) {
            case SHOW: {
                ZonedDateTime startTime = view.getZonedDateTimeMin();
                ZonedDateTime endTime = view.getZonedDateTimeMax();
                long startMillis = startTime.toInstant().toEpochMilli();
                long endMillis = endTime.toInstant().toEpochMilli();
                double mpp = (double)(endMillis - startMillis) / availableHeight;
                return (double)((int)((double)(epochMilli - startMillis) / mpp)) + 0.5;
            }
            case HIDE: {
                ZonedDateTime startTime = view.getZonedDateTimeStart();
                ZonedDateTime endTime = view.getZonedDateTimeEnd();
                if (zonedTime.isBefore(startTime)) {
                    return -1.0;
                }
                if (zonedTime.isAfter(endTime)) {
                    return availableHeight;
                }
                long startMillis = startTime.toInstant().toEpochMilli();
                long endMillis = endTime.toInstant().toEpochMilli();
                double mpp = (double)(endMillis - startMillis) / availableHeight;
                return (double)((int)((double)(epochMilli - startMillis) / mpp)) + 0.5;
            }
            case SHOW_COMPRESSED: {
                ZonedDateTime minTime = view.getZonedDateTimeMin();
                ZonedDateTime maxTime = view.getZonedDateTimeMax();
                ZonedDateTime startTime = view.getZonedDateTimeStart();
                ZonedDateTime endTime = view.getZonedDateTimeEnd();
                long earlyHours = ChronoUnit.HOURS.between(minTime, startTime);
                long lateHours = ChronoUnit.HOURS.between(endTime, maxTime) + 1L;
                double hourHeightCompressed = view.getHourHeightCompressed();
                double earlyHeight = hourHeightCompressed * (double)earlyHours;
                double lateHeight = hourHeightCompressed * (double)lateHours;
                if (zonedTime.isBefore(startTime)) {
                    long startMillis = minTime.toInstant().toEpochMilli();
                    long endMillis = startTime.toInstant().toEpochMilli();
                    double mpp = (double)(endMillis - startMillis) / earlyHeight;
                    return (double)((int)((double)(epochMilli - startMillis) / mpp)) + 0.5;
                }
                if (zonedTime.isAfter(endTime)) {
                    long startMillis = endTime.toInstant().toEpochMilli();
                    long endMillis = maxTime.toInstant().toEpochMilli();
                    double mpp = (double)(endMillis - startMillis) / lateHeight;
                    return (double)((int)((double)(epochMilli - startMillis) / mpp)) + (availableHeight - lateHeight) + 0.5;
                }
                long startMillis = startTime.toInstant().toEpochMilli();
                long endMillis = endTime.toInstant().toEpochMilli();
                double mpp = (double)(endMillis - startMillis) / (availableHeight - earlyHeight - lateHeight);
                return earlyHeight + (double)((int)((double)(epochMilli - startMillis) / mpp)) + 0.5;
            }
        }
        return 0.0;
    }

    public static Instant getInstantAt(DayViewBase view, double y) {
        ZonedDateTime zonedDateTime = view.getZonedDateTimeStart();
        double availableHeight = view.getHeight();
        switch (view.getEarlyLateHoursStrategy()) {
            case SHOW: {
                long startMillis = view.getZonedDateTimeMin().toInstant().toEpochMilli();
                long endMillis = view.getZonedDateTimeMax().toInstant().toEpochMilli();
                double mpp = (double)(endMillis - startMillis) / availableHeight;
                long millis = (long)(mpp * y) + startMillis;
                return Instant.ofEpochMilli(millis);
            }
            case HIDE: {
                ZonedDateTime startTime = view.getZonedDateTimeStart();
                ZonedDateTime endTime = view.getZonedDateTimeEnd();
                long startMillis = startTime.toInstant().toEpochMilli();
                long endMillis = endTime.toInstant().toEpochMilli();
                double mpp = (double)(endMillis - startMillis) / availableHeight;
                long millis = (long)(mpp * y) + startMillis;
                return Instant.ofEpochMilli(millis);
            }
            case SHOW_COMPRESSED: {
                ZonedDateTime startTime = view.getZonedDateTimeStart();
                ZonedDateTime endTime = view.getZonedDateTimeEnd();
                ZonedDateTime minTime = view.getZonedDateTimeMin();
                ZonedDateTime maxTime = view.getZonedDateTimeMax();
                long earlyHours = ChronoUnit.HOURS.between(minTime, startTime);
                long lateHours = ChronoUnit.HOURS.between(endTime, maxTime) + 1L;
                double hourHeightCompressed = view.getHourHeightCompressed();
                double earlyHeight = hourHeightCompressed * (double)earlyHours;
                double lateHeight = hourHeightCompressed * (double)lateHours;
                if (y < earlyHeight) {
                    long startMillis = minTime.toInstant().toEpochMilli();
                    long endMillis = startTime.toInstant().toEpochMilli();
                    double mpp = (double)(endMillis - startMillis) / earlyHeight;
                    long millis = (long)(mpp * y) + startMillis;
                    return Instant.ofEpochMilli(millis);
                }
                if (y > availableHeight - lateHeight) {
                    long startMillis = endTime.toInstant().toEpochMilli();
                    long endMillis = maxTime.toInstant().toEpochMilli();
                    double mpp = (double)(endMillis - startMillis) / lateHeight;
                    long millis = (long)(mpp * (y - (availableHeight - lateHeight))) + startMillis;
                    return Instant.ofEpochMilli(millis);
                }
                long startMillis = startTime.toInstant().toEpochMilli();
                long endMillis = endTime.toInstant().toEpochMilli();
                double mpp = (double)(endMillis - startMillis) / (availableHeight - earlyHeight - lateHeight);
                long millis = (long)(mpp * (y - earlyHeight)) + startMillis;
                return Instant.ofEpochMilli(millis);
            }
        }
        return zonedDateTime.toInstant();
    }

    public static PopOver.ArrowLocation findPopOverArrowLocation(Node view) {
        Bounds localBounds = view.getBoundsInLocal();
        Bounds entryBounds = view.localToScreen(localBounds);
        ObservableList screens = Screen.getScreensForRectangle((double)entryBounds.getMinX(), (double)entryBounds.getMinY(), (double)entryBounds.getWidth(), (double)entryBounds.getHeight());
        if (screens.isEmpty()) {
            return null;
        }
        Rectangle2D screenBounds = ((Screen)screens.get(0)).getVisualBounds();
        double spaceLeft = entryBounds.getMinX();
        double spaceRight = screenBounds.getWidth() - entryBounds.getMaxX();
        double spaceTop = entryBounds.getMinY();
        double spaceBottom = screenBounds.getHeight() - entryBounds.getMaxY();
        if (spaceLeft > spaceRight) {
            if (spaceTop > spaceBottom) {
                return PopOver.ArrowLocation.RIGHT_BOTTOM;
            }
            return PopOver.ArrowLocation.RIGHT_TOP;
        }
        if (spaceTop > spaceBottom) {
            return PopOver.ArrowLocation.LEFT_BOTTOM;
        }
        return PopOver.ArrowLocation.LEFT_TOP;
    }

    public static Point2D findPopOverArrowPosition(Node node, double screenY, double arrowSize, PopOver.ArrowLocation arrowLocation) {
        Bounds entryBounds = node.localToScreen(node.getBoundsInLocal());
        double screenX = arrowLocation == PopOver.ArrowLocation.LEFT_TOP || arrowLocation == PopOver.ArrowLocation.LEFT_BOTTOM ? entryBounds.getMaxX() : entryBounds.getMinX() - arrowSize;
        return new Point2D(screenX, screenY);
    }

    public static void scrollToRequestedTime(DateControl control, DayViewScrollPane scrollPane) {
        LocalTime requestedTime = control.getRequestedTime();
        if (requestedTime != null) {
            scrollPane.scrollToTime(requestedTime);
        }
    }
}

