/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.util;

import java.lang.ref.WeakReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class WeakList<T>
extends AbstractList<T> {
    private final ArrayList<WeakReference<T>> items = new ArrayList();

    public WeakList() {
    }

    public WeakList(Collection c) {
        this.addAll(0, c);
    }

    @Override
    public void add(int index, Object element) {
        this.items.add(index, new WeakReference<Object>(element));
    }

    @Override
    public Iterator<T> iterator() {
        return new WeakListIterator();
    }

    @Override
    public int size() {
        this.removeReleased();
        return this.items.size();
    }

    @Override
    public T get(int index) {
        return this.items.get(index).get();
    }

    private void removeReleased() {
        ArrayList<WeakReference<WeakReference>> temp = new ArrayList<WeakReference<WeakReference>>(this.items);
        temp.forEach(ref -> {
            if (ref.get() == null) {
                this.items.remove(ref);
            }
        });
    }

    private class WeakListIterator
    implements Iterator<T> {
        private final int n;
        private int i;

        public WeakListIterator() {
            this.n = WeakList.this.size();
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.n;
        }

        @Override
        public T next() {
            return WeakList.this.get(this.i++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

