/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view;

import com.calendarfx.model.Calendar;
import com.calendarfx.view.CalendarFXControl;
import com.calendarfx.view.DateControl;
import impl.com.calendarfx.view.CalendarHeaderViewSkin;
import java.util.Objects;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.util.Callback;

public class CalendarHeaderView
extends CalendarFXControl {
    private static final String DEFAULT_STYLE_CLASS = "calendar-header";
    private final ObservableMap<Calendar, BooleanProperty> calendarVisibilityMap = FXCollections.observableHashMap();
    private final ObjectProperty<Callback<Calendar, Node>> cellFactory = new SimpleObjectProperty((Object)this, "cellFactory");
    private final ObservableList<Calendar> calendars = FXCollections.observableArrayList();
    private final IntegerProperty numberOfDays = new SimpleIntegerProperty((Object)this, "numberOfDays", 1);

    public CalendarHeaderView() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.setCellFactory((Callback<Calendar, Node>)((Callback)calendar -> {
            Label label = new Label();
            label.textProperty().bind((ObservableValue)calendar.shortNameProperty());
            label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
            return label;
        }));
    }

    protected Skin<?> createDefaultSkin() {
        return new CalendarHeaderViewSkin(this);
    }

    public final void bind(DateControl dateControl) {
        Bindings.bindContentBidirectional(this.calendars, dateControl.getCalendars());
        Bindings.bindContentBidirectional(this.calendarVisibilityMap, dateControl.getCalendarVisibilityMap());
    }

    public final void unbind(DateControl dateControl) {
        this.getCalendarVisibilityMap().clear();
        Bindings.unbindContentBidirectional(this.calendars, dateControl.getCalendars());
        Bindings.unbindContentBidirectional(this.calendarVisibilityMap, dateControl.getCalendarVisibilityMap());
    }

    public final ObservableMap<Calendar, BooleanProperty> getCalendarVisibilityMap() {
        return this.calendarVisibilityMap;
    }

    public final BooleanProperty getCalendarVisibilityProperty(Calendar calendar) {
        return (BooleanProperty)this.calendarVisibilityMap.computeIfAbsent((Object)calendar, cal -> new SimpleBooleanProperty((Object)this, "visible", true));
    }

    public final boolean isCalendarVisible(Calendar calendar) {
        BooleanProperty prop = this.getCalendarVisibilityProperty(calendar);
        return prop.get();
    }

    public final void setCalendarVisibility(Calendar calendar, boolean visible) {
        BooleanProperty prop = this.getCalendarVisibilityProperty(calendar);
        prop.set(visible);
    }

    public final ObjectProperty<Callback<Calendar, Node>> cellFactoryProperty() {
        return this.cellFactory;
    }

    public final void setCellFactory(Callback<Calendar, Node> factory) {
        Objects.requireNonNull(factory);
        this.cellFactoryProperty().set(factory);
    }

    public final Callback<Calendar, Node> getCellFactory() {
        return (Callback)this.cellFactory.get();
    }

    public final ObservableList<Calendar> getCalendars() {
        return this.calendars;
    }

    public final IntegerProperty numberOfDaysProperty() {
        return this.numberOfDays;
    }

    public final int getNumberOfDays() {
        return this.numberOfDaysProperty().get();
    }

    public final void setNumberOfDays(int number) {
        if (number < 1) {
            throw new IllegalArgumentException("invalid number of days, must be larger than 0 but was " + number);
        }
        this.numberOfDaysProperty().set(number);
    }
}

