/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.CalendarSource;
import com.calendarfx.model.Entry;
import com.calendarfx.model.Interval;
import com.calendarfx.util.ViewHelper;
import com.calendarfx.util.WeakList;
import com.calendarfx.view.AllDayView;
import com.calendarfx.view.CalendarFXControl;
import com.calendarfx.view.CalendarView;
import com.calendarfx.view.ContextMenuProvider;
import com.calendarfx.view.DraggedEntry;
import com.calendarfx.view.EntryViewBase;
import com.calendarfx.view.Messages;
import com.calendarfx.view.VirtualGrid;
import com.calendarfx.view.ZonedDateTimeProvider;
import com.calendarfx.view.popover.DatePopOver;
import com.calendarfx.view.popover.EntryPopOverContentPane;
import java.text.MessageFormat;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Alert;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.InputEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.stage.Modality;
import javafx.util.Callback;
import org.controlsfx.control.PopOver;
import org.controlsfx.control.PropertySheet;

public abstract class DateControl
extends CalendarFXControl {
    private Boolean usesOwnContextMenu;
    private final InvalidationListener updateCalendarListListener = it -> this.updateCalendarList();
    private final WeakInvalidationListener weakUpdateCalendarListListener = new WeakInvalidationListener(this.updateCalendarListListener);
    private final ObservableMap<Calendar, BooleanProperty> calendarVisibilityMap = FXCollections.observableHashMap();
    private final ObservableSet<Layer> visibleLayers = FXCollections.observableSet((Object[])new Layer[]{Layer.BASE, Layer.TOP});
    private final ObjectProperty<DraggedEntry> draggedEntry = new SimpleObjectProperty((Object)this, "draggedEntry");
    private PopOver entryPopOver;
    private final ObjectProperty<Callback<CreateEntryParameter, Entry<?>>> entryFactory = new SimpleObjectProperty((Object)this, "entryFactory");
    private final ObjectProperty<Callback<CreateCalendarSourceParameter, CalendarSource>> calendarSourceFactory = new SimpleObjectProperty((Object)this, "calendarSourceFactory");
    private final ObjectProperty<Callback<EntryEditParameter, Boolean>> entryEditPolicy = new SimpleObjectProperty(action -> true);
    private final ObjectProperty<Callback<EntryContextMenuParameter, ContextMenu>> entryContextMenuCallback = new SimpleObjectProperty((Object)this, "entryFactory");
    private final ObjectProperty<Callback<ContextMenuParameter, ContextMenu>> contextMenuCallback = new SimpleObjectProperty((Object)this, "contextMenuCallback");
    private final ObjectProperty<Callback<DateControl, Calendar>> defaultCalendarProvider = new SimpleObjectProperty((Object)this, "defaultCalendarProvider");
    private final ObjectProperty<Callback<DateDetailsParameter, Boolean>> dateDetailsCallback = new SimpleObjectProperty((Object)this, "dateDetailsCallback");
    private final ObjectProperty<Callback<EntryDetailsParameter, Boolean>> entryDetailsCallback = new SimpleObjectProperty((Object)this, "entryDetailsCallback");
    private final ObjectProperty<Callback<EntryDetailsPopOverContentParameter, Node>> entryDetailsPopoverContentCallback = new SimpleObjectProperty((Object)this, "entryDetailsPopoverContentCallback");
    private final ObjectProperty<LocalDate> today = new SimpleObjectProperty((Object)this, "today", (Object)LocalDate.now());
    private final BooleanProperty showToday = new SimpleBooleanProperty((Object)this, "showToday", true);
    private final BooleanProperty showNoonMarker = new SimpleBooleanProperty((Object)this, "showNoonMarker", true);
    private final ObjectProperty<LocalDate> date = new SimpleObjectProperty((Object)this, "date", (Object)LocalDate.now());
    private final BooleanProperty enableTimeZoneSupport = new SimpleBooleanProperty((Object)this, "enableTimeZoneSupport", false);
    private final ObjectProperty<ZoneId> zoneId = new SimpleObjectProperty((Object)this, "zoneId", (Object)ZoneId.systemDefault());
    private final ObjectProperty<LocalTime> time = new SimpleObjectProperty((Object)this, "time", (Object)LocalTime.now());
    private final ObjectProperty<LocalTime> startTime = new SimpleObjectProperty((Object)this, "startTime", (Object)LocalTime.of(6, 0));
    private final ObjectProperty<LocalTime> endTime = new SimpleObjectProperty((Object)this, "endTime", (Object)LocalTime.of(22, 0));
    private final ObjectProperty<WeekFields> weekFields = new SimpleObjectProperty((Object)this, "weekFields", (Object)WeekFields.of(Locale.getDefault()));
    private final ReadOnlyListWrapper<Calendar> calendars = new ReadOnlyListWrapper(FXCollections.observableArrayList());
    private final ObservableList<Calendar> unmodifiableCalendars = FXCollections.unmodifiableObservableList((ObservableList)this.calendars.get());
    private final ObservableList<CalendarSource> calendarSources = FXCollections.observableArrayList();
    private final ObjectProperty<SelectionMode> selectionMode = new SimpleObjectProperty((Object)this, "selectionMode", (Object)SelectionMode.MULTIPLE);
    private final ObservableSet<Entry<?>> selections = FXCollections.observableSet((Object[])new Entry[0]);
    private final ObjectProperty<VirtualGrid> virtualGrid = new SimpleObjectProperty((Object)this, "virtualGrid", (Object)new VirtualGrid(Messages.getString("DateControl.DEFAULT_VIRTUAL_GRID_NAME"), Messages.getString("DateControl.DEFAULT_VIRTUAL_GRID_SHORT_NAME"), ChronoUnit.MINUTES, 15));
    private final ObjectProperty<LocalTime> requestedTime = new SimpleObjectProperty((Object)this, "requestedTime", (Object)LocalTime.now());
    private final ObjectProperty<Layout> layout = new SimpleObjectProperty((Object)this, "layout", (Object)Layout.STANDARD);
    private final ObservableSet<DayOfWeek> weekendDays = FXCollections.observableSet((Object[])new DayOfWeek[0]);
    private final WeakList<DateControl> boundDateControls = new WeakList();
    private final BooleanProperty enableHyperlinks = new SimpleBooleanProperty((Object)this, "enableHyperlinks", true);
    private final BooleanProperty editAvailability = new SimpleBooleanProperty((Object)this, "editAvailability");
    private final ObjectProperty<Calendar> availabilityCalendar = new SimpleObjectProperty((Object)this, "availabilityCalendar", new Calendar());
    private final ObjectProperty<VirtualGrid> availabilityGrid = new SimpleObjectProperty((Object)this, "availabilityGrid", (Object)new VirtualGrid("30 Minutes", "30 Minutes", ChronoUnit.MINUTES, 30));
    private final ObjectProperty<Paint> availabilityFill = new SimpleObjectProperty((Object)this, "availabilityFill", (Object)Color.rgb((int)0, (int)0, (int)0, (double)0.1));
    private final BooleanProperty showDetailsUponEntryCreation = new SimpleBooleanProperty((Object)this, "showDetailsUponEntryCreation", true);
    private final BooleanProperty suspendUpdates = new SimpleBooleanProperty((Object)this, "suspendUpdates", false);
    public final ObjectProperty<Callback<Integer, Usage>> usagePolicy = new SimpleObjectProperty((Object)this, "usagePolicy");
    private final ObservableList<ZoneId> availableZoneIds = FXCollections.observableArrayList();
    private final IntegerProperty createEntryClickCount = new SimpleIntegerProperty((Object)this, "createEntryClickCount", 2);
    private static final String DATE_CONTROL_CATEGORY = "Date Control";

    protected DateControl() {
        this.setOnMouseClicked(evt -> this.requestFocus());
        this.setUsagePolicy((Callback<Integer, Usage>)((Callback)count -> {
            if (count < 0) {
                throw new IllegalArgumentException("usage count can not be smaller than zero, but was " + count);
            }
            switch (count) {
                case 0: {
                    return Usage.NONE;
                }
                case 1: {
                    return Usage.VERY_LOW;
                }
                case 2: {
                    return Usage.LOW;
                }
                case 3: {
                    return Usage.MEDIUM;
                }
                case 4: {
                    return Usage.HIGH;
                }
            }
            return Usage.VERY_HIGH;
        }));
        this.getWeekendDays().add((Object)DayOfWeek.SATURDAY);
        this.getWeekendDays().add((Object)DayOfWeek.SUNDAY);
        CalendarSource defaultCalendarSource = new CalendarSource(Messages.getString("DateControl.DEFAULT_CALENDAR_SOURCE_NAME"));
        Calendar defaultCalendar = new Calendar(Messages.getString("DateControl.DEFAULT_CALENDAR_NAME"));
        defaultCalendarSource.getCalendars().add(defaultCalendar);
        this.getCalendarSources().add((Object)defaultCalendarSource);
        this.getCalendarSources().addListener((InvalidationListener)this.weakUpdateCalendarListListener);
        this.setEntryDetailsPopOverContentCallback((Callback<EntryDetailsPopOverContentParameter, Node>)((Callback)param -> new EntryPopOverContentPane(param.getPopOver(), param.getDateControl(), param.getEntry())));
        this.setDefaultCalendarProvider((Callback<DateControl, Calendar>)((Callback)control -> {
            ObservableList<CalendarSource> sources = control.getCalendarSources();
            for (CalendarSource s : sources) {
                ObservableList<Calendar> calendars = s.getCalendars();
                if (calendars == null || calendars.isEmpty()) continue;
                for (Calendar c : calendars) {
                    if (c.isReadOnly() || !control.isCalendarVisible(c)) continue;
                    return c;
                }
            }
            return null;
        }));
        this.setEntryFactory(param -> {
            DateControl dateControl = param.getDateControl();
            ZonedDateTime time = param.getZonedDateTime();
            DayOfWeek firstDayOfWeek = dateControl.getFirstDayOfWeek();
            VirtualGrid grid = dateControl.getVirtualGrid();
            ZonedDateTime lowerTime = grid.adjustTime(time, false, firstDayOfWeek);
            ZonedDateTime upperTime = grid.adjustTime(time, true, firstDayOfWeek);
            time = Duration.between(time, lowerTime).abs().minus(Duration.between(time, upperTime).abs()).isNegative() ? lowerTime : upperTime;
            Entry entry = new Entry(Messages.getString("DateControl.DEFAULT_ENTRY_TITLE"));
            Interval interval = new Interval(time.toLocalDateTime(), time.toLocalDateTime().plusHours(1L), time.getZone());
            entry.setInterval(interval);
            if (dateControl instanceof AllDayView) {
                entry.setFullDay(true);
            }
            return entry;
        });
        this.setEntryDetailsCallback((Callback<EntryDetailsParameter, Boolean>)((Callback)param -> {
            InputEvent evt = param.getInputEvent();
            if (evt instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)evt;
                if (mouseEvent.getClickCount() == 2) {
                    param.getDateControl().showEntryDetails(param.getEntry(), param.getNode(), param.getOwner(), param.getScreenY());
                    return true;
                }
            } else {
                param.getDateControl().showEntryDetails(param.getEntry(), param.getNode(), param.getOwner(), param.getScreenY());
                return true;
            }
            return false;
        }));
        this.setDateDetailsCallback((Callback<DateDetailsParameter, Boolean>)((Callback)param -> {
            MouseEvent mouseEvent;
            InputEvent evt = param.getInputEvent();
            if (evt == null) {
                param.getDateControl().showDateDetails(param.getOwner(), param.getLocalDate());
                return true;
            }
            if (evt instanceof MouseEvent && (mouseEvent = (MouseEvent)evt).getClickCount() == 1) {
                param.getDateControl().showDateDetails(param.getOwner(), param.getLocalDate());
                return true;
            }
            return false;
        }));
        this.setContextMenuCallback(new ContextMenuProvider());
        this.setEntryContextMenuCallback((Callback<EntryContextMenuParameter, ContextMenu>)((Callback)param -> {
            EntryViewBase<?> entryView = param.getEntryView();
            Entry<?> entry = entryView.getEntry();
            ContextMenu contextMenu = new ContextMenu();
            MenuItem informationItem = new MenuItem(Messages.getString("DateControl.MENU_ITEM_INFORMATION"));
            informationItem.setOnAction(evt -> {
                Callback<EntryDetailsParameter, Boolean> detailsCallback = param.getDateControl().getEntryDetailsCallback();
                if (detailsCallback != null) {
                    ContextMenuEvent ctxEvent = param.getContextMenuEvent();
                    detailsCallback.call((Object)new EntryDetailsParameter((InputEvent)ctxEvent, param.getDateControl(), entryView.getEntry(), (Node)entryView, (Node)entryView, ctxEvent.getScreenX(), ctxEvent.getScreenY()));
                }
            });
            contextMenu.getItems().add((Object)informationItem);
            String stylesheet = CalendarView.class.getResource("calendar.css").toExternalForm();
            Menu calendarMenu = new Menu(Messages.getString("DateControl.MENU_CALENDAR"));
            for (Calendar calendar : param.getDateControl().getCalendars()) {
                RadioMenuItem calendarItem = new RadioMenuItem(calendar.getName());
                calendarItem.setOnAction(evt -> entry.setCalendar(calendar));
                calendarItem.setDisable(calendar.isReadOnly());
                calendarItem.setSelected(calendar.equals(param.getCalendar()));
                calendarMenu.getItems().add((Object)calendarItem);
                StackPane graphic = new StackPane();
                graphic.getStylesheets().add((Object)stylesheet);
                Rectangle icon = new Rectangle(10.0, 10.0);
                icon.setArcHeight(2.0);
                icon.setArcWidth(2.0);
                icon.getStyleClass().setAll((Object[])new String[]{calendar.getStyle() + "-icon"});
                graphic.getChildren().add((Object)icon);
                calendarItem.setGraphic((Node)graphic);
            }
            calendarMenu.setDisable(param.getCalendar().isReadOnly());
            contextMenu.getItems().add((Object)calendarMenu);
            if (((Boolean)param.getDateControl().getEntryEditPolicy().call((Object)new EntryEditParameter(param.getDateControl(), entry, EditOperation.DELETE))).booleanValue()) {
                MenuItem delete = new MenuItem(Messages.getString("DateControl.MENU_ITEM_DELETE"));
                contextMenu.getItems().add((Object)delete);
                delete.setDisable(param.getCalendar().isReadOnly());
                delete.setOnAction(evt -> {
                    Calendar calendar = entry.getCalendar();
                    if (!calendar.isReadOnly()) {
                        if (entry.isRecurrence()) {
                            Entry recurrenceSourceEntry = entry.getRecurrenceSourceEntry();
                            if (recurrenceSourceEntry != null) {
                                recurrenceSourceEntry.removeFromCalendar();
                            }
                        } else {
                            entry.removeFromCalendar();
                        }
                    }
                });
            }
            return contextMenu;
        }));
        this.setCalendarSourceFactory((Callback<CreateCalendarSourceParameter, CalendarSource>)((Callback)param -> {
            CalendarSource source = new CalendarSource(Messages.getString("DateControl.DEFAULT_NEW_CALENDAR_SOURCE"));
            Calendar calendar = new Calendar(Messages.getString("DateControl.DEFAULT_NEW_CALENDAR"));
            calendar.setShortName(Messages.getString("DateControl.DEFAULT_NEW_CALENDAR").substring(0, 1));
            source.getCalendars().add(calendar);
            return source;
        }));
        this.addEventHandler(ContextMenuEvent.CONTEXT_MENU_REQUESTED, evt -> {
            Callback<ContextMenuParameter, ContextMenu> callback;
            if (null == this.usesOwnContextMenu) {
                this.usesOwnContextMenu = this.getContextMenu() != null;
            }
            if (!this.usesOwnContextMenu.booleanValue() && (callback = this.getContextMenuCallback()) != null) {
                ContextMenuParameter param;
                ContextMenu menu;
                Callback<DateControl, Calendar> calendarProvider = this.getDefaultCalendarProvider();
                Calendar calendar = (Calendar)calendarProvider.call((Object)this);
                ZonedDateTime time = ZonedDateTime.now();
                if (this instanceof ZonedDateTimeProvider) {
                    ZonedDateTimeProvider provider = (ZonedDateTimeProvider)((Object)this);
                    time = provider.getZonedDateTimeAt(evt.getX(), evt.getY(), this.getZoneId());
                }
                if ((menu = (ContextMenu)callback.call((Object)(param = new ContextMenuParameter((ContextMenuEvent)evt, this, calendar, time)))) != null) {
                    menu.show(this.getScene().getWindow(), evt.getScreenX(), evt.getScreenY());
                }
                evt.consume();
            }
        });
        this.getAvailableZoneIds().add((Object)ZoneId.of("Europe/Zurich"));
        this.getAvailableZoneIds().add((Object)ZoneId.of("Europe/Helsinki"));
        this.getAvailableZoneIds().add((Object)ZoneId.of("Europe/London"));
        this.getAvailableZoneIds().add((Object)ZoneId.of("US/Eastern"));
        this.getAvailableZoneIds().add((Object)ZoneId.of("US/Central"));
        this.getAvailableZoneIds().add((Object)ZoneId.of("US/Pacific"));
        this.createEntryClickCountProperty().addListener(it -> {
            int createEntryClickCount = this.getCreateEntryClickCount();
            if (createEntryClickCount <= 0 || createEntryClickCount > 3) {
                throw new IllegalArgumentException("the click count for creating new entries must be between 1 and 3 but was " + createEntryClickCount);
            }
        });
    }

    public final ObservableMap<Calendar, BooleanProperty> getCalendarVisibilityMap() {
        return this.calendarVisibilityMap;
    }

    public final BooleanProperty getCalendarVisibilityProperty(Calendar calendar) {
        return (BooleanProperty)this.calendarVisibilityMap.computeIfAbsent((Object)calendar, cal -> new SimpleBooleanProperty((Object)this, "visible", true));
    }

    public final boolean isCalendarVisible(Calendar calendar) {
        return this.getCalendarVisibilityProperty(calendar).get();
    }

    public final void setCalendarVisibility(Calendar calendar, boolean visible) {
        this.getCalendarVisibilityProperty(calendar).set(visible);
    }

    public final ObservableSet<Layer> visibleLayersProperty() {
        return this.visibleLayers;
    }

    public final void refreshData() {
        this.getProperties().put((Object)"refresh.data", (Object)true);
        this.getBoundDateControls().forEach(DateControl::refreshData);
    }

    public final void createCalendarSource() {
        CreateCalendarSourceParameter param;
        CalendarSource calendarSource;
        Callback<CreateCalendarSourceParameter, CalendarSource> factory = this.getCalendarSourceFactory();
        if (factory != null && (calendarSource = (CalendarSource)factory.call((Object)(param = new CreateCalendarSourceParameter(this)))) != null && !this.getCalendarSources().contains((Object)calendarSource)) {
            this.getCalendarSources().add((Object)calendarSource);
        }
    }

    public final ObjectProperty<DraggedEntry> draggedEntryProperty() {
        return this.draggedEntry;
    }

    public final DraggedEntry getDraggedEntry() {
        return (DraggedEntry)this.draggedEntry.get();
    }

    public final void setDraggedEntry(DraggedEntry entry) {
        this.draggedEntryProperty().set((Object)entry);
    }

    public final Entry<?> createEntryAt(ZonedDateTime time) {
        return this.createEntryAt(time, null, false);
    }

    public final Entry<?> createEntryAt(ZonedDateTime time, Calendar calendar) {
        return this.createEntryAt(time, calendar, false);
    }

    public final Entry<?> createEntryAt(ZonedDateTime time, Calendar calendar, boolean initiallyHidden) {
        Objects.requireNonNull(time);
        VirtualGrid grid = this.getVirtualGrid();
        if (grid != null) {
            ZonedDateTime timeA = grid.adjustTime(time, false, this.getFirstDayOfWeek());
            ZonedDateTime timeB = grid.adjustTime(time, true, this.getFirstDayOfWeek());
            time = Duration.between(time, timeA).abs().minus(Duration.between(time, timeB).abs()).isNegative() ? timeA : timeB;
        }
        if (calendar == null) {
            Callback<DateControl, Calendar> defaultCalendarProvider = this.getDefaultCalendarProvider();
            calendar = (Calendar)defaultCalendarProvider.call((Object)this);
        }
        if (calendar != null) {
            if (calendar.isReadOnly()) {
                return null;
            }
            this.setCalendarVisibility(calendar, true);
            CreateEntryParameter param = new CreateEntryParameter(this, calendar, time);
            Callback<CreateEntryParameter, Entry<?>> factory = this.getEntryFactory();
            Entry entry = (Entry)factory.call((Object)param);
            if (entry != null) {
                entry.setHidden(initiallyHidden);
                entry.setCalendar(calendar);
            }
            return entry;
        }
        Alert alert = new Alert(Alert.AlertType.WARNING);
        alert.initOwner(this.getScene().getWindow());
        alert.initModality(Modality.WINDOW_MODAL);
        alert.setTitle(Messages.getString("DateControl.TITLE_CALENDAR_PROBLEM"));
        alert.setHeaderText(Messages.getString("DateControl.HEADER_TEXT_UNABLE_TO_CREATE_NEW_ENTRY"));
        String newLine = System.getProperty("line.separator");
        alert.setContentText(MessageFormat.format(Messages.getString("DateControl.CONTENT_TEXT_UNABLE_TO_CREATE_NEW_ENTRY"), newLine));
        alert.show();
        return null;
    }

    public Optional<Calendar> getCalendarAt(double x, double y) {
        return Optional.empty();
    }

    public final void showEntry(Entry<?> entry) {
        Objects.requireNonNull(entry);
        this.doShowEntry(entry, false, true);
    }

    public final void editEntry(Entry<?> entry) {
        Objects.requireNonNull(entry);
        this.doShowEntry(entry, true, true);
    }

    public final void editEntry(Entry<?> entry, boolean changeDate) {
        Objects.requireNonNull(entry);
        this.doShowEntry(entry, true, changeDate);
    }

    private void doShowEntry(Entry<?> entry, boolean startEditing, boolean changeDate) {
        this.layout();
        if (changeDate) {
            this.setDate(entry.getStartDate());
        }
        Platform.runLater(() -> {
            if (!entry.isFullDay()) {
                this.setRequestedTime(null);
                this.setRequestedTime(entry.getStartTime());
            }
            Platform.runLater(() -> {
                if (startEditing) {
                    Platform.runLater(() -> this.doEditEntry(entry));
                } else {
                    Platform.runLater(() -> this.doBounceEntry(entry));
                }
            });
        });
    }

    private void doEditEntry(Entry<?> entry) {
        EntryViewBase<?> entryView = this.findEntryView(entry);
        Platform.runLater(() -> {
            if (entryView != null) {
                entryView.bounce();
                Point2D location = entryView.localToScreen(0.0, 0.0);
                Callback<EntryDetailsParameter, Boolean> callback = this.getEntryDetailsCallback();
                EntryDetailsParameter param = new EntryDetailsParameter(null, this, entry, (Node)entryView, (Node)entryView, location.getX(), location.getY());
                callback.call((Object)param);
            }
        });
    }

    private void doBounceEntry(Entry<?> entry) {
        EntryViewBase<?> entryView = this.findEntryView(entry);
        if (entryView != null) {
            entryView.bounce();
        }
    }

    private void showEntryDetails(Entry<?> entry, Node node, Node owner, double screenY) {
        EntryDetailsPopOverContentParameter param;
        Node content;
        Callback<EntryDetailsPopOverContentParameter, Node> contentCallback = this.getEntryDetailsPopOverContentCallback();
        if (contentCallback == null) {
            throw new IllegalStateException("No content callback found for entry popover");
        }
        if (this.entryPopOver == null || this.entryPopOver.isDetached()) {
            this.entryPopOver = new PopOver();
            this.entryPopOver.setAnimated(false);
        }
        if ((content = (Node)contentCallback.call((Object)(param = new EntryDetailsPopOverContentParameter(this.entryPopOver, this, owner, entry)))) == null) {
            content = new Label(Messages.getString("DateControl.NO_CONTENT"));
        }
        this.entryPopOver.setContentNode(content);
        PopOver.ArrowLocation location = ViewHelper.findPopOverArrowLocation(node);
        if (location == null) {
            location = PopOver.ArrowLocation.TOP_LEFT;
        }
        this.entryPopOver.setArrowLocation(location);
        Point2D position = ViewHelper.findPopOverArrowPosition(node, screenY, this.entryPopOver.getArrowSize(), location);
        this.entryPopOver.show(owner, position.getX(), position.getY());
    }

    public void showDateDetails(Node owner, LocalDate date) {
        DatePopOver datePopOver = new DatePopOver(this, date);
        datePopOver.show(owner);
    }

    public final ObjectProperty<Callback<CreateEntryParameter, Entry<?>>> entryFactoryProperty() {
        return this.entryFactory;
    }

    public final Callback<CreateEntryParameter, Entry<?>> getEntryFactory() {
        return (Callback)this.entryFactoryProperty().get();
    }

    public final void setEntryFactory(Callback<CreateEntryParameter, Entry<?>> factory) {
        Objects.requireNonNull(factory);
        this.entryFactoryProperty().set(factory);
    }

    public final ObjectProperty<Callback<CreateCalendarSourceParameter, CalendarSource>> calendarSourceFactoryProperty() {
        return this.calendarSourceFactory;
    }

    public final Callback<CreateCalendarSourceParameter, CalendarSource> getCalendarSourceFactory() {
        return (Callback)this.calendarSourceFactoryProperty().get();
    }

    public final void setCalendarSourceFactory(Callback<CreateCalendarSourceParameter, CalendarSource> callback) {
        this.calendarSourceFactoryProperty().set(callback);
    }

    public final ObjectProperty<Callback<EntryEditParameter, Boolean>> entryEditPolicyProperty() {
        return this.entryEditPolicy;
    }

    public final Callback<EntryEditParameter, Boolean> getEntryEditPolicy() {
        return (Callback)this.entryEditPolicy.get();
    }

    public final void setEntryEditPolicy(Callback<EntryEditParameter, Boolean> policy) {
        Objects.requireNonNull(policy, "The edit entry policy can not be null");
        this.entryEditPolicy.set(policy);
    }

    public final ObjectProperty<Callback<EntryContextMenuParameter, ContextMenu>> entryContextMenuCallbackProperty() {
        return this.entryContextMenuCallback;
    }

    public final Callback<EntryContextMenuParameter, ContextMenu> getEntryContextMenuCallback() {
        return (Callback)this.entryContextMenuCallbackProperty().get();
    }

    public final void setEntryContextMenuCallback(Callback<EntryContextMenuParameter, ContextMenu> callback) {
        this.entryContextMenuCallbackProperty().set(callback);
    }

    public final ObjectProperty<Callback<ContextMenuParameter, ContextMenu>> contextMenuCallbackProperty() {
        return this.contextMenuCallback;
    }

    public final Callback<ContextMenuParameter, ContextMenu> getContextMenuCallback() {
        return (Callback)this.contextMenuCallbackProperty().get();
    }

    public final void setContextMenuCallback(Callback<ContextMenuParameter, ContextMenu> callback) {
        this.contextMenuCallbackProperty().set(callback);
    }

    public final ObjectProperty<Callback<DateControl, Calendar>> defaultCalendarProviderProperty() {
        return this.defaultCalendarProvider;
    }

    public final Callback<DateControl, Calendar> getDefaultCalendarProvider() {
        return (Callback)this.defaultCalendarProviderProperty().get();
    }

    public final void setDefaultCalendarProvider(Callback<DateControl, Calendar> provider) {
        Objects.requireNonNull(provider);
        this.defaultCalendarProviderProperty().set(provider);
    }

    private void updateCalendarList() {
        ArrayList<Calendar> removedCalendars = new ArrayList<Calendar>((Collection<Calendar>)this.calendars);
        ArrayList<Calendar> newCalendars = new ArrayList<Calendar>();
        for (CalendarSource source : this.getCalendarSources()) {
            for (Calendar calendar2 : source.getCalendars()) {
                if (this.calendars.contains((Object)calendar2)) {
                    removedCalendars.remove(calendar2);
                    continue;
                }
                newCalendars.add(calendar2);
            }
            source.getCalendars().removeListener((InvalidationListener)this.weakUpdateCalendarListListener);
            source.getCalendars().addListener((InvalidationListener)this.weakUpdateCalendarListListener);
        }
        this.calendars.addAll(newCalendars);
        this.calendars.removeAll(removedCalendars);
        removedCalendars.forEach(calendar -> this.calendarVisibilityMap.remove(calendar));
    }

    public final ObjectProperty<Callback<DateDetailsParameter, Boolean>> dateDetailsCallbackProperty() {
        return this.dateDetailsCallback;
    }

    public final void setDateDetailsCallback(Callback<DateDetailsParameter, Boolean> callback) {
        Objects.requireNonNull(callback);
        this.dateDetailsCallbackProperty().set(callback);
    }

    public final Callback<DateDetailsParameter, Boolean> getDateDetailsCallback() {
        return (Callback)this.dateDetailsCallbackProperty().get();
    }

    public final ObjectProperty<Callback<EntryDetailsParameter, Boolean>> entryDetailsCallbackProperty() {
        return this.entryDetailsCallback;
    }

    public final void setEntryDetailsCallback(Callback<EntryDetailsParameter, Boolean> callback) {
        Objects.requireNonNull(callback);
        this.entryDetailsCallbackProperty().set(callback);
    }

    public final Callback<EntryDetailsParameter, Boolean> getEntryDetailsCallback() {
        return (Callback)this.entryDetailsCallbackProperty().get();
    }

    public final ObjectProperty<Callback<EntryDetailsPopOverContentParameter, Node>> entryDetailsPopOverContentCallbackProperty() {
        return this.entryDetailsPopoverContentCallback;
    }

    public final void setEntryDetailsPopOverContentCallback(Callback<EntryDetailsPopOverContentParameter, Node> callback) {
        Objects.requireNonNull(callback);
        this.entryDetailsPopOverContentCallbackProperty().set(callback);
    }

    public final Callback<EntryDetailsPopOverContentParameter, Node> getEntryDetailsPopOverContentCallback() {
        return (Callback)this.entryDetailsPopOverContentCallbackProperty().get();
    }

    public final ObjectProperty<LocalDate> todayProperty() {
        return this.today;
    }

    public final void setToday(LocalDate date) {
        Objects.requireNonNull(date);
        this.todayProperty().set((Object)date);
    }

    public final LocalDate getToday() {
        return (LocalDate)this.todayProperty().get();
    }

    public final BooleanProperty showTodayProperty() {
        return this.showToday;
    }

    public final boolean isShowToday() {
        return this.showTodayProperty().get();
    }

    public final void setShowToday(boolean show) {
        this.showTodayProperty().set(show);
    }

    public final boolean isShowNoonMarker() {
        return this.showNoonMarker.get();
    }

    public final BooleanProperty showNoonMarkerProperty() {
        return this.showNoonMarker;
    }

    public final void setShowNoonMarker(boolean showNoonMarker) {
        this.showNoonMarker.set(showNoonMarker);
    }

    public final ObjectProperty<LocalDate> dateProperty() {
        return this.date;
    }

    public final void setDate(LocalDate date) {
        Objects.requireNonNull(date);
        this.dateProperty().set((Object)date);
    }

    public final LocalDate getDate() {
        return (LocalDate)this.dateProperty().get();
    }

    public final boolean isEnableTimeZoneSupport() {
        return this.enableTimeZoneSupport.get();
    }

    public final BooleanProperty enableTimeZoneSupportProperty() {
        return this.enableTimeZoneSupport;
    }

    public final void setEnableTimeZoneSupport(boolean enableTimeZoneSupport) {
        this.enableTimeZoneSupport.set(enableTimeZoneSupport);
    }

    public final ObjectProperty<ZoneId> zoneIdProperty() {
        return this.zoneId;
    }

    public final void setZoneId(ZoneId zoneId) {
        Objects.requireNonNull(zoneId);
        this.zoneIdProperty().set((Object)zoneId);
    }

    public final ZoneId getZoneId() {
        return (ZoneId)this.zoneIdProperty().get();
    }

    public final ObjectProperty<LocalTime> timeProperty() {
        return this.time;
    }

    public final void setTime(LocalTime time) {
        Objects.requireNonNull(time);
        this.timeProperty().set((Object)time);
    }

    public final LocalTime getTime() {
        return (LocalTime)this.timeProperty().get();
    }

    public final ZonedDateTime getZonedDateTime() {
        return ZonedDateTime.of(this.getDate(), this.getTime(), this.getZoneId());
    }

    public final ObjectProperty<LocalTime> startTimeProperty() {
        return this.startTime;
    }

    public final LocalTime getStartTime() {
        return (LocalTime)this.startTimeProperty().get();
    }

    public final void setStartTime(LocalTime time) {
        this.startTimeProperty().set((Object)time);
    }

    public final ObjectProperty<LocalTime> endTimeProperty() {
        return this.endTime;
    }

    public final LocalTime getEndTime() {
        return (LocalTime)this.endTimeProperty().get();
    }

    public final void setEndTime(LocalTime time) {
        this.endTimeProperty().set((Object)time);
    }

    public final ObjectProperty<WeekFields> weekFieldsProperty() {
        return this.weekFields;
    }

    public final void setWeekFields(WeekFields weekFields) {
        Objects.requireNonNull(weekFields);
        this.weekFieldsProperty().set((Object)weekFields);
    }

    public final WeekFields getWeekFields() {
        return (WeekFields)this.weekFieldsProperty().get();
    }

    public final DayOfWeek getFirstDayOfWeek() {
        return this.getWeekFields().getFirstDayOfWeek();
    }

    public final ReadOnlyListProperty<Calendar> calendarsProperty() {
        return this.calendars.getReadOnlyProperty();
    }

    public final ObservableList<Calendar> getCalendars() {
        return this.unmodifiableCalendars;
    }

    public final ObservableList<CalendarSource> getCalendarSources() {
        return this.calendarSources;
    }

    public final ObjectProperty<SelectionMode> selectionModeProperty() {
        return this.selectionMode;
    }

    public final void setSelectionMode(SelectionMode mode) {
        Objects.requireNonNull(mode);
        this.selectionModeProperty().set((Object)mode);
    }

    public final SelectionMode getSelectionMode() {
        return (SelectionMode)this.selectionModeProperty().get();
    }

    public final ObservableSet<Entry<?>> getSelections() {
        return this.selections;
    }

    public final void select(Entry<?> entry) {
        Objects.requireNonNull(entry);
        this.selections.add(entry);
    }

    public final void deselect(Entry<?> entry) {
        Objects.requireNonNull(entry);
        this.selections.remove(entry);
    }

    public final void clearSelection() {
        this.getSelections().clear();
    }

    public final ObjectProperty<VirtualGrid> virtualGridProperty() {
        return this.virtualGrid;
    }

    public final VirtualGrid getVirtualGrid() {
        return (VirtualGrid)this.virtualGridProperty().get();
    }

    public final void setVirtualGrid(VirtualGrid grid) {
        Objects.requireNonNull(grid);
        this.virtualGridProperty().set((Object)grid);
    }

    public final ObjectProperty<LocalTime> requestedTimeProperty() {
        return this.requestedTime;
    }

    public final void setRequestedTime(LocalTime time) {
        this.requestedTimeProperty().set((Object)time);
    }

    public final LocalTime getRequestedTime() {
        return (LocalTime)this.requestedTimeProperty().get();
    }

    public final ObjectProperty<Layout> layoutProperty() {
        return this.layout;
    }

    public final void setLayout(Layout layout) {
        Objects.requireNonNull(layout);
        this.layoutProperty().set((Object)layout);
    }

    public final Layout getLayout() {
        return (Layout)((Object)this.layoutProperty().get());
    }

    public ObservableSet<DayOfWeek> getWeekendDays() {
        return this.weekendDays;
    }

    public void goForward() {
        this.setDate(this.getDate().plusDays(1L));
    }

    public void goBack() {
        this.setDate(this.getDate().minusDays(1L));
    }

    public void goToday() {
        this.setDate(this.getToday());
    }

    public final EntryViewBase<?> findEntryView(Entry<?> entry) {
        Objects.requireNonNull(entry);
        return this.doFindEntryView((Parent)this, entry);
    }

    private EntryViewBase<?> doFindEntryView(Parent parent, Entry<?> entry) {
        EntryViewBase result = null;
        for (Node node : parent.getChildrenUnmodifiable()) {
            if (node instanceof EntryViewBase) {
                EntryViewBase base = (EntryViewBase)node;
                if (!base.getEntry().equals(entry)) continue;
                result = base;
                break;
            }
            if (!(node instanceof Parent) || (result = this.doFindEntryView((Parent)node, entry)) == null) continue;
            break;
        }
        return result;
    }

    public final WeakList<DateControl> getBoundDateControls() {
        return this.boundDateControls;
    }

    public final void unbindAll() {
        WeakList<DateControl> controls = this.getBoundDateControls();
        for (DateControl next : controls) {
            if (next == null) continue;
            this.unbind(next);
        }
    }

    public final BooleanProperty enableHyperlinksProperty() {
        return this.enableHyperlinks;
    }

    public final void setEnableHyperlinks(boolean enable) {
        this.enableHyperlinks.set(enable);
    }

    public final boolean isEnableHyperlinks() {
        return this.enableHyperlinks.get();
    }

    public boolean isEditAvailability() {
        return this.editAvailability.get();
    }

    public BooleanProperty editAvailabilityProperty() {
        return this.editAvailability;
    }

    public void setEditAvailability(boolean editAvailability) {
        this.editAvailability.set(editAvailability);
    }

    public final Calendar getAvailabilityCalendar() {
        return (Calendar)this.availabilityCalendar.get();
    }

    public final ObjectProperty<Calendar> availabilityCalendarProperty() {
        return this.availabilityCalendar;
    }

    public final void setAvailabilityCalendar(Calendar calendar) {
        this.availabilityCalendar.set((Object)calendar);
    }

    public final VirtualGrid getAvailabilityGrid() {
        return (VirtualGrid)this.availabilityGrid.get();
    }

    public final ObjectProperty<VirtualGrid> availabilityGridProperty() {
        return this.availabilityGrid;
    }

    public final void setAvailabilityGrid(VirtualGrid availabilityGrid) {
        this.availabilityGrid.set((Object)availabilityGrid);
    }

    public final Paint getAvailabilityFill() {
        return (Paint)this.availabilityFill.get();
    }

    public final ObjectProperty<Paint> availabilityFillProperty() {
        return this.availabilityFill;
    }

    public final void setAvailabilityFill(Paint availabilityFill) {
        this.availabilityFill.set((Object)availabilityFill);
    }

    public final boolean isShowDetailsUponEntryCreation() {
        return this.showDetailsUponEntryCreation.get();
    }

    public final BooleanProperty showDetailsUponEntryCreationProperty() {
        return this.showDetailsUponEntryCreation;
    }

    public final void setShowDetailsUponEntryCreation(boolean showDetailsUponEntryCreation) {
        this.showDetailsUponEntryCreation.set(showDetailsUponEntryCreation);
    }

    public final void bind(DateControl otherControl, boolean bindDate) {
        Objects.requireNonNull(otherControl);
        this.boundDateControls.add(otherControl);
        Bindings.bindContentBidirectional(otherControl.getCalendarVisibilityMap(), this.getCalendarVisibilityMap());
        Bindings.bindContentBidirectional(otherControl.getCalendarSources(), this.getCalendarSources());
        Bindings.bindContentBidirectional(otherControl.getSelections(), this.getSelections());
        Bindings.bindContentBidirectional(otherControl.getWeekendDays(), this.getWeekendDays());
        Bindings.bindContentBidirectional(otherControl.getAvailableZoneIds(), this.getAvailableZoneIds());
        Bindings.bindBidirectional((Property)otherControl.suspendUpdatesProperty(), (Property)this.suspendUpdatesProperty());
        Bindings.bindBidirectional(otherControl.virtualGridProperty(), this.virtualGridProperty());
        Bindings.bindBidirectional(otherControl.draggedEntryProperty(), this.draggedEntryProperty());
        Bindings.bindBidirectional(otherControl.requestedTimeProperty(), this.requestedTimeProperty());
        Bindings.bindBidirectional(otherControl.selectionModeProperty(), this.selectionModeProperty());
        Bindings.bindBidirectional(otherControl.weekFieldsProperty(), this.weekFieldsProperty());
        Bindings.bindBidirectional(otherControl.layoutProperty(), this.layoutProperty());
        if (bindDate) {
            Bindings.bindBidirectional(otherControl.dateProperty(), this.dateProperty());
        }
        Bindings.bindBidirectional(otherControl.todayProperty(), this.todayProperty());
        Bindings.bindBidirectional(otherControl.zoneIdProperty(), this.zoneIdProperty());
        Bindings.bindBidirectional(otherControl.startTimeProperty(), this.startTimeProperty());
        Bindings.bindBidirectional(otherControl.endTimeProperty(), this.endTimeProperty());
        Bindings.bindBidirectional(otherControl.timeProperty(), this.timeProperty());
        Bindings.bindBidirectional(otherControl.usagePolicyProperty(), this.usagePolicyProperty());
        Bindings.bindBidirectional((Property)otherControl.enableTimeZoneSupportProperty(), (Property)this.enableTimeZoneSupportProperty());
        Bindings.bindBidirectional((Property)otherControl.showDetailsUponEntryCreationProperty(), (Property)this.showDetailsUponEntryCreationProperty());
        Bindings.bindBidirectional((Property)otherControl.showNoonMarkerProperty(), (Property)this.showNoonMarkerProperty());
        Bindings.bindBidirectional((Property)otherControl.showTodayProperty(), (Property)this.showTodayProperty());
        Bindings.bindBidirectional((Property)otherControl.editAvailabilityProperty(), (Property)this.editAvailabilityProperty());
        Bindings.bindBidirectional(otherControl.availabilityCalendarProperty(), this.availabilityCalendarProperty());
        Bindings.bindBidirectional(otherControl.availabilityGridProperty(), this.availabilityGridProperty());
        Bindings.bindBidirectional(otherControl.availabilityFillProperty(), this.availabilityFillProperty());
        Bindings.bindBidirectional((Property)otherControl.createEntryClickCountProperty(), (Property)this.createEntryClickCountProperty());
        Bindings.bindBidirectional(otherControl.contextMenuCallbackProperty(), this.contextMenuCallbackProperty());
        Bindings.bindBidirectional(otherControl.calendarSourceFactoryProperty(), this.calendarSourceFactoryProperty());
        Bindings.bindBidirectional(otherControl.entryDetailsPopOverContentCallbackProperty(), this.entryDetailsPopOverContentCallbackProperty());
        Bindings.bindBidirectional(otherControl.entryEditPolicyProperty(), this.entryEditPolicyProperty());
        Bindings.bindBidirectional(otherControl.entryDetailsCallbackProperty(), this.entryDetailsCallbackProperty());
        Bindings.bindBidirectional(otherControl.dateDetailsCallbackProperty(), this.dateDetailsCallbackProperty());
        Bindings.bindBidirectional(otherControl.entryContextMenuCallbackProperty(), this.entryContextMenuCallbackProperty());
        Bindings.bindBidirectional(otherControl.entryFactoryProperty(), this.entryFactoryProperty());
        Bindings.bindBidirectional(otherControl.defaultCalendarProviderProperty(), this.defaultCalendarProviderProperty());
    }

    public final void unbind(DateControl otherControl) {
        Objects.requireNonNull(otherControl);
        otherControl.getCalendarVisibilityMap().clear();
        Bindings.unbindContentBidirectional(otherControl.getCalendarVisibilityMap(), this.getCalendarVisibilityMap());
        Bindings.unbindContentBidirectional(otherControl.getCalendarSources(), this.getCalendarSources());
        Bindings.unbindContentBidirectional(otherControl.getSelections(), this.getSelections());
        Bindings.unbindContentBidirectional(otherControl.getWeekendDays(), this.getWeekendDays());
        Bindings.unbindContentBidirectional(otherControl.getAvailableZoneIds(), this.getAvailableZoneIds());
        Bindings.unbindBidirectional((Property)otherControl.suspendUpdatesProperty(), (Property)this.suspendUpdatesProperty());
        Bindings.unbindBidirectional(otherControl.virtualGridProperty(), this.virtualGridProperty());
        Bindings.unbindBidirectional(otherControl.draggedEntryProperty(), this.draggedEntryProperty());
        Bindings.unbindBidirectional(otherControl.requestedTimeProperty(), this.requestedTimeProperty());
        Bindings.unbindBidirectional(otherControl.selectionModeProperty(), this.selectionModeProperty());
        Bindings.unbindBidirectional(otherControl.weekFieldsProperty(), this.weekFieldsProperty());
        Bindings.unbindBidirectional(otherControl.layoutProperty(), this.layoutProperty());
        Bindings.unbindBidirectional(otherControl.dateProperty(), this.dateProperty());
        Bindings.unbindBidirectional(otherControl.todayProperty(), this.todayProperty());
        Bindings.unbindBidirectional(otherControl.zoneIdProperty(), this.zoneIdProperty());
        Bindings.unbindBidirectional(otherControl.startTimeProperty(), this.startTimeProperty());
        Bindings.unbindBidirectional(otherControl.endTimeProperty(), this.endTimeProperty());
        Bindings.unbindBidirectional(otherControl.timeProperty(), this.timeProperty());
        Bindings.unbindBidirectional(otherControl.usagePolicyProperty(), this.usagePolicyProperty());
        Bindings.unbindBidirectional((Property)otherControl.enableTimeZoneSupportProperty(), (Property)this.enableTimeZoneSupportProperty());
        Bindings.unbindBidirectional((Property)otherControl.showDetailsUponEntryCreationProperty(), (Property)this.showDetailsUponEntryCreationProperty());
        Bindings.unbindBidirectional((Property)otherControl.showNoonMarkerProperty(), (Property)this.showNoonMarkerProperty());
        Bindings.unbindBidirectional((Property)otherControl.showTodayProperty(), (Property)this.showTodayProperty());
        Bindings.unbindBidirectional((Property)otherControl.editAvailabilityProperty(), (Property)this.editAvailabilityProperty());
        Bindings.unbindBidirectional(otherControl.availabilityCalendarProperty(), this.availabilityCalendarProperty());
        Bindings.unbindBidirectional(otherControl.availabilityGridProperty(), this.availabilityGridProperty());
        Bindings.unbindBidirectional(otherControl.availabilityFillProperty(), this.availabilityFillProperty());
        Bindings.unbindBidirectional((Property)otherControl.createEntryClickCountProperty(), (Property)this.createEntryClickCountProperty());
        Bindings.unbindBidirectional(otherControl.contextMenuCallbackProperty(), this.contextMenuCallbackProperty());
        Bindings.unbindBidirectional(otherControl.calendarSourceFactoryProperty(), this.calendarSourceFactoryProperty());
        Bindings.unbindBidirectional(otherControl.entryDetailsCallbackProperty(), this.entryDetailsCallbackProperty());
        Bindings.unbindBidirectional(otherControl.entryEditPolicyProperty(), this.entryEditPolicyProperty());
        Bindings.unbindBidirectional(otherControl.entryDetailsPopOverContentCallbackProperty(), this.entryDetailsPopOverContentCallbackProperty());
        Bindings.unbindBidirectional(otherControl.dateDetailsCallbackProperty(), this.dateDetailsCallbackProperty());
        Bindings.unbindBidirectional(otherControl.entryContextMenuCallbackProperty(), this.entryContextMenuCallbackProperty());
        Bindings.unbindBidirectional(otherControl.entryFactoryProperty(), this.entryFactoryProperty());
        Bindings.unbindBidirectional(otherControl.defaultCalendarProviderProperty(), this.defaultCalendarProviderProperty());
    }

    public final BooleanProperty suspendUpdatesProperty() {
        return this.suspendUpdates;
    }

    public final boolean isSuspendUpdates() {
        return this.suspendUpdates.get();
    }

    public final void setSuspendUpdates(boolean suspend) {
        this.suspendUpdates.set(suspend);
    }

    public final ObjectProperty<Callback<Integer, Usage>> usagePolicyProperty() {
        return this.usagePolicy;
    }

    public final void setUsagePolicy(Callback<Integer, Usage> policy) {
        Objects.requireNonNull(policy);
        this.usagePolicy.set(policy);
    }

    public final Callback<Integer, Usage> getUsagePolicy() {
        return (Callback)this.usagePolicy.get();
    }

    public final ObservableList<ZoneId> getAvailableZoneIds() {
        return this.availableZoneIds;
    }

    public int getCreateEntryClickCount() {
        return this.createEntryClickCount.get();
    }

    public IntegerProperty createEntryClickCountProperty() {
        return this.createEntryClickCount;
    }

    public void setCreateEntryClickCount(int createEntryClickCount) {
        this.createEntryClickCount.set(createEntryClickCount);
    }

    @Override
    public ObservableList<PropertySheet.Item> getPropertySheetItems() {
        ObservableList<PropertySheet.Item> items = super.getPropertySheetItems();
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DateControl.this.dateProperty());
            }

            public void setValue(Object value) {
                DateControl.this.setDate((LocalDate)value);
            }

            public Object getValue() {
                return DateControl.this.getDate();
            }

            public Class<?> getType() {
                return LocalDate.class;
            }

            public String getName() {
                return "Date";
            }

            public String getDescription() {
                return "Date";
            }

            public String getCategory() {
                return DateControl.DATE_CONTROL_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DateControl.this.layoutProperty());
            }

            public void setValue(Object value) {
                DateControl.this.setLayout((Layout)((Object)value));
            }

            public Object getValue() {
                return DateControl.this.getLayout();
            }

            public Class<?> getType() {
                return Layout.class;
            }

            public String getName() {
                return "Layout";
            }

            public String getDescription() {
                return "Layout";
            }

            public String getCategory() {
                return DateControl.DATE_CONTROL_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DateControl.this.selectionModeProperty());
            }

            public void setValue(Object value) {
                DateControl.this.setSelectionMode((SelectionMode)value);
            }

            public Object getValue() {
                return DateControl.this.getSelectionMode();
            }

            public Class<?> getType() {
                return SelectionMode.class;
            }

            public String getName() {
                return "Selection Mode";
            }

            public String getDescription() {
                return "Selection Mode";
            }

            public String getCategory() {
                return DateControl.DATE_CONTROL_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DateControl.this.todayProperty());
            }

            public void setValue(Object value) {
                DateControl.this.setToday((LocalDate)value);
            }

            public Object getValue() {
                return DateControl.this.getToday();
            }

            public Class<?> getType() {
                return LocalDate.class;
            }

            public String getName() {
                return "Today";
            }

            public String getDescription() {
                return "Today";
            }

            public String getCategory() {
                return DateControl.DATE_CONTROL_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DateControl.this.showTodayProperty());
            }

            public void setValue(Object value) {
                DateControl.this.setShowToday((Boolean)value);
            }

            public Object getValue() {
                return DateControl.this.isShowToday();
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getName() {
                return "Show Today";
            }

            public String getDescription() {
                return "Highlight today";
            }

            public String getCategory() {
                return DateControl.DATE_CONTROL_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DateControl.this.zoneIdProperty());
            }

            public void setValue(Object value) {
                DateControl.this.setZoneId((ZoneId)value);
            }

            public Object getValue() {
                return DateControl.this.getZoneId();
            }

            public Class<?> getType() {
                return ZoneId.class;
            }

            public String getName() {
                return "Timezone";
            }

            public String getDescription() {
                return "Timezone";
            }

            public String getCategory() {
                return DateControl.DATE_CONTROL_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DateControl.this.weekFieldsProperty());
            }

            public void setValue(Object value) {
                DateControl.this.setWeekFields((WeekFields)value);
            }

            public Object getValue() {
                return DateControl.this.getWeekFields();
            }

            public Class<?> getType() {
                return WeekFields.class;
            }

            public String getName() {
                return "Week Fields";
            }

            public String getDescription() {
                return "Week Fields (calendar standard)";
            }

            public String getCategory() {
                return DateControl.DATE_CONTROL_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DateControl.this.timeProperty());
            }

            public void setValue(Object value) {
                DateControl.this.setTime((LocalTime)value);
            }

            public Object getValue() {
                return DateControl.this.getTime();
            }

            public Class<?> getType() {
                return LocalTime.class;
            }

            public String getName() {
                return "Time";
            }

            public String getDescription() {
                return "Time";
            }

            public String getCategory() {
                return DateControl.DATE_CONTROL_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DateControl.this.startTimeProperty());
            }

            public void setValue(Object value) {
                DateControl.this.setStartTime((LocalTime)value);
            }

            public Object getValue() {
                return DateControl.this.getStartTime();
            }

            public Class<?> getType() {
                return LocalTime.class;
            }

            public String getName() {
                return "Start Time";
            }

            public String getDescription() {
                return "The first visible time at the top.";
            }

            public String getCategory() {
                return DateControl.DATE_CONTROL_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DateControl.this.endTimeProperty());
            }

            public void setValue(Object value) {
                DateControl.this.setEndTime((LocalTime)value);
            }

            public Object getValue() {
                return DateControl.this.getEndTime();
            }

            public Class<?> getType() {
                return LocalTime.class;
            }

            public String getName() {
                return "End Time";
            }

            public String getDescription() {
                return "The last visible time at the bottom.";
            }

            public String getCategory() {
                return DateControl.DATE_CONTROL_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DateControl.this.enableHyperlinksProperty());
            }

            public void setValue(Object value) {
                DateControl.this.setEnableHyperlinks((Boolean)value);
            }

            public Object getValue() {
                return DateControl.this.isEnableHyperlinks();
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getName() {
                return "Hyperlinks";
            }

            public String getDescription() {
                return "Hyperlinks enabled / disabled";
            }

            public String getCategory() {
                return DateControl.DATE_CONTROL_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.empty();
            }

            public void setValue(Object value) {
                if (((Boolean)value).booleanValue()) {
                    DateControl.this.visibleLayersProperty().add((Object)Layer.BASE);
                } else {
                    DateControl.this.visibleLayersProperty().remove((Object)Layer.BASE);
                }
            }

            public Object getValue() {
                return DateControl.this.visibleLayersProperty().contains((Object)Layer.BASE);
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getName() {
                return "Base Layer";
            }

            public String getDescription() {
                return "Base Layer visible / hidden";
            }

            public String getCategory() {
                return DateControl.DATE_CONTROL_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.empty();
            }

            public void setValue(Object value) {
                if (((Boolean)value).booleanValue()) {
                    DateControl.this.visibleLayersProperty().add((Object)Layer.TOP);
                } else {
                    DateControl.this.visibleLayersProperty().remove((Object)Layer.TOP);
                }
            }

            public Object getValue() {
                return DateControl.this.visibleLayersProperty().contains((Object)Layer.TOP);
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getName() {
                return "Top Layer";
            }

            public String getDescription() {
                return "Top Layer visible / hidden";
            }

            public String getCategory() {
                return DateControl.DATE_CONTROL_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DateControl.this.showNoonMarkerProperty());
            }

            public void setValue(Object value) {
                DateControl.this.setShowNoonMarker((Boolean)value);
            }

            public Object getValue() {
                return DateControl.this.isShowNoonMarker();
            }

            public Class<?> getType() {
                return Boolean.TYPE;
            }

            public String getName() {
                return "Show Noon Marker";
            }

            public String getDescription() {
                return "Show / hide markers for noon.";
            }

            public String getCategory() {
                return DateControl.DATE_CONTROL_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DateControl.this.editAvailabilityProperty());
            }

            public void setValue(Object value) {
                DateControl.this.setEditAvailability((Boolean)value);
            }

            public Object getValue() {
                return DateControl.this.isEditAvailability();
            }

            public Class<?> getType() {
                return Boolean.TYPE;
            }

            public String getName() {
                return "Edit Availability";
            }

            public String getDescription() {
                return "Allow editing of the availability calendar";
            }

            public String getCategory() {
                return DateControl.DATE_CONTROL_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DateControl.this.enableTimeZoneSupportProperty());
            }

            public void setValue(Object value) {
                DateControl.this.setEnableTimeZoneSupport((Boolean)value);
            }

            public Object getValue() {
                return DateControl.this.isEnableTimeZoneSupport();
            }

            public Class<?> getType() {
                return Boolean.TYPE;
            }

            public String getName() {
                return "Enable Timezone Support";
            }

            public String getDescription() {
                return "Provide UI controls to work with timezones.";
            }

            public String getCategory() {
                return DateControl.DATE_CONTROL_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DateControl.this.showDetailsUponEntryCreationProperty());
            }

            public void setValue(Object value) {
                DateControl.this.setShowDetailsUponEntryCreation((Boolean)value);
            }

            public Object getValue() {
                return DateControl.this.isShowDetailsUponEntryCreation();
            }

            public Class<?> getType() {
                return Boolean.TYPE;
            }

            public String getName() {
                return "Show Details upon Creation";
            }

            public String getDescription() {
                return "Show the details dialog immediately after creating a new entry";
            }

            public String getCategory() {
                return DateControl.DATE_CONTROL_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DateControl.this.createEntryClickCountProperty());
            }

            public void setValue(Object value) {
                DateControl.this.setCreateEntryClickCount((Integer)value);
            }

            public Object getValue() {
                return DateControl.this.getCreateEntryClickCount();
            }

            public Class<?> getType() {
                return Integer.class;
            }

            public String getName() {
                return "Create Entry Click Count";
            }

            public String getDescription() {
                return "Set the number of clicks needed to create a new entry.";
            }

            public String getCategory() {
                return DateControl.DATE_CONTROL_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(DateControl.this.availabilityFillProperty());
            }

            public void setValue(Object value) {
                DateControl.this.setAvailabilityFill((Paint)value);
            }

            public Object getValue() {
                return DateControl.this.getAvailabilityFill();
            }

            public Class<?> getType() {
                return Paint.class;
            }

            public String getName() {
                return "Availability Fill Color";
            }

            public String getDescription() {
                return "Availability Fill Color";
            }

            public String getCategory() {
                return DateControl.DATE_CONTROL_CATEGORY;
            }
        });
        return items;
    }

    public static enum Layer {
        BASE,
        TOP;

    }

    public static enum Layout {
        STANDARD,
        SWIMLANE;

    }

    public static final class CreateCalendarSourceParameter {
        private final DateControl dateControl;

        public CreateCalendarSourceParameter(DateControl dateControl) {
            this.dateControl = Objects.requireNonNull(dateControl);
        }

        public DateControl getDateControl() {
            return this.dateControl;
        }
    }

    public static final class CreateEntryParameter {
        private final Calendar calendar;
        private final ZonedDateTime zonedDateTime;
        private final DateControl control;

        public CreateEntryParameter(DateControl control, Calendar calendar, ZonedDateTime time) {
            this.control = Objects.requireNonNull(control);
            this.calendar = Objects.requireNonNull(calendar);
            this.zonedDateTime = Objects.requireNonNull(time);
        }

        public Calendar getCalendar() {
            return this.calendar;
        }

        public ZonedDateTime getZonedDateTime() {
            return this.zonedDateTime;
        }

        public DateControl getDateControl() {
            return this.control;
        }

        public String toString() {
            return "CreateEntryParameter [calendar=" + this.calendar + ", zonedDateTime=" + this.zonedDateTime + "]";
        }
    }

    public static final class EntryDetailsPopOverContentParameter {
        private final DateControl dateControl;
        private final Node node;
        private final Entry<?> entry;
        private final PopOver popOver;

        public EntryDetailsPopOverContentParameter(PopOver popOver, DateControl control, Node node, Entry<?> entry) {
            this.popOver = Objects.requireNonNull(popOver);
            this.dateControl = Objects.requireNonNull(control);
            this.node = Objects.requireNonNull(node);
            this.entry = Objects.requireNonNull(entry);
        }

        public PopOver getPopOver() {
            return this.popOver;
        }

        public DateControl getDateControl() {
            return this.dateControl;
        }

        public Node getNode() {
            return this.node;
        }

        public Entry<?> getEntry() {
            return this.entry;
        }
    }

    public static final class EntryDetailsParameter
    extends DetailsParameter {
        private final Entry<?> entry;

        public EntryDetailsParameter(InputEvent inputEvent, DateControl control, Entry<?> entry, Node node, Node owner, double screenX, double screenY) {
            super(inputEvent, control, node, owner, screenX, screenY);
            this.entry = entry;
        }

        public Entry<?> getEntry() {
            return this.entry;
        }
    }

    public static final class ContextMenuParameter
    extends ContextMenuParameterBase {
        private final Calendar calendar;
        private final ZonedDateTime zonedDateTime;

        public ContextMenuParameter(ContextMenuEvent evt, DateControl dateControl, Calendar calendar, ZonedDateTime time) {
            super(evt, dateControl);
            this.calendar = calendar;
            this.zonedDateTime = time;
        }

        public Calendar getCalendar() {
            return this.calendar;
        }

        public ZonedDateTime getZonedDateTime() {
            return this.zonedDateTime;
        }

        public String toString() {
            return "ContextMenuParameter [calendar=" + this.calendar + ", zonedDateTime=" + this.zonedDateTime + "]";
        }
    }

    public static final class EntryContextMenuParameter
    extends ContextMenuParameterBase {
        private final EntryViewBase<?> entryView;

        public EntryContextMenuParameter(ContextMenuEvent evt, DateControl control, EntryViewBase<?> entryView) {
            super(evt, control);
            this.entryView = Objects.requireNonNull(entryView);
        }

        public EntryViewBase<?> getEntryView() {
            return this.entryView;
        }

        public Entry<?> getEntry() {
            return this.entryView.getEntry();
        }

        public Calendar getCalendar() {
            return this.getEntry().getCalendar();
        }

        public String toString() {
            return "EntryContextMenuParameter [entry=" + this.entryView + ", dateControl =" + this.getDateControl() + "]";
        }
    }

    public static final class EntryEditParameter {
        private final DateControl dateControl;
        private final Entry<?> entry;
        private final EditOperation editOperation;

        public EntryEditParameter(DateControl dateControl, Entry<?> entry, EditOperation editOperation) {
            this.dateControl = Objects.requireNonNull(dateControl);
            this.entry = Objects.requireNonNull(entry);
            this.editOperation = Objects.requireNonNull(editOperation);
        }

        public DateControl getDateControl() {
            return this.dateControl;
        }

        public Entry<?> getEntry() {
            return this.entry;
        }

        public EditOperation getEditOperation() {
            return this.editOperation;
        }

        public String toString() {
            return "EntryEditParameter{dateControl=" + this.dateControl + ", entry=" + this.entry + ", editOperation=" + this.editOperation + "}";
        }
    }

    public static enum EditOperation {
        CHANGE_START,
        CHANGE_END,
        MOVE,
        DELETE;

    }

    public static final class DateDetailsParameter
    extends DetailsParameter {
        private final LocalDate localDate;

        public DateDetailsParameter(InputEvent inputEvent, DateControl control, Node node, Node owner, LocalDate date, double screenX, double screenY) {
            super(inputEvent, control, node, owner, screenX, screenY);
            this.localDate = Objects.requireNonNull(date);
        }

        public LocalDate getLocalDate() {
            return this.localDate;
        }
    }

    public static enum Usage {
        NONE,
        VERY_LOW,
        LOW,
        MEDIUM,
        HIGH,
        VERY_HIGH;

    }

    private static abstract class DetailsParameter {
        private final InputEvent inputEvent;
        private final DateControl dateControl;
        private final Node owner;
        private final double screenX;
        private final double screenY;
        private final Node node;

        public DetailsParameter(InputEvent inputEvent, DateControl control, Node node, Node owner, double screenX, double screenY) {
            this.inputEvent = inputEvent;
            this.dateControl = Objects.requireNonNull(control);
            this.node = Objects.requireNonNull(node);
            this.owner = Objects.requireNonNull(owner);
            this.screenX = screenX;
            this.screenY = screenY;
        }

        public Node getOwner() {
            return this.owner;
        }

        public Node getNode() {
            return this.node;
        }

        public double getScreenX() {
            return this.screenX;
        }

        public double getScreenY() {
            return this.screenY;
        }

        public InputEvent getInputEvent() {
            return this.inputEvent;
        }

        public DateControl getDateControl() {
            return this.dateControl;
        }
    }

    private static abstract class ContextMenuParameterBase {
        private final DateControl dateControl;
        private final ContextMenuEvent contextMenuEvent;

        public ContextMenuParameterBase(ContextMenuEvent contextMenuEvent, DateControl dateControl) {
            this.contextMenuEvent = Objects.requireNonNull(contextMenuEvent);
            this.dateControl = Objects.requireNonNull(dateControl);
        }

        public ContextMenuEvent getContextMenuEvent() {
            return this.contextMenuEvent;
        }

        public DateControl getDateControl() {
            return this.dateControl;
        }
    }
}

