/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class DateSelectionModel {
    private LocalDate lastSelected;
    private DateSelector selector;
    private final ObservableList<LocalDate> selectedDates = FXCollections.observableArrayList();
    private final ObservableList<LocalDate> unmodifiable = FXCollections.unmodifiableObservableList(this.selectedDates);
    private final ObjectProperty<SelectionMode> selectionMode = new SimpleObjectProperty((Object)this, "selectionMode");

    public DateSelectionModel() {
        this.setSelectionMode(SelectionMode.MULTIPLE_DATES);
    }

    public final void select(LocalDate date) {
        this.selector.select(date);
    }

    public final void selectRange(LocalDate start, LocalDate end) {
        this.selector.selectRange(start, end);
    }

    public final void selectUntil(LocalDate date) {
        this.selector.selectUntil(date);
    }

    public final void deselect(LocalDate date) {
        this.selector.deselect(date);
    }

    public final void clearAndSelect(LocalDate date) {
        this.selector.clearAndSelect(date);
    }

    public final void clear() {
        this.selector.clear();
    }

    public final boolean isSelected(LocalDate date) {
        return this.selectedDates.contains((Object)date);
    }

    public final boolean isEmpty() {
        return this.selectedDates.isEmpty();
    }

    public final ObservableList<LocalDate> getSelectedDates() {
        return this.unmodifiable;
    }

    public final LocalDate getLastSelected() {
        return this.lastSelected;
    }

    public final ObjectProperty<SelectionMode> selectionModeProperty() {
        return this.selectionMode;
    }

    public final SelectionMode getSelectionMode() {
        return (SelectionMode)((Object)this.selectionModeProperty().get());
    }

    public final void setSelectionMode(SelectionMode selectionMode) {
        SelectionMode oldMode = this.getSelectionMode();
        this.selectionModeProperty().set((Object)Objects.requireNonNull(selectionMode));
        if (oldMode != selectionMode) {
            this.selector = DateSelector.createInstance(this);
        }
    }

    public static enum SelectionMode {
        SINGLE_DATE,
        SINGLE_DATE_RANGE,
        MULTIPLE_DATES;

    }

    private static abstract class DateSelector {
        protected final DateSelectionModel model;

        public DateSelector(DateSelectionModel model) {
            this.model = model;
        }

        public abstract void select(LocalDate var1);

        public abstract void selectRange(LocalDate var1, LocalDate var2);

        public abstract void selectUntil(LocalDate var1);

        public void clear() {
            this.model.selectedDates.clear();
            this.model.lastSelected = null;
        }

        public void clearAndSelect(LocalDate date) {
            if (date != null) {
                this.model.selectedDates.setAll((Object[])new LocalDate[]{date});
                this.model.lastSelected = date;
            } else {
                this.clear();
            }
        }

        public void deselect(LocalDate date) {
            this.model.selectedDates.remove((Object)date);
            if (this.model.lastSelected != null && this.model.lastSelected.equals(date)) {
                this.model.lastSelected = null;
            }
        }

        public static DateSelector createInstance(DateSelectionModel model) {
            switch (model.getSelectionMode()) {
                case SINGLE_DATE: {
                    return new SingleDateSelector(model);
                }
                case SINGLE_DATE_RANGE: {
                    return new SingleDateRangeSelector(model);
                }
                case MULTIPLE_DATES: {
                    return new MultipleDatesSelector(model);
                }
            }
            throw new UnsupportedOperationException();
        }
    }

    private static final class MultipleDatesSelector
    extends DateSelector {
        public MultipleDatesSelector(DateSelectionModel model) {
            super(model);
        }

        @Override
        public void select(LocalDate date) {
            if (date != null) {
                if (!this.model.selectedDates.contains((Object)date)) {
                    this.model.selectedDates.add((Object)date);
                }
                this.model.lastSelected = date;
            }
        }

        @Override
        public void selectRange(LocalDate start, LocalDate end) {
            if (start == null || end == null || start.isAfter(end)) {
                return;
            }
            ArrayList<LocalDate> toSelect = new ArrayList<LocalDate>();
            while (start.isBefore(end) || start.equals(end)) {
                if (!this.model.selectedDates.contains((Object)start)) {
                    toSelect.add(start);
                }
                start = start.plusDays(1L);
            }
            this.model.selectedDates.addAll(toSelect);
            this.model.lastSelected = (LocalDate)toSelect.get(toSelect.size() - 1);
        }

        @Override
        public void selectUntil(LocalDate date) {
            if (date != null && this.model.lastSelected != null) {
                LocalDate start = this.model.lastSelected.isBefore(date) ? this.model.lastSelected : date;
                LocalDate end = this.model.lastSelected.isBefore(date) ? date : this.model.lastSelected;
                this.selectRange(start, end);
            }
        }
    }

    private static final class SingleDateRangeSelector
    extends DateSelector {
        private LocalDate rangeStart;
        private LocalDate rangeEnd;

        public SingleDateRangeSelector(DateSelectionModel model) {
            super(model);
            ArrayList<LocalDate> selection = new ArrayList<LocalDate>();
            selection.addAll((Collection<LocalDate>)model.selectedDates);
            if (!selection.isEmpty()) {
                Collections.sort(selection);
                boolean valid = true;
                for (int i = 0; i < selection.size() - 1 && i != selection.size() - 1; ++i) {
                    LocalDate pivot = (LocalDate)selection.get(i);
                    LocalDate next = (LocalDate)selection.get(i + 1);
                    if (next.equals(pivot.plusDays(1L))) continue;
                    valid = false;
                    break;
                }
                if (!valid) {
                    this.clear();
                } else {
                    this.rangeStart = (LocalDate)selection.get(0);
                    model.lastSelected = this.rangeEnd = (LocalDate)selection.get(selection.size() - 1);
                }
            }
        }

        @Override
        public void select(LocalDate date) {
            if (date != null) {
                if (this.rangeStart == null) {
                    this.model.selectedDates.setAll((Object[])new LocalDate[]{date});
                    this.model.lastSelected = date;
                    this.rangeStart = date;
                    this.rangeEnd = date;
                } else if (date.equals(this.rangeStart.plusDays(-1L)) || date.equals(this.rangeEnd.plusDays(1L))) {
                    this.model.selectedDates.add((Object)date);
                    this.model.lastSelected = date;
                    if (date.isAfter(this.rangeEnd)) {
                        this.rangeEnd = date;
                    }
                    if (date.isBefore(this.rangeStart)) {
                        this.rangeStart = date;
                    }
                } else {
                    this.rangeStart = null;
                    this.rangeEnd = null;
                    this.select(date);
                }
            }
        }

        @Override
        public void selectRange(LocalDate start, LocalDate end) {
            if (start != null && end != null && !start.isAfter(end)) {
                if (this.model.isEmpty() || this.isIntersecting(start, end)) {
                    ArrayList<LocalDate> toSelect = new ArrayList<LocalDate>();
                    while (start.isBefore(end) || start.isEqual(end)) {
                        if (!this.model.selectedDates.contains((Object)start)) {
                            toSelect.add(start);
                        }
                        start = start.plusDays(1L);
                    }
                    if (!toSelect.isEmpty()) {
                        LocalDate first = (LocalDate)toSelect.get(0);
                        LocalDate last = (LocalDate)toSelect.get(toSelect.size() - 1);
                        this.model.selectedDates.addAll(toSelect);
                        this.model.lastSelected = last;
                        if (this.rangeStart == null || this.rangeStart.isAfter(first)) {
                            this.rangeStart = first;
                        }
                        if (this.rangeEnd == null || this.rangeEnd.isBefore(last)) {
                            this.rangeEnd = last;
                        }
                    }
                } else if (start.equals(this.rangeEnd.plusDays(1L)) || end.equals(this.rangeStart.plusDays(-1L))) {
                    ArrayList<LocalDate> toSelect = new ArrayList<LocalDate>();
                    while (start.isBefore(end) || start.isEqual(end)) {
                        toSelect.add(start);
                        start = start.plusDays(1L);
                    }
                    LocalDate first = (LocalDate)toSelect.get(0);
                    LocalDate last = (LocalDate)toSelect.get(toSelect.size() - 1);
                    this.model.selectedDates.addAll(toSelect);
                    this.model.lastSelected = last;
                    if (this.rangeStart == null || this.rangeStart.isAfter(first)) {
                        this.rangeStart = first;
                    }
                    if (this.rangeEnd == null || this.rangeEnd.isBefore(last)) {
                        this.rangeEnd = last;
                    }
                } else {
                    ArrayList<LocalDate> toSelect = new ArrayList<LocalDate>();
                    while (start.isBefore(end) || start.isEqual(end)) {
                        toSelect.add(start);
                        start = start.plusDays(1L);
                    }
                    LocalDate first = (LocalDate)toSelect.get(0);
                    LocalDate last = (LocalDate)toSelect.get(toSelect.size() - 1);
                    this.model.selectedDates.setAll(toSelect);
                    this.model.lastSelected = last;
                    if (this.rangeStart == null || this.rangeStart.isAfter(first)) {
                        this.rangeStart = first;
                    }
                    if (this.rangeEnd == null || this.rangeEnd.isBefore(last)) {
                        this.rangeEnd = last;
                    }
                }
            }
        }

        @Override
        public void selectUntil(LocalDate date) {
            if (date != null && this.model.lastSelected != null) {
                LocalDate start = this.model.lastSelected.isBefore(date) ? this.model.lastSelected : date;
                LocalDate end = this.model.lastSelected.isBefore(date) ? date : this.model.lastSelected;
                this.selectRange(start, end);
                this.model.lastSelected = date;
            }
        }

        @Override
        public void clear() {
            super.clear();
            this.rangeStart = null;
            this.rangeEnd = null;
        }

        private boolean isIntersecting(LocalDate start, LocalDate end) {
            if ((start.isBefore(this.rangeStart) || start.isEqual(this.rangeStart)) && (end.isAfter(this.rangeEnd) || end.isEqual(this.rangeEnd))) {
                return true;
            }
            if ((start.isEqual(this.rangeStart) || start.isAfter(this.rangeStart)) && (start.isBefore(this.rangeEnd) || start.isEqual(this.rangeEnd))) {
                return true;
            }
            return !(!end.isEqual(this.rangeStart) && !end.isAfter(this.rangeStart) || !end.isBefore(this.rangeEnd) && !end.isEqual(this.rangeEnd));
        }

        @Override
        public void clearAndSelect(LocalDate date) {
            super.clearAndSelect(date);
            this.rangeStart = date;
            this.rangeEnd = date;
        }
    }

    private static class SingleDateSelector
    extends DateSelector {
        public SingleDateSelector(DateSelectionModel model) {
            super(model);
            if (model.selectedDates.size() > 1) {
                if (model.lastSelected != null) {
                    this.select(model.lastSelected);
                } else {
                    this.select((LocalDate)model.selectedDates.get(0));
                }
            }
        }

        @Override
        public void select(LocalDate date) {
            if (date != null) {
                this.model.selectedDates.setAll((Object[])new LocalDate[]{date});
                this.model.lastSelected = date;
            } else {
                this.model.clear();
            }
        }

        @Override
        public void selectRange(LocalDate start, LocalDate end) {
            if (start == null && end == null) {
                this.model.clear();
            } else if (end != null) {
                this.select(end);
            } else {
                this.select(start);
            }
        }

        @Override
        public void selectUntil(LocalDate date) {
            this.select(date);
        }
    }
}

