/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view;

import com.calendarfx.model.Entry;
import com.calendarfx.view.DayView;
import com.calendarfx.view.EntryViewBase;
import impl.com.calendarfx.view.DayEntryViewSkin;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyMapWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Skin;

public class DayEntryView
extends EntryViewBase<DayView> {
    private final ReadOnlyMapWrapper<Pos, List<Node>> nodes = new ReadOnlyMapWrapper((Object)this, "nodes");
    private final BooleanProperty minHeightEqualToTitleHeight = new SimpleBooleanProperty((Object)this, "minHeightEqualToTitleHeight", true);

    public DayEntryView(Entry<?> entry) {
        super(entry);
    }

    protected Skin<?> createDefaultSkin() {
        return new DayEntryViewSkin(this);
    }

    public final ObservableMap<Pos, List<Node>> getNodes() {
        return this.nodes.getReadOnlyProperty();
    }

    public final ReadOnlyMapWrapper<Pos, List<Node>> nodesProperty() {
        return this.nodes;
    }

    public void clearNodes() {
        if (this.nodes.get() != null) {
            this.nodes.get().clear();
        }
    }

    public void addNode(Pos pos, Node node) {
        if (this.nodes.get() == null) {
            this.nodes.set(FXCollections.observableHashMap());
        }
        List nodes = (List)this.nodes.computeIfAbsent((Object)pos, p -> new ArrayList());
        ArrayList<Node> newNodes = new ArrayList<Node>(nodes);
        newNodes.add(node);
        this.nodes.put((Object)pos, newNodes);
    }

    public void removeNode(Node node) {
        if (this.nodes.get() != null) {
            this.nodes.values().forEach(nodesList -> nodesList.remove(node));
        }
    }

    public final BooleanProperty minHeightEqualToTitleHeightProperty() {
        return this.minHeightEqualToTitleHeight;
    }

    public final boolean isMinHeightEqualToTitleHeight() {
        return this.minHeightEqualToTitleHeight.get();
    }

    public final void setMinHeightEqualToTitleHeight(boolean minHeightEqualToTitleHeight) {
        this.minHeightEqualToTitleHeight.set(minHeightEqualToTitleHeight);
    }
}

