/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view;

import com.calendarfx.view.DateControl;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import org.controlsfx.control.PropertySheet;

public abstract class MonthViewBase
extends DateControl {
    private final ReadOnlyObjectWrapper<YearMonth> yearMonth = new ReadOnlyObjectWrapper((Object)this, "yearMonth", (Object)YearMonth.from(this.getToday()));
    private final BooleanProperty showWeeks = new SimpleBooleanProperty((Object)this, "showWeeks", true);
    private final ObservableSet<LocalDate> selectedDates = FXCollections.observableSet((Object[])new LocalDate[0]);
    private static final String MONTH_VIEW_CATEGORY = "Month View Base";

    protected MonthViewBase() {
        this.dateProperty().addListener(evt -> this.yearMonth.set((Object)YearMonth.from(this.getDate())));
        this.selectionModeProperty().addListener(evt -> this.getSelectedDates().clear());
    }

    public final ReadOnlyObjectProperty<YearMonth> yearMonthProperty() {
        return this.yearMonth.getReadOnlyProperty();
    }

    public final YearMonth getYearMonth() {
        return (YearMonth)this.yearMonthProperty().get();
    }

    public final BooleanProperty showWeekNumbersProperty() {
        return this.showWeeks;
    }

    public final void setShowWeekNumbers(boolean show) {
        this.showWeekNumbersProperty().set(show);
    }

    public final boolean isShowWeekNumbers() {
        return this.showWeekNumbersProperty().get();
    }

    public final ObservableSet<LocalDate> getSelectedDates() {
        return this.selectedDates;
    }

    @Override
    public ObservableList<PropertySheet.Item> getPropertySheetItems() {
        ObservableList<PropertySheet.Item> items = super.getPropertySheetItems();
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(MonthViewBase.this.showWeekNumbersProperty());
            }

            public void setValue(Object value) {
                MonthViewBase.this.setShowWeekNumbers((Boolean)value);
            }

            public Object getValue() {
                return MonthViewBase.this.isShowWeekNumbers();
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getName() {
                return "Show Week Numbers";
            }

            public String getDescription() {
                return "Show or hide the week numbers";
            }

            public String getCategory() {
                return MonthViewBase.MONTH_VIEW_CATEGORY;
            }
        });
        return items;
    }
}

