/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.CalendarSource;
import com.calendarfx.view.CalendarFXControl;
import com.calendarfx.view.DateControl;
import impl.com.calendarfx.view.SourceGridViewSkin;
import java.util.Optional;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.scene.control.Skin;
import org.controlsfx.control.PropertySheet;

public class SourceGridView
extends CalendarFXControl {
    private static final int DEFAULT_MAXIMUM_ROWS_PER_COLUMN = 5;
    private final ObservableList<CalendarSource> calendarSources = FXCollections.observableArrayList();
    private final ObservableMap<Calendar, BooleanProperty> calendarVisibilityMap = FXCollections.observableHashMap();
    private final IntegerProperty maximumRowsPerColumn = new SimpleIntegerProperty((Object)this, "maximumRowsPerColumn", 5){

        public void set(int newValue) {
            if (newValue < 1) {
                throw new RuntimeException("Invalid Number! " + newValue);
            }
            super.set(newValue);
        }
    };
    private static final String SOURCE_GRID_VIEW_CATEGORY = "Source Grid View";

    protected Skin<?> createDefaultSkin() {
        return new SourceGridViewSkin(this);
    }

    public final void bind(DateControl dateControl) {
        Bindings.bindContentBidirectional(this.calendarSources, dateControl.getCalendarSources());
        Bindings.bindContentBidirectional(this.calendarVisibilityMap, dateControl.getCalendarVisibilityMap());
    }

    public final void unbind(DateControl dateControl) {
        Bindings.unbindContentBidirectional(this.calendarSources, dateControl.getCalendarSources());
        Bindings.unbindContentBidirectional(this.calendarVisibilityMap, dateControl.getCalendarVisibilityMap());
        dateControl.getCalendarVisibilityMap().clear();
    }

    public final ObservableList<CalendarSource> getCalendarSources() {
        return this.calendarSources;
    }

    public final ObservableMap<Calendar, BooleanProperty> getCalendarVisibilityMap() {
        return this.calendarVisibilityMap;
    }

    public final BooleanProperty getCalendarVisibilityProperty(Calendar calendar) {
        return (BooleanProperty)this.calendarVisibilityMap.computeIfAbsent((Object)calendar, cal -> new SimpleBooleanProperty((Object)this, "visible", true));
    }

    public final boolean isCalendarVisible(Calendar calendar) {
        BooleanProperty prop = this.getCalendarVisibilityProperty(calendar);
        return prop.get();
    }

    public final void setCalendarVisibility(Calendar calendar, boolean visible) {
        BooleanProperty prop = this.getCalendarVisibilityProperty(calendar);
        prop.set(visible);
    }

    public final IntegerProperty maximumRowsPerColumnProperty() {
        return this.maximumRowsPerColumn;
    }

    public final int getMaximumRowsPerColumn() {
        return this.maximumRowsPerColumnProperty().get();
    }

    public final void setMaximumRowsPerColumn(int maximumRowsPerColumn) {
        this.maximumRowsPerColumnProperty().set(maximumRowsPerColumn);
    }

    @Override
    public ObservableList<PropertySheet.Item> getPropertySheetItems() {
        ObservableList<PropertySheet.Item> items = super.getPropertySheetItems();
        items.add((Object)new PropertySheet.Item(){

            public void setValue(Object value) {
                SourceGridView.this.setMaximumRowsPerColumn((Integer)value);
            }

            public Object getValue() {
                return SourceGridView.this.getMaximumRowsPerColumn();
            }

            public Class<?> getType() {
                return Integer.class;
            }

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(SourceGridView.this.maximumRowsPerColumnProperty());
            }

            public String getName() {
                return "Maximum Rows Per Column";
            }

            public String getDescription() {
                return "The maximum number of rows per column";
            }

            public String getCategory() {
                return SourceGridView.SOURCE_GRID_VIEW_CATEGORY;
            }
        });
        return items;
    }
}

