/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view;

import com.calendarfx.view.MonthViewBase;
import impl.com.calendarfx.view.YearMonthViewSkin;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.util.Callback;
import org.controlsfx.control.PropertySheet;

public class YearMonthView
extends MonthViewBase {
    private final ObjectProperty<Callback<YearMonthView, DateCell>> cellFactory = new SimpleObjectProperty((Object)this, "cellFactory");
    private final BooleanProperty showMonth = new SimpleBooleanProperty((Object)this, "showMonth", true);
    private final BooleanProperty showYear = new SimpleBooleanProperty((Object)this, "showYear", true);
    private final BooleanProperty showTodayButton = new SimpleBooleanProperty((Object)this, "showTodayButton", true);
    private final BooleanProperty showMonthArrows = new SimpleBooleanProperty((Object)this, "showMonthArrows", true);
    private final BooleanProperty showYearArrows = new SimpleBooleanProperty((Object)this, "showYearArrows", true);
    private final BooleanProperty showUsageColors = new SimpleBooleanProperty((Object)this, "showUsageColors", false);
    private final ObjectProperty<ClickBehaviour> clickBehaviour = new SimpleObjectProperty((Object)this, "clickBehaviour", (Object)ClickBehaviour.PERFORM_SELECTION);
    private static final String MONTH_VIEW_CATEGORY = "Month View";

    public YearMonthView() {
        this.getStyleClass().add((Object)"year-month-view");
        this.setCellFactory((Callback<YearMonthView, DateCell>)((Callback)view -> new DateCell()));
    }

    protected Skin<?> createDefaultSkin() {
        return new YearMonthViewSkin(this);
    }

    public final ObjectProperty<Callback<YearMonthView, DateCell>> cellFactoryProperty() {
        return this.cellFactory;
    }

    public final void setCellFactory(Callback<YearMonthView, DateCell> factory) {
        Objects.requireNonNull(factory);
        this.cellFactoryProperty().set(factory);
    }

    public final Callback<YearMonthView, DateCell> getCellFactory() {
        return (Callback)this.cellFactoryProperty().get();
    }

    public final BooleanProperty showMonthProperty() {
        return this.showMonth;
    }

    public final void setShowMonth(boolean show) {
        this.showMonthProperty().set(show);
    }

    public final boolean isShowMonth() {
        return this.showMonthProperty().get();
    }

    public final BooleanProperty showYearProperty() {
        return this.showYear;
    }

    public final void setShowYear(boolean show) {
        this.showYearProperty().set(show);
    }

    public final boolean isShowYear() {
        return this.showYearProperty().get();
    }

    public final BooleanProperty showTodayButtonProperty() {
        return this.showTodayButton;
    }

    public final void setShowTodayButton(boolean show) {
        this.showTodayButtonProperty().set(show);
    }

    public final boolean isShowTodayButton() {
        return this.showTodayButtonProperty().get();
    }

    public final BooleanProperty showMonthArrowsProperty() {
        return this.showMonthArrows;
    }

    public final void setShowMonthArrows(boolean show) {
        this.showMonthArrowsProperty().set(show);
    }

    public final boolean isShowMonthArrows() {
        return this.showMonthArrowsProperty().get();
    }

    public final BooleanProperty showYearArrowsProperty() {
        return this.showYearArrows;
    }

    public final void setShowYearArrows(boolean show) {
        this.showYearArrowsProperty().set(show);
    }

    public final boolean isShowYearArrows() {
        return this.showYearArrowsProperty().get();
    }

    public final BooleanProperty showUsageColorsProperty() {
        return this.showUsageColors;
    }

    public final void setShowUsageColors(boolean show) {
        this.showUsageColorsProperty().set(show);
    }

    public final boolean isShowUsageColors() {
        return this.showUsageColorsProperty().get();
    }

    public final ObjectProperty<ClickBehaviour> clickBehaviourProperty() {
        return this.clickBehaviour;
    }

    public final void setClickBehaviour(ClickBehaviour behaviour) {
        Objects.requireNonNull(behaviour);
        this.clickBehaviourProperty().set((Object)behaviour);
    }

    public final ClickBehaviour getClickBehaviour() {
        return (ClickBehaviour)((Object)this.clickBehaviourProperty().get());
    }

    @Override
    public ObservableList<PropertySheet.Item> getPropertySheetItems() {
        ObservableList<PropertySheet.Item> items = super.getPropertySheetItems();
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(YearMonthView.this.clickBehaviourProperty());
            }

            public void setValue(Object value) {
                YearMonthView.this.setClickBehaviour((ClickBehaviour)((Object)value));
            }

            public Object getValue() {
                return YearMonthView.this.getClickBehaviour();
            }

            public Class<?> getType() {
                return ClickBehaviour.class;
            }

            public String getName() {
                return "Click Behaviour";
            }

            public String getDescription() {
                return "Click behaviour";
            }

            public String getCategory() {
                return YearMonthView.MONTH_VIEW_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(YearMonthView.this.showMonthProperty());
            }

            public void setValue(Object value) {
                YearMonthView.this.setShowMonth((Boolean)value);
            }

            public Object getValue() {
                return YearMonthView.this.isShowMonth();
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getName() {
                return "Show Month";
            }

            public String getDescription() {
                return "Show or hide the name of the month";
            }

            public String getCategory() {
                return YearMonthView.MONTH_VIEW_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(YearMonthView.this.showTodayButtonProperty());
            }

            public void setValue(Object value) {
                YearMonthView.this.setShowTodayButton((Boolean)value);
            }

            public Object getValue() {
                return YearMonthView.this.isShowTodayButton();
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getName() {
                return "Show Today Button";
            }

            public String getDescription() {
                return "Show or hide the 'today' button";
            }

            public String getCategory() {
                return YearMonthView.MONTH_VIEW_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(YearMonthView.this.showUsageColorsProperty());
            }

            public void setValue(Object value) {
                YearMonthView.this.setShowUsageColors((Boolean)value);
            }

            public Object getValue() {
                return YearMonthView.this.isShowUsageColors();
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getName() {
                return "Show Usage Colors";
            }

            public String getDescription() {
                return "Show Usage Colors";
            }

            public String getCategory() {
                return YearMonthView.MONTH_VIEW_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(YearMonthView.this.showYearProperty());
            }

            public void setValue(Object value) {
                YearMonthView.this.setShowYear((Boolean)value);
            }

            public Object getValue() {
                return YearMonthView.this.isShowYear();
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getName() {
                return "Show Year";
            }

            public String getDescription() {
                return "Show or hide the year";
            }

            public String getCategory() {
                return YearMonthView.MONTH_VIEW_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(YearMonthView.this.showYearArrowsProperty());
            }

            public void setValue(Object value) {
                YearMonthView.this.setShowYearArrows((Boolean)value);
            }

            public Object getValue() {
                return YearMonthView.this.isShowYearArrows();
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getName() {
                return "Show Year Arrows";
            }

            public String getDescription() {
                return "Show or hide the year adjuster arrows";
            }

            public String getCategory() {
                return YearMonthView.MONTH_VIEW_CATEGORY;
            }
        });
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(YearMonthView.this.showMonthArrowsProperty());
            }

            public void setValue(Object value) {
                YearMonthView.this.setShowMonthArrows((Boolean)value);
            }

            public Object getValue() {
                return YearMonthView.this.isShowMonthArrows();
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getName() {
                return "Show Month Arrows";
            }

            public String getDescription() {
                return "Show or hide the month adjustment arrows";
            }

            public String getCategory() {
                return YearMonthView.MONTH_VIEW_CATEGORY;
            }
        });
        return items;
    }

    public static enum ClickBehaviour {
        PERFORM_SELECTION,
        SHOW_DETAILS,
        NONE;

    }

    public static class DateCell
    extends Label {
        private LocalDate date;

        public DateCell() {
            this.setFocusTraversable(false);
            this.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
            this.setAlignment(Pos.CENTER);
        }

        public final void setDate(LocalDate date) {
            this.date = date;
            this.update(date);
        }

        public final LocalDate getDate() {
            return this.date;
        }

        protected void update(LocalDate date) {
            this.setText(Integer.toString(date.getDayOfMonth()));
        }
    }
}

