/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view.page;

import com.calendarfx.view.DateControl;
import com.calendarfx.view.DetailedWeekView;
import com.calendarfx.view.Messages;
import com.calendarfx.view.page.PageBase;
import com.calendarfx.view.print.ViewType;
import impl.com.calendarfx.view.page.WeekPageSkin;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import org.controlsfx.control.PropertySheet;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.fontawesome.FontAwesome;
import org.kordamp.ikonli.javafx.FontIcon;

public class WeekPage
extends PageBase {
    private final DetailedWeekView detailedWeekView;
    private final HBox toolBarControls = new HBox();
    private final BooleanProperty showLayoutButton = new SimpleBooleanProperty((Object)this, "showLayoutButton", true);
    private final String WEEK_PAGE_CATEGORY = "Week Page";

    public WeekPage() {
        this.getStyleClass().add((Object)"week-page");
        this.setDateTimeFormatter(DateTimeFormatter.ofPattern(Messages.getString("WeekPage.DATE_FORMAT")));
        this.toolBarControls.getStyleClass().add((Object)"toolbar-controls-box");
        this.detailedWeekView = new DetailedWeekView();
        FontIcon layoutIcon = new FontIcon((Ikon)FontAwesome.TABLE);
        layoutIcon.getStyleClass().addAll((Object[])new String[]{"button-icon", "layout-button-icon"});
        ToggleButton layoutButton = new ToggleButton();
        layoutButton.setMaxHeight(Double.MAX_VALUE);
        layoutButton.setTooltip(new Tooltip(Messages.getString("WeekPage.TOOLTIP_LAYOUT")));
        layoutButton.setId("layout-button");
        layoutButton.setGraphic((Node)layoutIcon);
        layoutButton.setSelected(this.getLayout().equals((Object)DateControl.Layout.SWIMLANE));
        layoutButton.setOnAction(evt -> {
            if (layoutButton.isSelected()) {
                this.setLayout(DateControl.Layout.SWIMLANE);
            } else {
                this.setLayout(DateControl.Layout.STANDARD);
            }
        });
        this.showLayoutButtonProperty().addListener(it -> this.updateToolBarControls(layoutButton));
        this.updateToolBarControls(layoutButton);
    }

    protected Skin<?> createDefaultSkin() {
        return new WeekPageSkin(this);
    }

    @Override
    public Node getToolBarControls() {
        return this.toolBarControls;
    }

    private void updateToolBarControls(ToggleButton layoutButton) {
        if (this.isShowLayoutButton()) {
            this.toolBarControls.getChildren().setAll((Object[])new Node[]{layoutButton});
        } else {
            this.toolBarControls.getChildren().clear();
        }
    }

    public final BooleanProperty showLayoutButtonProperty() {
        return this.showLayoutButton;
    }

    public final boolean isShowLayoutButton() {
        return this.showLayoutButton.get();
    }

    public final void setShowLayoutButton(boolean show) {
        this.showLayoutButton.set(show);
    }

    public final DetailedWeekView getDetailedWeekView() {
        return this.detailedWeekView;
    }

    @Override
    public final void goForward() {
        this.setDate(this.detailedWeekView.getStartDate().plusDays(Math.max(7, this.detailedWeekView.getNumberOfDays())));
    }

    @Override
    public final void goBack() {
        this.setDate(this.detailedWeekView.getStartDate().minusDays(Math.max(7, this.detailedWeekView.getNumberOfDays())));
    }

    @Override
    public final ViewType getPrintViewType() {
        return ViewType.WEEK_VIEW;
    }

    @Override
    public ObservableList<PropertySheet.Item> getPropertySheetItems() {
        ObservableList<PropertySheet.Item> items = super.getPropertySheetItems();
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(WeekPage.this.showLayoutButtonProperty());
            }

            public void setValue(Object value) {
                WeekPage.this.setShowLayoutButton((Boolean)value);
            }

            public Object getValue() {
                return WeekPage.this.isShowLayoutButton();
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public String getName() {
                return "Layout Button";
            }

            public String getDescription() {
                return "Can the user access the button to toggle the layout or not.";
            }

            public String getCategory() {
                return "Week Page";
            }
        });
        return items;
    }
}

