/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view.popover;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.Entry;
import com.calendarfx.view.DateControl;
import com.calendarfx.view.Messages;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.format.TextStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Circle;

class EntriesPane
extends VBox {
    private final DateControl dateControl;
    private final ObservableList<Entry<?>> entries = FXCollections.observableArrayList();

    public EntriesPane(DateControl dateControl) {
        this.dateControl = Objects.requireNonNull(dateControl, "date control can not be null");
        this.setMinSize(0.0, 0.0);
        this.getEntries().addListener(evt -> this.update());
        this.getStyleClass().add((Object)"entries-pane");
        this.setAlignment(Pos.CENTER);
    }

    public final ObservableList<Entry<?>> getEntries() {
        return this.entries;
    }

    private void update() {
        if (!this.entries.isEmpty()) {
            ArrayList workingList = new ArrayList((Collection<Entry<?>>)this.entries);
            Collections.sort(workingList);
            for (Entry entry : workingList) {
                Calendar calendar = entry.getCalendar();
                BorderPane borderPane = new BorderPane();
                borderPane.getStyleClass().add((Object)"entry");
                Label titleLabel = new Label(entry.getTitle());
                BorderPane.setAlignment((Node)titleLabel, (Pos)Pos.CENTER_LEFT);
                titleLabel.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
                titleLabel.getStyleClass().add((Object)"title");
                borderPane.setCenter((Node)titleLabel);
                Circle colorDot = new Circle();
                colorDot.setRadius(2.5);
                colorDot.getStyleClass().add((Object)(calendar.getStyle() + "-icon-small"));
                titleLabel.setGraphic((Node)colorDot);
                Label timeLabel = new Label();
                if (entry.isFullDay()) {
                    timeLabel.setText(Messages.getString("EntriesPane.FULL_DAY"));
                } else {
                    ZoneId controlZoneId;
                    DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT);
                    ZonedDateTime startTime = entry.getStartAsZonedDateTime();
                    ZoneId entryZoneId = entry.getZoneId();
                    if (!Objects.equals(entryZoneId, controlZoneId = this.dateControl.getZoneId())) {
                        timeLabel.setText(formatter.format(startTime.withZoneSameInstant(controlZoneId)) + " (" + formatter.format(startTime) + " " + entryZoneId.getDisplayName(TextStyle.SHORT, Locale.getDefault()) + ")");
                    } else {
                        timeLabel.setText(formatter.format(startTime));
                    }
                }
                borderPane.setRight((Node)timeLabel);
                timeLabel.getStyleClass().add((Object)"time");
                BorderPane.setAlignment((Node)timeLabel, (Pos)Pos.CENTER_RIGHT);
                this.getChildren().add((Object)borderPane);
            }
        }
    }
}

