/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view.popover;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.Entry;
import com.calendarfx.view.CalendarSelector;
import com.calendarfx.view.CalendarView;
import com.calendarfx.view.Messages;
import java.util.List;
import java.util.Objects;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;

public class EntryHeaderView
extends GridPane {
    private final CalendarSelector calendarSelector;
    private final Entry<?> entry;
    private final TextField titleField = new TextField();
    private final ChangeListener<Calendar> calendarChangeListener = (observable, oldCalendar, newCalendar) -> {
        if (oldCalendar != null) {
            this.titleField.getStyleClass().remove((Object)(oldCalendar.getStyle() + "-entry-popover-title"));
        }
        if (newCalendar != null) {
            this.titleField.getStyleClass().add((Object)(newCalendar.getStyle() + "-entry-popover-title"));
        }
    };
    private final WeakChangeListener<Calendar> weakCalendarChangeListener = new WeakChangeListener(this.calendarChangeListener);

    public EntryHeaderView(Entry<?> entry, List<Calendar> calendars) {
        this.entry = Objects.requireNonNull(entry);
        Objects.requireNonNull(calendars);
        this.getStylesheets().add((Object)CalendarView.class.getResource("calendar.css").toExternalForm());
        Bindings.bindBidirectional((Property)this.titleField.textProperty(), (Property)entry.titleProperty());
        this.titleField.setText(entry.getTitle());
        this.titleField.disableProperty().bind((ObservableValue)entry.getCalendar().readOnlyProperty());
        TextField locationField = new TextField(entry.getLocation());
        Bindings.bindBidirectional((Property)locationField.textProperty(), (Property)entry.locationProperty());
        locationField.getStyleClass().add((Object)"location");
        locationField.setEditable(true);
        locationField.setPromptText(Messages.getString("EntryHeaderView.PROMPT_LOCATION"));
        locationField.setMaxWidth(500.0);
        locationField.disableProperty().bind((ObservableValue)entry.getCalendar().readOnlyProperty());
        this.calendarSelector = new CalendarSelector();
        this.calendarSelector.disableProperty().bind((ObservableValue)entry.getCalendar().readOnlyProperty());
        this.calendarSelector.getCalendars().setAll(calendars);
        this.calendarSelector.setCalendar(entry.getCalendar());
        Bindings.bindBidirectional(this.calendarSelector.calendarProperty(), entry.calendarProperty());
        this.titleField.getStyleClass().add((Object)"default-style-entry-popover-title");
        this.add((Node)this.titleField, 0, 0);
        this.add((Node)this.calendarSelector, 1, 0, 1, 2);
        this.add((Node)locationField, 0, 1);
        RowConstraints row1 = new RowConstraints();
        row1.setValignment(VPos.TOP);
        row1.setFillHeight(true);
        RowConstraints row2 = new RowConstraints();
        row2.setValignment(VPos.TOP);
        row2.setFillHeight(true);
        this.getRowConstraints().addAll((Object[])new RowConstraints[]{row1, row2});
        ColumnConstraints col1 = new ColumnConstraints();
        col1.setFillWidth(true);
        col1.setHgrow(Priority.ALWAYS);
        ColumnConstraints col2 = new ColumnConstraints();
        col2.setFillWidth(true);
        col2.setHgrow(Priority.NEVER);
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{col1, col2});
        this.getStyleClass().add((Object)"popover-header");
        this.titleField.getStyleClass().add((Object)"title");
        this.titleField.setPromptText(Messages.getString("EntryHeaderView.PROMPT_TITLE"));
        this.titleField.setMaxWidth(500.0);
        Calendar calendar = entry.getCalendar();
        this.titleField.getStyleClass().add((Object)(calendar.getStyle() + "-entry-popover-title"));
        entry.calendarProperty().addListener(this.weakCalendarChangeListener);
    }

    public final Calendar getCalendar() {
        Calendar calendar = this.calendarSelector.getCalendar();
        if (calendar == null) {
            calendar = this.entry.getCalendar();
        }
        return calendar;
    }
}

