/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view.popover;

import com.calendarfx.model.Entry;
import com.calendarfx.util.LoggingDomain;
import com.calendarfx.view.popover.EntryPopOverPane;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.logging.Level;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.geometry.Insets;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.BackgroundSize;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;

public class EntryMapView
extends EntryPopOverPane {
    private final Entry<?> entry;
    private final ImageLoader imageLoader = new ImageLoader();
    private final InvalidationListener invalidationListener = it -> this.imageLoader.restart();
    private final WeakInvalidationListener weakInvalidationListener = new WeakInvalidationListener(this.invalidationListener);
    private final StringProperty googleApiKey = new SimpleStringProperty((Object)this, "googleApiKey", System.getProperty("calendarfx.google.api.key"));

    public EntryMapView(Entry<?> entry) {
        this.entry = Objects.requireNonNull(entry);
        StackPane mapViewPane = new StackPane();
        mapViewPane.setPrefSize(340.0, 240.0);
        mapViewPane.setPadding(new Insets(1.0));
        mapViewPane.setStyle("-fx-border-color: gray; -fx-border-radius: 4px;");
        mapViewPane.backgroundProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> {
            Image image = (Image)this.imageLoader.getValue();
            if (image != null) {
                return new Background(new BackgroundImage[]{new BackgroundImage(image, BackgroundRepeat.NO_REPEAT, BackgroundRepeat.NO_REPEAT, BackgroundPosition.CENTER, new BackgroundSize(100.0, 100.0, true, true, false, true))});
            }
            return null;
        }, (Observable[])new Observable[]{this.imageLoader.valueProperty()}));
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            mapViewPane.setCursor(Cursor.HAND);
            mapViewPane.setOnMouseClicked(evt -> {
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.browse(new URL("https://www.google.com/maps/search/?api=1&query=" + URLEncoder.encode(entry.getLocation(), StandardCharsets.UTF_8)).toURI());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        Rectangle clip = new Rectangle();
        clip.widthProperty().bind((ObservableValue)mapViewPane.widthProperty());
        clip.heightProperty().bind((ObservableValue)mapViewPane.heightProperty());
        clip.setArcHeight(4.0);
        clip.setArcWidth(4.0);
        mapViewPane.setClip((Node)clip);
        this.getChildren().add((Object)mapViewPane);
        entry.locationProperty().addListener((InvalidationListener)this.weakInvalidationListener);
        this.visibleProperty().bind((ObservableValue)entry.locationProperty().isNotNull().and((ObservableBooleanValue)this.googleApiKeyProperty().isNotNull()));
        this.managedProperty().bind((ObservableValue)entry.locationProperty().isNotNull().and((ObservableBooleanValue)this.googleApiKeyProperty().isNotNull()));
        this.imageLoader.restart();
    }

    public Image loadMapImage(String address) {
        if (address != null) {
            try {
                String encodedAddress = URLEncoder.encode(address, StandardCharsets.UTF_8);
                String key = this.getGoogleApiKey();
                String url = "https://maps.googleapis.com/maps/api/staticmap?center=" + encodedAddress + "&markers=color:0xE94B35%7C" + encodedAddress + "&scale=2&zoom=16&size=340x240&key=" + key;
                LoggingDomain.VIEW.fine("google map call (static image): " + url);
                Image image = new Image(url);
                return image;
            }
            catch (Exception ex) {
                LoggingDomain.VIEW.log(Level.SEVERE, "error when trying to load google maps static image", ex);
            }
        }
        return null;
    }

    public final String getGoogleApiKey() {
        return (String)this.googleApiKey.get();
    }

    public final StringProperty googleApiKeyProperty() {
        return this.googleApiKey;
    }

    public final void setGoogleApiKey(String googleApiKey) {
        this.googleApiKey.set((Object)googleApiKey);
    }

    private class ImageLoader
    extends Service<Image> {
        protected Task createTask() {
            return new ImageTask(EntryMapView.this.entry.getLocation());
        }
    }

    private class ImageTask
    extends Task<Image> {
        private final String location;

        public ImageTask(String location) {
            this.location = location;
        }

        protected Image call() throws Exception {
            Thread.sleep(500L);
            if (this.isCancelled() || EntryMapView.this.getGoogleApiKey().isBlank() || this.location == null || this.location.trim().equals("")) {
                return null;
            }
            return EntryMapView.this.loadMapImage(this.location);
        }
    }
}

