/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view.popover;

import javafx.animation.FadeTransition;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TitledPane;
import javafx.util.Duration;

public class PopOverTitledPane
extends TitledPane {
    private final ObjectProperty<Duration> fadingDuration = new SimpleObjectProperty((Object)this, "fadingDuration", (Object)Duration.seconds((double)0.2));

    public PopOverTitledPane(String title, Node detailedContent) {
        this(title, null, detailedContent);
    }

    public PopOverTitledPane(String title, Node summaryContent, Node detailedContent) {
        super(title, detailedContent);
        if (title == null) {
            throw new IllegalArgumentException("title can not be null");
        }
        if (detailedContent == null) {
            throw new IllegalArgumentException("detailed content can not be null");
        }
        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
        this.setGraphic(summaryContent);
        this.expandedProperty().addListener((value, oldExpanded, newExpanded) -> {
            if (newExpanded.booleanValue()) {
                this.setContentDisplay(ContentDisplay.TEXT_ONLY);
                detailedContent.setOpacity(0.0);
                FadeTransition fadeInContent = new FadeTransition(this.getFadingDuration());
                fadeInContent.setFromValue(0.0);
                fadeInContent.setToValue(1.0);
                fadeInContent.setNode(detailedContent);
                fadeInContent.play();
            } else if (summaryContent != null) {
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                summaryContent.setOpacity(0.0);
                FadeTransition fadeInSummary = new FadeTransition(this.getFadingDuration());
                fadeInSummary.setFromValue(0.0);
                fadeInSummary.setToValue(1.0);
                fadeInSummary.setNode(summaryContent);
                fadeInSummary.play();
            }
        });
    }

    public final ObjectProperty<Duration> fadingDurationProperty() {
        return this.fadingDuration;
    }

    public final void setFadingDuration(Duration duration) {
        this.fadingDurationProperty().set((Object)duration);
    }

    public final Duration getFadingDuration() {
        return (Duration)this.fadingDurationProperty().get();
    }
}

