/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view.popover;

import com.calendarfx.view.CalendarView;
import com.calendarfx.view.RecurrenceView;
import impl.com.calendarfx.view.popover.RecurrencePopupSkin;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.control.PopupControl;
import javafx.scene.control.Skin;
import javafx.scene.layout.StackPane;

public class RecurrencePopup
extends PopupControl {
    private static final String DEFAULT_STYLE = "recurrence-popup";
    private final RecurrenceView recurrenceView;
    private final StackPane root;
    private RecurrencePopupEventHandlerProperty onOkPressed;
    private RecurrencePopupEventHandlerProperty onCancelPressed;

    public RecurrencePopup() {
        this.getStyleClass().add((Object)DEFAULT_STYLE);
        this.root = new StackPane();
        this.root.getStylesheets().add((Object)CalendarView.class.getResource("calendar.css").toExternalForm());
        this.recurrenceView = new RecurrenceView();
        this.recurrenceView.setShowSummary(false);
        Bindings.bindContentBidirectional((ObservableList)this.root.getStyleClass(), (ObservableList)this.getStyleClass());
        this.setAutoFix(true);
        this.setAutoHide(true);
    }

    protected Skin<?> createDefaultSkin() {
        return new RecurrencePopupSkin(this);
    }

    public final StackPane getRoot() {
        return this.root;
    }

    public final RecurrenceView getRecurrenceView() {
        return this.recurrenceView;
    }

    public final ObjectProperty<EventHandler<RecurrencePopupEvent>> onOkPressedProperty() {
        if (this.onOkPressed == null) {
            this.onOkPressed = new RecurrencePopupEventHandlerProperty("onOkPressed", RecurrencePopupEvent.OK_PRESSED);
        }
        return this.onOkPressed;
    }

    public final void setOnOkPressed(EventHandler<RecurrencePopupEvent> value) {
        this.onOkPressedProperty().set(value);
    }

    public final EventHandler<RecurrencePopupEvent> getOnOkPressed() {
        return this.onOkPressed == null ? null : (EventHandler)this.onOkPressedProperty().get();
    }

    public final ObjectProperty<EventHandler<RecurrencePopupEvent>> onCancelPressedProperty() {
        if (this.onCancelPressed == null) {
            this.onCancelPressed = new RecurrencePopupEventHandlerProperty("onCancelPressed", RecurrencePopupEvent.CANCEL_PRESSED);
        }
        return this.onCancelPressed;
    }

    public final void setOnCancelPressed(EventHandler<RecurrencePopupEvent> value) {
        this.onCancelPressedProperty().set(value);
    }

    public final EventHandler<RecurrencePopupEvent> getOnCancelPressed() {
        return this.onCancelPressed == null ? null : (EventHandler)this.onCancelPressedProperty().get();
    }

    private class RecurrencePopupEventHandlerProperty
    extends SimpleObjectProperty<EventHandler<RecurrencePopupEvent>> {
        private final EventType<RecurrencePopupEvent> eventType;

        public RecurrencePopupEventHandlerProperty(String name, EventType<RecurrencePopupEvent> eventType) {
            super((Object)RecurrencePopup.this, name);
            this.eventType = eventType;
        }

        protected void invalidated() {
            RecurrencePopup.this.setEventHandler(this.eventType, (EventHandler)this.get());
        }
    }

    public static class RecurrencePopupEvent
    extends Event {
        public static final EventType<RecurrencePopupEvent> RECURRENCE_POPUP_CLOSED = new EventType(Event.ANY, "RECURRENCE_POPUP_CLOSED");
        public static final EventType<RecurrencePopupEvent> OK_PRESSED = new EventType(RECURRENCE_POPUP_CLOSED, "OK_PRESSED");
        public static final EventType<RecurrencePopupEvent> CANCEL_PRESSED = new EventType(RECURRENCE_POPUP_CLOSED, "CANCEL_PRESSED");

        public RecurrencePopupEvent(EventType<? extends Event> eventType) {
            super(eventType);
        }
    }
}

