/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view.print;

import com.calendarfx.view.print.ViewTypeControl;
import impl.com.calendarfx.view.print.PaperViewSkin;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.print.Paper;
import javafx.print.Printer;
import javafx.print.PrinterAttributes;
import javafx.scene.control.Skin;

public class PaperView
extends ViewTypeControl {
    private static final String DEFAULT_STYLE = "paper-view";
    private final ObjectProperty<Paper> paper = new SimpleObjectProperty((Object)this, "paper", (Object)Paper.A4);
    private final ObservableList<Paper> availablePapers = FXCollections.observableArrayList();
    private final ObjectProperty<MarginType> marginType = new SimpleObjectProperty<MarginType>((Object)this, "marginType", MarginType.DEFAULT){

        public void set(MarginType newValue) {
            super.set((Object)Objects.requireNonNull(newValue));
        }
    };
    private final DoubleProperty topMargin = new SimpleDoubleProperty((Object)this, "topMargin"){

        public void set(double newValue) {
            if (newValue < 0.0) {
                throw new IllegalArgumentException("The margin is invalid: " + newValue);
            }
            super.set(newValue);
        }
    };
    private final DoubleProperty rightMargin = new SimpleDoubleProperty((Object)this, "rightMargin"){

        public void set(double newValue) {
            if (newValue < 0.0) {
                throw new IllegalArgumentException("The margin is invalid: " + newValue);
            }
            super.set(newValue);
        }
    };
    private final DoubleProperty bottomMargin = new SimpleDoubleProperty((Object)this, "bottomMargin"){

        public void set(double newValue) {
            if (newValue < 0.0) {
                throw new IllegalArgumentException("The margin is invalid: " + newValue);
            }
            super.set(newValue);
        }
    };
    private final DoubleProperty leftMargin = new SimpleDoubleProperty((Object)this, "leftMargin"){

        public void set(double newValue) {
            if (newValue < 0.0) {
                throw new IllegalArgumentException("The margin is invalid: " + newValue);
            }
            super.set(newValue);
        }
    };
    private final BooleanProperty showMargin = new SimpleBooleanProperty((Object)this, "showMargin", true);

    public PaperView() {
        Set supportedPapers;
        PrinterAttributes printerAttributes;
        this.getStyleClass().add((Object)DEFAULT_STYLE);
        Printer defaultPrinter = Printer.getDefaultPrinter();
        if (defaultPrinter != null && (printerAttributes = defaultPrinter.getPrinterAttributes()) != null && (supportedPapers = printerAttributes.getSupportedPapers()) != null) {
            this.getAvailablePapers().setAll((Collection)supportedPapers);
        }
    }

    protected Skin<?> createDefaultSkin() {
        return new PaperViewSkin(this);
    }

    public final ObjectProperty<Paper> paperProperty() {
        return this.paper;
    }

    public final Paper getPaper() {
        return (Paper)this.paperProperty().get();
    }

    public final void setPaper(Paper paper) {
        this.paperProperty().set((Object)paper);
    }

    public final ObservableList<Paper> getAvailablePapers() {
        return this.availablePapers;
    }

    public final ObjectProperty<MarginType> marginTypeProperty() {
        return this.marginType;
    }

    public final MarginType getMarginType() {
        return (MarginType)((Object)this.marginTypeProperty().get());
    }

    public final void setMarginType(MarginType type) {
        this.marginTypeProperty().set((Object)type);
    }

    public final DoubleProperty topMarginProperty() {
        return this.topMargin;
    }

    public final double getTopMargin() {
        return this.topMarginProperty().get();
    }

    public final void setTopMargin(double margin) {
        this.topMarginProperty().set(margin);
    }

    public final DoubleProperty rightMarginProperty() {
        return this.rightMargin;
    }

    public final double getRightMargin() {
        return this.rightMarginProperty().get();
    }

    public final void setRightMargin(double margin) {
        this.rightMarginProperty().set(margin);
    }

    public final DoubleProperty bottomMarginProperty() {
        return this.bottomMargin;
    }

    public final double getBottomMargin() {
        return this.bottomMarginProperty().get();
    }

    public final void setBottomMargin(double margin) {
        this.bottomMarginProperty().set(margin);
    }

    public final DoubleProperty leftMarginProperty() {
        return this.leftMargin;
    }

    public final double getLeftMargin() {
        return this.leftMarginProperty().get();
    }

    public final void setLeftMargin(double margin) {
        this.leftMarginProperty().set(margin);
    }

    public BooleanProperty showMarginProperty() {
        return this.showMargin;
    }

    public void setShowMargin(boolean show) {
        this.showMarginProperty().set(show);
    }

    public boolean isShowMargin() {
        return this.showMarginProperty().get();
    }

    public static enum MarginType {
        MINIMUM(Printer.MarginType.HARDWARE_MINIMUM),
        DEFAULT(Printer.MarginType.DEFAULT),
        CUSTOM(null);

        Printer.MarginType type;

        private MarginType(Printer.MarginType type) {
            this.type = type;
        }

        public Printer.MarginType getPrinterMarginType() {
            return this.type;
        }
    }
}

