/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view.print;

import com.calendarfx.view.print.ViewType;
import com.calendarfx.view.print.ViewTypeControl;
import impl.com.calendarfx.view.print.TimeRangeFieldSkin;
import java.time.LocalDate;
import java.time.Month;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Skin;
import org.controlsfx.control.PropertySheet;

public class TimeRangeField
extends ViewTypeControl {
    public static final String DEFAULT_STYLE = "time-range-field";
    private final ObjectProperty<LocalDate> today = new SimpleObjectProperty((Object)this, "today", (Object)LocalDate.now());
    private final ObjectProperty<WeekFields> weekFields = new SimpleObjectProperty((Object)this, "weekFields", (Object)WeekFields.ISO);
    private final BooleanProperty endField = new SimpleBooleanProperty((Object)this, "endField");
    private final ObservableList<TimeRangeFieldValue> values = FXCollections.observableArrayList();
    private final ObservableList<TimeRangeFieldValue> valuesUnmodifiable = FXCollections.unmodifiableObservableList(this.values);
    private final ObjectProperty<TimeRangeFieldValue> value = new SimpleObjectProperty<TimeRangeFieldValue>((Object)this, "value"){

        public void set(TimeRangeFieldValue newValue) {
            if (newValue == null) {
                return;
            }
            super.set((Object)newValue);
        }
    };
    private final ObjectProperty<LocalDate> onDate = new SimpleObjectProperty((Object)this, "onDate");
    private final ObjectProperty<Integer> onWeekNumber = new SimpleObjectProperty((Object)this, "onWeekNumber");
    private final ObjectProperty<Integer> monthYear = new SimpleObjectProperty((Object)this, "monthYear");
    private final ObjectProperty<Integer> afterUnits = new SimpleObjectProperty((Object)this, "afterUnits");
    private static final String TIME_RANGE_FIELD_CATEGORY = "Time Range Field";

    public TimeRangeField() {
        this(ViewType.DAY_VIEW);
    }

    public TimeRangeField(ViewType viewType) {
        this(viewType, false);
    }

    public TimeRangeField(boolean endField) {
        this(ViewType.DAY_VIEW, endField);
    }

    public TimeRangeField(ViewType viewType, boolean endField) {
        this.getStyleClass().add((Object)DEFAULT_STYLE);
        InvalidationListener updateValuesListener = obs -> this.updateValues();
        this.viewTypeProperty().addListener(updateValuesListener);
        this.endFieldProperty().addListener(updateValuesListener);
        this.valueProperty().addListener(obs -> this.updateFields());
        this.setViewType(viewType);
        this.setEndField(endField);
        this.updateValues();
    }

    protected Skin<?> createDefaultSkin() {
        return new TimeRangeFieldSkin(this);
    }

    public final ObjectProperty<LocalDate> todayProperty() {
        return this.today;
    }

    public final void setToday(LocalDate date) {
        Objects.requireNonNull(date);
        this.todayProperty().set((Object)date);
    }

    public final LocalDate getToday() {
        return (LocalDate)this.todayProperty().get();
    }

    public final ObjectProperty<WeekFields> weekFieldsProperty() {
        return this.weekFields;
    }

    public final void setWeekFields(WeekFields fields) {
        Objects.requireNonNull(fields);
        this.weekFieldsProperty().set((Object)fields);
    }

    public final WeekFields getWeekFields() {
        return (WeekFields)this.weekFieldsProperty().get();
    }

    private void updateValues() {
        this.values.setAll(TimeRangeFieldValue.getSelectablesForView(this.getViewType(), this.isEndField()));
        this.setValue((TimeRangeFieldValue)((Object)this.values.get(0)));
    }

    private void updateFields() {
        if (this.getValue() == TimeRangeFieldValue.ON_DATE) {
            if (this.getOnDate() == null) {
                this.setOnDate(this.getToday());
            }
            this.setOnWeekNumber(null);
            this.setMonthYear(null);
            this.setAfterUnits(null);
        } else if (this.getValue() == TimeRangeFieldValue.ON_WEEK_NUMBER) {
            if (this.getOnWeekNumber() == null) {
                this.setOnWeekNumber(this.getToday().get(this.getWeekFields().weekOfWeekBasedYear()));
            }
            this.setOnDate(null);
            this.setMonthYear(null);
            this.setAfterUnits(null);
        } else if (this.getValue() == TimeRangeFieldValue.AFTER) {
            if (this.getAfterUnits() == null) {
                this.setAfterUnits(1);
            }
            this.setOnDate(null);
            this.setOnWeekNumber(null);
            this.setMonthYear(null);
        } else if (this.getValue().isMonthValue()) {
            if (this.getMonthYear() == null) {
                this.setMonthYear(this.getToday().getYear());
            }
            this.setOnDate(null);
            this.setOnWeekNumber(null);
            this.setAfterUnits(null);
        } else {
            this.setOnDate(null);
            this.setOnWeekNumber(null);
            this.setMonthYear(null);
            this.setAfterUnits(null);
        }
    }

    public final BooleanProperty endFieldProperty() {
        return this.endField;
    }

    public final boolean isEndField() {
        return this.endFieldProperty().get();
    }

    public final void setEndField(boolean endField) {
        this.endFieldProperty().set(endField);
    }

    public ObservableList<TimeRangeFieldValue> getValues() {
        return this.valuesUnmodifiable;
    }

    public final ObjectProperty<TimeRangeFieldValue> valueProperty() {
        return this.value;
    }

    public final TimeRangeFieldValue getValue() {
        return (TimeRangeFieldValue)((Object)this.valueProperty().get());
    }

    public final void setValue(TimeRangeFieldValue value) {
        this.valueProperty().set((Object)value);
    }

    public final ObjectProperty<LocalDate> onDateProperty() {
        return this.onDate;
    }

    public final LocalDate getOnDate() {
        return (LocalDate)this.onDateProperty().get();
    }

    public final void setOnDate(LocalDate onDate) {
        this.onDateProperty().set((Object)onDate);
    }

    public final ObjectProperty<Integer> onWeekNumberProperty() {
        return this.onWeekNumber;
    }

    public final Integer getOnWeekNumber() {
        return (Integer)this.onWeekNumberProperty().get();
    }

    public final void setOnWeekNumber(Integer onWeekNumber) {
        this.onWeekNumberProperty().set((Object)onWeekNumber);
    }

    public final ObjectProperty<Integer> monthYearProperty() {
        return this.monthYear;
    }

    public final Integer getMonthYear() {
        return (Integer)this.monthYearProperty().get();
    }

    public final void setMonthYear(Integer monthYear) {
        this.monthYearProperty().set((Object)monthYear);
    }

    public final ObjectProperty<Integer> afterUnitsProperty() {
        return this.afterUnits;
    }

    public final Integer getAfterUnits() {
        return (Integer)this.afterUnitsProperty().get();
    }

    public final void setAfterUnits(Integer afterUnits) {
        this.afterUnitsProperty().set((Object)afterUnits);
    }

    @Override
    public ObservableList<PropertySheet.Item> getPropertySheetItems() {
        ObservableList<PropertySheet.Item> items = super.getPropertySheetItems();
        items.add((Object)new PropertySheet.Item(){

            public void setValue(Object value) {
                TimeRangeField.this.setEndField((Boolean)value);
            }

            public Object getValue() {
                return TimeRangeField.this.isEndField();
            }

            public Class<?> getType() {
                return Boolean.class;
            }

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(TimeRangeField.this.endFieldProperty());
            }

            public String getName() {
                return "End Field";
            }

            public String getDescription() {
                return "Indicates this field is used for te end value";
            }

            public String getCategory() {
                return TimeRangeField.TIME_RANGE_FIELD_CATEGORY;
            }
        });
        return items;
    }

    public static enum TimeRangeFieldValue {
        TODAY(1, "TimeRangeFieldValue.TODAY_LABEL"){

            @Override
            public Collection<ViewType> getViewTypes() {
                return Collections.singletonList(ViewType.DAY_VIEW);
            }
        }
        ,
        TOMORROW(2, "TimeRangeFieldValue.TOMORROW"){

            @Override
            public Collection<ViewType> getViewTypes() {
                return Collections.singletonList(ViewType.DAY_VIEW);
            }
        }
        ,
        THIS_WEEK(3, "TimeRangeFieldValue.THIS_WEEK_LABEL"){

            @Override
            public Collection<ViewType> getViewTypes() {
                return Collections.singletonList(ViewType.WEEK_VIEW);
            }
        }
        ,
        NEXT_WEEK(4, "TimeRangeFieldValue.NEXT_WEEK_LABEL"){

            @Override
            public Collection<ViewType> getViewTypes() {
                return Collections.singletonList(ViewType.WEEK_VIEW);
            }
        }
        ,
        ON_WEEK_NUMBER(5, "TimeRangeFieldValue.ON_WEEK_NUMBER_LABEL"){

            @Override
            public Collection<ViewType> getViewTypes() {
                return Collections.singletonList(ViewType.WEEK_VIEW);
            }
        }
        ,
        THIS_MONTH(6, "TimeRangeFieldValue.THIS_MONTH_LABEL"){

            @Override
            public Collection<ViewType> getViewTypes() {
                return Collections.singletonList(ViewType.MONTH_VIEW);
            }
        }
        ,
        NEXT_MONTH(7, "TimeRangeFieldValue.NEXT_MONTH_LABEL"){

            @Override
            public Collection<ViewType> getViewTypes() {
                return Collections.singletonList(ViewType.MONTH_VIEW);
            }
        }
        ,
        JANUARY(8, "TimeRangeFieldValue.JANUARY_LABEL"){

            @Override
            public boolean isMonthValue() {
                return true;
            }

            @Override
            public Collection<ViewType> getViewTypes() {
                return Collections.singletonList(ViewType.MONTH_VIEW);
            }
        }
        ,
        FEBRUARY(9, "TimeRangeFieldValue.FEBRUARY_LABEL"){

            @Override
            public boolean isMonthValue() {
                return true;
            }

            @Override
            public Collection<ViewType> getViewTypes() {
                return Collections.singletonList(ViewType.MONTH_VIEW);
            }
        }
        ,
        MARCH(10, "TimeRangeFieldValue.MARCH_LABEL"){

            @Override
            public boolean isMonthValue() {
                return true;
            }

            @Override
            public Collection<ViewType> getViewTypes() {
                return Collections.singletonList(ViewType.MONTH_VIEW);
            }
        }
        ,
        APRIL(11, "TimeRangeFieldValue.APRIL_LABEL"){

            @Override
            public boolean isMonthValue() {
                return true;
            }

            @Override
            public Collection<ViewType> getViewTypes() {
                return Collections.singletonList(ViewType.MONTH_VIEW);
            }
        }
        ,
        MAY(12, "TimeRangeFieldValue.MAY_LABEL"){

            @Override
            public boolean isMonthValue() {
                return true;
            }

            @Override
            public Collection<ViewType> getViewTypes() {
                return Collections.singletonList(ViewType.MONTH_VIEW);
            }
        }
        ,
        JUNE(13, "TimeRangeFieldValue.JUNE_LABEL"){

            @Override
            public boolean isMonthValue() {
                return true;
            }

            @Override
            public Collection<ViewType> getViewTypes() {
                return Collections.singletonList(ViewType.MONTH_VIEW);
            }
        }
        ,
        JULY(14, "TimeRangeFieldValue.JULY_LABEL"){

            @Override
            public boolean isMonthValue() {
                return true;
            }

            @Override
            public Collection<ViewType> getViewTypes() {
                return Collections.singletonList(ViewType.MONTH_VIEW);
            }
        }
        ,
        AUGUST(15, "TimeRangeFieldValue.AUGUST_LABEL"){

            @Override
            public boolean isMonthValue() {
                return true;
            }

            @Override
            public Collection<ViewType> getViewTypes() {
                return Collections.singletonList(ViewType.MONTH_VIEW);
            }
        }
        ,
        SEPTEMBER(16, "TimeRangeFieldValue.SEPTEMBER_LABEL"){

            @Override
            public boolean isMonthValue() {
                return true;
            }

            @Override
            public Collection<ViewType> getViewTypes() {
                return Collections.singletonList(ViewType.MONTH_VIEW);
            }
        }
        ,
        OCTOBER(17, "TimeRangeFieldValue.OCTOBER_LABEL"){

            @Override
            public boolean isMonthValue() {
                return true;
            }

            @Override
            public Collection<ViewType> getViewTypes() {
                return Collections.singletonList(ViewType.MONTH_VIEW);
            }
        }
        ,
        NOVEMBER(18, "TimeRangeFieldValue.NOVEMBER_LABEL"){

            @Override
            public boolean isMonthValue() {
                return true;
            }

            @Override
            public Collection<ViewType> getViewTypes() {
                return Collections.singletonList(ViewType.MONTH_VIEW);
            }
        }
        ,
        DECEMBER(19, "TimeRangeFieldValue.DECEMBER_LABEL"){

            @Override
            public boolean isMonthValue() {
                return true;
            }

            @Override
            public Collection<ViewType> getViewTypes() {
                return Collections.singletonList(ViewType.MONTH_VIEW);
            }
        }
        ,
        ON_DATE(20, "TimeRangeFieldValue.ON_DATE_LABEL"){

            @Override
            public Collection<ViewType> getViewTypes() {
                return Arrays.asList(ViewType.DAY_VIEW, ViewType.WEEK_VIEW);
            }
        }
        ,
        AFTER(21, "TimeRangeFieldValue.AFTER_LABEL"){

            @Override
            public Collection<ViewType> getViewTypes() {
                return Arrays.asList(ViewType.DAY_VIEW, ViewType.WEEK_VIEW, ViewType.MONTH_VIEW);
            }
        };

        private final int order;
        private final String messageKey;

        private TimeRangeFieldValue(int order, String messageKey) {
            this.order = order;
            this.messageKey = messageKey;
        }

        public String getMessageKey() {
            return this.messageKey;
        }

        public boolean isMonthValue() {
            return false;
        }

        public boolean isSelectableForView(ViewType viewType) {
            return this.getViewTypes().contains((Object)viewType);
        }

        public abstract Collection<ViewType> getViewTypes();

        public static List<TimeRangeFieldValue> getSelectablesForView(ViewType viewType, boolean endField) {
            ArrayList<TimeRangeFieldValue> allowedValues = new ArrayList<TimeRangeFieldValue>();
            for (TimeRangeFieldValue value : TimeRangeFieldValue.values()) {
                if (!value.isSelectableForView(viewType)) continue;
                allowedValues.add(value);
            }
            if (!endField) {
                allowedValues.remove((Object)AFTER);
            }
            allowedValues.sort(Comparator.comparingInt(v -> v.order));
            return allowedValues;
        }

        public static TimeRangeFieldValue getFromMonth(Month month) {
            switch (month) {
                case JANUARY: {
                    return JANUARY;
                }
                case FEBRUARY: {
                    return FEBRUARY;
                }
                case MARCH: {
                    return MARCH;
                }
                case APRIL: {
                    return APRIL;
                }
                case MAY: {
                    return MAY;
                }
                case JUNE: {
                    return JUNE;
                }
                case JULY: {
                    return JULY;
                }
                case AUGUST: {
                    return AUGUST;
                }
                case SEPTEMBER: {
                    return SEPTEMBER;
                }
                case OCTOBER: {
                    return OCTOBER;
                }
                case NOVEMBER: {
                    return NOVEMBER;
                }
            }
            return DECEMBER;
        }
    }
}

