/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.CalendarEvent;
import com.calendarfx.model.CalendarSource;
import com.calendarfx.model.Entry;
import com.calendarfx.util.LoggingDomain;
import com.calendarfx.view.AllDayEntryView;
import com.calendarfx.view.AllDayView;
import com.calendarfx.view.DraggedEntry;
import com.calendarfx.view.EntryViewBase;
import impl.com.calendarfx.view.DataLoader;
import impl.com.calendarfx.view.DateControlSkin;
import impl.com.calendarfx.view.LoadDataSettingsProvider;
import impl.com.calendarfx.view.util.Placement;
import impl.com.calendarfx.view.util.TimeBoundsResolver;
import impl.com.calendarfx.view.util.Util;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.geometry.Insets;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.util.Callback;

public class AllDayViewSkin
extends DateControlSkin<AllDayView>
implements LoadDataSettingsProvider {
    private static final String ALL_DAY_BACKGROUND_REGION = "day-region";
    private static final String ALL_DAY_BACKGROUND_REGION_TODAY = "today";
    private static final String ALL_DAY_BACKGROUND_REGION_WEEKEND = "weekend";
    private final DataLoader dataLoader;
    private final HBox container;
    private final Group entryViewGroup = new Group();

    public AllDayViewSkin(AllDayView view) {
        super(view);
        view.setFocusTraversable(true);
        this.container = new HBox();
        this.container.getStyleClass().add((Object)"container");
        this.getChildren().add((Object)this.container);
        this.entryViewGroup.setMouseTransparent(false);
        this.entryViewGroup.setManaged(false);
        this.getChildren().add((Object)this.entryViewGroup);
        InvalidationListener updateBackgroundsListener = evt -> this.updateBackgrounds();
        view.numberOfDaysProperty().addListener(updateBackgroundsListener);
        view.showTodayProperty().addListener(updateBackgroundsListener);
        view.weekFieldsProperty().addListener(updateBackgroundsListener);
        view.adjustToFirstDayOfWeekProperty().addListener(updateBackgroundsListener);
        InvalidationListener updateEntriesListener = evt -> this.updateEntries("a view property changed");
        view.numberOfDaysProperty().addListener(updateEntriesListener);
        view.dateProperty().addListener(updateEntriesListener);
        view.extraPaddingProperty().addListener(updateEntriesListener);
        view.rowHeightProperty().addListener(updateEntriesListener);
        view.rowSpacingProperty().addListener(updateEntriesListener);
        view.columnSpacingProperty().addListener(updateEntriesListener);
        view.weekFieldsProperty().addListener(updateEntriesListener);
        view.adjustToFirstDayOfWeekProperty().addListener(updateEntriesListener);
        this.updateBackgrounds();
        this.dataLoader = new DataLoader(this);
        this.updateEntries("initial load");
    }

    @Override
    protected void refreshData() {
        this.updateEntries("refreshData() called");
    }

    private void updateEntries(String reason) {
        LoggingDomain.PERFORMANCE.fine("updating entries, reason: " + reason);
        this.entryViewGroup.getChildren().clear();
        HashMap dataMap = new HashMap();
        this.dataLoader.loadEntries(dataMap);
        HashSet<Entry> entrySet = new HashSet<Entry>();
        for (List entryList : dataMap.values()) {
            entrySet.addAll(entryList);
        }
        entrySet.removeIf(ref -> !ref.isFullDay());
        ArrayList entryList = new ArrayList(entrySet);
        for (Entry entry : entryList) {
            this.doAddEntryView(entry);
        }
        ((AllDayView)this.getSkinnable()).autosize();
        ((AllDayView)this.getSkinnable()).requestLayout();
    }

    private List<EntryViewBase> findEntryViews(Entry<?> entry) {
        return this.entryViewGroup.getChildren().stream().map(node -> (EntryViewBase)node).filter(e -> e.getEntry().getId().equals(entry.getId())).collect(Collectors.toList());
    }

    private boolean removeEntryViews(Entry<?> entry, String reason) {
        boolean removed;
        if (reason != null) {
            LoggingDomain.VIEW.fine("removing entry, reason = " + reason + ", date = " + ((AllDayView)this.getSkinnable()).getDate());
        }
        if ((removed = Util.removeChildren(this.entryViewGroup, node -> {
            AllDayEntryView view = (AllDayEntryView)node;
            Entry<?> viewEntry = view.getEntry();
            return viewEntry.getId().equals(entry.getId());
        })) && !(entry instanceof DraggedEntry) && LoggingDomain.VIEW.isLoggable(Level.FINE)) {
            LoggingDomain.VIEW.fine("successfully removed the entry view of entry " + entry);
        }
        return removed;
    }

    private void addEntryViews(Entry<?> entry, String reason) {
        LoggingDomain.VIEW.fine("adding entry, reason = " + reason + ", date = " + ((AllDayView)this.getSkinnable()).getDate());
        if (entry.isRecurring()) {
            Map<LocalDate, Entry<?>> recurrenceEntries = this.findRecurrenceEntries(entry);
            recurrenceEntries.forEach((date, recurrence) -> this.doAddEntryView((Entry<?>)recurrence));
        } else {
            this.doAddEntryView(entry);
        }
        ((AllDayView)this.getSkinnable()).requestLayout();
    }

    private Map<LocalDate, Entry<?>> findRecurrenceEntries(Entry<?> entry) {
        Calendar calendar = entry.getCalendar();
        LocalDate startDate = this.getLoadStartDate();
        LocalDate endDate = this.getLoadEndDate();
        Map<LocalDate, List<Entry<?>>> entries = calendar.findEntries(startDate, endDate, this.getZoneId());
        HashMap result = new HashMap();
        entries.forEach((date, list) -> {
            Optional<Entry> first;
            if (!list.isEmpty() && (first = list.stream().filter(e -> e.getId().equals(entry.getId())).filter(e -> e.getStartDate().equals(date)).findFirst()).isPresent()) {
                result.put((LocalDate)date, first.get());
            }
        });
        return result;
    }

    private AllDayEntryView doAddEntryView(Entry<?> entry) {
        Callback<Entry<?>, AllDayEntryView> factory = ((AllDayView)this.getSkinnable()).getEntryViewFactory();
        AllDayEntryView view = (AllDayEntryView)factory.call(entry);
        view.getProperties().put((Object)"control", (Object)this.getSkinnable());
        view.setManaged(false);
        int index = this.findIndex(entry);
        this.entryViewGroup.getChildren().add(index, (Object)view);
        if (!(entry instanceof DraggedEntry) && LoggingDomain.VIEW.isLoggable(Level.FINE)) {
            LoggingDomain.VIEW.fine("added entry view " + entry.getTitle() + ", day = " + ((AllDayView)this.getSkinnable()).getDate());
        }
        return view;
    }

    private int findIndex(Entry<?> entry) {
        int childrenSize = this.entryViewGroup.getChildren().size();
        for (int i = 0; i < childrenSize; ++i) {
            Node node = (Node)this.entryViewGroup.getChildren().get(i);
            AllDayEntryView view = (AllDayEntryView)node;
            Entry<?> viewEntry = view.getEntry();
            if (!viewEntry.getStartAsZonedDateTime().isAfter(entry.getStartAsZonedDateTime())) continue;
            return i;
        }
        return childrenSize;
    }

    @Override
    protected void calendarChanged(Calendar calendar) {
        this.updateEntries("calendar changed");
    }

    @Override
    protected void entryTitleChanged(CalendarEvent evt) {
        LoggingDomain.VIEW.fine("handle entry title changed, date = " + ((AllDayView)this.getSkinnable()).getDate());
        Entry<?> entry = evt.getEntry();
        if (entry.isFullDay()) {
            this.findEntryViews(entry).forEach(entryView -> entryView.getEntry().setTitle(evt.getEntry().getTitle()));
        }
    }

    @Override
    protected void entryLocationChanged(CalendarEvent evt) {
        LoggingDomain.VIEW.fine("handle entry location changed, date = " + ((AllDayView)this.getSkinnable()).getDate());
        Entry<?> entry = evt.getEntry();
        if (entry.isFullDay()) {
            this.findEntryViews(entry).forEach(entryView -> entryView.getEntry().setLocation(evt.getEntry().getLocation()));
        }
    }

    @Override
    protected void entryUserObjectChanged(CalendarEvent evt) {
        LoggingDomain.VIEW.fine("handle entry user object changed, date = " + ((AllDayView)this.getSkinnable()).getDate());
        Entry<?> entry = evt.getEntry();
        if (entry.isFullDay()) {
            this.findEntryViews(entry).forEach(entryView -> entryView.getEntry().setUserObject(evt.getEntry().getUserObject()));
        }
    }

    @Override
    protected void entryCalendarChanged(CalendarEvent evt) {
        LoggingDomain.VIEW.fine("handle entry calendar changed, date = " + ((AllDayView)this.getSkinnable()).getDate());
        Entry<?> entry = evt.getEntry();
        if (evt.getCalendar() == null) {
            this.removeEntryViews(entry, "entry was deleted");
        } else if (entry.isFullDay() && this.isRelevant(entry)) {
            List<EntryViewBase> entryView = this.findEntryViews(entry);
            if (!entryView.isEmpty()) {
                entryView.forEach(view -> view.getEntry().setCalendar(evt.getCalendar()));
            } else {
                this.addEntryViews(entry, "entry calendar changed");
            }
        }
        ((AllDayView)this.getSkinnable()).requestLayout();
    }

    @Override
    protected void entryFullDayChanged(CalendarEvent evt) {
        LoggingDomain.VIEW.fine("handle entry full day flag changed, date = " + ((AllDayView)this.getSkinnable()).getDate());
        Entry<?> entry = evt.getEntry();
        if (this.isRelevant(entry)) {
            this.removeEntryViews(entry, "full day flag changed to false");
            if (entry.isFullDay()) {
                this.addEntryViews(entry, "full day flag changed to true, no entry view can be present");
            }
        }
        ((AllDayView)this.getSkinnable()).requestLayout();
    }

    @Override
    protected void entryRecurrenceRuleChanged(CalendarEvent evt) {
        LoggingDomain.VIEW.fine("handle entry recurrence rule changed, date = " + ((AllDayView)this.getSkinnable()).getDate());
        Entry<?> entry = evt.getEntry();
        if (entry.isFullDay()) {
            this.removeEntryViews(entry, "recurrence rule changed");
            if (this.isRelevant(entry)) {
                this.addEntryViews(entry, "recurrence rule changed");
            }
        }
        ((AllDayView)this.getSkinnable()).requestLayout();
    }

    @Override
    protected void entryIntervalChanged(CalendarEvent evt) {
        LoggingDomain.VIEW.fine("handle entry interval changed, date = " + ((AllDayView)this.getSkinnable()).getDate());
        Entry<?> entry = evt.getEntry();
        if (entry.isFullDay()) {
            this.removeEntryViews(entry, "interval changed");
            if (this.isRelevant(entry)) {
                this.addEntryViews(entry, "interval changed");
            }
        }
        ((AllDayView)this.getSkinnable()).requestLayout();
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        List entryViews = this.entryViewGroup.getChildren().stream().filter(node -> node instanceof AllDayEntryView).map(node -> (AllDayEntryView)node).collect(Collectors.toList());
        List<Placement> placements = TimeBoundsResolver.resolve(entryViews);
        int maxPosition = 0;
        for (Placement p : placements) {
            maxPosition = Math.max(maxPosition, p.getColumnIndex());
        }
        AllDayView view = (AllDayView)this.getSkinnable();
        Insets insets = view.getInsets();
        Insets extraPadding = view.getExtraPadding();
        double rowHeight = view.getRowHeight();
        double rowSpacing = view.getRowSpacing();
        return (double)(maxPosition + 1) * rowHeight + (double)maxPosition * rowSpacing + insets.getTop() + insets.getBottom() * extraPadding.getTop() + extraPadding.getBottom();
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        super.layoutChildren(contentX, contentY, contentWidth, contentHeight);
        AllDayView view = (AllDayView)this.getSkinnable();
        double rowHeight = view.getRowHeight();
        double rowSpacing = view.getRowSpacing();
        double height = 0.0;
        Insets extraPadding = view.getExtraPadding();
        List entryViews = this.entryViewGroup.getChildren().stream().map(node -> (AllDayEntryView)node).collect(Collectors.toList());
        List<Placement> placements = TimeBoundsResolver.resolve(entryViews);
        for (Placement placement : placements) {
            EntryViewBase<?> entryView = placement.getEntryView();
            Entry<?> entry = entryView.getEntry();
            LocalDate startDate = view.getDate();
            if (view.isAdjustToFirstDayOfWeek()) {
                startDate = Util.adjustToFirstDayOfWeek(view.getDate(), view.getFirstDayOfWeek());
            }
            LocalDate endDate = startDate.plusDays(view.getNumberOfDays() - 1);
            long deltaDays = ChronoUnit.DAYS.between(startDate, entry.getStartDate());
            long entryDurationInDays = ChronoUnit.DAYS.between(entry.getStartDate(), entry.getEndDate()) + 1L;
            if (deltaDays < 0L) {
                entryDurationInDays += deltaDays;
            }
            if (entry.getStartDate().isBefore(startDate)) {
                entryView.getProperties().put((Object)"startDate", (Object)startDate);
            } else {
                entryView.getProperties().put((Object)"startDate", (Object)entry.getStartDate());
            }
            if (entry.getEndDate().isAfter(endDate)) {
                entryView.getProperties().put((Object)"endDate", (Object)endDate);
            } else {
                entryView.getProperties().put((Object)"endDate", (Object)entry.getEndDate());
            }
            entryDurationInDays = Math.max(entryDurationInDays, 1L);
            double dayWidth = contentWidth / (double)view.getNumberOfDays();
            double x = Math.max(0.0, contentX + (double)deltaDays * dayWidth);
            double y = contentY + (double)placement.getColumnIndex() * (rowHeight + rowSpacing) + extraPadding.getTop();
            double w = view.getNumberOfDays() == 1 ? contentWidth + 1.0 : Math.min((double)entryDurationInDays * dayWidth - view.getColumnSpacing(), contentWidth - x);
            entryView.setMaxHeight(rowHeight);
            entryView.resizeRelocate(this.snapPositionX(x), this.snapPositionY(y), this.snapSizeX(w), this.snapSizeY(rowHeight));
            height = Math.max(height, y + rowHeight);
        }
    }

    private void updateBackgrounds() {
        this.container.getChildren().clear();
        AllDayView allDayView = (AllDayView)this.getSkinnable();
        Callback<AllDayView, Region> separatorFactory = allDayView.getSeparatorFactory();
        int numberOfDays = allDayView.getNumberOfDays();
        for (int i = 0; i < numberOfDays; ++i) {
            Region separator;
            Region region = new Region();
            region.setPrefWidth(1.0);
            region.setMaxWidth(Double.MAX_VALUE);
            region.getStyleClass().add((Object)ALL_DAY_BACKGROUND_REGION);
            int day = i;
            allDayView.dateProperty().addListener(evt -> this.updateRegion(region, day));
            this.updateRegion(region, day);
            HBox.setHgrow((Node)region, (Priority)Priority.ALWAYS);
            this.container.getChildren().add((Object)region);
            if (separatorFactory == null || i >= numberOfDays - 1 || (separator = (Region)separatorFactory.call((Object)allDayView)) == null) continue;
            this.container.getChildren().add((Object)separator);
            HBox.setHgrow((Node)separator, (Priority)Priority.NEVER);
        }
        allDayView.requestLayout();
    }

    private void updateRegion(Region region, int day) {
        AllDayView view = (AllDayView)this.getSkinnable();
        LocalDate startDate = view.getDate();
        if (view.isAdjustToFirstDayOfWeek()) {
            startDate = Util.adjustToFirstDayOfWeek(view.getDate(), view.getFirstDayOfWeek());
        }
        LocalDate date = this.getDate(startDate, day);
        if (view.isShowToday() && date.equals(view.getToday())) {
            if (!region.getStyleClass().contains((Object)ALL_DAY_BACKGROUND_REGION_TODAY)) {
                region.getStyleClass().add((Object)ALL_DAY_BACKGROUND_REGION_TODAY);
            }
        } else {
            region.getStyleClass().remove((Object)ALL_DAY_BACKGROUND_REGION_TODAY);
        }
        if (view.getWeekendDays().contains((Object)date.getDayOfWeek())) {
            if (!region.getStyleClass().contains((Object)ALL_DAY_BACKGROUND_REGION_WEEKEND)) {
                region.getStyleClass().add((Object)ALL_DAY_BACKGROUND_REGION_WEEKEND);
            }
        } else {
            region.getStyleClass().remove((Object)ALL_DAY_BACKGROUND_REGION_WEEKEND);
        }
    }

    private LocalDate getDate(LocalDate startDate, int dayCount) {
        return startDate.plusDays(dayCount);
    }

    @Override
    public String getLoaderName() {
        return "All Day View";
    }

    @Override
    public LocalDate getLoadStartDate() {
        AllDayView view = (AllDayView)this.getSkinnable();
        if (view.isAdjustToFirstDayOfWeek()) {
            return Util.adjustToFirstDayOfWeek(view.getDate(), view.getFirstDayOfWeek());
        }
        return view.getDate();
    }

    @Override
    public LocalDate getLoadEndDate() {
        return this.getLoadStartDate().plusDays(((AllDayView)this.getSkinnable()).getNumberOfDays() - 1);
    }

    @Override
    public ZoneId getZoneId() {
        return ((AllDayView)this.getSkinnable()).getZoneId();
    }

    @Override
    public List<CalendarSource> getCalendarSources() {
        return ((AllDayView)this.getSkinnable()).getCalendarSources();
    }

    @Override
    public Control getControl() {
        return this.getSkinnable();
    }

    @Override
    public boolean isCalendarVisible(Calendar calendar) {
        return ((AllDayView)this.getSkinnable()).isCalendarVisible(calendar);
    }
}

