/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.view.DayEntryView;
import java.util.Map;
import javafx.application.Platform;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;

public class AutoScrollPane
extends ScrollPane {
    final double proximity = 20.0;
    private ScrollThread scrollThread;

    public AutoScrollPane() {
        this(null);
    }

    public AutoScrollPane(Node content) {
        super(content);
        this.addEventFilter(MouseEvent.MOUSE_DRAGGED, this::autoscrollIfNeeded);
        this.addEventFilter(MouseEvent.MOUSE_RELEASED, evt -> this.stopAutoScrollIfNeeded());
        this.addEventFilter(MouseEvent.DRAG_DETECTED, this::startDrag);
        this.addEventFilter(DragEvent.DRAG_OVER, this::autoscrollIfNeeded);
        this.addEventFilter(DragEvent.DRAG_EXITED, evt -> this.stopAutoScrollIfNeeded());
        this.addEventFilter(DragEvent.DRAG_DROPPED, evt -> this.stopAutoScrollIfNeeded());
        this.addEventFilter(DragEvent.DRAG_DONE, evt -> this.stopAutoScrollIfNeeded());
    }

    private void startDrag(MouseEvent evt) {
        EventTarget target = evt.getTarget();
        if (this.isScrollBar(target) || !this.isOnEntry(target)) {
            return;
        }
        Dragboard db = this.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
        ClipboardContent content = new ClipboardContent();
        content.putString("dummy");
        db.setContent((Map)content);
    }

    private boolean isOnEntry(EventTarget target) {
        if (target == null || !(target instanceof Node)) {
            return false;
        }
        Node node = (Node)target;
        if (node instanceof DayEntryView) {
            return true;
        }
        return this.isOnEntry((EventTarget)node.getParent());
    }

    private boolean isScrollBar(EventTarget target) {
        if (target instanceof Node) {
            return this.isScrollBar((Node)target);
        }
        return false;
    }

    private boolean isScrollBar(Node node) {
        boolean result = false;
        if (node instanceof ScrollBar) {
            result = true;
        } else if (node.getParent() != null) {
            return this.isScrollBar((Node)node.getParent());
        }
        return result;
    }

    private void autoscrollIfNeeded(DragEvent evt) {
        evt.acceptTransferModes(TransferMode.ANY);
        if (this.getBoundsInLocal().getWidth() < 1.0 && this.getBoundsInLocal().getWidth() < 1.0) {
            this.stopAutoScrollIfNeeded();
            return;
        }
        double yOffset = 0.0;
        double delta = evt.getSceneY() - this.localToScene(0.0, 0.0).getY();
        if (delta < 20.0) {
            yOffset = -(20.0 - delta);
        }
        if ((delta = this.localToScene(0.0, 0.0).getY() + this.getHeight() - evt.getSceneY()) < 20.0) {
            yOffset = 20.0 - delta;
        }
        if (yOffset != 0.0) {
            this.autoscroll(yOffset);
        } else {
            this.stopAutoScrollIfNeeded();
        }
    }

    private void autoscrollIfNeeded(MouseEvent evt) {
        if (this.getBoundsInLocal().getWidth() < 1.0 && this.getBoundsInLocal().getWidth() < 1.0) {
            this.stopAutoScrollIfNeeded();
            return;
        }
        double yOffset = 0.0;
        double delta = evt.getSceneY() - this.localToScene(0.0, 0.0).getY();
        if (delta < 0.0) {
            yOffset = Math.max(delta / 2.0, -10.0);
        }
        if ((delta = this.localToScene(0.0, 0.0).getY() + this.getHeight() - evt.getSceneY()) < 0.0) {
            yOffset = Math.min(-delta / 2.0, 10.0);
        }
        if (yOffset != 0.0) {
            this.autoscroll(yOffset);
        } else {
            this.stopAutoScrollIfNeeded();
        }
    }

    private void autoscroll(double yOffset) {
        if (this.scrollThread == null) {
            this.scrollThread = new ScrollThread();
            this.scrollThread.start();
        }
        this.scrollThread.setDelta(yOffset);
    }

    private void stopAutoScrollIfNeeded() {
        if (this.scrollThread != null) {
            this.scrollThread.stopRunning();
            this.scrollThread = null;
        }
    }

    class ScrollThread
    extends Thread {
        private boolean running;
        private double yOffset;

        public ScrollThread() {
            super("Autoscrolling List View");
            this.running = true;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            while (this.running) {
                Platform.runLater(this::scrollY);
                try {
                    ScrollThread.sleep(15L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        private void scrollY() {
            double percent = this.yOffset / AutoScrollPane.this.getHeight();
            AutoScrollPane.this.setVvalue(AutoScrollPane.this.getVvalue() + percent);
        }

        public void stopRunning() {
            this.running = false;
        }

        public void setDelta(double yOffset) {
            this.yOffset = yOffset;
        }
    }
}

