/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.model.Calendar;
import com.calendarfx.view.CalendarHeaderView;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.util.Callback;

public class CalendarHeaderViewSkin
extends SkinBase<CalendarHeaderView> {
    private final GridPane pane;
    private final PseudoClass FIRST_COLUMN = PseudoClass.getPseudoClass((String)"first");
    private final PseudoClass MIDDLE_COLUMN = PseudoClass.getPseudoClass((String)"middle");
    private final PseudoClass LAST_COLUMN = PseudoClass.getPseudoClass((String)"last");
    private final InvalidationListener calendarVisibilityListener = it -> this.updateColumns();
    private final WeakInvalidationListener weakCalendarVisibilityListener = new WeakInvalidationListener(this.calendarVisibilityListener);

    public CalendarHeaderViewSkin(CalendarHeaderView view) {
        super((Control)view);
        view.setFocusTraversable(false);
        this.pane = new GridPane();
        this.getChildren().add((Object)this.pane);
        InvalidationListener updateBackgroundsListener = evt -> this.updateColumns();
        view.numberOfDaysProperty().addListener(updateBackgroundsListener);
        this.updateColumns();
        for (Calendar calendar : ((CalendarHeaderView)this.getSkinnable()).getCalendars()) {
            view.getCalendarVisibilityProperty(calendar).addListener((InvalidationListener)this.weakCalendarVisibilityListener);
        }
        ((CalendarHeaderView)this.getSkinnable()).getCalendars().addListener(change -> {
            while (change.next()) {
                if (change.wasAdded()) {
                    for (Calendar calendar : change.getAddedSubList()) {
                        view.getCalendarVisibilityProperty(calendar).addListener((InvalidationListener)this.weakCalendarVisibilityListener);
                    }
                    continue;
                }
                if (!change.wasRemoved()) continue;
                for (Calendar calendar : change.getRemoved()) {
                    view.getCalendarVisibilityProperty(calendar).removeListener((InvalidationListener)this.weakCalendarVisibilityListener);
                }
            }
            this.updateColumns();
        });
        view.visibleProperty().addListener((InvalidationListener)this.weakCalendarVisibilityListener);
    }

    private void updateColumns() {
        this.pane.getChildren().clear();
        CalendarHeaderView headerView = (CalendarHeaderView)this.getSkinnable();
        if (headerView.isVisible()) {
            Callback<Calendar, Node> factory = headerView.getCellFactory();
            ArrayList<ColumnConstraints> weekConstraints = new ArrayList<ColumnConstraints>();
            int numberOfDays = headerView.getNumberOfDays();
            for (int i = 0; i < numberOfDays; ++i) {
                ColumnConstraints con = new ColumnConstraints();
                con.setPercentWidth(100.0 / (double)numberOfDays);
                weekConstraints.add(con);
                GridPane dayGridPane = new GridPane();
                dayGridPane.setMaxWidth(Double.MAX_VALUE);
                GridPane.setHgrow((Node)dayGridPane, (Priority)Priority.ALWAYS);
                GridPane.setVgrow((Node)dayGridPane, (Priority)Priority.ALWAYS);
                GridPane.setFillHeight((Node)dayGridPane, (Boolean)true);
                GridPane.setFillWidth((Node)dayGridPane, (Boolean)true);
                ArrayList<ColumnConstraints> dayConstraints = new ArrayList<ColumnConstraints>();
                List calendars = headerView.getCalendars().stream().filter(headerView::isCalendarVisible).collect(Collectors.toList());
                int calendarCount = calendars.size();
                double columnWidth = 100.0 / (double)calendarCount;
                for (int j = 0; j < calendarCount; ++j) {
                    Calendar calendar = (Calendar)calendars.get(j);
                    ColumnConstraints calendarConstraint = new ColumnConstraints();
                    calendarConstraint.setPercentWidth(columnWidth);
                    calendarConstraint.setFillWidth(true);
                    calendarConstraint.setHgrow(Priority.ALWAYS);
                    dayConstraints.add(calendarConstraint);
                    Node calendarLabel = (Node)factory.call((Object)calendar);
                    calendarLabel.getStyleClass().addAll((Object[])new String[]{"default-style-calendar-header", calendar.getStyle() + "-calendar-header"});
                    dayGridPane.add(calendarLabel, j, 0);
                    GridPane.setHgrow((Node)calendarLabel, (Priority)Priority.ALWAYS);
                    GridPane.setVgrow((Node)calendarLabel, (Priority)Priority.ALWAYS);
                    GridPane.setFillHeight((Node)calendarLabel, (Boolean)true);
                    GridPane.setFillWidth((Node)calendarLabel, (Boolean)true);
                    calendarLabel.pseudoClassStateChanged(this.FIRST_COLUMN, j == 0);
                    calendarLabel.pseudoClassStateChanged(this.MIDDLE_COLUMN, j > 0 && j < calendarCount - 1);
                    calendarLabel.pseudoClassStateChanged(this.LAST_COLUMN, j == calendarCount - 1);
                }
                dayGridPane.getColumnConstraints().setAll(dayConstraints);
                this.pane.add((Node)dayGridPane, i, 0);
            }
            this.pane.getColumnConstraints().setAll(weekConstraints);
        }
    }
}

