/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.model.Calendar;
import com.calendarfx.view.CalendarSelector;
import com.calendarfx.view.CalendarView;
import java.util.ArrayList;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.MenuButton;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SkinBase;
import javafx.scene.control.ToggleGroup;
import javafx.scene.shape.Rectangle;

public class CalendarSelectorSkin
extends SkinBase<CalendarSelector> {
    private final MenuButton button;
    private final Rectangle buttonIcon = new Rectangle(12.0, 12.0);

    public CalendarSelectorSkin(CalendarSelector selector) {
        super((Control)selector);
        this.button = new MenuButton();
        this.button.setGraphic((Node)this.buttonIcon);
        this.button.getStylesheets().add((Object)CalendarView.class.getResource("calendar.css").toExternalForm());
        this.getChildren().add((Object)this.button);
        selector.calendarProperty().addListener(it -> this.updateButton());
        selector.getCalendars().addListener(evt -> this.updateMenuItems());
        this.updateMenuItems();
        this.updateButton();
    }

    private void updateButton() {
        Calendar calendar = ((CalendarSelector)this.getSkinnable()).getCalendar();
        if (calendar != null) {
            this.buttonIcon.getStyleClass().setAll((Object[])new String[]{calendar.getStyle() + "-icon"});
        } else {
            this.buttonIcon.getStyleClass().clear();
        }
    }

    private void updateMenuItems() {
        ToggleGroup group = new ToggleGroup();
        ArrayList<RadioMenuItem> items = new ArrayList<RadioMenuItem>();
        for (Calendar calendar : ((CalendarSelector)this.getSkinnable()).getCalendars()) {
            RadioMenuItem item = new RadioMenuItem(calendar.getName());
            Rectangle icon = new Rectangle(10.0, 10.0);
            icon.setArcHeight(2.0);
            icon.setArcWidth(2.0);
            icon.getStyleClass().add((Object)(calendar.getStyle() + "-icon"));
            item.setGraphic((Node)icon);
            item.setDisable(calendar.isReadOnly());
            item.setOnAction(evt -> ((CalendarSelector)this.getSkinnable()).setCalendar(calendar));
            group.getToggles().add((Object)item);
            items.add(item);
            if (!calendar.equals(((CalendarSelector)this.getSkinnable()).getCalendar())) continue;
            item.setSelected(true);
        }
        this.button.getItems().setAll(items);
    }
}

