/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.Entry;
import com.calendarfx.model.Interval;
import com.calendarfx.util.LoggingDomain;
import com.calendarfx.view.DateControl;
import com.calendarfx.view.DayEntryView;
import com.calendarfx.view.DayView;
import com.calendarfx.view.DayViewBase;
import com.calendarfx.view.DraggedEntry;
import com.calendarfx.view.EntryViewBase;
import com.calendarfx.view.RequestEvent;
import com.calendarfx.view.VirtualGrid;
import com.calendarfx.view.WeekView;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.logging.Logger;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Cursor;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;

public class DayViewEditController {
    private static final Logger LOGGER = LoggingDomain.EDITING;
    private final DayViewBase view;
    private DayEntryView dayEntryView;
    private Entry<?> entry;
    private DraggedEntry.DragMode dragMode;
    private Handle handle;
    private Duration offsetDuration;
    private Duration entryDuration;
    private Operation operation = Operation.NONE;
    private MouseEvent mousePressedEvent;
    private boolean entryEditingAllowed;
    private final ObjectProperty<Instant> lassoStart = new SimpleObjectProperty((Object)this, "lassoStart");
    private final ObjectProperty<Instant> lassoEnd = new SimpleObjectProperty((Object)this, "lassoEnd");
    private final ObjectProperty<BiConsumer<Instant, Instant>> onLassoFinished = new SimpleObjectProperty((Object)this, "onLassoFinished", (start, end) -> {});

    public DayViewEditController(DayViewBase dayView) {
        this.view = Objects.requireNonNull(dayView);
        dayView.addEventFilter(MouseEvent.MOUSE_CLICKED, this::mouseClicked);
        dayView.addEventFilter(MouseEvent.MOUSE_PRESSED, this::mousePressed);
        dayView.addEventFilter(MouseEvent.MOUSE_DRAGGED, this::mouseDragged);
        EventHandler mouseReleasedHandler = this::mouseReleased;
        if (dayView.getScene() != null) {
            dayView.addEventFilter(MouseEvent.MOUSE_RELEASED, mouseReleasedHandler);
        }
        dayView.sceneProperty().addListener((observable, oldScene, newScene) -> {
            if (oldScene != null) {
                oldScene.removeEventFilter(MouseEvent.MOUSE_RELEASED, mouseReleasedHandler);
            }
            if (newScene != null) {
                newScene.addEventFilter(MouseEvent.MOUSE_RELEASED, mouseReleasedHandler);
            }
        });
        dayView.addEventFilter(MouseEvent.MOUSE_MOVED, this::mouseMoved);
        this.lassoStartProperty().addListener(it -> dayView.setLassoStart(this.getLassoStart()));
        this.lassoEndProperty().addListener(it -> dayView.setLassoEnd(this.getLassoEnd()));
        this.setOnLassoFinished(dayView.getOnLassoFinished());
        dayView.onLassoFinishedProperty().addListener(it -> this.setOnLassoFinished(dayView.getOnLassoFinished()));
    }

    private boolean initDragModeAndHandle(MouseEvent evt) {
        this.dragMode = null;
        this.handle = null;
        if (evt.isSynthesized()) {
            return false;
        }
        if (!(evt.getTarget() instanceof EntryViewBase)) {
            return false;
        }
        this.dayEntryView = (DayEntryView)evt.getTarget();
        this.entry = this.dayEntryView.getEntry();
        Calendar calendar = this.entry.getCalendar();
        if (calendar != null && calendar.isReadOnly()) {
            return false;
        }
        double y = evt.getY() - this.dayEntryView.getBoundsInParent().getMinY();
        LOGGER.finer("y-coordinate inside entry view: " + y);
        if (y > this.dayEntryView.getHeight() - 5.0) {
            if (this.dayEntryView.getHeightLayoutStrategy().equals((Object)EntryViewBase.HeightLayoutStrategy.USE_START_AND_END_TIME) && ((Boolean)this.view.getEntryEditPolicy().call((Object)new DateControl.EntryEditParameter(this.view, this.entry, DateControl.EditOperation.CHANGE_END))).booleanValue()) {
                this.dragMode = DraggedEntry.DragMode.END_TIME;
                this.handle = Handle.BOTTOM;
            }
        } else if (y < 5.0) {
            if (this.dayEntryView.getHeightLayoutStrategy().equals((Object)EntryViewBase.HeightLayoutStrategy.USE_START_AND_END_TIME) && ((Boolean)this.view.getEntryEditPolicy().call((Object)new DateControl.EntryEditParameter(this.view, this.entry, DateControl.EditOperation.CHANGE_START))).booleanValue()) {
                this.dragMode = DraggedEntry.DragMode.START_TIME;
                this.handle = Handle.TOP;
            }
        } else if (((Boolean)this.view.getEntryEditPolicy().call((Object)new DateControl.EntryEditParameter(this.view, this.entry, DateControl.EditOperation.MOVE))).booleanValue()) {
            this.dragMode = DraggedEntry.DragMode.START_AND_END_TIME;
            this.handle = Handle.CENTER;
        }
        return this.entry != null && this.dragMode != null && this.handle != null;
    }

    private void mouseMoved(MouseEvent evt) {
        this.initDragModeAndHandle(evt);
        if (this.dayEntryView != null) {
            if (this.handle == null) {
                this.dayEntryView.setCursor(Cursor.DEFAULT);
                return;
            }
            switch (this.handle) {
                case TOP: {
                    this.dayEntryView.setCursor(Cursor.N_RESIZE);
                    break;
                }
                case BOTTOM: {
                    this.dayEntryView.setCursor(Cursor.S_RESIZE);
                    break;
                }
                case CENTER: {
                    this.dayEntryView.setCursor(Cursor.MOVE);
                    break;
                }
                default: {
                    this.dayEntryView.setCursor(Cursor.DEFAULT);
                }
            }
        }
    }

    private void mouseClicked(MouseEvent evt) {
        if (evt.isConsumed() || !evt.isStillSincePress() || !evt.getButton().equals((Object)MouseButton.PRIMARY)) {
            return;
        }
        if (this.view.isEditAvailability()) {
            return;
        }
        if (!(evt.getTarget() instanceof DayViewBase)) {
            return;
        }
        if (evt.getClickCount() == this.view.getCreateEntryClickCount()) {
            Entry<?> entry = this.createEntryAt(evt);
            evt.consume();
            if (this.view.isShowDetailsUponEntryCreation()) {
                this.view.fireEvent(new RequestEvent((Object)this.view, (EventTarget)this.view, entry));
            }
        }
    }

    private void mousePressed(MouseEvent evt) {
        if (evt.isConsumed() || !evt.getButton().equals((Object)MouseButton.PRIMARY)) {
            return;
        }
        this.mousePressedEvent = evt;
        this.entry = null;
        LOGGER.finer("mouse event source: " + evt.getSource());
        LOGGER.finer("mouse event target: " + evt.getTarget());
        LOGGER.finer("mouse event y-coordinate:" + evt.getY());
        LOGGER.finer("time: " + this.view.getZonedDateTimeAt(evt.getX(), evt.getY(), this.view.getZoneId()));
        if (evt.getTarget() instanceof DayViewBase) {
            this.mousePressedOnDayView(evt);
        } else if (evt.getTarget() instanceof EntryViewBase) {
            if (this.view.isEditAvailability()) {
                if (!this.view.isScrollingEnabled()) {
                    this.mousePressedEditAvailability(evt);
                }
            } else {
                this.mousePressedEditEntry(evt);
            }
        }
    }

    private void mousePressedEditEntry(MouseEvent evt) {
        this.operation = Operation.EDIT_ENTRY;
        this.entryEditingAllowed = false;
        this.dragMode = null;
        this.handle = null;
        LOGGER.finer("mouse event source: " + evt.getSource());
        LOGGER.finer("mouse event target: " + evt.getTarget());
        LOGGER.finer("mouse event y-coordinate:" + evt.getY());
        LOGGER.finer("time: " + this.view.getZonedDateTimeAt(evt.getX(), evt.getY(), this.view.getZoneId()));
        boolean successfulInitialization = this.initDragModeAndHandle(evt);
        if (successfulInitialization) {
            LOGGER.finer("drag mode: " + this.dragMode);
            LOGGER.finer("handle: " + this.handle);
            Callback<DateControl.EntryEditParameter, Boolean> entryEditPolicy = this.view.getEntryEditPolicy();
            boolean operationAllowed = false;
            switch (this.dragMode) {
                case START_AND_END_TIME: {
                    if (!((Boolean)entryEditPolicy.call((Object)new DateControl.EntryEditParameter(this.view, this.entry, DateControl.EditOperation.MOVE))).booleanValue()) break;
                    operationAllowed = true;
                    Instant time = this.view.getInstantAt(evt);
                    this.offsetDuration = Duration.between(this.entry.getStartAsZonedDateTime().toInstant(), time);
                    this.entryDuration = this.entry.getDuration();
                    LOGGER.finer("time at mouse pressed location: " + time);
                    LOGGER.finer("offset duration: " + this.offsetDuration);
                    LOGGER.finer("entry duration: " + this.entryDuration);
                    break;
                }
                case END_TIME: {
                    if (!((Boolean)entryEditPolicy.call((Object)new DateControl.EntryEditParameter(this.view, this.entry, DateControl.EditOperation.CHANGE_END))).booleanValue()) break;
                    operationAllowed = true;
                    break;
                }
                case START_TIME: {
                    if (!((Boolean)entryEditPolicy.call((Object)new DateControl.EntryEditParameter(this.view, this.entry, DateControl.EditOperation.CHANGE_START))).booleanValue()) break;
                    operationAllowed = true;
                    break;
                }
            }
            if (!operationAllowed) {
                return;
            }
            this.entryEditingAllowed = true;
        }
    }

    private void mousePressedOnDayView(MouseEvent evt) {
        if (this.view.isEditAvailability()) {
            this.mousePressedEditAvailability(evt);
        } else {
            this.operation = Operation.CREATE_ENTRY;
        }
    }

    private void mousePressedEditAvailability(MouseEvent evt) {
        this.operation = Operation.EDIT_AVAILABILITY;
        VirtualGrid availabilityGrid = this.view.getAvailabilityGrid();
        this.setLassoStart(this.snapToGrid(this.view.getInstantAt(evt), availabilityGrid, false));
        this.setLassoEnd(this.snapToGrid(this.view.getInstantAt(evt), availabilityGrid, false).plus((long)availabilityGrid.getAmount(), availabilityGrid.getUnit()));
    }

    private Entry<?> createEntryAt(MouseEvent evt) {
        Optional<Calendar> calendar = this.view.getCalendarAt(evt.getX(), evt.getY());
        Instant instantAt = this.view.getInstantAt(evt);
        VirtualGrid virtualGrid = this.view.getVirtualGrid();
        if (virtualGrid != null) {
            instantAt = this.snapToGrid(instantAt, virtualGrid, false);
        }
        ZonedDateTime time = ZonedDateTime.ofInstant(instantAt, this.view.getZoneId());
        Entry<?> newEntry = this.view.createEntryAt(time, calendar.orElse(null), false);
        Duration duration = newEntry.getMinimumDuration();
        LOGGER.fine("minimum duration for the entry is " + duration);
        if (virtualGrid != null) {
            LOGGER.fine("checking the virtual grid duration");
            Duration gridAmount = Duration.of(virtualGrid.getAmount(), virtualGrid.getUnit());
            if (gridAmount.toMillis() > duration.toMillis()) {
                LOGGER.fine("using the grid amount as it is longer than the minimum duration of the entry");
                duration = gridAmount;
            }
        }
        newEntry.setInterval(newEntry.getInterval().withEndTime(newEntry.getInterval().getStartTime().plus(duration)));
        this.view.getSelections().clear();
        this.view.getSelections().add(newEntry);
        return newEntry;
    }

    private void mouseDragged(MouseEvent evt) {
        if (evt.isStillSincePress()) {
            return;
        }
        if (evt.isSynthesized()) {
            return;
        }
        switch (this.operation) {
            case NONE: {
                break;
            }
            case EDIT_ENTRY: {
                Calendar calendar;
                if (this.entry == null || (calendar = this.entry.getCalendar()).isReadOnly()) break;
                this.mouseDraggedEditEntry(evt);
                break;
            }
            case EDIT_AVAILABILITY: {
                this.mouseDraggedEditAvailability(evt);
                break;
            }
            case CREATE_ENTRY: {
                this.mouseDraggedCreateEntry(evt);
            }
        }
    }

    private void mouseDraggedEditAvailability(MouseEvent evt) {
        this.setLassoEnd(this.snapToGrid(this.view.getInstantAt(evt), this.view.getAvailabilityGrid(), true));
    }

    private void mouseDraggedCreateEntry(MouseEvent evt) {
        if (this.entry == null) {
            this.dragMode = null;
            this.handle = null;
            this.entry = this.createEntryAt(this.mousePressedEvent);
            DayView dayView = null;
            if (this.view instanceof DayView) {
                dayView = (DayView)this.view;
            } else if (this.view instanceof WeekView) {
                WeekView weekView = (WeekView)this.view;
                dayView = (DayView)weekView.getWeekDayViews().get(0);
            }
            if (dayView != null) {
                this.dragMode = DraggedEntry.DragMode.END_TIME;
                this.handle = Handle.BOTTOM;
            }
            if (this.dayEntryView != null) {
                this.dayEntryView.getProperties().put((Object)"dragged-end", (Object)true);
            }
            DraggedEntry draggedEntry = new DraggedEntry(this.entry, this.dragMode);
            draggedEntry.setOffsetDuration(this.offsetDuration);
            this.view.setDraggedEntry(draggedEntry);
        }
        this.changeEndTime(evt);
    }

    private void mouseDraggedEditEntry(MouseEvent evt) {
        if (this.entryEditingAllowed && this.view.getDraggedEntry() == null) {
            DraggedEntry draggedEntry = new DraggedEntry(this.entry, this.dragMode);
            draggedEntry.setOffsetDuration(this.offsetDuration);
            this.view.setDraggedEntry(draggedEntry);
            switch (this.dragMode) {
                case START_AND_END_TIME: {
                    if (this.dayEntryView == null) break;
                    this.dayEntryView.getProperties().put((Object)"dragged", (Object)true);
                    break;
                }
                case END_TIME: {
                    if (this.dayEntryView == null) break;
                    this.dayEntryView.getProperties().put((Object)"dragged-end", (Object)true);
                    break;
                }
                case START_TIME: {
                    if (this.dayEntryView == null) break;
                    this.dayEntryView.getProperties().put((Object)"dragged-start", (Object)true);
                    break;
                }
            }
        }
        block5 : switch (this.dragMode) {
            case START_TIME: {
                switch (this.handle) {
                    case TOP: 
                    case BOTTOM: {
                        this.changeStartTime(evt);
                        break block5;
                    }
                }
                break;
            }
            case END_TIME: {
                switch (this.handle) {
                    case TOP: 
                    case BOTTOM: {
                        this.changeEndTime(evt);
                        break block5;
                    }
                }
                break;
            }
            case START_AND_END_TIME: {
                this.changeStartAndEndTime(evt);
            }
        }
    }

    private void mouseReleased(MouseEvent evt) {
        if (!evt.getButton().equals((Object)MouseButton.PRIMARY) || evt.getClickCount() > 1) {
            return;
        }
        switch (this.operation) {
            case NONE: {
                break;
            }
            case EDIT_ENTRY: {
                this.mouseReleasedEditEntry();
                break;
            }
            case EDIT_AVAILABILITY: {
                this.mouseReleasedEditAvailability();
                break;
            }
            case CREATE_ENTRY: {
                this.mouseReleasedCreateEntry();
            }
        }
        this.operation = Operation.NONE;
    }

    private void mouseReleasedEditAvailability() {
        this.getOnLassoFinished().accept(this.getLassoStart(), this.getLassoEnd());
        this.setLassoStart(null);
        this.setLassoEnd(null);
    }

    private void mouseReleasedEditEntry() {
        DraggedEntry draggedEntry;
        if (this.dayEntryView != null) {
            this.dayEntryView.getProperties().put((Object)"dragged", (Object)false);
            this.dayEntryView.getProperties().put((Object)"dragged-start", (Object)false);
            this.dayEntryView.getProperties().put((Object)"dragged-end", (Object)false);
        }
        if ((draggedEntry = this.view.getDraggedEntry()) != null) {
            this.view.setDraggedEntry(null);
            Interval newInterval = draggedEntry.getInterval();
            this.entry.setInterval(newInterval);
            if (this.view.isShowDetailsUponEntryCreation() && this.operation.equals((Object)Operation.CREATE_ENTRY)) {
                this.view.fireEvent(new RequestEvent((Object)this.view, (EventTarget)this.view, this.entry));
            }
        }
    }

    private void mouseReleasedCreateEntry() {
        if (this.entry != null) {
            DraggedEntry draggedEntry;
            Calendar calendar = this.entry.getCalendar();
            if (calendar.isReadOnly()) {
                return;
            }
            if (this.dayEntryView != null) {
                this.dayEntryView.getProperties().put((Object)"dragged", (Object)false);
                this.dayEntryView.getProperties().put((Object)"dragged-start", (Object)false);
                this.dayEntryView.getProperties().put((Object)"dragged-end", (Object)false);
            }
            if ((draggedEntry = this.view.getDraggedEntry()) != null) {
                this.view.setDraggedEntry(null);
                this.entry.setInterval(draggedEntry.getInterval());
                if (this.view.isShowDetailsUponEntryCreation() && this.operation.equals((Object)Operation.CREATE_ENTRY)) {
                    this.view.fireEvent(new RequestEvent((Object)this.view, (EventTarget)this.view, this.entry));
                }
            }
        }
    }

    private void changeStartTime(MouseEvent evt) {
        DraggedEntry draggedEntry = this.view.getDraggedEntry();
        Instant gridTime = this.fixTimeIfOutsideView(evt, this.snapToGrid(this.view.getInstantAt(evt), this.view.getVirtualGrid(), true));
        LOGGER.finer("changing start time, time = " + gridTime);
        if (this.isMinimumDuration(this.entry, this.entry.getEndAsZonedDateTime().toInstant(), gridTime)) {
            LocalDate endDate;
            LocalTime endTime;
            LocalDate startDate;
            LocalTime startTime;
            ZonedDateTime gridZonedTime = ZonedDateTime.ofInstant(gridTime, draggedEntry.getZoneId());
            if (gridTime.isAfter(this.entry.getEndAsZonedDateTime().toInstant())) {
                if (this.view.isEnableStartAndEndTimesFlip()) {
                    startTime = this.entry.getEndTime();
                    startDate = this.entry.getEndDate();
                    endTime = gridZonedTime.toLocalTime();
                    endDate = gridZonedTime.toLocalDate();
                } else {
                    startTime = this.entry.getEndTime().minus(this.entry.getMinimumDuration());
                    startDate = this.entry.getEndDate();
                    endTime = this.entry.getEndTime();
                    endDate = this.entry.getEndDate();
                }
            } else {
                startDate = gridZonedTime.toLocalDate();
                startTime = gridZonedTime.toLocalTime();
                endTime = this.entry.getEndTime();
                endDate = this.entry.getEndDate();
            }
            LOGGER.finer("new interval: sd = " + startDate + ", st = " + startTime + ", ed = " + endDate + ", et = " + endTime);
            draggedEntry.setInterval(startDate, startTime, endDate, endTime);
        }
    }

    private void changeEndTime(MouseEvent evt) {
        DraggedEntry draggedEntry = this.view.getDraggedEntry();
        Instant gridTime = this.fixTimeIfOutsideView(evt, this.snapToGrid(this.view.getInstantAt(evt), this.view.getVirtualGrid(), true));
        LOGGER.finer("changing end time, time = " + gridTime);
        if (this.isMinimumDuration(this.entry, this.entry.getStartAsZonedDateTime().toInstant(), gridTime)) {
            LocalDate startDate;
            LocalTime startTime;
            LocalDate endDate;
            LocalTime endTime;
            LOGGER.finer("dragged entry: " + draggedEntry.getInterval());
            ZonedDateTime gridZonedTime = ZonedDateTime.ofInstant(gridTime, draggedEntry.getZoneId());
            if (gridTime.isBefore(this.entry.getStartAsZonedDateTime().toInstant())) {
                if (this.view.isEnableStartAndEndTimesFlip()) {
                    endTime = this.entry.getStartTime();
                    endDate = this.entry.getStartDate();
                    startTime = gridZonedTime.toLocalTime();
                    startDate = gridZonedTime.toLocalDate();
                } else {
                    startTime = this.entry.getStartTime();
                    startDate = this.entry.getStartDate();
                    endTime = this.entry.getStartTime().plus(this.entry.getMinimumDuration());
                    endDate = this.entry.getStartDate();
                }
            } else {
                startTime = this.entry.getStartTime();
                startDate = this.entry.getStartDate();
                endTime = gridZonedTime.toLocalTime();
                endDate = gridZonedTime.toLocalDate();
            }
            LOGGER.finer("new interval: sd = " + startDate + ", st = " + startTime + ", ed = " + endDate + ", et = " + endTime);
            draggedEntry.setInterval(startDate, startTime, endDate, endTime);
        }
    }

    private void changeStartAndEndTime(MouseEvent evt) {
        DraggedEntry draggedEntry = this.view.getDraggedEntry();
        Instant locationTime = this.fixTimeIfOutsideView(evt, this.view.getInstantAt(evt));
        LOGGER.fine("changing start/end time, time = " + locationTime + " offset duration = " + this.offsetDuration);
        if (locationTime != null && this.offsetDuration != null) {
            Instant newStartTime = locationTime.minus(this.offsetDuration);
            LOGGER.fine("new start time = " + newStartTime);
            newStartTime = this.snapToGrid(newStartTime, this.view.getVirtualGrid(), true);
            Instant newEndTime = newStartTime.plus(this.entryDuration);
            LOGGER.fine("new start time (grid) = " + newStartTime);
            LOGGER.fine("new end time = " + newEndTime);
            ZonedDateTime gridStartZonedTime = ZonedDateTime.ofInstant(newStartTime, draggedEntry.getZoneId());
            ZonedDateTime gridEndZonedTime = ZonedDateTime.ofInstant(newEndTime, draggedEntry.getZoneId());
            LocalDate startDate = gridStartZonedTime.toLocalDate();
            LocalTime startTime = gridStartZonedTime.toLocalTime();
            LocalDate endDate = LocalDateTime.of(startDate, startTime).plus(this.entryDuration).toLocalDate();
            LocalTime endTime = gridEndZonedTime.toLocalTime();
            draggedEntry.setInterval(startDate, startTime, endDate, endTime);
        }
    }

    private Instant fixTimeIfOutsideView(MouseEvent evt, Instant gridTime) {
        if (evt.getX() > this.view.getWidth() || evt.getX() < 0.0) {
            ZonedDateTime zdt = ZonedDateTime.ofInstant(gridTime, this.entry.getZoneId());
            gridTime = ZonedDateTime.of(this.entry.getStartDate(), zdt.toLocalTime(), zdt.getZone()).toInstant();
        }
        return gridTime;
    }

    private boolean isMinimumDuration(Entry<?> entry, Instant timeA, Instant timeB) {
        Duration minDuration = entry.getMinimumDuration().abs();
        if (minDuration != null) {
            Duration duration = Duration.between(timeA, timeB).abs();
            return !duration.minus(minDuration).isNegative();
        }
        return true;
    }

    private Instant snapToGrid(Instant time, VirtualGrid grid, boolean checkCloser) {
        Instant upperTime;
        if (grid == null) {
            return time;
        }
        DayOfWeek firstDayOfWeek = this.view.getFirstDayOfWeek();
        Instant lowerTime = grid.adjustTime(time, this.view.getZoneId(), false, firstDayOfWeek);
        if (checkCloser && Duration.between(time, upperTime = grid.adjustTime(time, this.view.getZoneId(), true, firstDayOfWeek)).abs().minus(Duration.between(time, lowerTime).abs()).isNegative()) {
            return upperTime;
        }
        return lowerTime;
    }

    public final Instant getLassoStart() {
        return (Instant)this.lassoStart.get();
    }

    public final ObjectProperty<Instant> lassoStartProperty() {
        return this.lassoStart;
    }

    public final void setLassoStart(Instant lassoStart) {
        this.lassoStart.set((Object)lassoStart);
    }

    public final Instant getLassoEnd() {
        return (Instant)this.lassoEnd.get();
    }

    public final ObjectProperty<Instant> lassoEndProperty() {
        return this.lassoEnd;
    }

    public final void setLassoEnd(Instant lassoEnd) {
        this.lassoEnd.set((Object)lassoEnd);
    }

    public final BiConsumer<Instant, Instant> getOnLassoFinished() {
        return (BiConsumer)this.onLassoFinished.get();
    }

    public final ObjectProperty<BiConsumer<Instant, Instant>> onLassoFinishedProperty() {
        return this.onLassoFinished;
    }

    public final void setOnLassoFinished(BiConsumer<Instant, Instant> onLassoFinished) {
        this.onLassoFinished.set(onLassoFinished);
    }

    private static enum Operation {
        NONE,
        EDIT_ENTRY,
        EDIT_AVAILABILITY,
        CREATE_ENTRY;

    }

    private static enum Handle {
        TOP,
        CENTER,
        BOTTOM;

    }
}

