/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.CalendarEvent;
import com.calendarfx.model.CalendarSource;
import com.calendarfx.model.Entry;
import com.calendarfx.util.LoggingDomain;
import com.calendarfx.util.ViewHelper;
import com.calendarfx.view.DateControl;
import com.calendarfx.view.DayEntryView;
import com.calendarfx.view.DayView;
import com.calendarfx.view.DayViewBase;
import com.calendarfx.view.DraggedEntry;
import com.calendarfx.view.EntryViewBase;
import com.calendarfx.view.VirtualGrid;
import impl.com.calendarfx.view.DataLoader;
import impl.com.calendarfx.view.DayViewBaseSkin;
import impl.com.calendarfx.view.DayViewEditController;
import impl.com.calendarfx.view.LoadDataSettingsProvider;
import impl.com.calendarfx.view.WeekDayViewSkin;
import impl.com.calendarfx.view.util.Placement;
import impl.com.calendarfx.view.util.TimeBoundsResolver;
import impl.com.calendarfx.view.util.Util;
import impl.com.calendarfx.view.util.VisualBoundsResolver;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javafx.animation.FadeTransition;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.transformation.FilteredList;
import javafx.event.EventHandler;
import javafx.event.WeakEventHandler;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Control;
import javafx.scene.layout.Region;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.util.Callback;
import javafx.util.Duration;

public class DayViewSkin<T extends DayView>
extends DayViewBaseSkin<T>
implements LoadDataSettingsProvider {
    private static final String MIDNIGHT_LINE_STYLE_CLASS = "midnight-line";
    private static final String NOON_LINE_STYLE_CLASS = "noon-line";
    private static final String HALF_HOUR_LINE_STYLE_CLASS = "half-hour-line";
    private static final String FULL_HOUR_LINE_STYLE_CLASS = "full-hour-line";
    private final List<Line> lines = new ArrayList<Line>();
    private final DataLoader dataLoader = new DataLoader(this);
    private final Circle currentTimeCircle;
    private final Line currentTimeLine;
    private DayEntryView draggedEntryView;
    private final Region earlyHoursRegion;
    private final Region lateHoursRegion;
    private LocalDate displayedDate;
    private double startY;
    private final BackgroundCanvas backgroundCanvas = new BackgroundCanvas();
    private final Group entryViewGroup = new Group();
    private final EventHandler<CalendarEvent> availabilityHandler = evt -> this.backgroundCanvas.draw();
    private final WeakEventHandler<CalendarEvent> weakAvailabilityHandler = new WeakEventHandler(this.availabilityHandler);
    private final InvalidationListener layoutListener = it -> ((DayView)this.getSkinnable()).requestLayout();
    private final WeakInvalidationListener weakLayoutListener = new WeakInvalidationListener(this.layoutListener);

    public DayViewSkin(T view) {
        super(view);
        this.entryViewGroup.setMouseTransparent(false);
        this.entryViewGroup.setManaged(false);
        this.entryViewGroup.opacityProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> view.isEditAvailability() && view.getEntryViewAvailabilityEditingBehaviour().equals((Object)DayViewBase.AvailabilityEditingEntryBehaviour.OPACITY) ? view.getEntryViewAvailabilityEditingOpacity() : 1.0, (Observable[])new Observable[]{((DateControl)((Object)view)).editAvailabilityProperty(), ((DayViewBase)view).entryViewAvailabilityEditingBehaviourProperty(), ((DayViewBase)view).entryViewAvailabilityEditingOpacityProperty()}));
        this.earlyHoursRegion = new Region();
        this.earlyHoursRegion.setMouseTransparent(true);
        this.earlyHoursRegion.getStyleClass().add((Object)"early-hours-region");
        this.earlyHoursRegion.setManaged(false);
        this.getChildren().add((Object)this.earlyHoursRegion);
        this.lateHoursRegion = new Region();
        this.lateHoursRegion.setMouseTransparent(true);
        this.lateHoursRegion.getStyleClass().add((Object)"late-hours-region");
        this.lateHoursRegion.setManaged(false);
        this.getChildren().add((Object)this.lateHoursRegion);
        InvalidationListener drawBackgroundCanvasListener = it -> this.backgroundCanvas.draw();
        ((DateControl)((Object)view)).editAvailabilityProperty().addListener(drawBackgroundCanvasListener);
        this.getChildren().add((Object)this.backgroundCanvas);
        if (!((DayViewBase)view).isScrollingEnabled()) {
            this.createStaticLines();
        }
        this.getChildren().add((Object)this.entryViewGroup);
        this.currentTimeCircle = new Circle(4.0);
        this.currentTimeCircle.getStyleClass().add((Object)"current-time-circle");
        this.currentTimeCircle.setManaged(false);
        this.currentTimeCircle.setMouseTransparent(true);
        this.currentTimeCircle.setOpacity(0.0);
        this.currentTimeCircle.visibleProperty().bind((ObservableValue)((DayViewBase)view).enableCurrentTimeCircleProperty().and((ObservableBooleanValue)((DateControl)((Object)view)).editAvailabilityProperty().not()));
        this.getChildren().add((Object)this.currentTimeCircle);
        this.currentTimeLine = new Line();
        this.currentTimeLine.getStyleClass().add((Object)"current-time-line");
        this.currentTimeLine.setManaged(false);
        this.currentTimeLine.setMouseTransparent(true);
        this.currentTimeLine.setOpacity(0.0);
        this.currentTimeLine.visibleProperty().bind((ObservableValue)((DayViewBase)view).enableCurrentTimeMarkerProperty().and((ObservableBooleanValue)((DateControl)((Object)view)).editAvailabilityProperty().not()));
        this.getChildren().add((Object)this.currentTimeLine);
        ((DayViewBase)view).scrollTimeProperty().addListener(drawBackgroundCanvasListener);
        ((DayViewBase)view).lassoStartProperty().addListener(drawBackgroundCanvasListener);
        ((DayViewBase)view).lassoEndProperty().addListener(drawBackgroundCanvasListener);
        ((DateControl)((Object)view)).editAvailabilityProperty().addListener(drawBackgroundCanvasListener);
        ((DateControl)((Object)view)).availabilityCalendarProperty().addListener((obs, oldCalendar, newCalendar) -> this.listenToAvailabilityCalendar((Calendar)oldCalendar, (Calendar)newCalendar));
        this.listenToAvailabilityCalendar(null, ((DateControl)((Object)view)).getAvailabilityCalendar());
        if (!(this instanceof WeekDayViewSkin)) {
            new DayViewEditController((DayViewBase)view);
        }
        this.setupCurrentTimeMarkerSupport();
        ((DateControl)((Object)view)).draggedEntryProperty().addListener(it -> this.addOrRemoveDraggedEntryView());
        ((DayViewBase)view).showCurrentTimeMarkerProperty().addListener(it -> this.updateTimelineVisibility());
        ((DayViewBase)view).showCurrentTimeTodayMarkerProperty().addListener(it -> this.updateTimelineVisibility());
        ((DateControl)((Object)view)).layoutProperty().addListener(it -> view.requestLayout());
        ((DateControl)((Object)view)).visibleLayersProperty().addListener(it -> view.requestLayout());
        ((DayViewBase)view).scrollTimeProperty().addListener(it -> {
            this.loadData("view scrolled");
            view.requestLayout();
        });
        ((DayViewBase)view).scrollingEnabledProperty().addListener(it -> {
            if (view.isScrollingEnabled()) {
                this.lines.clear();
            } else {
                this.createStaticLines();
            }
            view.requestLayout();
        });
        this.updateShowMarkers();
        this.updateTimelineVisibility();
        ((DateControl)((Object)view)).dateProperty().addListener(it -> {
            if (this.displayedDate == null || !this.displayedDate.equals(view.getDate())) {
                this.loadData("date changed");
            }
        });
        ((DateControl)((Object)view)).suspendUpdatesProperty().addListener(evt -> this.loadData("suspend updates was changed to " + view.isSuspendUpdates()));
        ((DateControl)((Object)view)).getCalendars().addListener(obs -> this.loadData("list of calendars changed"));
        InvalidationListener styleLinesListener = it -> this.updateLineStyling();
        ((DateControl)((Object)view)).startTimeProperty().addListener(styleLinesListener);
        ((DateControl)((Object)view)).endTimeProperty().addListener(styleLinesListener);
        ((DayViewBase)view).earlyLateHoursStrategyProperty().addListener(styleLinesListener);
        ((DayViewBase)view).gridTypeProperty().addListener(styleLinesListener);
        this.loadData("initial data loading");
        InvalidationListener loadDataListener = it -> {
            if (view.isScrollingEnabled()) {
                Platform.runLater(() -> this.loadData("height changed"));
            }
        };
        view.heightProperty().addListener(loadDataListener);
        ((DayViewBase)view).hourHeightProperty().addListener(loadDataListener);
        Rectangle clip = new Rectangle();
        clip.widthProperty().bind((ObservableValue)view.widthProperty());
        clip.heightProperty().bind((ObservableValue)view.heightProperty());
        view.setClip((Node)clip);
        ((DayView)this.getSkinnable()).setOnMousePressed(evt -> {
            this.startY = evt.getScreenY();
        });
        ((DayView)this.getSkinnable()).setOnMouseDragged(evt -> {
            if (view.isScrollingEnabled()) {
                view.setScrollTime(view.getZonedDateTimeAt(0.0, this.startY - evt.getScreenY(), view.getZoneId()));
                this.startY = evt.getScreenY();
            }
        });
        ((DayViewBase)view).gridLinesProperty().addListener(drawBackgroundCanvasListener);
        ((DayViewBase)view).gridLineColorProperty().addListener(drawBackgroundCanvasListener);
        ((DayViewBase)view).gridTypeProperty().addListener(drawBackgroundCanvasListener);
    }

    private void listenToAvailabilityCalendar(Calendar oldCalendar, Calendar newCalendar) {
        if (oldCalendar != null) {
            oldCalendar.removeEventHandler((EventHandler<CalendarEvent>)this.weakAvailabilityHandler);
        }
        if (newCalendar != null) {
            newCalendar.addEventHandler((EventHandler<CalendarEvent>)this.weakAvailabilityHandler);
        }
    }

    private void createStaticLines() {
        this.lines.clear();
        for (int i = 1; i < 24; ++i) {
            this.createLine(HALF_HOUR_LINE_STYLE_CLASS);
            this.createLine(FULL_HOUR_LINE_STYLE_CLASS);
        }
        this.createLine(HALF_HOUR_LINE_STYLE_CLASS);
        this.updateLineStyling();
    }

    @Override
    protected void calendarVisibilityChanged() {
        ((DayView)this.getSkinnable()).requestLayout();
    }

    @Override
    protected void refreshData() {
        this.loadData("refreshData() was called");
    }

    private void updateTimelineVisibility() {
        double lineOpacity = ((DayView)this.getSkinnable()).isShowCurrentTimeMarker() ? 1.0 : 0.0;
        FadeTransition lineTransition = new FadeTransition(Duration.millis((double)600.0), (Node)this.currentTimeLine);
        lineTransition.setToValue(lineOpacity);
        lineTransition.play();
        double circleOpacity = ((DayView)this.getSkinnable()).isShowCurrentTimeTodayMarker() ? 1.0 : 0.0;
        FadeTransition circleTransition = new FadeTransition(Duration.millis((double)600.0), (Node)this.currentTimeCircle);
        circleTransition.setToValue(circleOpacity);
        circleTransition.play();
    }

    private void setupCurrentTimeMarkerSupport() {
        DayView view = (DayView)this.getSkinnable();
        ChangeListener listener = (obs, oldValue, newValue) -> this.updateShowMarkers();
        view.dateProperty().addListener(listener);
        view.todayProperty().addListener(listener);
    }

    private void updateShowMarkers() {
        DayView view = (DayView)this.getSkinnable();
        view.getProperties().put((Object)"show.current.time.marker", (Object)this.isShowingTimeMarker());
        view.getProperties().put((Object)"show.current.time.today.marker", (Object)this.isShowingTimeTodayMarker());
    }

    protected boolean isShowingTimeMarker() {
        return ((DayView)this.getSkinnable()).getDate().equals(((DayView)this.getSkinnable()).getToday());
    }

    protected boolean isShowingTimeTodayMarker() {
        return this.isShowingTimeMarker();
    }

    private void addOrRemoveDraggedEntryView() {
        DayView view = (DayView)this.getSkinnable();
        DraggedEntry draggedEntry = view.getDraggedEntry();
        if (draggedEntry != null) {
            this.draggedEntryView = this.doAddEntryView(draggedEntry);
            this.draggedEntryView.toFront();
            this.draggedEntryView.setMouseTransparent(true);
            this.draggedEntryView.getProperties().put((Object)"selected", (Object)true);
            draggedEntry.intervalProperty().addListener((InvalidationListener)this.weakLayoutListener);
        } else if (this.draggedEntryView != null) {
            this.removeEntryView(this.draggedEntryView.getEntry(), null);
            this.draggedEntryView = null;
        }
        view.requestLayout();
    }

    private void loadData(String reason) {
        if (((DayView)this.getSkinnable()).isSuspendUpdates()) {
            return;
        }
        this.updateEntries(reason);
    }

    private void createLine() {
        this.createLine(null);
    }

    private void createLine(String styleClass) {
        Line line = new Line();
        line.setManaged(false);
        line.setMouseTransparent(true);
        if (styleClass != null) {
            line.getStyleClass().add((Object)styleClass);
        }
        this.lines.add(line);
        this.getChildren().add((Object)line);
    }

    private void updateLineStyling() {
        DayView dayView = (DayView)this.getSkinnable();
        LocalTime startTime = dayView.getStartTime();
        LocalTime endTime = dayView.getEndTime();
        boolean showEarlyHoursRegion = startTime.isAfter(LocalTime.MIN);
        boolean showLateHoursRegion = endTime.isBefore(LocalTime.MAX);
        this.earlyHoursRegion.setVisible(showEarlyHoursRegion);
        this.lateHoursRegion.setVisible(showLateHoursRegion);
        int lineCount = this.lines.size();
        for (int i = 0; i < lineCount; ++i) {
            LocalTime time;
            boolean halfHourLine;
            Line line = this.lines.get(i);
            line.getStyleClass().removeAll((Object[])new String[]{"early-hour-line", "late-hour-line"});
            int hour = (i + 1) / 2;
            int minute = 0;
            boolean bl = halfHourLine = i % 2 == 0;
            if (halfHourLine) {
                minute = 30;
            }
            if ((time = LocalTime.of(hour, minute)).isBefore(startTime) && !line.getStyleClass().contains((Object)"early-hour-line")) {
                line.getStyleClass().add((Object)"early-hour-line");
            }
            if (time.isAfter(endTime) && !line.getStyleClass().contains((Object)"late-hour-line")) {
                line.getStyleClass().add((Object)"late-hour-line");
            }
            if (dayView.getGridType().equals((Object)DayViewBase.GridType.STANDARD)) {
                switch (dayView.getEarlyLateHoursStrategy()) {
                    case HIDE: {
                        line.setVisible(!time.isBefore(startTime) && !time.equals(startTime) && !time.isAfter(endTime) && !time.equals(endTime));
                        break;
                    }
                    case SHOW: {
                        line.setVisible(true);
                        break;
                    }
                    case SHOW_COMPRESSED: {
                        line.setVisible(!halfHourLine);
                        break;
                    }
                }
                continue;
            }
            line.setVisible(false);
        }
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        super.layoutChildren(contentX, contentY, contentWidth, contentHeight);
        this.backgroundCanvas.relocate(contentX, contentY);
        this.backgroundCanvas.setWidth(contentWidth);
        this.backgroundCanvas.setHeight(contentHeight);
        this.backgroundCanvas.draw();
        if (((DayView)this.getSkinnable()).isScrollingEnabled()) {
            this.layoutChildrenInfiniteScrolling(contentX, contentY, contentWidth, contentHeight);
        } else {
            this.layoutChildrenStatic(contentX, contentY, contentWidth, contentHeight);
        }
    }

    protected void layoutChildrenInfiniteScrolling(double contentX, double contentY, double contentWidth, double contentHeight) {
        DayView view = (DayView)this.getSkinnable();
        if (view.getGridType().equals((Object)DayViewBase.GridType.STANDARD)) {
            Line line;
            ZonedDateTime scrollTime = view.getScrollTime();
            Instant time = scrollTime.toInstant().truncatedTo(ChronoUnit.HOURS);
            double y = view.getLocation(time);
            int lineIndex = 0;
            do {
                LocalTime localTime = LocalTime.ofInstant(time, view.getZoneId());
                if (lineIndex >= this.lines.size()) {
                    this.createLine();
                    line = this.lines.get(lineIndex);
                    line.toBack();
                }
                line = this.lines.get(lineIndex);
                line.toBack();
                line.setVisible(true);
                line.getStyleClass().removeAll((Object[])new String[]{HALF_HOUR_LINE_STYLE_CLASS, FULL_HOUR_LINE_STYLE_CLASS, MIDNIGHT_LINE_STYLE_CLASS, NOON_LINE_STYLE_CLASS});
                if (localTime.getMinute() == 30) {
                    line.getStyleClass().add((Object)HALF_HOUR_LINE_STYLE_CLASS);
                } else {
                    line.getStyleClass().add((Object)FULL_HOUR_LINE_STYLE_CLASS);
                }
                if (localTime.equals(LocalTime.MIDNIGHT)) {
                    line.getStyleClass().add((Object)MIDNIGHT_LINE_STYLE_CLASS);
                    line.setStartX(this.snapPositionX(contentX));
                    line.setEndX(this.snapPositionX(contentX + contentWidth));
                } else if (localTime.equals(LocalTime.NOON)) {
                    line.setStartX(this.snapPositionX(contentX));
                    line.setEndX(this.snapPositionX(contentX + contentWidth));
                    if (view.isShowNoonMarker()) {
                        line.getStyleClass().add((Object)NOON_LINE_STYLE_CLASS);
                    }
                } else {
                    line.setStartX(this.snapPositionX(contentX + 4.0));
                    line.setEndX(this.snapPositionX(contentX + contentWidth - 4.0));
                }
                line.setStartY(this.snapPositionY(y));
                line.setEndY(this.snapPositionY(y));
                ++lineIndex;
            } while ((y = view.getLocation(time = time.plus(30L, ChronoUnit.MINUTES))) < contentY + contentHeight);
            for (int i = lineIndex; i < this.lines.size(); ++i) {
                line = this.lines.get(i);
                line.setVisible(false);
            }
        }
        this.layoutEntries(contentX, contentY, contentWidth, contentHeight);
        this.layoutCurrentTime(contentX, contentY, contentWidth);
    }

    protected void layoutChildrenStatic(double contentX, double contentY, double contentWidth, double contentHeight) {
        int lineCount = this.lines.size();
        DayView dayView = (DayView)this.getSkinnable();
        boolean showEarlyHoursRegion = dayView.getStartTime().isAfter(LocalTime.MIN) && !dayView.getEarlyLateHoursStrategy().equals((Object)DayViewBase.EarlyLateHoursStrategy.HIDE);
        boolean showLateHoursRegion = dayView.getEndTime().isBefore(LocalTime.MAX) && !dayView.getEarlyLateHoursStrategy().equals((Object)DayViewBase.EarlyLateHoursStrategy.HIDE);
        this.earlyHoursRegion.setVisible(showEarlyHoursRegion);
        this.lateHoursRegion.setVisible(showLateHoursRegion);
        ZonedDateTime startTime = dayView.getZonedDateTimeStart();
        ZonedDateTime endTime = dayView.getZonedDateTimeEnd();
        double earlyHoursY = dayView.getLocation(startTime);
        double lateHoursY = dayView.getLocation(endTime);
        this.earlyHoursRegion.resizeRelocate(this.snapPositionX(contentX), this.snapPositionY(contentY), this.snapSizeX(contentWidth), this.snapSizeY(earlyHoursY));
        this.lateHoursRegion.resizeRelocate(this.snapPositionX(contentX), this.snapPositionY(lateHoursY), this.snapSizeX(contentWidth), this.snapSizeY(contentHeight - lateHoursY));
        for (int i = 0; i < lineCount; ++i) {
            boolean halfHourLine;
            Line line = this.lines.get(i);
            int hour = (i + 1) / 2;
            int minute = 0;
            boolean bl = halfHourLine = i % 2 == 0;
            if (halfHourLine) {
                minute = 30;
            }
            LocalTime time = LocalTime.of(hour, minute);
            ZonedDateTime zonedDateTime = dayView.getZonedDateTime(time);
            double yy = this.snapPositionY(contentY + dayView.getLocation(zonedDateTime));
            line.setStartX(this.snapPositionX(contentX + 4.0));
            line.setStartY(yy);
            line.setEndX(this.snapPositionX(contentX + contentWidth - 4.0));
            line.setEndY(yy);
        }
        if (this.draggedEntryView != null) {
            Entry<?> draggedEntry = this.draggedEntryView.getEntry();
            this.draggedEntryView.visibleProperty().unbind();
            this.draggedEntryView.setVisible(this.isRelevant(draggedEntry));
        }
        this.layoutEntries(contentX, contentY, contentWidth, contentHeight);
        this.layoutCurrentTime(contentX, contentY, contentWidth);
    }

    protected void layoutEntries(double contentX, double contentY, double contentWidth, double contentHeight) {
        DayView dayView = (DayView)this.getSkinnable();
        switch (dayView.getLayout()) {
            case STANDARD: {
                this.layoutStandard(dayView, contentX, contentY, contentWidth, contentHeight);
                break;
            }
            case SWIMLANE: {
                this.layoutSwimlane(dayView, contentX, contentY, contentWidth, contentHeight);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown layout: " + dayView.getLayout());
            }
        }
    }

    protected void layoutCurrentTime(double contentX, double contentY, double contentWidth) {
        DayView dayView = (DayView)this.getSkinnable();
        ZonedDateTime time = dayView.getZonedDateTime();
        double y = dayView.isScrollingEnabled() ? this.snapPositionY(dayView.getLocation(time)) : this.snapPositionY(contentY + dayView.getLocation(time));
        this.currentTimeLine.setStartX(this.snapPositionX(contentX));
        this.currentTimeLine.setStartY(this.snapPositionY(y));
        this.currentTimeLine.setEndX(this.snapPositionX(contentX + contentWidth));
        this.currentTimeLine.setEndY(this.snapPositionY(y));
        this.currentTimeLine.toFront();
        this.currentTimeCircle.setCenterX(this.snapPositionX(contentX + this.currentTimeCircle.getRadius() + 4.0));
        this.currentTimeCircle.setCenterY(y);
        this.currentTimeCircle.toFront();
    }

    private void layoutStandard(DayView dayView, double contentX, double contentY, double contentWidth, double contentHeight) {
        Predicate<DayEntryView> isRelatedToVisibleLayer = view -> dayView.visibleLayersProperty().contains((Object)view.getLayer());
        Map<DateControl.Layer, List<DayEntryView>> layerGroupedEntryViews = this.groupEntryViewsBy(EntryViewBase::getLayer, isRelatedToVisibleLayer);
        this.layoutOnLayers(layerGroupedEntryViews, dayView, contentX, contentY, contentWidth, contentHeight);
    }

    private void layoutSwimlane(DayView dayView, double contentX, double contentY, double contentWidth, double contentHeight) {
        FilteredList visibleCalendars = dayView.getCalendars().filtered(c -> ((DayView)this.getSkinnable()).isCalendarVisible((Calendar)c));
        double x = contentX;
        double w = contentWidth / (double)visibleCalendars.size();
        Predicate<DayEntryView> isRelatedToVisibleLayer = view -> dayView.visibleLayersProperty().contains((Object)view.getLayer());
        Predicate<DayEntryView> isRelatedToVisibleCalendar = arg_0 -> this.lambda$layoutSwimlane$24((List)visibleCalendars, arg_0);
        Predicate<DayEntryView> entryViewFilter = isRelatedToVisibleLayer.and(isRelatedToVisibleCalendar);
        Map<Calendar, List<DayEntryView>> calendarGroupedEntryViews = this.groupEntryViewsBy(this::getEntryViewCalendar, entryViewFilter);
        for (Calendar calendar : visibleCalendars) {
            Map<DateControl.Layer, List<DayEntryView>> layerGroupedEntryViews = calendarGroupedEntryViews.getOrDefault(calendar, Collections.emptyList()).stream().collect(Collectors.groupingBy(EntryViewBase::getLayer));
            this.layoutOnLayers(layerGroupedEntryViews, dayView, x, contentY, w, contentHeight);
            x += w;
        }
    }

    private <G> Map<G, List<DayEntryView>> groupEntryViewsBy(Function<DayEntryView, G> groupByFunction, Predicate<DayEntryView> viewEntryFilter) {
        return this.entryViewGroup.getChildren().stream().map(DayEntryView.class::cast).filter(viewEntryFilter).collect(Collectors.groupingBy(groupByFunction));
    }

    private void layoutOnLayers(Map<DateControl.Layer, List<DayEntryView>> layerGroupedViewEntries, DayView dayView, double contentX, double contentY, double contentWidth, double contentHeight) {
        List<DayEntryView> baseEntryViews = layerGroupedViewEntries.getOrDefault((Object)DateControl.Layer.BASE, Collections.emptyList());
        this.layoutBaseEntryViews(baseEntryViews, dayView, contentX, contentY, contentWidth, contentHeight);
        List<DayEntryView> topEntryViews = layerGroupedViewEntries.getOrDefault((Object)DateControl.Layer.TOP, Collections.emptyList());
        this.layoutTopEntryViews(topEntryViews, dayView, contentX, contentY, contentWidth, contentHeight);
    }

    private Calendar getEntryViewCalendar(DayEntryView view) {
        Calendar cal;
        Entry<?> entry = view.getEntry();
        if (entry instanceof DraggedEntry) {
            DraggedEntry draggedEntry = (DraggedEntry)view.getEntry();
            cal = draggedEntry.getOriginalCalendar();
        } else {
            cal = entry.getCalendar();
        }
        return cal;
    }

    protected void layoutBaseEntryViews(List<DayEntryView> entryViews, DayView dayView, double contentX, double contentY, double contentWidth, double contentHeight) {
        List<Placement> placements = dayView.getOverlapResolutionStrategy().equals((Object)DayViewBase.OverlapResolutionStrategy.VISUAL_BOUNDS) ? VisualBoundsResolver.resolve(entryViews, dayView, contentWidth) : TimeBoundsResolver.resolve(entryViews);
        if (placements != null) {
            contentWidth = contentWidth * dayView.getEntryWidthPercentage() / 100.0;
            Instant dayViewStart = dayView.getZonedDateTime().with(LocalTime.MIN).toInstant();
            Instant dayViewEnd = dayView.getZonedDateTimeEnd().with(LocalTime.MAX).toInstant();
            for (Placement placement : placements) {
                EntryViewBase<?> entryView = placement.getEntryView();
                Entry<?> entry = entryView.getEntry();
                double y1 = dayView.getLocation(entry.getStartAsZonedDateTime());
                double y2 = dayView.getLocation(entry.getEndAsZonedDateTime());
                if (entryView.getHeightLayoutStrategy().equals((Object)EntryViewBase.HeightLayoutStrategy.COMPUTE_PREF_SIZE)) {
                    y2 = y1 + entryView.prefHeight(contentWidth);
                }
                LocalDate viewDate = dayView.getDate();
                LocalTime viewStartTime = entry.getStartTime();
                LocalTime viewEndTime = entry.getEndTime();
                if (!dayView.isScrollingEnabled()) {
                    boolean startsBefore = false;
                    boolean endsAfter = false;
                    if (entry.getStartAsZonedDateTime().toInstant().isBefore(dayViewStart)) {
                        y1 = contentY;
                        viewStartTime = dayView.getStartTime();
                        startsBefore = true;
                    }
                    if (entry.getEndAsZonedDateTime().toInstant().isAfter(dayViewEnd)) {
                        y2 = contentHeight;
                        viewEndTime = dayView.getEndTime();
                        endsAfter = true;
                    }
                    EntryViewBase.Position position = EntryViewBase.Position.ONLY;
                    if (startsBefore && endsAfter) {
                        position = EntryViewBase.Position.MIDDLE;
                    } else if (startsBefore) {
                        position = EntryViewBase.Position.LAST;
                    } else if (endsAfter) {
                        position = EntryViewBase.Position.FIRST;
                    }
                    entryView.getProperties().put((Object)"position", (Object)position);
                }
                entryView.getProperties().put((Object)"startDate", (Object)viewDate);
                entryView.getProperties().put((Object)"endDate", (Object)viewDate);
                entryView.getProperties().put((Object)"startTime", (Object)viewStartTime);
                entryView.getProperties().put((Object)"endTime", (Object)viewEndTime);
                double minHeight = entryView.minHeight(contentWidth);
                double columnWidth = contentWidth / (double)placement.getColumnCount();
                double x = contentX;
                if (!dayView.getOverlapResolutionStrategy().equals((Object)DayViewBase.OverlapResolutionStrategy.OFF)) {
                    x += (double)placement.getColumnIndex() * columnWidth;
                }
                double entryWidth = this.computeEntryWidth(entryView, columnWidth);
                double entryLeftOffset = this.computeEntryLeftOffset(entryView, entryWidth, columnWidth);
                entryView.resizeRelocate(this.snapPositionX(x + entryLeftOffset), this.snapPositionY(y1), this.snapSizeX(entryWidth), this.snapSizeY(Math.max(minHeight, y2 - y1 - 2.0)));
            }
        }
    }

    protected void layoutTopEntryViews(List<DayEntryView> entryViews, DayView dayView, double contentX, double contentY, double contentWidth, double contentHeight) {
        entryViews.sort(Comparator.comparing(EntryViewBase::getStartDate));
        for (DayEntryView entryView : entryViews) {
            Entry<?> entry = entryView.getEntry();
            double y1 = dayView.getLocation(entry.getStartAsZonedDateTime());
            double y2 = dayView.getLocation(entry.getEndAsZonedDateTime());
            double entryWidth = this.computeEntryWidth(entryView, contentWidth);
            double entryLeftOffset = this.computeEntryLeftOffset(entryView, entryWidth, contentWidth);
            double minHeight = entryView.minHeight(entryWidth);
            entryView.resizeRelocate(this.snapPositionX(contentX + entryLeftOffset), this.snapPositionY(y1), this.snapSizeX(entryWidth), this.snapSizeY(Math.max(minHeight, y2 - y1 - 2.0)));
            entryView.toFront();
        }
    }

    private double computeEntryWidth(EntryViewBase<?> entryView, double availableWidth) {
        if (entryView.getAlignmentStrategy().equals((Object)EntryViewBase.AlignmentStrategy.FILL)) {
            return availableWidth;
        }
        double preferredWidth = entryView.prefWidth(-1.0);
        if (preferredWidth != 0.0) {
            return preferredWidth;
        }
        return availableWidth * (entryView.getWidthPercentage() * 0.01);
    }

    private double computeEntryLeftOffset(EntryViewBase<?> entryView, double entryWidth, double availableWidth) {
        switch (entryView.getAlignmentStrategy()) {
            default: {
                return 0.0;
            }
            case ALIGN_CENTER: {
                return (availableWidth - entryWidth) * 0.5;
            }
            case ALIGN_RIGHT: 
        }
        return availableWidth - entryWidth;
    }

    @Override
    protected void zoneIdChanged() {
        if (!((DayView)this.getSkinnable()).isSuspendUpdates()) {
            this.loadData("zone ID changed");
        }
    }

    @Override
    protected void calendarChanged(Calendar calendar) {
        LoggingDomain.VIEW.fine("handle calendar changed, date = " + ((DayView)this.getSkinnable()).getDate());
        if (!((DayView)this.getSkinnable()).isSuspendUpdates()) {
            this.loadData("changes in calendar " + calendar.getName());
        }
    }

    @Override
    protected void entryCalendarChanged(CalendarEvent evt) {
        LoggingDomain.VIEW.fine("handle entry calendar changed, date = " + ((DayView)this.getSkinnable()).getDate());
        Entry<?> entry = evt.getEntry();
        if (evt.getCalendar() == null) {
            if (this.findEntryView(entry).isPresent()) {
                this.removeEntryView(entry, "entry was deleted");
            }
        } else if (!entry.isFullDay() && evt.getOldCalendar() == null && this.isRelevant(entry)) {
            this.addEntryView(entry, "entry calendar changed");
        }
    }

    @Override
    protected void entryFullDayChanged(CalendarEvent evt) {
        LoggingDomain.VIEW.fine("handle entry full day flag changed, date = " + ((DayView)this.getSkinnable()).getDate());
        Entry<?> entry = evt.getEntry();
        if (this.isRelevant(entry)) {
            Optional<EntryViewBase> entryView = this.findEntryView(entry);
            if (entry.isFullDay() && entryView.isPresent()) {
                this.removeEntryView(entry, "full day flag changed to true");
            } else {
                this.addEntryView(entry, "full day flag changed to false, no entry view can be present");
            }
        }
        ((DayView)this.getSkinnable()).requestLayout();
    }

    @Override
    protected void entryRecurrenceRuleChanged(CalendarEvent evt) {
        LoggingDomain.VIEW.fine("handle entry recurrence rule changed, date = " + ((DayView)this.getSkinnable()).getDate());
        Entry<?> entry = evt.getEntry();
        if (!entry.isFullDay() && !entry.getStartDate().equals(((DayView)this.getSkinnable()).getDate())) {
            Optional<Entry<?>> recurrenceEntry = this.findRecurrenceEntry(entry);
            if (recurrenceEntry.isPresent()) {
                Optional<EntryViewBase> entryView = this.findEntryView(entry);
                if (entryView.isPresent()) {
                    entryView.get().setEntry(recurrenceEntry.get());
                } else {
                    this.addEntryView(entry, "recurrence rule changed, no view was present");
                }
            } else {
                this.removeEntryView(entry, "recurrence rule changed, no recurrence found");
            }
        }
        ((DayView)this.getSkinnable()).requestLayout();
    }

    @Override
    protected void entryIntervalChanged(CalendarEvent evt) {
        LoggingDomain.VIEW.fine("handle entry interval changed, date = " + ((DayView)this.getSkinnable()).getDate());
        Entry<?> entry = evt.getEntry();
        if (!entry.isFullDay()) {
            Optional<EntryViewBase> entryView = this.findEntryView(entry);
            if (this.isRelevant(entry)) {
                if (entryView.isPresent()) {
                    if (entry.isRecurring() && !entry.getStartDate().equals(((DayView)this.getSkinnable()).getDate())) {
                        Optional<Entry<?>> recurrenceEntry = this.findRecurrenceEntry(entry);
                        if (recurrenceEntry.isPresent()) {
                            entryView.get().setEntry(recurrenceEntry.get());
                        }
                    } else {
                        entryView.get().setEntry(entry);
                    }
                } else {
                    this.addEntryView(entry, "interval changed, no view was present");
                }
            } else {
                this.removeEntryView(entry, "interval changed, entry is not relevant");
            }
        }
        ((DayView)this.getSkinnable()).requestLayout();
    }

    private Optional<EntryViewBase> findEntryView(Entry<?> entry) {
        List collect = this.entryViewGroup.getChildren().stream().map(node -> (EntryViewBase)node).filter(e -> e.getEntry().getId().equals(entry.getId())).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((EntryViewBase)collect.get(0));
    }

    private boolean removeEntryView(Entry<?> entry, String reason) {
        boolean removed;
        if (reason != null) {
            LoggingDomain.VIEW.fine("removing entry, reason = " + reason + ", date = " + ((DayView)this.getSkinnable()).getDate());
        }
        if ((removed = Util.removeChildren(this.entryViewGroup, node -> {
            Entry<?> viewEntry;
            DayEntryView view = (DayEntryView)node;
            Entry removedEntry = entry;
            if (removedEntry.getRecurrenceSourceEntry() != null) {
                removedEntry = removedEntry.getRecurrenceSourceEntry();
            }
            if ((viewEntry = view.getEntry()).getRecurrenceSourceEntry() != null) {
                viewEntry = viewEntry.getRecurrenceSourceEntry();
            }
            return viewEntry.getId().equals(removedEntry.getId());
        })) && !(entry instanceof DraggedEntry) && LoggingDomain.VIEW.isLoggable(Level.FINE)) {
            LoggingDomain.VIEW.fine("successfully removed the entry view of entry " + entry);
        }
        return removed;
    }

    private void addEntryView(Entry<?> entry, String reason) {
        LoggingDomain.VIEW.fine("adding entry, reason = " + reason + ", date = " + ((DayView)this.getSkinnable()).getDate());
        if (entry.isRecurring()) {
            Optional<Entry<?>> recurrenceEntry = this.findRecurrenceEntry(entry);
            if (recurrenceEntry.isPresent()) {
                this.doAddEntryView(recurrenceEntry.get());
            }
        } else {
            this.doAddEntryView(entry);
        }
        ((DayView)this.getSkinnable()).requestLayout();
    }

    private Optional<Entry<?>> findRecurrenceEntry(Entry<?> entry) {
        LocalDate date;
        Calendar calendar = entry.getCalendar();
        Map<LocalDate, List<Entry<?>>> entries = calendar.findEntries(date = ((DayView)this.getSkinnable()).getDate(), date, this.getZoneId());
        List<Entry<?>> entriesOnDate = entries.get(date);
        if (entriesOnDate != null && !entriesOnDate.isEmpty()) {
            return entriesOnDate.stream().filter(e -> e.getId().equals(entry.getId())).findFirst();
        }
        return Optional.empty();
    }

    private DayEntryView doAddEntryView(Entry<?> entry) {
        Callback<Entry<?>, DayEntryView> factory = ((DayView)this.getSkinnable()).getEntryViewFactory();
        DayEntryView view = (DayEntryView)factory.call(entry);
        view.getProperties().put((Object)"control", (Object)this.getSkinnable());
        view.setManaged(false);
        int index = this.findIndex(entry);
        this.entryViewGroup.getChildren().add(index, (Object)view);
        if (!(entry instanceof DraggedEntry) && LoggingDomain.VIEW.isLoggable(Level.FINE)) {
            LoggingDomain.VIEW.fine("added entry view " + entry.getTitle() + ", day = " + ((DayView)this.getSkinnable()).getDate());
        }
        return view;
    }

    private int findIndex(Entry<?> entry) {
        int childrenSize = this.entryViewGroup.getChildren().size();
        for (int i = 0; i < childrenSize; ++i) {
            Node node = (Node)this.entryViewGroup.getChildren().get(i);
            DayEntryView view = (DayEntryView)node;
            Entry<?> viewEntry = view.getEntry();
            if (!viewEntry.getStartAsZonedDateTime().isAfter(entry.getStartAsZonedDateTime())) continue;
            return i;
        }
        return childrenSize;
    }

    private void updateEntries(String reason) {
        this.displayedDate = ((DayView)this.getSkinnable()).getDate();
        this.entryViewGroup.getChildren().clear();
        HashMap dataMap = new HashMap();
        this.dataLoader.loadEntries(dataMap);
        LocalDate date = this.getLoadStartDate();
        LocalTime earliest = null;
        LocalTime latest = null;
        ArrayList<Entry> processedEntries = new ArrayList<Entry>();
        do {
            List entryList;
            if ((entryList = (List)dataMap.get(date)) == null) continue;
            entryList.removeIf(Entry::isFullDay);
            for (Entry entry : entryList) {
                if (processedEntries.contains(entry)) continue;
                processedEntries.add(entry);
                this.doAddEntryView(entry);
                if (earliest == null || entry.getStartTime().isBefore(earliest)) {
                    earliest = entry.getStartTime();
                }
                if (entry.getStartDate().isBefore(((DayView)this.getSkinnable()).getDate())) {
                    earliest = LocalTime.MIN;
                }
                if (latest == null || entry.getEndTime().isAfter(latest)) {
                    latest = entry.getEndTime();
                }
                if (!entry.getEndDate().isAfter(((DayView)this.getSkinnable()).getDate())) continue;
                latest = LocalTime.MAX;
            }
        } while (!(date = date.plusDays(1L)).isAfter(this.getLoadEndDate()));
        ((DayView)this.getSkinnable()).getProperties().put((Object)"earliest.time.used", earliest);
        ((DayView)this.getSkinnable()).getProperties().put((Object)"latest.time.used", latest);
        ((DayView)this.getSkinnable()).requestLayout();
        LoggingDomain.VIEW.fine("updating entries in day view " + ((DayView)this.getSkinnable()).getDate() + ": reason = " + reason + ", entry count: " + this.entryViewGroup.getChildren().size());
    }

    @Override
    public String getLoaderName() {
        return "Day View";
    }

    @Override
    public LocalDate getLoadStartDate() {
        if (((DayView)this.getSkinnable()).isScrollingEnabled()) {
            return ((DayView)this.getSkinnable()).getScrollTime().toLocalDate().minusDays(1L);
        }
        return ((DayView)this.getSkinnable()).getDate();
    }

    @Override
    public LocalDate getLoadEndDate() {
        if (((DayView)this.getSkinnable()).isScrollingEnabled()) {
            return ((DayView)this.getSkinnable()).getZonedDateTimeAt(0.0, ((DayView)this.getSkinnable()).getHeight(), ((DayView)this.getSkinnable()).getZoneId()).toLocalDate();
        }
        return ((DayView)this.getSkinnable()).getDate();
    }

    @Override
    public ZoneId getZoneId() {
        return ((DayView)this.getSkinnable()).getZoneId();
    }

    @Override
    public List<CalendarSource> getCalendarSources() {
        return ((DayView)this.getSkinnable()).getCalendarSources();
    }

    @Override
    public Control getControl() {
        return this.getSkinnable();
    }

    @Override
    public boolean isCalendarVisible(Calendar calendar) {
        return ((DayView)this.getSkinnable()).isCalendarVisible(calendar);
    }

    private /* synthetic */ boolean lambda$layoutSwimlane$24(List visibleCalendars, DayEntryView view) {
        return visibleCalendars.contains(this.getEntryViewCalendar(view));
    }

    private class BackgroundCanvas
    extends Canvas {
        BackgroundCanvas() {
            this.setMouseTransparent(true);
            InvalidationListener redrawListener = it -> this.draw();
            this.heightProperty().addListener(redrawListener);
            this.widthProperty().addListener(redrawListener);
        }

        public boolean isResizable() {
            return true;
        }

        public void draw() {
            GraphicsContext gc = DayViewSkin.this.backgroundCanvas.getGraphicsContext2D();
            gc.clearRect(0.0, 0.0, this.getWidth(), this.getHeight());
            DayView view = (DayView)DayViewSkin.this.getSkinnable();
            Calendar availabilityCalendar = view.getAvailabilityCalendar();
            if (availabilityCalendar != null) {
                gc.setFill(view.getAvailabilityFill());
                LocalDate date = view.getDate();
                Map<LocalDate, List<Entry<?>>> entries = availabilityCalendar.findEntries(date, date, view.getZoneId());
                List<Entry<?>> entriesOnDate = entries.get(date);
                if (entriesOnDate != null) {
                    entriesOnDate.forEach(entry -> {
                        ZonedDateTime startAsZonedDateTime = entry.getStartAsZonedDateTime();
                        ZonedDateTime endAsZonedDateTime = entry.getEndAsZonedDateTime();
                        double y1 = ViewHelper.getTimeLocation((DayViewBase)view, startAsZonedDateTime);
                        double y2 = ViewHelper.getTimeLocation((DayViewBase)view, endAsZonedDateTime);
                        gc.fillRect(0.0, y1, this.getWidth(), y2 - y1);
                    });
                }
            }
            if (view.isEditAvailability()) {
                Instant start = view.getLassoStart();
                Instant end = view.getLassoEnd();
                if (start != null && end != null) {
                    double y1 = ViewHelper.getTimeLocation((DayViewBase)view, start);
                    double y2 = ViewHelper.getTimeLocation((DayViewBase)view, end);
                    double minY = Math.min(y1, y2);
                    double maxY = Math.max(y1, y2);
                    gc.setFill(view.getLassoColor());
                    gc.fillRect(0.0, minY, this.getWidth(), maxY - minY);
                }
            }
            VirtualGrid virtualGrid = view.getGridLines();
            if (view.getGridType().equals((Object)DayViewBase.GridType.CUSTOM)) {
                gc.setStroke(view.getGridLineColor());
                if (view.isScrollingEnabled()) {
                    ZonedDateTime time = view.getScrollTime();
                    time = virtualGrid.adjustTime(time, false, view.getFirstDayOfWeek());
                    double y = view.getLocation(time);
                    do {
                        if (time.toLocalTime().getMinute() == 0) {
                            gc.setLineDashes(null);
                        } else {
                            gc.setLineDashes(new double[]{2.0, 2.0});
                        }
                        gc.strokeLine(0.0, y, this.getWidth(), y);
                    } while ((y = view.getLocation(time = time.plus(virtualGrid.getAmount(), virtualGrid.getUnit()))) < this.getHeight());
                    gc.setLineDashes(null);
                } else {
                    ZonedDateTime startTime = view.getZonedDateTimeMin();
                    ZonedDateTime endTime = view.getZonedDateTimeMax();
                    if (view.getEarlyLateHoursStrategy().equals((Object)DayViewBase.EarlyLateHoursStrategy.HIDE)) {
                        startTime = view.getZonedDateTimeStart();
                        endTime = view.getZonedDateTimeEnd();
                    }
                    do {
                        double y = ViewHelper.getTimeLocation((DayViewBase)view, startTime);
                        if (startTime.toLocalTime().getMinute() == 0) {
                            gc.setLineDashes(null);
                        } else {
                            gc.setLineDashes(new double[]{2.0, 2.0});
                        }
                        gc.strokeLine(0.0, y, this.getWidth(), y);
                    } while ((startTime = startTime.plus(virtualGrid.getAmount(), virtualGrid.getUnit())).isBefore(endTime));
                }
            }
        }
    }
}

