/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.util.ViewHelper;
import com.calendarfx.view.AgendaView;
import com.calendarfx.view.AllDayView;
import com.calendarfx.view.CalendarHeaderView;
import com.calendarfx.view.DateControl;
import com.calendarfx.view.DayView;
import com.calendarfx.view.DetailedDayView;
import com.calendarfx.view.Messages;
import com.calendarfx.view.TimeScaleView;
import impl.com.calendarfx.view.DateControlSkin;
import impl.com.calendarfx.view.DayViewScrollPane;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.OverrunStyle;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.Separator;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;

public class DetailedDayViewSkin
extends DateControlSkin<DetailedDayView> {
    private final GridPane gridPane;
    private final Label allDayLabel;
    private final DayViewScrollPane timeScaleScrollPane;
    private final DayViewScrollPane dayViewScrollPane;
    private final Separator separator;
    private final AllDayView allDayView;
    private final ScrollBar scrollBar = new ScrollBar();
    private final CalendarHeaderView calendarHeaderView;
    private final Region allDayFiller;
    private final AgendaView agendaView;
    private final ColumnConstraints col0;
    private final ColumnConstraints col1;
    private final ColumnConstraints col2;
    private final ColumnConstraints col3;
    private final ColumnConstraints col4;

    public DetailedDayViewSkin(DetailedDayView view) {
        super(view);
        DayView dayView = view.getDayView();
        this.dayViewScrollPane = new DayViewScrollPane(dayView, this.scrollBar);
        this.dayViewScrollPane.getStyleClass().addAll((Object[])new String[]{"calendar-scroll-pane", "day-view-scroll-pane"});
        TimeScaleView timeScale = view.getTimeScaleView();
        Bindings.bindBidirectional((Property)timeScale.translateYProperty(), (Property)dayView.translateYProperty());
        this.allDayView = view.getAllDayView();
        this.allDayView.showTodayProperty().unbindBidirectional((Property)view.showTodayProperty());
        this.allDayView.setShowToday(false);
        this.allDayView.setAdjustToFirstDayOfWeek(false);
        this.allDayLabel = new Label(Messages.getString("DetailedDayViewSkin.ALL_DAY"));
        this.allDayLabel.setTextOverrun(OverrunStyle.CLIP);
        this.allDayLabel.getStyleClass().add((Object)"all-day-label");
        this.allDayLabel.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.allDayFiller = new Region();
        this.allDayFiller.getStyleClass().add((Object)"header-all-day-filler");
        this.timeScaleScrollPane = new DayViewScrollPane(timeScale, this.scrollBar);
        this.timeScaleScrollPane.getStyleClass().addAll((Object[])new String[]{"calendar-scroll-pane", "day-view-timescale-scroll-pane"});
        this.timeScaleScrollPane.setMinWidth(Double.NEGATIVE_INFINITY);
        this.separator = new Separator(Orientation.VERTICAL);
        InvalidationListener visibilityListener = it -> this.updateVisibilities();
        view.showAllDayViewProperty().addListener(visibilityListener);
        view.showTimeScaleViewProperty().addListener(visibilityListener);
        view.layoutProperty().addListener(visibilityListener);
        view.showAgendaViewProperty().addListener(visibilityListener);
        view.showScrollBarProperty().addListener(visibilityListener);
        this.calendarHeaderView = view.getCalendarHeaderView();
        this.calendarHeaderView.visibleProperty().bind((ObservableValue)view.layoutProperty().isEqualTo((Object)DateControl.Layout.SWIMLANE));
        this.agendaView = view.getAgendaView();
        RowConstraints row0 = new RowConstraints();
        row0.setFillHeight(true);
        row0.setPrefHeight(-1.0);
        row0.setVgrow(Priority.NEVER);
        RowConstraints row1 = new RowConstraints();
        row1.setFillHeight(true);
        row1.setPrefHeight(-1.0);
        row1.setVgrow(Priority.NEVER);
        RowConstraints row2 = new RowConstraints();
        row2.setFillHeight(true);
        row2.setPrefHeight(-1.0);
        row2.setVgrow(Priority.ALWAYS);
        this.col0 = new ColumnConstraints();
        this.col0.setFillWidth(true);
        this.col0.setHgrow(Priority.NEVER);
        this.col0.setPrefWidth(-1.0);
        this.col1 = new ColumnConstraints();
        this.col1.setFillWidth(true);
        this.col1.setHgrow(Priority.ALWAYS);
        this.col1.setPrefWidth(-1.0);
        this.col2 = new ColumnConstraints();
        this.col2.setFillWidth(true);
        this.col2.setHgrow(Priority.NEVER);
        this.col2.setPrefWidth(-1.0);
        this.col3 = new ColumnConstraints();
        this.col3.setFillWidth(true);
        this.col3.setHgrow(Priority.NEVER);
        this.col3.setPrefWidth(-1.0);
        this.col4 = new ColumnConstraints();
        this.col4.setFillWidth(true);
        this.col4.setHgrow(Priority.ALWAYS);
        this.col4.setPrefWidth(-1.0);
        GridPane.setRowSpan((Node)this.agendaView, (Integer)3);
        GridPane.setRowSpan((Node)this.separator, (Integer)3);
        this.gridPane = new GridPane();
        this.gridPane.getRowConstraints().setAll((Object[])new RowConstraints[]{row0, row1, row2});
        this.gridPane.getStyleClass().add((Object)"container");
        this.getChildren().add((Object)this.gridPane);
        this.agendaView.setPrefWidth(0.0);
        dayView.setPrefWidth(0.0);
        Platform.runLater(() -> ViewHelper.scrollToRequestedTime(view, this.dayViewScrollPane));
        view.requestedTimeProperty().addListener(it -> ViewHelper.scrollToRequestedTime(view, this.dayViewScrollPane));
        this.updateVisibilities();
    }

    private void updateVisibilities() {
        this.gridPane.getChildren().clear();
        DetailedDayView view = (DetailedDayView)this.getSkinnable();
        if (view.isShowTimeScaleView()) {
            this.gridPane.add((Node)this.timeScaleScrollPane, 0, 2);
            if (view.isShowAllDayView()) {
                this.gridPane.add((Node)this.allDayLabel, 0, 0);
            }
        }
        if (view.isShowAllDayView()) {
            this.gridPane.add((Node)this.allDayView, 1, 0);
            this.gridPane.add((Node)this.allDayFiller, 2, 0);
        }
        if (view.getLayout().equals((Object)DateControl.Layout.SWIMLANE)) {
            this.gridPane.add((Node)this.calendarHeaderView, 1, 1);
        }
        this.gridPane.add((Node)this.dayViewScrollPane, 1, 2);
        if (view.isShowScrollBar()) {
            this.gridPane.add((Node)this.scrollBar, 2, 2);
        }
        if (view.isShowAgendaView()) {
            this.gridPane.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{this.col0, this.col1, this.col2, this.col3, this.col4});
            this.gridPane.add((Node)this.separator, 3, 0);
            this.gridPane.add((Node)this.agendaView, 4, 0);
        } else {
            this.gridPane.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{this.col0, this.col1, this.col2});
        }
    }
}

