/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.CalendarEvent;
import com.calendarfx.model.CalendarSource;
import com.calendarfx.model.Entry;
import com.calendarfx.util.LoggingDomain;
import com.calendarfx.view.DateControl;
import com.calendarfx.view.DateSelectionModel;
import com.calendarfx.view.MonthSheetView;
import impl.com.calendarfx.view.DataLoader;
import impl.com.calendarfx.view.DateControlSkin;
import impl.com.calendarfx.view.LoadDataSettingsProvider;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.event.WeakEventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.util.Callback;

public class MonthSheetViewSkin
extends DateControlSkin<MonthSheetView>
implements LoadDataSettingsProvider {
    private final GridPane grid = new GridPane();
    private final DataLoader dataLoader = new DataLoader(this);
    private final Map<LocalDate, List<Entry<?>>> dataMap = new HashMap();
    private final Map<LocalDate, MonthSheetView.DateCell> cellMap = new HashMap<LocalDate, MonthSheetView.DateCell>();
    private final Map<Position, MonthSheetView.DateCell> positionToDateCellMap = new HashMap<Position, MonthSheetView.DateCell>();
    private final Map<LocalDate, Position> dateToPositionMap = new HashMap<LocalDate, Position>();
    private final EventHandler<MouseEvent> cellClickedHandler = evt -> {
        if (!(evt.getSource() instanceof MonthSheetView.DateCell)) {
            return;
        }
        MonthSheetView.DateCell cell = (MonthSheetView.DateCell)((Object)((Object)evt.getSource()));
        cell.requestFocus();
        LocalDate date = cell.getDate();
        if (date != null) {
            switch (((MonthSheetView)this.getSkinnable()).getClickBehaviour()) {
                case NONE: {
                    break;
                }
                case PERFORM_SELECTION: {
                    DateSelectionModel selectionModel = ((MonthSheetView)this.getSkinnable()).getDateSelectionModel();
                    if (selectionModel.isSelected(date)) {
                        if (evt.getButton() != MouseButton.PRIMARY) break;
                        if (evt.isShortcutDown()) {
                            selectionModel.deselect(date);
                            break;
                        }
                        selectionModel.clear();
                        break;
                    }
                    if (evt.isShiftDown() && evt.getButton() == MouseButton.PRIMARY) {
                        selectionModel.selectUntil(date);
                        break;
                    }
                    if (evt.isShortcutDown() && evt.getButton() == MouseButton.PRIMARY) {
                        selectionModel.select(date);
                        break;
                    }
                    selectionModel.clearAndSelect(date);
                    break;
                }
                case SHOW_DETAILS: {
                    this.showDateDetails(date);
                }
            }
        }
    };
    private final WeakEventHandler<MouseEvent> weakCellClickedHandler = new WeakEventHandler(this.cellClickedHandler);

    public MonthSheetViewSkin(MonthSheetView control) {
        super(control);
        this.grid.getStyleClass().add((Object)"container");
        this.grid.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.updateRowConstraints();
        control.weekDayLayoutProperty().addListener(it -> this.updateRowConstraints());
        InvalidationListener builder = obs -> this.buildCells();
        control.dateProperty().addListener(builder);
        control.viewUnitProperty().addListener(builder);
        control.extendedViewUnitProperty().addListener(builder);
        control.extendedUnitsForwardProperty().addListener(builder);
        control.extendedUnitsBackwardProperty().addListener(builder);
        control.weekDayLayoutProperty().addListener(builder);
        control.weekFieldsProperty().addListener(builder);
        control.cellFactoryProperty().addListener(builder);
        control.headerCellFactoryProperty().addListener(builder);
        control.enableHyperlinksProperty().addListener(builder);
        control.getCalendars().addListener(obs -> this.updateEntries("list of calendars changed"));
        control.clickBehaviourProperty().addListener(it -> control.getDateSelectionModel().clear());
        control.getDateSelectionModel().getSelectedDates().addListener(obs -> this.updateSelected());
        ChangeListener todayUpdater = (obs, oldValue, newValue) -> this.updateToday();
        control.todayProperty().addListener(todayUpdater);
        control.showTodayProperty().addListener(todayUpdater);
        EventHandler keyPressedHandler = evt -> {
            DateSelectionModel selectionModel = ((MonthSheetView)this.getSkinnable()).getDateSelectionModel();
            LocalDate lastSelected = selectionModel.getLastSelected();
            if (lastSelected != null) {
                Position lastPosition = this.dateToPositionMap.get(lastSelected);
                LocalDate newSelection = null;
                boolean isNavigationKey = true;
                switch (evt.getCode()) {
                    case UP: {
                        newSelection = lastSelected.plusDays(-1L);
                        break;
                    }
                    case DOWN: {
                        newSelection = lastSelected.plusDays(1L);
                        break;
                    }
                    case LEFT: {
                        Position newPosition = new Position(Math.max(0, lastPosition.getColumn() - 1), lastPosition.getRow());
                        MonthSheetView.DateCell newCell = this.positionToDateCellMap.get(newPosition);
                        if (newCell == null) break;
                        newSelection = newCell.getDate();
                        break;
                    }
                    case RIGHT: {
                        Position newPosition = new Position(lastPosition.getColumn() + 1, lastPosition.getRow());
                        MonthSheetView.DateCell newCell = this.positionToDateCellMap.get(newPosition);
                        if (newCell == null) break;
                        newSelection = newCell.getDate();
                        break;
                    }
                    default: {
                        isNavigationKey = false;
                    }
                }
                if (((MonthSheetView)this.getSkinnable()).isVisibleDate(newSelection)) {
                    if (evt.isShiftDown()) {
                        selectionModel.selectUntil(newSelection);
                    } else if (evt.isShortcutDown()) {
                        selectionModel.select(newSelection);
                    } else {
                        selectionModel.clearAndSelect(newSelection);
                    }
                }
                if (isNavigationKey) {
                    evt.consume();
                }
            }
        };
        control.addEventFilter(KeyEvent.KEY_PRESSED, keyPressedHandler);
        control.setFocusTraversable(true);
        this.buildCells();
        this.getChildren().add((Object)this.grid);
        this.updateEntries("initial load");
        this.updateToday();
    }

    private void updateRowConstraints() {
        int rowCount = 32;
        if (((MonthSheetView)this.getSkinnable()).getWeekDayLayout() == MonthSheetView.WeekDayLayoutStrategy.ALIGNED) {
            rowCount += 6;
        }
        ArrayList<RowConstraints> rowConstraints = new ArrayList<RowConstraints>();
        for (int i = 0; i <= rowCount; ++i) {
            RowConstraints con = new RowConstraints();
            con.setFillHeight(true);
            con.setPrefHeight(-1.0);
            con.setMinHeight(Double.NEGATIVE_INFINITY);
            con.setMaxHeight(Double.MAX_VALUE);
            con.setVgrow(i == 0 ? Priority.NEVER : Priority.ALWAYS);
            rowConstraints.add(con);
        }
        this.grid.getRowConstraints().setAll(rowConstraints);
    }

    @Override
    protected void calendarVisibilityChanged() {
        this.updateEntries("calendar visibility changed");
    }

    private void buildCells() {
        this.positionToDateCellMap.clear();
        this.dateToPositionMap.clear();
        this.cellMap.clear();
        YearMonth start = ((MonthSheetView)this.getSkinnable()).getExtendedStartMonth();
        YearMonth end = ((MonthSheetView)this.getSkinnable()).getExtendedEndMonth();
        int colIndex = 0;
        this.grid.getColumnConstraints().clear();
        this.grid.getChildren().clear();
        while (!start.isAfter(end)) {
            ColumnConstraints columnConstraints = new ColumnConstraints();
            columnConstraints.setFillWidth(true);
            columnConstraints.setMinWidth(Double.NEGATIVE_INFINITY);
            columnConstraints.setMaxWidth(Double.MAX_VALUE);
            this.grid.getColumnConstraints().add((Object)columnConstraints);
            this.buildCells(start, colIndex);
            start = start.plusMonths(1L);
            ++colIndex;
        }
        this.grid.getColumnConstraints().forEach(con -> con.setPercentWidth(100.0 / (double)this.grid.getColumnConstraints().size()));
        this.updateEntries("cells were rebuild");
        this.updateToday();
        this.updateSelected();
    }

    private void buildCells(YearMonth yearMonth, int colIndex) {
        ArrayList<Node> cells = new ArrayList<Node>();
        Node header = this.buildHeaderCell(yearMonth);
        header.getStyleClass().add((Object)"month-header");
        cells.add(header);
        LocalDate start = yearMonth.atDay(1);
        LocalDate end = yearMonth.atEndOfMonth();
        if (((MonthSheetView)this.getSkinnable()).getWeekDayLayout() == MonthSheetView.WeekDayLayoutStrategy.ALIGNED) {
            DayOfWeek firstDayOfWeek = ((MonthSheetView)this.getSkinnable()).getFirstDayOfWeek();
            DayOfWeek startDayOfWeek = start.getDayOfWeek();
            int distanceDays = Math.abs(firstDayOfWeek.getValue() - startDayOfWeek.getValue());
            while (distanceDays-- > 0) {
                cells.add((Node)this.buildCell(null));
            }
        }
        while (start.isBefore(end) || start.isEqual(end)) {
            cells.add((Node)this.buildCell(start));
            start = start.plusDays(1L);
        }
        this.buildEmptyCellBottom(cells);
        YearMonth extendedStart = ((MonthSheetView)this.getSkinnable()).getExtendedStartMonth();
        YearMonth extendedEnd = ((MonthSheetView)this.getSkinnable()).getExtendedEndMonth();
        cells.forEach(cell -> {
            if (extendedStart.equals(yearMonth)) {
                cell.getStyleClass().add((Object)"first-month");
            } else if (extendedEnd.equals(yearMonth)) {
                cell.getStyleClass().add((Object)"last-month");
            } else {
                cell.getStyleClass().add((Object)"middle-month");
            }
        });
        for (int i = 0; i < cells.size(); ++i) {
            Node node = (Node)cells.get(i);
            this.grid.add(node, colIndex, i + 1);
            if (!(node instanceof MonthSheetView.DateCell)) continue;
            Position position = new Position(colIndex, i);
            MonthSheetView.DateCell dateCell = (MonthSheetView.DateCell)node;
            LocalDate date = dateCell.getDate();
            this.cellMap.put(date, dateCell);
            this.positionToDateCellMap.put(position, dateCell);
            this.dateToPositionMap.put(date, position);
        }
    }

    private MonthSheetView.DateCell buildCell(LocalDate date) {
        MonthSheetView.DateCell cell = (MonthSheetView.DateCell)((Object)((MonthSheetView)this.getSkinnable()).getCellFactory().call((Object)new MonthSheetView.DateParameter((MonthSheetView)this.getSkinnable(), date)));
        cell.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        cell.setOnMouseClicked((EventHandler)this.weakCellClickedHandler);
        return cell;
    }

    private Node buildHeaderCell(YearMonth yearMonth) {
        return (Node)((MonthSheetView)this.getSkinnable()).getHeaderCellFactory().call((Object)new MonthSheetView.HeaderParameter((MonthSheetView)this.getSkinnable(), yearMonth));
    }

    private void buildEmptyCellBottom(List<Node> cells) {
        int cellsNumber;
        int maximumCells = 31;
        if (((MonthSheetView)this.getSkinnable()).getWeekDayLayout().equals((Object)MonthSheetView.WeekDayLayoutStrategy.ALIGNED)) {
            maximumCells = 37;
        }
        if ((cellsNumber = cells.size() - 1) < maximumCells) {
            while (cellsNumber < maximumCells) {
                cells.add((Node)this.buildCell(null));
                ++cellsNumber;
            }
        }
    }

    private void updateSelected() {
        ObservableList<LocalDate> selectedDates = ((MonthSheetView)this.getSkinnable()).getDateSelectionModel().getSelectedDates();
        this.grid.getChildren().stream().filter(child -> child instanceof MonthSheetView.DateCell).map(child -> (MonthSheetView.DateCell)((Object)child)).forEach(cell -> cell.setSelected(selectedDates.contains(cell.getDate())));
    }

    private void updateToday() {
        LocalDate today = ((MonthSheetView)this.getSkinnable()).getToday();
        this.grid.getChildren().stream().filter(child -> child instanceof MonthSheetView.DateCell).map(child -> (MonthSheetView.DateCell)((Object)child)).forEach(cell -> cell.setToday(((MonthSheetView)this.getSkinnable()).isShowToday() && today.equals(cell.getDate())));
    }

    private void showDateDetails(LocalDate date) {
        MonthSheetView.DateCell cell = this.cellMap.get(date);
        Bounds bounds = cell.localToScreen(cell.getLayoutBounds());
        Callback<DateControl.DateDetailsParameter, Boolean> callback = ((MonthSheetView)this.getSkinnable()).getDateDetailsCallback();
        if (callback != null) {
            callback.call((Object)new DateControl.DateDetailsParameter(null, (DateControl)this.getSkinnable(), (Node)cell, (Node)cell.getScene().getRoot(), date, bounds.getMinX(), bounds.getMinY()));
        }
    }

    @Override
    protected void calendarChanged(Calendar calendar) {
        this.updateEntries("calendar changed");
    }

    @Override
    protected void entryCalendarChanged(CalendarEvent evt) {
        this.updateEntries("entry calendar changed");
    }

    @Override
    protected void entryIntervalChanged(CalendarEvent evt) {
        this.updateEntries("entry interval changed");
    }

    @Override
    protected void entryFullDayChanged(CalendarEvent evt) {
        this.updateEntries("entry full day flag changed");
    }

    @Override
    protected void entryRecurrenceRuleChanged(CalendarEvent evt) {
        this.updateEntries("entry recurrence rule changed");
    }

    private void updateEntries(String reason) {
        if (LoggingDomain.VIEW.isLoggable(Level.FINE)) {
            LoggingDomain.VIEW.fine("updating entries because: " + reason);
        }
        this.dataMap.clear();
        this.dataLoader.loadEntries(this.dataMap);
        for (LocalDate date : this.cellMap.keySet()) {
            List<Entry<?>> entries = this.dataMap.get(date);
            MonthSheetView.DateCell cell = this.cellMap.get(date);
            cell.updateEntries(entries == null ? Collections.emptyList() : entries);
        }
    }

    @Override
    public String getLoaderName() {
        return "Month Sheet View";
    }

    @Override
    public List<CalendarSource> getCalendarSources() {
        return ((MonthSheetView)this.getSkinnable()).getCalendarSources();
    }

    @Override
    public Control getControl() {
        return this.getSkinnable();
    }

    @Override
    public LocalDate getLoadStartDate() {
        return ((MonthSheetView)this.getSkinnable()).getExtendedStartMonth().atDay(1);
    }

    @Override
    public LocalDate getLoadEndDate() {
        return ((MonthSheetView)this.getSkinnable()).getExtendedEndMonth().atEndOfMonth();
    }

    @Override
    public ZoneId getZoneId() {
        return ((MonthSheetView)this.getSkinnable()).getZoneId();
    }

    @Override
    public boolean isCalendarVisible(Calendar calendar) {
        return ((MonthSheetView)this.getSkinnable()).isCalendarVisible(calendar);
    }

    private static final class Position {
        int column;
        int row;

        private Position(int column, int row) {
            this.column = column;
            this.row = row;
        }

        public int getColumn() {
            return this.column;
        }

        public int getRow() {
            return this.row;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Position position = (Position)o;
            if (this.column != position.column) {
                return false;
            }
            return this.row == position.row;
        }

        public int hashCode() {
            int result = this.column;
            result = 31 * result + this.row;
            return result;
        }
    }
}

