/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.CalendarEvent;
import com.calendarfx.model.CalendarSource;
import com.calendarfx.model.Entry;
import com.calendarfx.util.LoggingDomain;
import com.calendarfx.view.EntryViewBase;
import com.calendarfx.view.Messages;
import com.calendarfx.view.MonthEntryView;
import com.calendarfx.view.MonthView;
import com.calendarfx.view.RequestEvent;
import impl.com.calendarfx.view.DataLoader;
import impl.com.calendarfx.view.DateControlSkin;
import impl.com.calendarfx.view.LoadDataSettingsProvider;
import impl.com.calendarfx.view.util.Util;
import java.text.MessageFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.TextStyle;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.event.EventTarget;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import javafx.util.Callback;

public class MonthViewSkin
extends DateControlSkin<MonthView>
implements LoadDataSettingsProvider {
    private static final String DAY_OF_WEEK_LABEL = "day-of-week-label";
    private static final String DAY_OF_WEEKEND_LABEL = "day-of-weekend-label";
    private final GridPane gridPane;
    private final Map<LocalDate, MonthDayView> controlsMap = new HashMap<LocalDate, MonthDayView>();
    private final DataLoader dataLoader;
    private YearMonth displayedYearMonth;
    private final PseudoClass selectedClass = PseudoClass.getPseudoClass((String)"selected");
    private final List<Map<Object, Integer>> positionMaps = new ArrayList<Map<Object, Integer>>();
    private int[][] numberOfFullDayEntries;

    public MonthViewSkin(MonthView view) {
        super(view);
        this.gridPane = new GridPane();
        this.gridPane.setAlignment(Pos.CENTER);
        this.gridPane.setMinSize(0.0, 0.0);
        this.gridPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        ColumnConstraints colCon = new ColumnConstraints();
        colCon.setPercentWidth(14.285714285714286);
        this.gridPane.getColumnConstraints().add((Object)colCon);
        this.gridPane.getColumnConstraints().add((Object)colCon);
        this.gridPane.getColumnConstraints().add((Object)colCon);
        this.gridPane.getColumnConstraints().add((Object)colCon);
        this.gridPane.getColumnConstraints().add((Object)colCon);
        this.gridPane.getColumnConstraints().add((Object)colCon);
        this.gridPane.getColumnConstraints().add((Object)colCon);
        RowConstraints rowHeaderCon = new RowConstraints();
        rowHeaderCon.setMinHeight(Double.NEGATIVE_INFINITY);
        this.gridPane.getRowConstraints().add((Object)rowHeaderCon);
        for (int i = 0; i < 6; ++i) {
            RowConstraints rowCon = new RowConstraints();
            this.gridPane.getRowConstraints().add((Object)rowCon);
        }
        this.gridPane.getStyleClass().add((Object)"container");
        ChangeListener updateViewListener = (obs, oldV, newV) -> {
            System.out.println("property: " + obs.toString());
            this.updateView();
        };
        view.yearMonthProperty().addListener(it -> {
            if (this.displayedYearMonth == null || !this.displayedYearMonth.equals(view.getYearMonth())) {
                this.updateView();
            }
        });
        view.todayProperty().addListener(updateViewListener);
        view.showWeekNumbersProperty().addListener(updateViewListener);
        view.showWeekendsProperty().addListener(updateViewListener);
        view.showWeekdaysProperty().addListener(updateViewListener);
        view.showTodayProperty().addListener(updateViewListener);
        view.showCurrentWeekProperty().addListener(updateViewListener);
        view.weekFieldsProperty().addListener(updateViewListener);
        view.showTimedEntriesProperty().addListener(updateViewListener);
        view.showFullDayEntriesProperty().addListener(updateViewListener);
        view.enableHyperlinksProperty().addListener(updateViewListener);
        this.dataLoader = new DataLoader(this);
        this.updateView();
        view.getSelections().addListener(it -> this.updateSelection());
        this.getChildren().add((Object)this.gridPane);
        view.getSelectedDates().addListener(observable -> this.updateDaySelection());
        view.getCalendars().addListener(obs -> this.updateEntries("list of calendars changed"));
        view.suspendUpdatesProperty().addListener(it -> this.updateEntries("suspend updates set to false"));
    }

    @Override
    protected void calendarVisibilityChanged() {
        this.updateEntries("calendar visibility changed");
    }

    @Override
    protected void refreshData() {
        this.updateView();
    }

    @Override
    protected void zoneIdChanged() {
        this.updateEntries("time zone changed");
    }

    @Override
    protected void calendarChanged(Calendar calendar) {
        this.updateEntries("changes in calendar " + calendar.getName());
    }

    @Override
    protected void entryCalendarChanged(CalendarEvent evt) {
        if (evt.isEntryAdded()) {
            this.updateEntries("entry added");
        } else if (evt.isEntryRemoved()) {
            this.updateEntries("entry removed");
        }
    }

    @Override
    protected void entryFullDayChanged(CalendarEvent evt) {
    }

    @Override
    protected void entryRecurrenceRuleChanged(CalendarEvent evt) {
        this.updateEntries("recurrence rule changed");
    }

    @Override
    protected void entryIntervalChanged(CalendarEvent evt) {
        Entry<?> entry = evt.getEntry();
        if (this.isRelevant(evt.getOldInterval()) || this.isRelevant(entry)) {
            this.updateEntries("entry interval changed");
        }
    }

    private void updateDaySelection() {
        for (MonthDayView view : this.controlsMap.values()) {
            view.pseudoClassStateChanged(this.selectedClass, false);
        }
        for (LocalDate date : ((MonthView)this.getSkinnable()).getSelectedDates()) {
            MonthDayView view = this.controlsMap.get(date);
            if (view == null) continue;
            view.pseudoClassStateChanged(this.selectedClass, true);
        }
    }

    private void updateSelection() {
        Set selectedKeys = ((MonthView)this.getSkinnable()).getSelections().stream().map(Entry::getId).collect(Collectors.toSet());
        for (MonthDayView view : this.controlsMap.values()) {
            MonthDayEntriesPane entriesPane = view.getEntriesPane();
            for (Node node : entriesPane.getChildren()) {
                MonthEntryView entryView;
                Entry<?> entry;
                if (!(node instanceof MonthEntryView) || (entry = (entryView = (MonthEntryView)node).getEntry()) == null) continue;
                String entryId = entryView.getEntry().getId();
                entryView.getProperties().put((Object)"selected", (Object)selectedKeys.contains(entryId));
            }
        }
    }

    private void updateView() {
        this.controlsMap.clear();
        MonthView view = (MonthView)this.getSkinnable();
        this.gridPane.getChildren().clear();
        this.displayedYearMonth = view.getYearMonth();
        WeekFields weekFields = view.getWeekFields();
        DayOfWeek dayOfWeek = weekFields.getFirstDayOfWeek();
        if (view.isShowWeekdays()) {
            for (int i = 0; i < 7; ++i) {
                Label dayOfWeekLabel = new Label(dayOfWeek.getDisplayName(TextStyle.SHORT_STANDALONE, Locale.getDefault()));
                dayOfWeekLabel.setAlignment(Pos.CENTER_RIGHT);
                dayOfWeekLabel.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
                dayOfWeekLabel.getStyleClass().add((Object)DAY_OF_WEEK_LABEL);
                if (view.isShowWeekends() && view.getWeekendDays().contains((Object)dayOfWeek)) {
                    dayOfWeekLabel.getStyleClass().add((Object)DAY_OF_WEEKEND_LABEL);
                }
                GridPane.setHgrow((Node)dayOfWeekLabel, (Priority)Priority.ALWAYS);
                this.gridPane.add((Node)dayOfWeekLabel, i, 0);
                dayOfWeek = dayOfWeek.plus(1L);
            }
        }
        LocalDate date = view.getDate().with(TemporalAdjusters.firstDayOfMonth());
        date = Util.adjustToFirstDayOfWeek(date, ((MonthView)this.getSkinnable()).getFirstDayOfWeek());
        boolean firstWeek = false;
        int lastWeek = 5;
        boolean firstDay = false;
        int lastDay = 6;
        for (int week = 0; week <= 5; ++week) {
            for (int day = 0; day <= 6; ++day) {
                MonthDayView dayOfMonthLabel = new MonthDayView(date, week, day);
                if (week == 0) {
                    dayOfMonthLabel.getStyleClass().add((Object)"first-week");
                } else if (week == 5) {
                    dayOfMonthLabel.getStyleClass().add((Object)"last-week");
                } else {
                    dayOfMonthLabel.getStyleClass().add((Object)"middle-week");
                }
                if (day == 0) {
                    dayOfMonthLabel.getStyleClass().add((Object)"first-day");
                } else if (day == 6) {
                    dayOfMonthLabel.getStyleClass().add((Object)"last-day");
                } else {
                    dayOfMonthLabel.getStyleClass().add((Object)"middle-day");
                }
                this.controlsMap.put(date, dayOfMonthLabel);
                GridPane.setHgrow((Node)dayOfMonthLabel, (Priority)Priority.ALWAYS);
                GridPane.setVgrow((Node)dayOfMonthLabel, (Priority)Priority.ALWAYS);
                this.gridPane.add((Node)dayOfMonthLabel, day, week + 1);
                date = date.plusDays(1L);
            }
        }
        this.updateDaySelection();
        this.updateEntries("view was updated after a view property change");
    }

    private void updateEntries(String reason) {
        List entries;
        int day;
        int week;
        if (((MonthView)this.getSkinnable()).isSuspendUpdates()) {
            return;
        }
        HashMap dataMap = new HashMap();
        this.dataLoader.loadEntries(dataMap);
        this.positionMaps.clear();
        LocalDate date = this.getLoadStartDate();
        int numberOfWeeks = 6;
        int numberOfDays = 7;
        this.numberOfFullDayEntries = new int[numberOfWeeks][numberOfDays];
        for (week = 0; week < numberOfWeeks; ++week) {
            int w = week;
            for (day = 0; day < numberOfDays; ++day) {
                int d = day;
                entries = (List)dataMap.get(date);
                if (entries != null) {
                    entries.forEach(entry -> {
                        if (entry.isFullDay() || entry.isMultiDay()) {
                            int[] nArray = this.numberOfFullDayEntries[w];
                            int n = d;
                            nArray[n] = nArray[n] + 1;
                        }
                    });
                }
                date = date.plusDays(1L);
            }
        }
        date = this.getLoadStartDate();
        for (week = 0; week < numberOfWeeks; ++week) {
            HashMap keyPositionMap = new HashMap();
            this.positionMaps.add(keyPositionMap);
            for (day = 0; day < numberOfDays; ++day) {
                List entries2 = (List)dataMap.get(date);
                if (entries2 != null) {
                    entries2.forEach(entry -> {
                        String entryId;
                        if ((entry.isFullDay() || entry.isMultiDay()) && keyPositionMap.get(entryId = entry.getId()) == null) {
                            int position = 0;
                            for (Entry otherEntry : entries2) {
                                int otherPosition;
                                String otherEntryId;
                                if (!otherEntry.isFullDay() && !otherEntry.isMultiDay() || (otherEntryId = otherEntry.getId()).equals(entryId) || keyPositionMap.get(otherEntryId) == null || (otherPosition = ((Integer)keyPositionMap.get(otherEntryId)).intValue()) != position) continue;
                                position = otherPosition + 1;
                            }
                            keyPositionMap.put(entryId, position);
                        }
                    });
                }
                date = date.plusDays(1L);
            }
        }
        for (MonthDayView view : this.controlsMap.values()) {
            MonthDayEntriesPane entriesPane = view.getEntriesPane();
            entriesPane.getEntries().clear();
        }
        for (LocalDate localDate : dataMap.keySet()) {
            if (!this.controlsMap.containsKey(localDate)) continue;
            MonthDayView view = this.controlsMap.get(localDate);
            MonthDayEntriesPane entriesPane = view.getEntriesPane();
            entries = (List)dataMap.get(localDate);
            if (entries == null) continue;
            if (!((MonthView)this.getSkinnable()).isShowFullDayEntries()) {
                entries.removeIf(Entry::isFullDay);
            }
            if (!((MonthView)this.getSkinnable()).isShowTimedEntries()) {
                entries.removeIf(entry -> !entry.isFullDay());
            }
            Collections.sort(entries);
            entriesPane.getEntries().setAll((Collection)entries);
        }
        LoggingDomain.VIEW.fine("updated entries in month view " + ((MonthView)this.getSkinnable()).getYearMonth() + ": reason = " + reason);
    }

    @Override
    public String getLoaderName() {
        return "Month View";
    }

    @Override
    public LocalDate getLoadStartDate() {
        return Util.adjustToFirstDayOfWeek(((MonthView)this.getSkinnable()).getDate().withDayOfMonth(1), ((MonthView)this.getSkinnable()).getFirstDayOfWeek());
    }

    @Override
    public LocalDate getLoadEndDate() {
        return this.getLoadStartDate().plusDays(41L);
    }

    @Override
    public ZoneId getZoneId() {
        return ((MonthView)this.getSkinnable()).getZoneId();
    }

    @Override
    public List<CalendarSource> getCalendarSources() {
        return ((MonthView)this.getSkinnable()).getCalendarSources();
    }

    @Override
    public Control getControl() {
        return this.getSkinnable();
    }

    @Override
    public boolean isCalendarVisible(Calendar calendar) {
        return ((MonthView)this.getSkinnable()).isCalendarVisible(calendar);
    }

    public ZonedDateTime getZonedDateTimeAt(double x, double y, ZoneId zoneId) {
        Point2D location = ((MonthView)this.getSkinnable()).localToScreen(x, y);
        for (MonthDayView view : this.controlsMap.values()) {
            if (!view.localToScreen(view.getLayoutBounds()).contains(location)) continue;
            return ZonedDateTime.of(view.getDate(), LocalTime.NOON, zoneId);
        }
        return null;
    }

    class MonthDayView
    extends VBox {
        private static final String LAST_DAY_OF_WEEK = "last-day-of-week";
        private static final String FIRST_DAY_OF_WEEK = "first-day-of-week";
        private static final String MONTH_DAY = "day";
        private static final String MONTH_DAY_HEADER = "header";
        private static final String MONTH_DAY_ENTRIES_PANE = "entries-pane";
        private static final String MONTH_DAY_TODAY = "today";
        private static final String MONTH_DAY_CURRENT_WEEK = "current-week";
        private static final String WEEKEND_DAY = "weekend-day";
        private static final String DAY_NOT_OF_MONTH_LABEL = "day-not-of-month-label";
        private static final String DAY_OF_MONTH_LABEL = "day-of-month-label";
        private static final String TODAY_LABEL = "today-label";
        private static final String WEEK_OF_YEAR_LABEL = "week-of-year-label";
        private static final String CURRENT_WEEK_OF_YEAR_LABEL = "current-week-of-year-label";
        private final MonthDayEntriesPane entriesPane;
        private final LocalDate date;

        MonthDayView(LocalDate date, int week, int day) {
            this.date = date;
            this.getStyleClass().add((Object)MONTH_DAY);
            this.setFillWidth(true);
            if (day == 0) {
                this.getStyleClass().add((Object)FIRST_DAY_OF_WEEK);
            } else if (day == 6) {
                this.getStyleClass().add((Object)LAST_DAY_OF_WEEK);
            }
            Label dateLabel = new Label();
            dateLabel.setMaxWidth(Double.MAX_VALUE);
            if (((MonthView)MonthViewSkin.this.getSkinnable()).isEnableHyperlinks()) {
                dateLabel.setOnMouseClicked(evt -> {
                    if (evt.getButton() == MouseButton.PRIMARY && evt.getClickCount() == 1) {
                        this.fireEvent(new RequestEvent((Object)MonthViewSkin.this.getSkinnable(), (EventTarget)MonthViewSkin.this.getSkinnable(), date));
                    }
                });
                dateLabel.getStyleClass().add((Object)"date-hyperlink");
            }
            WeekFields weekFields = ((MonthView)MonthViewSkin.this.getSkinnable()).getWeekFields();
            LocalDate firstDay = Util.adjustToFirstDayOfWeek(date, ((MonthView)MonthViewSkin.this.getSkinnable()).getFirstDayOfWeek());
            int weekOfYear = firstDay.get(weekFields.weekOfYear());
            Year year = Year.of(Util.adjustToFirstDayOfWeek(date, ((MonthView)MonthViewSkin.this.getSkinnable()).getFirstDayOfWeek()).getYear());
            Label weekLabel = new Label(Integer.toString(weekOfYear));
            weekLabel.setVisible(firstDay.equals(date));
            if (((MonthView)MonthViewSkin.this.getSkinnable()).isEnableHyperlinks()) {
                weekLabel.getStyleClass().add((Object)"date-hyperlink");
                weekLabel.setOnMouseClicked(evt -> {
                    if (evt.getClickCount() == 1) {
                        ((MonthView)MonthViewSkin.this.getSkinnable()).fireEvent(new RequestEvent(MonthViewSkin.this.getSkinnable(), (EventTarget)MonthViewSkin.this.getSkinnable(), year, weekOfYear));
                    }
                });
            }
            MonthView monthView = (MonthView)MonthViewSkin.this.getSkinnable();
            if (((MonthView)MonthViewSkin.this.getSkinnable()).isShowCurrentWeek() && date.getYear() == monthView.getToday().getYear() && weekOfYear == monthView.getToday().get(weekFields.weekOfYear())) {
                dateLabel.setText(DateTimeFormatter.ofPattern(Messages.getString("MonthViewSkin.TODAY_DATE_FORMAT")).format(date));
                weekLabel.getStyleClass().add((Object)CURRENT_WEEK_OF_YEAR_LABEL);
                this.getStyleClass().add((Object)MONTH_DAY_CURRENT_WEEK);
            } else {
                dateLabel.setText(Integer.toString(date.getDayOfMonth()));
                weekLabel.getStyleClass().add((Object)WEEK_OF_YEAR_LABEL);
            }
            if (YearMonth.from(date).equals(monthView.getYearMonth())) {
                dateLabel.getStyleClass().add((Object)DAY_OF_MONTH_LABEL);
                if (date.equals(monthView.getToday()) && monthView.isShowToday()) {
                    dateLabel.getStyleClass().add((Object)TODAY_LABEL);
                    this.getStyleClass().add((Object)MONTH_DAY_TODAY);
                }
            } else {
                dateLabel.getStyleClass().add((Object)DAY_NOT_OF_MONTH_LABEL);
            }
            DayOfWeek dayOfWeek = date.getDayOfWeek();
            if (monthView.isShowWeekends() && monthView.getWeekendDays().contains((Object)dayOfWeek)) {
                this.getStyleClass().add((Object)WEEKEND_DAY);
                dateLabel.getStyleClass().add((Object)WEEKEND_DAY);
            }
            this.getStyleClass().add((Object)dayOfWeek.toString().toLowerCase());
            BorderPane headerPane = new BorderPane();
            headerPane.getStyleClass().add((Object)MONTH_DAY_HEADER);
            if (monthView.isShowWeekNumbers()) {
                headerPane.setLeft((Node)weekLabel);
            }
            headerPane.setRight((Node)dateLabel);
            VBox.setVgrow((Node)headerPane, (Priority)Priority.NEVER);
            this.getChildren().add((Object)headerPane);
            this.entriesPane = new MonthDayEntriesPane(date, week, day);
            this.entriesPane.getStyleClass().add((Object)MONTH_DAY_ENTRIES_PANE);
            VBox.setVgrow((Node)this.entriesPane, (Priority)Priority.ALWAYS);
            this.getChildren().add((Object)this.entriesPane);
            this.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
            this.setPrefSize(50.0, 50.0);
            this.addEventHandler(MouseEvent.MOUSE_CLICKED, evt -> {
                if (evt.getClickCount() == 1 && evt.getButton() == MouseButton.PRIMARY) {
                    monthView.getSelections().clear();
                    boolean wasSelected = monthView.getSelectedDates().contains((Object)date);
                    if (!evt.isShiftDown() && !evt.isControlDown()) {
                        monthView.getSelectedDates().clear();
                    }
                    if (!wasSelected && !((MonthView)MonthViewSkin.this.getSkinnable()).getSelectedDates().contains((Object)date)) {
                        monthView.getSelectedDates().add((Object)date);
                    }
                }
            });
        }

        final MonthDayEntriesPane getEntriesPane() {
            return this.entriesPane;
        }

        final LocalDate getDate() {
            return this.date;
        }
    }

    class MonthDayEntriesPane
    extends Pane {
        private static final String MONTH_DAY_MORE_LABEL = "more-label";
        private static final String SPACE = " ";
        private final Label moreLabel;
        private final LocalDate date;
        private final int week;
        private final int day;
        private final ObservableList<Entry<?>> entries = FXCollections.observableArrayList();

        MonthDayEntriesPane(LocalDate date, int week, int day) {
            this.getStyleClass().add((Object)"entries-pane");
            this.date = date;
            this.week = week;
            this.day = day;
            this.entries.addListener(evt -> Platform.runLater(() -> this.update()));
            this.setMinSize(0.0, 0.0);
            this.setPrefSize(0.0, 0.0);
            Rectangle clip = new Rectangle();
            clip.widthProperty().bind((ObservableValue)this.widthProperty());
            clip.heightProperty().bind((ObservableValue)this.heightProperty());
            this.setClip((Node)clip);
            this.moreLabel = new Label();
            this.moreLabel.getStyleClass().add((Object)MONTH_DAY_MORE_LABEL);
            this.moreLabel.setManaged(false);
            this.moreLabel.setVisible(false);
            if (((MonthView)MonthViewSkin.this.getSkinnable()).isEnableHyperlinks()) {
                this.moreLabel.getStyleClass().add((Object)"date-hyperlink");
                this.moreLabel.setOnMouseClicked(evt -> this.fireEvent(new RequestEvent((Object)this, (EventTarget)this, date)));
            }
            this.getChildren().add((Object)this.moreLabel);
        }

        public final ObservableList<Entry<?>> getEntries() {
            return this.entries;
        }

        private void update() {
            Util.removeChildren(this, node -> node instanceof MonthEntryView);
            if (!this.entries.isEmpty()) {
                ArrayList<Entry> otherEntries = new ArrayList<Entry>();
                Map<Object, Integer> positionMap = Objects.requireNonNull(MonthViewSkin.this.positionMaps.get(this.week), "missing position map for week number " + this.week);
                int maxPosition = -1;
                for (Entry entry : this.entries) {
                    Objects.requireNonNull(entry, "found NULL calendar entry in entry list");
                    if (entry.isFullDay() || entry.isMultiDay()) {
                        int position = positionMap.get(Objects.requireNonNull(entry.getId(), "entry ID is missing, entry type = " + entry.getClass().getName() + ", entry title = " + entry.getTitle()));
                        maxPosition = Math.max(maxPosition, position);
                        continue;
                    }
                    otherEntries.add(entry);
                }
                if (maxPosition > -1) {
                    Node[] fullDayNodes = new Node[maxPosition + 1];
                    for (int i = 0; i < maxPosition; ++i) {
                        MonthEntryView label = new MonthEntryView(new Entry(SPACE));
                        label.setVisible(false);
                        label.getProperties().put((Object)"control", (Object)MonthViewSkin.this.getSkinnable());
                        fullDayNodes[i] = label;
                    }
                    for (Entry entry : this.entries) {
                        if (!entry.isFullDay() && !entry.isMultiDay()) continue;
                        int position = positionMap.get(entry.getId());
                        fullDayNodes[position] = this.createNode(entry);
                    }
                    for (Node node2 : fullDayNodes) {
                        this.getChildren().add((Object)node2);
                    }
                }
                Collections.sort(otherEntries);
                for (Entry entry : otherEntries) {
                    this.getChildren().add((Object)this.createNode(entry));
                }
            }
        }

        private Node createNode(Entry<?> entry) {
            Callback<Entry<?>, MonthEntryView> factory = ((MonthView)MonthViewSkin.this.getSkinnable()).getEntryViewFactory();
            MonthEntryView view = (MonthEntryView)factory.call(entry);
            view.getProperties().put((Object)"control", (Object)MonthViewSkin.this.getSkinnable());
            view.getProperties().put((Object)"startDate", (Object)this.date);
            view.getProperties().put((Object)"endDate", (Object)this.date);
            EntryViewBase.Position position = EntryViewBase.Position.ONLY;
            if (entry.isFullDay()) {
                if (this.date.isBefore(entry.getEndDate()) && (this.day == 0 || this.date.equals(entry.getStartDate()))) {
                    position = EntryViewBase.Position.FIRST;
                } else if (entry.isMultiDay() && this.date.equals(entry.getEndDate())) {
                    position = EntryViewBase.Position.LAST;
                } else if (entry.isMultiDay()) {
                    position = EntryViewBase.Position.MIDDLE;
                }
            } else if (entry.isMultiDay()) {
                position = this.day == 0 || this.date.equals(entry.getStartDate()) && this.date.isBefore(entry.getEndDate()) ? EntryViewBase.Position.FIRST : (this.date.equals(entry.getEndDate()) ? EntryViewBase.Position.LAST : EntryViewBase.Position.MIDDLE);
            }
            view.getProperties().put((Object)"position", (Object)position);
            return view;
        }

        protected void layoutChildren() {
            Insets insets = this.getInsets();
            double w = this.getWidth();
            double h = this.getHeight();
            double y = insets.getTop();
            this.moreLabel.setVisible(false);
            ObservableList children = this.getChildren();
            boolean conflictFound = false;
            int childrenAdded = 0;
            for (int i = 0; i < children.size(); ++i) {
                Node child = (Node)children.get(i);
                if (child == this.moreLabel) continue;
                double ph = child.prefHeight(-1.0);
                if (y + ph < h - insets.getTop() - insets.getBottom()) {
                    child.resizeRelocate(this.snapPositionX(insets.getLeft()), this.snapPositionY(y), this.snapSizeX(w - insets.getRight() - insets.getLeft()), this.snapSizeY(ph));
                    y += ph + 1.0;
                    child.getProperties().put((Object)"hidden", (Object)false);
                    ++childrenAdded;
                    continue;
                }
                if (!conflictFound && i > 0) {
                    conflictFound = true;
                    ((Node)children.get(i - 1)).getProperties().put((Object)"hidden", (Object)true);
                }
                child.getProperties().put((Object)"hidden", (Object)true);
            }
            if (conflictFound) {
                this.moreLabel.setVisible(true);
                this.moreLabel.setText(MessageFormat.format(Messages.getString("MonthViewSkin.MORE_ENTRIES"), childrenAdded == 0 ? children.size() - 1 : children.size() - childrenAdded));
                double ph = this.moreLabel.prefHeight(-1.0);
                this.moreLabel.resizeRelocate(this.snapPositionX(insets.getLeft()), this.snapPositionY(h - insets.getTop() - insets.getBottom() - ph), this.snapSizeX(w - insets.getRight() - insets.getLeft()), this.snapSizeY(ph));
            }
        }
    }
}

