/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.util.LoggingDomain;
import com.calendarfx.view.Messages;
import com.calendarfx.view.RecurrenceView;
import impl.com.calendarfx.view.util.Util;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.FormatStyle;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.logging.Level;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.util.StringConverter;
import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.model.WeekDay;
import net.fortuna.ical4j.model.WeekDayList;

public class RecurrenceViewSkin
extends SkinBase<RecurrenceView> {
    private final ComboBox<Frequency> frequencyBox = new ComboBox();
    private final Spinner<Integer> repeatCountSpinner = new Spinner();
    private final Label repeatCountGranularity = new Label();
    private final Label startOnDateLabel = new Label();
    private final RadioButton endsNeverButton = new RadioButton(Messages.getString("RecurrenceViewSkin.NEVER"));
    private final RadioButton endsAfterButton = new RadioButton(Messages.getString("RecurrenceViewSkin.AFTER"));
    private final Spinner<Integer> endsAfterCounterSpinner = new Spinner();
    private final Label endsAfterOccurencesLabel = new Label(Messages.getString("RecurrenceViewSkin.OCCURENCES"));
    private final RadioButton endsOnButton = new RadioButton(Messages.getString("RecurrenceViewSkin.ON"));
    private final DatePicker endsOnDatePicker = new DatePicker(LocalDate.now());
    private Label summaryLabel = new Label();
    private final RadioButton repeatByDayOfTheMonth = new RadioButton(Messages.getString("RecurrenceViewSkin.DAY_OF_MONTH"));
    private final RadioButton repeatByDayOfTheWeek = new RadioButton(Messages.getString("RecurrenceViewSkin.DAY_OF_WEEK"));
    private final ToggleButton weekDayMondayButton = new ToggleButton(Messages.getString("RecurrenceViewSkin.SHORT_MONDAY"));
    private final ToggleButton weekDayTuesdayButton = new ToggleButton(Messages.getString("RecurrenceViewSkin.SHORT_TUESDAY"));
    private final ToggleButton weekDayWednesdayButton = new ToggleButton(Messages.getString("RecurrenceViewSkin.SHORT_WEDNESDAY"));
    private final ToggleButton weekDayThursdayButton = new ToggleButton(Messages.getString("RecurrenceViewSkin.SHORT_THURSDAY"));
    private final ToggleButton weekDayFridayButton = new ToggleButton(Messages.getString("RecurrenceViewSkin.SHORT_FRIDAY"));
    private final ToggleButton weekDaySaturdayButton = new ToggleButton(Messages.getString("RecurrenceViewSkin.SHORT_SATURDAY"));
    private final ToggleButton weekDaySundayButton = new ToggleButton(Messages.getString("RecurrenceViewSkin.SHORT_SUNDAY"));
    private final HBox weekdayBox;
    private final HBox repeatByBox;
    private final HBox repeatCountBox;
    private final Label labelRepeatOn;
    private final Label summary = new Label();
    private final Label labelRepeatBy;
    private final Label frequencyLabel;
    private final Label repeatCountLabel;
    private final Label startsOnLabel;
    private final Label endsOnLabel;
    private final HBox endsAfterBox;
    private final HBox endsOnBox;
    private final GridPane grid;
    private final SpinnerValueFactory.IntegerSpinnerValueFactory repeatCountSpinnerValueFactory;
    private final SpinnerValueFactory.IntegerSpinnerValueFactory endsAfterCounterSpinnerValueFactory;

    public RecurrenceViewSkin(RecurrenceView view) {
        super((Control)view);
        this.summary.setMaxWidth(250.0);
        this.summary.setWrapText(true);
        this.frequencyBox.getItems().setAll((Object[])Frequency.values());
        this.frequencyBox.setValue((Object)Frequency.DAILY);
        this.frequencyBox.setConverter((StringConverter)new StringConverter<Frequency>(){

            public String toString(Frequency frequency) {
                switch (frequency) {
                    case DAILY: {
                        return Messages.getString("RecurrenceViewSkin.DAILY");
                    }
                    case MONTHLY: {
                        return Messages.getString("RecurrenceViewSkin.MONTHLY");
                    }
                    case WEEKLY: {
                        return Messages.getString("RecurrenceViewSkin.WEEKLY");
                    }
                    case YEARLY: {
                        return Messages.getString("RecurrenceViewSkin.YEARLY");
                    }
                }
                return "";
            }

            public Frequency fromString(String txt) {
                return null;
            }
        });
        this.repeatCountSpinnerValueFactory = new SpinnerValueFactory.IntegerSpinnerValueFactory(1, 100);
        this.repeatCountSpinner.setValueFactory((SpinnerValueFactory)this.repeatCountSpinnerValueFactory);
        this.repeatCountSpinner.setEditable(true);
        this.repeatCountSpinner.getEditor().setPrefColumnCount(5);
        this.endsAfterCounterSpinnerValueFactory = new SpinnerValueFactory.IntegerSpinnerValueFactory(1, 1000);
        this.endsAfterCounterSpinner.setValueFactory((SpinnerValueFactory)this.endsAfterCounterSpinnerValueFactory);
        this.endsAfterCounterSpinner.setEditable(true);
        this.endsAfterCounterSpinner.getEditor().setPrefColumnCount(5);
        this.endsAfterCounterSpinner.disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)this.endsAfterButton.selectedProperty()));
        this.endsAfterOccurencesLabel.disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)this.endsAfterButton.selectedProperty()));
        this.endsOnDatePicker.disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)this.endsOnButton.selectedProperty()));
        this.endsOnDatePicker.getEditor().setPrefColumnCount(14);
        ToggleGroup endsByGroup = new ToggleGroup();
        endsByGroup.getToggles().setAll((Object[])new Toggle[]{this.endsAfterButton, this.endsNeverButton, this.endsOnButton});
        ToggleGroup repeatByGroup = new ToggleGroup();
        repeatByGroup.getToggles().setAll((Object[])new Toggle[]{this.repeatByDayOfTheMonth, this.repeatByDayOfTheWeek});
        ToggleGroup endsGroup = new ToggleGroup();
        endsGroup.getToggles().setAll((Object[])new Toggle[]{this.endsOnButton, this.endsAfterButton, this.endsNeverButton});
        this.repeatCountBox = new HBox();
        this.repeatCountBox.getStyleClass().add((Object)"repeat-count-box");
        this.repeatCountBox.getChildren().setAll((Object[])new Node[]{this.repeatCountSpinner, this.repeatCountGranularity});
        this.weekdayBox = new HBox();
        this.weekdayBox.getStyleClass().add((Object)"weekday-box");
        this.weekdayBox.getChildren().setAll((Object[])new Node[]{this.weekDayMondayButton, this.weekDayTuesdayButton, this.weekDayWednesdayButton, this.weekDayThursdayButton, this.weekDayFridayButton, this.weekDaySaturdayButton, this.weekDaySundayButton});
        this.repeatByBox = new HBox();
        this.repeatByBox.getStyleClass().add((Object)"repeat-by-box");
        this.repeatByBox.getChildren().setAll((Object[])new Node[]{this.repeatByDayOfTheMonth, this.repeatByDayOfTheWeek});
        this.endsAfterBox = new HBox();
        this.endsAfterBox.getStyleClass().add((Object)"ends-after-box");
        this.endsAfterBox.getChildren().setAll((Object[])new Node[]{this.endsAfterButton, this.endsAfterCounterSpinner, this.endsAfterOccurencesLabel});
        this.endsOnBox = new HBox();
        this.endsOnBox.getStyleClass().add((Object)"ends-on-box");
        this.endsOnBox.getChildren().setAll((Object[])new Node[]{this.endsOnButton, this.endsOnDatePicker});
        this.grid = new GridPane();
        this.grid.getStyleClass().add((Object)"container");
        ColumnConstraints labelsColumn = new ColumnConstraints();
        ColumnConstraints fieldsColumn = new ColumnConstraints();
        labelsColumn.setHalignment(HPos.RIGHT);
        labelsColumn.setPrefWidth(-1.0);
        this.grid.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{labelsColumn, fieldsColumn});
        this.frequencyLabel = new Label(Messages.getString("RecurrenceViewSkin.FREQUENCY"));
        this.repeatCountLabel = new Label(Messages.getString("RecurrenceViewSkin.REPEAT_EVERY"));
        this.labelRepeatOn = new Label(Messages.getString("RecurrenceViewSkin.REPEAT_ON"));
        this.labelRepeatBy = new Label(Messages.getString("RecurrenceViewSkin.REPEAT_BY"));
        this.startsOnLabel = new Label(Messages.getString("RecurrenceViewSkin.STARTS_ON"));
        this.endsOnLabel = new Label(Messages.getString("RecurrenceViewSkin.ENDS"));
        this.summaryLabel = new Label(Messages.getString("RecurrenceViewSkin.SUMMARY"));
        this.grid.add((Node)this.frequencyLabel, 0, 0);
        this.grid.add(this.frequencyBox, 1, 0);
        this.grid.add((Node)this.repeatCountLabel, 0, 1);
        this.grid.add((Node)this.repeatCountBox, 1, 1);
        this.buildGrid();
        this.frequencyBox.setMaxWidth(Double.MAX_VALUE);
        GridPane.setFillWidth(this.frequencyBox, (Boolean)true);
        this.getChildren().add((Object)this.grid);
        InvalidationListener updateListener = it -> this.updateRule();
        this.frequencyBox.valueProperty().addListener(updateListener);
        this.frequencyBox.valueProperty().addListener(it -> this.buildGrid());
        this.repeatCountSpinner.valueProperty().addListener(updateListener);
        this.weekDayMondayButton.selectedProperty().addListener(updateListener);
        this.weekDayTuesdayButton.selectedProperty().addListener(updateListener);
        this.weekDayWednesdayButton.selectedProperty().addListener(updateListener);
        this.weekDayThursdayButton.selectedProperty().addListener(updateListener);
        this.weekDayFridayButton.selectedProperty().addListener(updateListener);
        this.weekDaySaturdayButton.selectedProperty().addListener(updateListener);
        this.weekDaySundayButton.selectedProperty().addListener(updateListener);
        this.repeatByDayOfTheMonth.selectedProperty().addListener(updateListener);
        this.repeatByDayOfTheWeek.selectedProperty().addListener(updateListener);
        this.endsNeverButton.selectedProperty().addListener(updateListener);
        this.endsAfterButton.selectedProperty().addListener(updateListener);
        this.endsAfterCounterSpinner.valueProperty().addListener(updateListener);
        this.endsOnButton.selectedProperty().addListener(updateListener);
        this.endsOnDatePicker.valueProperty().addListener(updateListener);
        ((RecurrenceView)this.getSkinnable()).showSummaryProperty().addListener(it -> this.buildGrid());
        view.recurrenceRuleProperty().addListener(it -> this.updateView());
        this.updateView();
    }

    private void buildGrid() {
        this.grid.getChildren().removeIf(node -> node != this.frequencyLabel && node != this.frequencyBox && node != this.repeatCountLabel && node != this.repeatCountBox);
        int row = 2;
        if (((Frequency)((Object)this.frequencyBox.getValue())).equals((Object)Frequency.WEEKLY)) {
            this.grid.add((Node)this.labelRepeatOn, 0, row);
            this.grid.add((Node)this.weekdayBox, 1, row);
            ++row;
        }
        if (((Frequency)((Object)this.frequencyBox.getValue())).equals((Object)Frequency.MONTHLY)) {
            this.grid.add((Node)this.labelRepeatBy, 0, row);
            this.grid.add((Node)this.repeatByBox, 1, row);
            ++row;
        }
        this.grid.add((Node)this.startsOnLabel, 0, row);
        this.grid.add((Node)this.startOnDateLabel, 1, row);
        this.grid.add((Node)this.endsOnLabel, 0, ++row);
        this.grid.add((Node)this.endsNeverButton, 1, row);
        this.grid.add((Node)this.endsAfterBox, 1, ++row);
        this.grid.add((Node)this.endsOnBox, 1, ++row);
        ++row;
        if (((RecurrenceView)this.getSkinnable()).isShowSummary()) {
            this.grid.add((Node)this.summaryLabel, 0, row);
            this.grid.add((Node)this.summary, 1, row);
        }
    }

    private void updateView() {
        try {
            String rule = ((RecurrenceView)this.getSkinnable()).getRecurrenceRule();
            if (rule == null) {
                return;
            }
            Recur rrule = new Recur(rule.replaceFirst("^RRULE:", ""));
            switch (rrule.getFrequency()) {
                case DAILY: {
                    this.frequencyBox.setValue((Object)Frequency.DAILY);
                    this.repeatCountGranularity.setText(Messages.getString("RecurrenceViewSkin.DAYS"));
                    break;
                }
                case WEEKLY: {
                    this.frequencyBox.setValue((Object)Frequency.WEEKLY);
                    this.repeatCountGranularity.setText(Messages.getString("RecurrenceViewSkin.32"));
                    break;
                }
                case MONTHLY: {
                    this.frequencyBox.setValue((Object)Frequency.MONTHLY);
                    this.repeatCountGranularity.setText(Messages.getString("RecurrenceViewSkin.MONTHS"));
                    break;
                }
                case YEARLY: {
                    this.frequencyBox.setValue((Object)Frequency.YEARLY);
                    this.repeatCountGranularity.setText(Messages.getString("RecurrenceViewSkin.YEARS"));
                    break;
                }
                case SECONDLY: 
                case HOURLY: 
                case MINUTELY: {
                    throw new IllegalArgumentException("unsupported frequency: " + rrule.getFrequency());
                }
                default: {
                    throw new IllegalArgumentException("unknown frequency: " + rrule.getFrequency());
                }
            }
            LocalDate until = (LocalDate)rrule.getUntil();
            if (until != null) {
                this.endsOnButton.setSelected(true);
                this.endsOnDatePicker.setValue((Object)until);
            } else if (rrule.getCount() > 0) {
                this.endsAfterButton.setSelected(true);
            } else {
                this.endsNeverButton.setSelected(true);
            }
            if (!rrule.getMonthDayList().isEmpty()) {
                this.repeatByDayOfTheMonth.setSelected(true);
            } else {
                this.repeatByDayOfTheWeek.setSelected(true);
            }
            this.repeatCountSpinnerValueFactory.setValue((Object)rrule.getInterval());
            this.endsAfterCounterSpinnerValueFactory.setValue((Object)rrule.getCount());
            List days = rrule.getDayList();
            this.weekDayMondayButton.setSelected(this.isSelected(WeekDay.Day.MO, days));
            this.weekDayTuesdayButton.setSelected(this.isSelected(WeekDay.Day.TU, days));
            this.weekDayWednesdayButton.setSelected(this.isSelected(WeekDay.Day.WE, days));
            this.weekDayThursdayButton.setSelected(this.isSelected(WeekDay.Day.TH, days));
            this.weekDayFridayButton.setSelected(this.isSelected(WeekDay.Day.FR, days));
            this.weekDaySaturdayButton.setSelected(this.isSelected(WeekDay.Day.SA, days));
            this.weekDaySundayButton.setSelected(this.isSelected(WeekDay.Day.SU, days));
            this.summary.setText(Util.convertRFC2445ToText(rule, ((RecurrenceView)this.getSkinnable()).getStartDate()));
        }
        catch (IllegalArgumentException | DateTimeParseException e) {
            e.printStackTrace();
        }
        this.startOnDateLabel.setText(DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG).format(((RecurrenceView)this.getSkinnable()).getStartDate()));
    }

    private boolean isSelected(WeekDay.Day day, List<WeekDay> days) {
        for (WeekDay num : days) {
            if (!num.getDay().equals((Object)day)) continue;
            return true;
        }
        return false;
    }

    private void updateRule() {
        Recur.Builder rBuilder = new Recur.Builder();
        switch ((Frequency)((Object)this.frequencyBox.getValue())) {
            case DAILY: {
                rBuilder.frequency(net.fortuna.ical4j.transform.recurrence.Frequency.DAILY);
                break;
            }
            case MONTHLY: {
                rBuilder.frequency(net.fortuna.ical4j.transform.recurrence.Frequency.MONTHLY);
                break;
            }
            case WEEKLY: {
                rBuilder.frequency(net.fortuna.ical4j.transform.recurrence.Frequency.WEEKLY);
                break;
            }
            case YEARLY: {
                rBuilder.frequency(net.fortuna.ical4j.transform.recurrence.Frequency.YEARLY);
                break;
            }
        }
        int interval = (Integer)this.repeatCountSpinner.getValue();
        if (interval > 1) {
            rBuilder.interval(Integer.valueOf(interval));
        } else {
            rBuilder.interval(Integer.valueOf(0));
        }
        if (this.endsOnButton.isSelected()) {
            LocalDate date = (LocalDate)this.endsOnDatePicker.getValue();
            rBuilder.until((Temporal)date);
        }
        if (this.endsAfterButton.isSelected()) {
            rBuilder.count((Integer)this.endsAfterCounterSpinner.getValue());
        }
        RecurrenceView recurrenceView = (RecurrenceView)this.getSkinnable();
        if (this.frequencyBox.getValue() == Frequency.MONTHLY) {
            if (this.repeatByDayOfTheMonth.isSelected()) {
                rBuilder.monthDayList(List.of(Integer.valueOf(recurrenceView.getStartDate().getDayOfMonth())));
            } else {
                LocalDate localDate = recurrenceView.getStartDate();
                ZonedDateTime zonedDateTime = ZonedDateTime.of(localDate, LocalTime.now(), ZoneId.systemDefault());
                int hits = 1;
                ZonedDateTime current = zonedDateTime.withDayOfMonth(1);
                do {
                    if (!current.getDayOfWeek().equals(zonedDateTime.getDayOfWeek())) continue;
                    ++hits;
                } while ((current = current.plusDays(1L)).toLocalDate().isBefore(localDate));
                WeekDayList weekdays = new WeekDayList();
                switch (zonedDateTime.getDayOfWeek()) {
                    case FRIDAY: {
                        weekdays.add((Object)new WeekDay(WeekDay.FR, hits));
                        break;
                    }
                    case MONDAY: {
                        weekdays.add((Object)new WeekDay(WeekDay.MO, hits));
                        break;
                    }
                    case SATURDAY: {
                        weekdays.add((Object)new WeekDay(WeekDay.SA, hits));
                        break;
                    }
                    case SUNDAY: {
                        weekdays.add((Object)new WeekDay(WeekDay.SU, hits));
                        break;
                    }
                    case THURSDAY: {
                        weekdays.add((Object)new WeekDay(WeekDay.TH, hits));
                        break;
                    }
                    case TUESDAY: {
                        weekdays.add((Object)new WeekDay(WeekDay.TU, hits));
                        break;
                    }
                    case WEDNESDAY: {
                        weekdays.add((Object)new WeekDay(WeekDay.WE, hits));
                        break;
                    }
                }
                rBuilder.dayList((List)weekdays);
            }
        }
        if (this.frequencyBox.getValue() == Frequency.WEEKLY) {
            WeekDayList weekdays = new WeekDayList();
            this.maybeAddWeekday(weekdays, WeekDay.MO, this.weekDayMondayButton);
            this.maybeAddWeekday(weekdays, WeekDay.TU, this.weekDayTuesdayButton);
            this.maybeAddWeekday(weekdays, WeekDay.WE, this.weekDayWednesdayButton);
            this.maybeAddWeekday(weekdays, WeekDay.TH, this.weekDayThursdayButton);
            this.maybeAddWeekday(weekdays, WeekDay.FR, this.weekDayFridayButton);
            this.maybeAddWeekday(weekdays, WeekDay.SA, this.weekDaySaturdayButton);
            this.maybeAddWeekday(weekdays, WeekDay.SU, this.weekDaySundayButton);
            rBuilder.dayList((List)weekdays);
        }
        Recur rule = rBuilder.build();
        recurrenceView.setRecurrenceRule(rule.toString());
        if (LoggingDomain.RECURRENCE.isLoggable(Level.FINE)) {
            LoggingDomain.RECURRENCE.fine("test dumping 10 recurrences starting with today's date");
            LocalDate today = LocalDate.of(2015, 8, 18);
            List dates = rule.getDates((Temporal)today, (Temporal)today, (Temporal)LocalDate.MAX, 10);
            for (LocalDate repeatingDate : dates) {
                LoggingDomain.RECURRENCE.fine(repeatingDate.toString());
            }
        }
    }

    private void maybeAddWeekday(WeekDayList weekdays, WeekDay weekdayNum, ToggleButton button) {
        if (button.isSelected()) {
            weekdays.add((Object)weekdayNum);
        }
    }

    static enum Frequency {
        DAILY,
        WEEKLY,
        MONTHLY,
        YEARLY;

    }
}

