/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.Resource;
import com.calendarfx.view.DateControl;
import com.calendarfx.view.DayView;
import com.calendarfx.view.ResourcesView;
import com.calendarfx.view.WeekView;
import impl.com.calendarfx.view.DayViewBaseSkin;
import impl.com.calendarfx.view.ResourcesViewContainer;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.util.Callback;

public class ResourcesViewContainerSkin<T extends Resource<?>>
extends DayViewBaseSkin<ResourcesViewContainer<T>> {
    private final HBox box = new HBox();
    private final ResourcesView<T> resourcesView;

    public ResourcesViewContainerSkin(ResourcesViewContainer<T> view) {
        super(view);
        this.box.getStyleClass().add((Object)"container");
        this.box.setFillHeight(true);
        this.resourcesView = view.getResourcesView();
        InvalidationListener updateViewListener = it -> this.updateView();
        this.resourcesView.getResources().addListener(updateViewListener);
        this.resourcesView.numberOfDaysProperty().addListener(updateViewListener);
        this.resourcesView.typeProperty().addListener(updateViewListener);
        this.updateView();
        this.getChildren().add((Object)this.box);
    }

    private void updateView() {
        this.box.getChildren().clear();
        ResourcesViewContainer resourcesContainer = (ResourcesViewContainer)this.getSkinnable();
        resourcesContainer.unbindAll();
        if (this.resourcesView.getType().equals((Object)ResourcesView.Type.RESOURCES_OVER_DATES)) {
            this.updateViewResourcesOverDates();
        } else {
            this.updateViewDatesOverResources();
        }
    }

    private void updateViewDatesOverResources() {
        ResourcesViewContainer resourcesViewContainer = (ResourcesViewContainer)this.getSkinnable();
        ObservableList<T> resources = this.resourcesView.getResources();
        int numberOfDays = this.resourcesView.getNumberOfDays();
        for (int dayIndex = 0; dayIndex < numberOfDays; ++dayIndex) {
            Region separator;
            Callback<ResourcesView<T>, Region> separatorFactory;
            HBox resourcesBox = new HBox();
            for (int resourceIndex = 0; resourceIndex < resources.size(); ++resourceIndex) {
                Resource resource = (Resource)resources.get(resourceIndex);
                DayView dayView = (DayView)this.resourcesView.getDayViewFactory().call((Object)resource);
                int additionalDays = dayIndex;
                dayView.dateProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> resourcesViewContainer.getDate().plusDays(additionalDays), (Observable[])new Observable[]{resourcesViewContainer.dateProperty()}));
                dayView.getStyleClass().removeAll((Object[])new String[]{"only", "first", "middle", "last"});
                if (resources.size() == 1) {
                    dayView.getStyleClass().add((Object)"only");
                } else if (resourceIndex == 0) {
                    dayView.getStyleClass().add((Object)"first");
                } else if (resourceIndex == resources.size() - 1) {
                    dayView.getStyleClass().add((Object)"last");
                } else {
                    dayView.getStyleClass().add((Object)"middle");
                }
                resourcesViewContainer.bind(dayView, false);
                Bindings.unbindBidirectional(resourcesViewContainer.defaultCalendarProviderProperty(), dayView.defaultCalendarProviderProperty());
                Bindings.unbindBidirectional(resourcesViewContainer.draggedEntryProperty(), dayView.draggedEntryProperty());
                Bindings.unbindBidirectional((Property)resourcesViewContainer.enableCurrentTimeMarkerProperty(), (Property)dayView.enableCurrentTimeMarkerProperty());
                Bindings.unbindBidirectional((Property)resourcesViewContainer.enableCurrentTimeCircleProperty(), (Property)dayView.enableCurrentTimeCircleProperty());
                Bindings.unbindBidirectional(resourcesViewContainer.availabilityCalendarProperty(), dayView.availabilityCalendarProperty());
                Bindings.unbindBidirectional(resourcesViewContainer.lassoStartProperty(), dayView.lassoStartProperty());
                Bindings.unbindBidirectional(resourcesViewContainer.lassoEndProperty(), dayView.lassoEndProperty());
                Bindings.unbindBidirectional(resourcesViewContainer.onLassoFinishedProperty(), dayView.onLassoFinishedProperty());
                Bindings.unbindContentBidirectional(resourcesViewContainer.getCalendarSources(), dayView.getCalendarSources());
                dayView.setEnableCurrentTimeMarker(true);
                dayView.setEnableCurrentTimeCircle(dayIndex == 0 && resourceIndex == 0);
                dayView.setAvailabilityCalendar(resource.getAvailabilityCalendar());
                dayView.installDefaultLassoFinishedBehaviour();
                Bindings.bindContent(dayView.getCalendarSources(), resource.getCalendarSources());
                dayView.setDefaultCalendarProvider((Callback<DateControl, Calendar>)((Callback)dateControl -> (Calendar)resource.getCalendars().get(0)));
                dayView.setPrefWidth(0.0);
                dayView.setMinHeight(0.0);
                HBox.setHgrow((Node)dayView, (Priority)Priority.ALWAYS);
                resourcesBox.getChildren().add((Object)dayView);
                if (resourceIndex >= resources.size() - 1) continue;
                Region separator2 = new Region();
                separator2.getStyleClass().add((Object)"weekday-separator");
                resourcesBox.getChildren().add((Object)separator2);
                HBox.setHgrow((Node)separator2, (Priority)Priority.NEVER);
            }
            this.box.getChildren().add((Object)resourcesBox);
            if (dayIndex < numberOfDays - 1 && (separatorFactory = this.resourcesView.getLargeSeparatorFactory()) != null && (separator = (Region)separatorFactory.call(resourcesViewContainer.getResourcesView())) != null) {
                this.box.getChildren().add((Object)separator);
                HBox.setHgrow((Node)separator, (Priority)Priority.NEVER);
            }
            HBox.setHgrow((Node)resourcesBox, (Priority)Priority.ALWAYS);
        }
    }

    private void updateViewResourcesOverDates() {
        ResourcesViewContainer container = (ResourcesViewContainer)this.getSkinnable();
        ObservableList<T> resources = this.resourcesView.getResources();
        for (int i = 0; i < resources.size(); ++i) {
            Region separator;
            Callback<ResourcesView<T>, Region> separatorFactory;
            Resource resource = (Resource)resources.get(i);
            WeekView weekView = (WeekView)this.resourcesView.getWeekViewFactory().call((Object)resource);
            weekView.getStyleClass().removeAll((Object[])new String[]{"only", "first", "middle", "last"});
            if (resources.size() == 1) {
                weekView.getStyleClass().add((Object)"only");
            } else if (i == 0) {
                weekView.getStyleClass().add((Object)"first");
            } else if (i == resources.size() - 1) {
                weekView.getStyleClass().add((Object)"last");
            } else {
                weekView.getStyleClass().add((Object)"middle");
            }
            weekView.setPrefWidth(0.0);
            container.bind(weekView, true);
            weekView.adjustToFirstDayOfWeekProperty().bind((ObservableValue)this.resourcesView.adjustToFirstDayOfWeekProperty());
            Bindings.unbindBidirectional(container.defaultCalendarProviderProperty(), weekView.defaultCalendarProviderProperty());
            Bindings.unbindBidirectional(container.draggedEntryProperty(), weekView.draggedEntryProperty());
            Bindings.unbindBidirectional((Property)container.enableCurrentTimeMarkerProperty(), (Property)weekView.enableCurrentTimeMarkerProperty());
            Bindings.unbindBidirectional((Property)container.enableCurrentTimeCircleProperty(), (Property)weekView.enableCurrentTimeCircleProperty());
            Bindings.unbindBidirectional(container.availabilityCalendarProperty(), weekView.availabilityCalendarProperty());
            Bindings.unbindBidirectional(container.lassoStartProperty(), weekView.lassoStartProperty());
            Bindings.unbindBidirectional(container.lassoEndProperty(), weekView.lassoEndProperty());
            Bindings.unbindBidirectional(container.onLassoFinishedProperty(), weekView.onLassoFinishedProperty());
            Bindings.unbindContentBidirectional(container.getCalendarSources(), weekView.getCalendarSources());
            weekView.setEnableCurrentTimeCircle(i == 0);
            weekView.setEnableCurrentTimeMarker(true);
            weekView.setAvailabilityCalendar(resource.getAvailabilityCalendar());
            weekView.installDefaultLassoFinishedBehaviour();
            weekView.numberOfDaysProperty().bindBidirectional((Property)this.resourcesView.numberOfDaysProperty());
            Bindings.bindContent(weekView.getCalendarSources(), resource.getCalendarSources());
            weekView.setDefaultCalendarProvider((Callback<DateControl, Calendar>)((Callback)dateControl -> (Calendar)resource.getCalendars().get(0)));
            this.box.getChildren().add((Object)weekView);
            if (i < resources.size() - 1 && (separatorFactory = this.resourcesView.getLargeSeparatorFactory()) != null && (separator = (Region)separatorFactory.call(container.getResourcesView())) != null) {
                this.box.getChildren().add((Object)separator);
                HBox.setHgrow((Node)separator, (Priority)Priority.NEVER);
            }
            HBox.setHgrow((Node)weekView, (Priority)Priority.ALWAYS);
        }
    }
}

