/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.view.TimeField;
import java.time.LocalTime;
import javafx.beans.InvalidationListener;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.util.StringConverter;

public class TimeFieldSkin
extends SkinBase<TimeField> {
    private final NumericTextField hourField;
    private final NumericTextField minuteField;
    private boolean updatingTextFields;
    private boolean updatingValue;

    public TimeFieldSkin(TimeField field) {
        super((Control)field);
        StringConverter<String> valueConverter = new StringConverter<String>(){

            public String fromString(String text) {
                if (text.length() == 0) {
                    return "00";
                }
                if (text.length() == 1) {
                    return "0" + text;
                }
                return text;
            }

            public String toString(String text) {
                return text;
            }
        };
        TextFormatter hourFormatter = new TextFormatter((StringConverter)valueConverter, (Object)"0");
        TextFormatter minuteFormatter = new TextFormatter((StringConverter)valueConverter, (Object)"0");
        this.hourField = new NumericTextField(23);
        this.hourField.setOnKeyPressed(new RollingHandler(this.hourField, 23));
        this.hourField.setTextFormatter(hourFormatter);
        this.minuteField = new NumericTextField(59);
        this.minuteField.setOnKeyPressed(new RollingHandler(this.minuteField, 59));
        this.minuteField.setTextFormatter(minuteFormatter);
        Label separator = new Label(":");
        separator.setMaxHeight(Double.MAX_VALUE);
        HBox box = new HBox();
        box.getStyleClass().add((Object)"box");
        box.setFillHeight(true);
        box.getChildren().addAll((Object[])new Node[]{this.hourField, separator, this.minuteField});
        this.getChildren().add((Object)box);
        field.valueProperty().addListener(it -> {
            if (!this.updatingValue) {
                this.updateFields();
            }
        });
        this.updateFields();
        InvalidationListener updateValueListener = it -> {
            if (!this.updatingTextFields) {
                this.updateValue();
            }
        };
        this.hourField.textProperty().addListener(updateValueListener);
        this.minuteField.textProperty().addListener(updateValueListener);
    }

    private void updateFields() {
        this.updatingTextFields = true;
        try {
            TimeField timeField = (TimeField)this.getSkinnable();
            LocalTime localTime = timeField.getValue();
            if (localTime != null) {
                this.hourField.setText(Integer.toString(localTime.getHour()));
                this.minuteField.setText(Integer.toString(localTime.getMinute()));
            } else {
                this.hourField.setText("");
                this.minuteField.setText("");
            }
        }
        finally {
            this.updatingTextFields = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateValue() {
        this.updatingValue = true;
        try {
            int hour = 0;
            int minute = 0;
            try {
                hour = Math.max(0, Math.min(23, Integer.parseInt(this.hourField.getText())));
                minute = Math.max(0, Math.min(59, Integer.parseInt(this.minuteField.getText())));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            LocalTime oldTime = ((TimeField)this.getSkinnable()).getValue();
            LocalTime newTime = LocalTime.of(hour, minute);
            if (oldTime != null && newTime != null) {
                if (oldTime.getHour() != newTime.getHour() || oldTime.getMinute() != newTime.getMinute()) {
                    ((TimeField)this.getSkinnable()).setValue(newTime);
                }
            } else if (newTime == null) {
                ((TimeField)this.getSkinnable()).setValue(null);
            }
        }
        finally {
            this.updatingValue = false;
        }
    }

    public class NumericTextField
    extends TextField {
        public NumericTextField(int max) {
            this.setPrefColumnCount(2);
            this.focusedProperty().addListener(it -> {
                if (this.isFocused()) {
                    this.selectAll();
                }
            });
        }

        public void replaceText(int start, int end, String s) {
            super.replaceText(start, end, s.replaceAll("[^0-9]", ""));
        }

        public void replaceSelection(String s) {
            super.replaceSelection(s.replaceAll("[^0-9]", ""));
        }
    }

    public class RollingHandler
    implements EventHandler<KeyEvent> {
        private final int max;
        private final TextField field;

        public RollingHandler(TextField field, int max) {
            this.field = field;
            this.max = max;
        }

        public void handle(KeyEvent event) {
            switch (event.getCode()) {
                case UP: {
                    this.increment();
                    break;
                }
                case DOWN: {
                    this.decrement();
                    break;
                }
            }
        }

        private void increment() {
            int value = 0;
            try {
                value = Integer.parseInt(this.field.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (value < this.max) {
                ++value;
            } else if (((TimeField)TimeFieldSkin.this.getSkinnable()).isRollOver()) {
                value = 0;
            }
            if (value < 10) {
                this.field.setText("0" + value);
            } else {
                this.field.setText(Integer.toString(value));
            }
        }

        private void decrement() {
            int value = 0;
            try {
                value = Integer.parseInt(this.field.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (value > 0) {
                --value;
            } else if (((TimeField)TimeFieldSkin.this.getSkinnable()).isRollOver()) {
                value = this.max;
            }
            if (value < 10) {
                this.field.setText("0" + value);
            } else {
                this.field.setText(Integer.toString(value));
            }
        }
    }
}

