/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.view.WeekDayHeaderView;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.util.Callback;

public class WeekDayHeaderViewSkin
extends SkinBase<WeekDayHeaderView> {
    private static final String TODAY = "today";
    private final HBox hbox;
    private final List<InvalidationListener> listeners = new ArrayList<InvalidationListener>();

    public WeekDayHeaderViewSkin(WeekDayHeaderView view) {
        super((Control)view);
        this.hbox = new HBox();
        this.hbox.getStyleClass().add((Object)"container");
        this.getChildren().add((Object)this.hbox);
        InvalidationListener updateListener = it -> this.updateControl();
        view.numberOfDaysProperty().addListener(updateListener);
        view.showTodayProperty().addListener(updateListener);
        view.weekFieldsProperty().addListener(updateListener);
        view.enableHyperlinksProperty().addListener(updateListener);
        view.adjustToFirstDayOfWeekProperty().addListener(updateListener);
        this.updateControl();
    }

    private void updateControl() {
        this.hbox.getChildren().clear();
        WeekDayHeaderView view = (WeekDayHeaderView)this.getSkinnable();
        this.listeners.forEach(l -> view.dateProperty().removeListener(l));
        int numberOfDays = view.getNumberOfDays();
        Callback<WeekDayHeaderView, Region> separatorFactory = view.getSeparatorFactory();
        Callback<WeekDayHeaderView, WeekDayHeaderView.WeekDayHeaderCell> cellFactory = view.getCellFactory();
        for (int i = 0; i < numberOfDays; ++i) {
            Region separator;
            WeekDayHeaderView.WeekDayHeaderCell cell = (WeekDayHeaderView.WeekDayHeaderCell)((Object)cellFactory.call((Object)view));
            cell.setPrefWidth(1.0);
            int dayCount = i;
            InvalidationListener invalidationListener = evt -> this.updateCell(cell, dayCount);
            this.listeners.add(invalidationListener);
            view.dateProperty().addListener(invalidationListener);
            this.updateCell(cell, dayCount);
            HBox.setHgrow((Node)cell, (Priority)Priority.ALWAYS);
            this.hbox.getChildren().add((Object)cell);
            if (separatorFactory == null || i >= numberOfDays - 1 || (separator = (Region)separatorFactory.call((Object)view)) == null) continue;
            HBox.setHgrow((Node)separator, (Priority)Priority.NEVER);
            this.hbox.getChildren().add((Object)separator);
        }
    }

    private void updateCell(WeekDayHeaderView.WeekDayHeaderCell cell, int dayCount) {
        LocalDate startDate = ((WeekDayHeaderView)this.getSkinnable()).getDate();
        LocalDate date = this.getDate(startDate, dayCount);
        cell.setDate(date);
        if (((WeekDayHeaderView)this.getSkinnable()).isShowToday() && date.equals(((WeekDayHeaderView)this.getSkinnable()).getToday())) {
            if (!cell.getStyleClass().contains((Object)TODAY)) {
                cell.getStyleClass().add((Object)TODAY);
            }
        } else {
            cell.getStyleClass().remove((Object)TODAY);
        }
    }

    private LocalDate getDate(LocalDate startDate, int dayCount) {
        if (((WeekDayHeaderView)this.getSkinnable()).isAdjustToFirstDayOfWeek()) {
            LocalDate newStartDate = startDate.with(ChronoField.DAY_OF_WEEK, ((WeekDayHeaderView)this.getSkinnable()).getFirstDayOfWeek().getValue());
            startDate = newStartDate.isAfter(startDate) ? newStartDate.minusWeeks(1L) : newStartDate;
        }
        return startDate.plusDays(dayCount);
    }
}

