/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view.page;

import com.calendarfx.view.MonthSheetView;
import com.calendarfx.view.YearView;
import com.calendarfx.view.page.YearPage;
import impl.com.calendarfx.view.page.PageBaseSkin;
import javafx.scene.Node;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.StackPane;

public class YearPageSkin
extends PageBaseSkin<YearPage> {
    private YearView yearView;
    private MonthSheetView sheetView;
    private StackPane stackPane;

    public YearPageSkin(YearPage view) {
        super(view);
        view.addEventFilter(ScrollEvent.SCROLL, this::handleScroll);
        view.displayModeProperty().addListener(it -> this.updateVisibility());
        this.updateVisibility();
    }

    private void updateVisibility() {
        switch (((YearPage)this.getSkinnable()).getDisplayMode()) {
            case COLUMNS: {
                this.yearView.setManaged(false);
                this.yearView.setVisible(false);
                this.sheetView.setManaged(true);
                this.sheetView.setVisible(true);
                if (this.stackPane.getChildren().contains((Object)this.sheetView)) break;
                this.stackPane.getChildren().add((Object)this.sheetView);
                break;
            }
            case GRID: {
                this.yearView.setManaged(true);
                this.yearView.setVisible(true);
                this.sheetView.setManaged(false);
                this.sheetView.setVisible(false);
                if (this.stackPane.getChildren().contains((Object)this.yearView)) break;
                this.stackPane.getChildren().add((Object)this.yearView);
            }
        }
    }

    private void handleScroll(ScrollEvent evt) {
        YearPage yearPage = (YearPage)this.getSkinnable();
        double delta = evt.getDeltaX();
        if (delta == 0.0) {
            return;
        }
        if (delta < 0.0) {
            yearPage.goForward();
        } else if (delta > 0.0) {
            yearPage.goBack();
        }
    }

    @Override
    protected Node createContent() {
        this.stackPane = new StackPane();
        this.sheetView = ((YearPage)this.getSkinnable()).getMonthSheetView();
        this.sheetView.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.yearView = ((YearPage)this.getSkinnable()).getYearView();
        this.yearView.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        return this.stackPane;
    }
}

