/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view.print;

import com.calendarfx.view.Messages;
import com.calendarfx.view.print.OptionsView;
import com.calendarfx.view.print.ViewType;
import java.util.ArrayList;
import javafx.beans.property.Property;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.VBox;

public class OptionsViewSkin
extends SkinBase<OptionsView> {
    private final VBox container;
    private final CheckBox allDayEventsChk;
    private final CheckBox detailsChk;
    private final CheckBox timedEventsChk;
    private final CheckBox miniCalendarChk;
    private final CheckBox calendarKeysChk;
    private final CheckBox swimlaneLayoutChk;

    public OptionsViewSkin(OptionsView control) {
        super((Control)control);
        control.viewTypeProperty().addListener(obs -> this.layout());
        this.container = new VBox(5.0);
        this.allDayEventsChk = new CheckBox(Messages.getString("OptionsViewSkin.ALL_DAY_EVENTS_LABEL"));
        this.allDayEventsChk.selectedProperty().bindBidirectional((Property)control.showAllDayEntriesProperty());
        this.detailsChk = new CheckBox(Messages.getString("OptionsViewSkin.DETAILS_LABEL"));
        this.detailsChk.selectedProperty().bindBidirectional((Property)control.showEntryDetailsProperty());
        this.timedEventsChk = new CheckBox(Messages.getString("OptionsViewSkin.TIMED_EVENTS_LABEL"));
        this.timedEventsChk.selectedProperty().bindBidirectional((Property)control.showTimedEntriesProperty());
        this.miniCalendarChk = new CheckBox(Messages.getString("OptionsViewSkin.MINI_CALENDAR_LABEL"));
        this.miniCalendarChk.selectedProperty().bindBidirectional((Property)control.showMiniCalendarsProperty());
        this.calendarKeysChk = new CheckBox(Messages.getString("OptionsViewSkin.CALENDAR_KEYS_LABEL"));
        this.calendarKeysChk.selectedProperty().bindBidirectional((Property)control.showCalendarKeysProperty());
        this.swimlaneLayoutChk = new CheckBox(Messages.getString("OptionsViewSkin.SWIMLANE_LAYOUT_LABEL"));
        this.swimlaneLayoutChk.selectedProperty().bindBidirectional((Property)control.showSwimlaneLayoutProperty());
        this.layout();
        this.getChildren().add((Object)this.container);
    }

    private void layout() {
        ArrayList<CheckBox> children = new ArrayList<CheckBox>();
        if (((OptionsView)this.getSkinnable()).getViewType() == ViewType.DAY_VIEW) {
            children.add(this.allDayEventsChk);
            children.add(this.detailsChk);
            children.add(this.miniCalendarChk);
            children.add(this.calendarKeysChk);
            children.add(this.swimlaneLayoutChk);
        } else if (((OptionsView)this.getSkinnable()).getViewType() == ViewType.WEEK_VIEW) {
            children.add(this.allDayEventsChk);
            children.add(this.miniCalendarChk);
            children.add(this.calendarKeysChk);
            children.add(this.swimlaneLayoutChk);
        } else if (((OptionsView)this.getSkinnable()).getViewType() == ViewType.MONTH_VIEW) {
            children.add(this.allDayEventsChk);
            children.add(this.timedEventsChk);
            children.add(this.miniCalendarChk);
            children.add(this.calendarKeysChk);
        }
        this.container.getChildren().setAll(children);
    }
}

