/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.discovery;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.printer.SGD;
import com.zebra.sdk.printer.discovery.DiscoveryPacketDecodeException;
import com.zebra.sdk.printer.discovery.internal.DiscoveredPrinterNetworkFactory;
import com.zebra.sdk.settings.internal.JsonHelper;
import com.zebra.sdk.util.internal.Base64;
import java.util.Map;

public class DiscoveryUtil {
    private DiscoveryUtil() {
    }

    public static Map<String, String> parseDiscoveryPacket(String string) throws DiscoveryPacketDecodeException {
        if (string == null) {
            throw new DiscoveryPacketDecodeException("Unable to parse the supplied discovery packet due to an invalid discovery packet length");
        }
        byte[] byArray = null;
        if (JsonHelper.isValidJson(string)) {
            byArray = string.getBytes();
        } else {
            if (string.contains(":")) {
                string = string.substring(0, string.indexOf(58));
            }
            byArray = Base64.decode(string);
        }
        return DiscoveredPrinterNetworkFactory.getDiscoveredPrinterNetwork(byArray).getDiscoveryDataMap();
    }

    public static Map<String, String> getDiscoveryDataMap(Connection connection) throws DiscoveryPacketDecodeException, ConnectionException {
        return DiscoveryUtil.parseDiscoveryPacket(SGD.GET("ip.discovery_packet", connection));
    }
}

