/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.discovery.internal;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.zebra.sdk.printer.discovery.DiscoveredPrinter;
import com.zebra.sdk.printer.discovery.DiscoveredPrinterNetwork;
import com.zebra.sdk.printer.discovery.DiscoveryPacketDecodeException;
import com.zebra.sdk.printer.discovery.internal.DiscoveryPacketDecoderAdvanced;
import com.zebra.sdk.printer.discovery.internal.DiscoveryPacketDecoderLegacy;
import com.zebra.sdk.settings.internal.JsonHelper;
import java.util.LinkedHashMap;
import java.util.Map;

public class DiscoveredPrinterNetworkFactory {
    private static final int DISCOVERY_VERSION_OFFSET = 3;
    private static final int LEGACY_DISCOVERY_VERSION = 3;
    private static final int ADVANCED_DISCOVERY_VERSION = 4;

    private DiscoveredPrinterNetworkFactory() {
    }

    public static DiscoveredPrinterNetwork getDiscoveredPrinterNetwork(byte[] byArray) throws DiscoveryPacketDecodeException {
        DiscoveredPrinterNetwork discoveredPrinterNetwork = null;
        if (byArray == null || byArray.length <= 3) {
            throw new DiscoveryPacketDecodeException("Unable to parse the supplied discovery packet due to an invalid discovery packet length");
        }
        if (JsonHelper.isValidJson(byArray)) {
            discoveredPrinterNetwork = DiscoveredPrinterNetworkFactory.getDiscoveredPrinterFromJsonData(byArray);
        } else {
            int n = DiscoveredPrinterNetworkFactory.getDiscoveryVersionNumber(byArray);
            if (n == 3) {
                DiscoveryPacketDecoderLegacy discoveryPacketDecoderLegacy = new DiscoveryPacketDecoderLegacy(byArray);
                discoveredPrinterNetwork = discoveryPacketDecoderLegacy.getDiscoveredPrinterNetwork();
            } else if (n == 4) {
                DiscoveryPacketDecoderAdvanced discoveryPacketDecoderAdvanced = new DiscoveryPacketDecoderAdvanced(byArray);
                discoveredPrinterNetwork = discoveryPacketDecoderAdvanced.getDiscoveredPrinterNetworkAdvanced();
            } else {
                throw new DiscoveryPacketDecodeException("Unable to parse the supplied discovery packet due to an invalid discovery packet version");
            }
        }
        return discoveredPrinterNetwork;
    }

    private static DiscoveredPrinterNetwork getDiscoveredPrinterFromJsonData(byte[] byArray) throws DiscoveryPacketDecodeException {
        DiscoveredPrinterNetwork discoveredPrinterNetwork = null;
        Map<String, Object> map = DiscoveredPrinterNetworkFactory.getJsonDiscoData(byArray);
        if (map == null || map.isEmpty()) {
            throw new DiscoveryPacketDecodeException("Unable to parse the supplied discovery packet due to invalid discovery packet data");
        }
        if (!map.containsKey("version")) {
            throw new DiscoveryPacketDecodeException("Unable to parse the supplied discovery packet due to an invalid discovery packet version");
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (String string : map.keySet()) {
            Object object = map.get(string);
            linkedHashMap.put(string.toUpperCase(), String.valueOf(object));
        }
        if (linkedHashMap.containsKey("CARD_LINK_OS_VER")) {
            linkedHashMap.put("ADDRESS", (String)linkedHashMap.get("DISCO_IP"));
            linkedHashMap.put("PORT_NUMBER", (String)linkedHashMap.get("IP.PORT"));
            linkedHashMap.put("JSON_PORT_NUMBER", (String)linkedHashMap.get("IP.PORT_JSON_CONFIG"));
        }
        discoveredPrinterNetwork = new DiscoveredPrinterNetwork(linkedHashMap);
        return discoveredPrinterNetwork;
    }

    private static Map<String, Object> getJsonDiscoData(byte[] byArray) throws DiscoveryPacketDecodeException {
        Map map = null;
        try {
            Map map2 = (Map)new ObjectMapper().readValue(new String(byArray), (TypeReference)new TypeReference<Map<String, Map<String, Object>>>(){});
            map = (Map)map2.get("discovery");
        }
        catch (JsonMappingException jsonMappingException) {
            try {
                map = (Map)new ObjectMapper().readValue(new String(byArray), (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
            catch (Exception exception) {
                throw new DiscoveryPacketDecodeException(exception.getLocalizedMessage());
            }
        }
        catch (Exception exception) {
            throw new DiscoveryPacketDecodeException(exception.getLocalizedMessage());
        }
        return map;
    }

    private static int getDiscoveryVersionNumber(byte[] byArray) {
        int n = byArray[3];
        if (n < 0) {
            n += 256;
        }
        return n;
    }

    public static boolean isLinkOsPrinter(DiscoveredPrinter discoveredPrinter) {
        boolean bl = false;
        try {
            Map<String, String> map = discoveredPrinter.getDiscoveryDataMap();
            if (map != null) {
                String string = "0";
                if (map.containsKey("LINK_OS_MAJOR_VER")) {
                    string = map.get("LINK_OS_MAJOR_VER");
                } else if (map.containsKey("CARD_LINK_OS_VER")) {
                    String string2 = map.get("CARD_LINK_OS_VER");
                    string = string2.split("\\.")[0];
                }
                int n = Integer.parseInt(string);
                bl = n != 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }
}

