/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.discovery.internal;

import com.zebra.sdk.printer.discovery.DiscoveryException;
import com.zebra.sdk.printer.discovery.DiscoveryHandler;
import com.zebra.sdk.printer.discovery.internal.BroadcastA;
import com.zebra.sdk.printer.discovery.internal.ZebraDiscoSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

public class PrinterNameSearch
extends BroadcastA {
    public PrinterNameSearch(DiscoveryHandler discoveryHandler, List<String> list) throws DiscoveryException {
        this(discoveryHandler, list, 6000);
    }

    public PrinterNameSearch(DiscoveryHandler discoveryHandler, List<String> list, int n) throws DiscoveryException {
        super(n);
        if (discoveryHandler == null) {
            throw new DiscoveryException("A DiscoveryHandler must be supplied");
        }
        ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>();
        for (String string : list) {
            try {
                arrayList.add(InetAddress.getByName(string));
            }
            catch (UnknownHostException unknownHostException) {
                discoveryHandler.discoveryError("An invalid printer name/ip address was provided: " + string);
            }
        }
        this.broadcastIpAddresses = arrayList.toArray(new InetAddress[0]);
    }

    @Override
    protected void setSocketOptions(ZebraDiscoSocket zebraDiscoSocket) throws DiscoveryException {
    }
}

