/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.internal;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.zebra.sdk.printer.PrinterAlert;
import com.zebra.sdk.printer.internal.RestoreType;
import com.zebra.sdk.settings.SettingsException;
import com.zebra.sdk.util.internal.FileReader;
import com.zebra.sdk.util.internal.JacksonObjectMapperFactory;
import com.zebra.sdk.util.internal.StringUtilities;
import com.zebra.sdk.util.internal.ZipUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;

public class ProfileHelper {
    public static final String ALERTS_JSON_NAME = "alerts.json";
    public static final String SETTINGS_JSON_NAME = "settings.json";
    public static final String PROFILE_SUPPLEMENT_NAME = "profileSupplement.txt";
    public static final String FIRMWARE_FILE_NAME = "firmwareFile.txt";
    public static final String FIRMWARE_FILE_USER_SPECIFIED_NAME = "firmwareFileUserSpecifiedName.txt";

    public static Map<String, String> getSettingsFromProfile(String string) throws FileNotFoundException, IOException {
        String string2 = new ZipUtil(string).getEntryContents(SETTINGS_JSON_NAME);
        Map<String, String> map = StringUtilities.convertKeyValueJsonToMap(string2);
        return map;
    }

    public static void commitAlertsToProfile(String string, List<PrinterAlert> list) throws IOException {
        ProfileHelper.modifyProfile(string, new OurAlertsWriter(list));
    }

    public static void deleteFileFromProfile(String string, String string2) throws IOException {
        ProfileHelper.modifyProfile(string, new OurComponentDeleter(string2));
    }

    public static void modifyProfile(String string, ProfileComponentTransformer profileComponentTransformer) throws IOException {
        byte[] byArray = FileReader.toByteArray(string);
        File file = File.createTempFile("proftmp", null);
        FileOutputStream fileOutputStream = new FileOutputStream(file.getAbsolutePath());
        fileOutputStream.write(byArray);
        fileOutputStream.close();
        new File(string).delete();
        String string2 = file.getAbsolutePath();
        try {
            FileOutputStream fileOutputStream2 = new FileOutputStream(string);
            ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream2));
            ZipUtil zipUtil = new ZipUtil(string2);
            List<String> list = zipUtil.getEntryNames();
            for (String string3 : list) {
                byte[] byArray2 = profileComponentTransformer.shouldTransformComponent(string3) ? profileComponentTransformer.transformComponent() : zipUtil.extractEntry(string3);
                if (byArray2 == null || byArray2.length <= 0) continue;
                zipOutputStream.putNextEntry(new ZipEntry(string3));
                zipOutputStream.write(byArray2);
                zipOutputStream.closeEntry();
            }
            zipOutputStream.close();
            file.delete();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static String createJson(List<PrinterAlert> list) throws SettingsException {
        try {
            return JacksonObjectMapperFactory.getInstance().enable(SerializationFeature.INDENT_OUTPUT).writeValueAsString(list);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new SettingsException(jsonProcessingException.getLocalizedMessage());
        }
    }

    public static List<PrinterAlert> getAlertsFromJson(String string) throws FileNotFoundException, IOException {
        String string2 = new ZipUtil(string).getEntryContents(ALERTS_JSON_NAME);
        return ProfileHelper.getAlertsFromJsonData(string2);
    }

    public static List<PrinterAlert> getAlertsFromJsonData(String string) {
        TypeReference<List<PrinterAlert>> typeReference = new TypeReference<List<PrinterAlert>>(){};
        try {
            return (List)JacksonObjectMapperFactory.getInstance().readValue(string, (TypeReference)typeReference);
        }
        catch (JsonParseException jsonParseException) {
        }
        catch (JsonMappingException jsonMappingException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new ArrayList<PrinterAlert>();
    }

    public static boolean isSpecialProfileFile(String string) {
        return string.equals(SETTINGS_JSON_NAME) || string.equals(ALERTS_JSON_NAME) || string.equals(PROFILE_SUPPLEMENT_NAME) || string.equals(FIRMWARE_FILE_NAME) || string.equals(FIRMWARE_FILE_USER_SPECIFIED_NAME);
    }

    public static void handleSpecialCases(Map<String, String> map, RestoreType restoreType) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        String string = map.get("internal_wired.ip.protocol");
        boolean bl4 = bl3 = restoreType == RestoreType.ARCHIVE && string != null && string.equalsIgnoreCase("permanent");
        if (!bl3) {
            map.remove("internal_wired.ip.addr");
        }
        String string2 = map.get("wlan.ip.protocol");
        boolean bl5 = bl2 = restoreType == RestoreType.ARCHIVE && string2 != null && string2.equalsIgnoreCase("permanent");
        if (!bl2) {
            map.remove("ip.addr");
            map.remove("wlan.ip.addr");
        }
        String string3 = map.get("external_wired.ip.protocol");
        boolean bl6 = bl = restoreType == RestoreType.ARCHIVE && string3 != null && string3.equalsIgnoreCase("permanent");
        if (!bl) {
            map.remove("external_wired.ip.addr");
        }
    }

    static class OurAlertsWriter
    implements ProfileComponentTransformer {
        private List<PrinterAlert> myAlerts;

        public OurAlertsWriter(List<PrinterAlert> list) {
            this.myAlerts = list;
        }

        @Override
        public boolean shouldTransformComponent(String string) {
            return string.equals(ProfileHelper.ALERTS_JSON_NAME);
        }

        @Override
        public byte[] transformComponent() {
            try {
                return ProfileHelper.createJson(this.myAlerts).getBytes();
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    static interface ProfileComponentTransformer {
        public boolean shouldTransformComponent(String var1);

        public byte[] transformComponent();
    }

    static class OurComponentDeleter
    implements ProfileComponentTransformer {
        private String myDeleteSpecification;

        public OurComponentDeleter(String string) {
            this.myDeleteSpecification = string;
        }

        @Override
        public boolean shouldTransformComponent(String string) {
            return FilenameUtils.wildcardMatch((String)string, (String)this.myDeleteSpecification);
        }

        @Override
        public byte[] transformComponent() {
            return null;
        }
    }
}

