/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.util.fileConversion.internal;

import com.zebra.sdk.printer.internal.FirmwareUtil;
import com.zebra.sdk.util.fileConversion.internal.PrinterFileType;
import com.zebra.sdk.util.fileConversion.internal.PrinterWrappingType;
import com.zebra.sdk.util.fileConversion.internal.StreamDecoratorBase;
import com.zebra.sdk.util.internal.PrinterFileMetadata;
import com.zebra.sdk.util.internal.ZCRC16;
import com.zebra.sdk.util.internal.ZPLUtilities;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class MetadataExtractorPassthruStream
extends StreamDecoratorBase {
    private char crc16;
    private char sum;
    private long numberOfBytes = 0L;
    ByteArrayOutputStream headerBuffer = new ByteArrayOutputStream();

    public MetadataExtractorPassthruStream(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IOException("Input stream is null");
        }
        this.sourceStream = inputStream;
        this.crc16 = '\u0000';
        this.sum = '\u0000';
    }

    @Override
    public int read() throws IOException {
        int n = this.sourceStream.read();
        if (n > -1) {
            this.checkForHeader(n);
            ++this.numberOfBytes;
            this.sum = (char)(this.sum + n);
            this.crc16 = ZCRC16.addCrc16Byte_cpcl(this.crc16, n);
        }
        return n;
    }

    private void checkForHeader(int n) {
        if (!(this.headerBuffer.size() >= 200 || Character.isWhitespace(n) && this.headerBuffer.size() == 0)) {
            this.headerBuffer.write(n);
        }
    }

    @Override
    public PrinterFileMetadata getPrinterFileMetadata() {
        boolean bl;
        String string = String.format("%04X", this.crc16);
        String string2 = String.format("%04X", (this.sum ^ 0xFFFF) + 1);
        PrinterFileMetadata printerFileMetadata = new PrinterFileMetadata(this.numberOfBytes, string, string2);
        String string3 = this.headerBuffer.toString();
        printerFileMetadata.setPrinterWrappingType(this.getTypeToUnwrap(string3));
        boolean bl2 = bl = printerFileMetadata.getPrinterWrappingType() == PrinterWrappingType.DC;
        if (bl) {
            String string4 = this.extractFWVersionFromDCHeader(string3);
            printerFileMetadata.setFileName(string4);
            printerFileMetadata.setPrinterFileType(PrinterFileType.FIRMWARE);
        }
        return printerFileMetadata;
    }

    private PrinterWrappingType getTypeToUnwrap(String string) {
        PrinterWrappingType printerWrappingType = PrinterWrappingType.UNSUPPORTED;
        String string2 = string.toUpperCase().replace(ZPLUtilities.ZPL_INTERNAL_COMMAND_PREFIX, "~").trim();
        if (string2.startsWith("~DG")) {
            printerWrappingType = PrinterWrappingType.DG;
        } else if (string2.startsWith("~DY")) {
            printerWrappingType = PrinterWrappingType.DY;
        } else if (string2.startsWith("~DZ")) {
            printerWrappingType = PrinterWrappingType.DZ;
        } else if (string2.startsWith("! CISDFCRC16")) {
            printerWrappingType = PrinterWrappingType.CISDF;
        } else if (string2.startsWith("! CISDFRCRC16")) {
            printerWrappingType = PrinterWrappingType.CISDF;
        } else if (string2.contains("~DC")) {
            printerWrappingType = PrinterWrappingType.DC;
        } else if (string2.contains("<ZEBRA-OBJECT>")) {
            printerWrappingType = PrinterWrappingType.HZO;
        } else if (string2.startsWith("--") && string2.contains("CONTENT-DISPOSITION:")) {
            printerWrappingType = PrinterWrappingType.MPF;
        }
        return printerWrappingType;
    }

    private String extractFWVersionFromDCHeader(String string) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        return FirmwareUtil.extractFirmwareVersion(byteArrayInputStream);
    }
}

