/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.analysis;

import com.mxgraph.analysis.StructuralException;
import com.mxgraph.analysis.mxAnalysisGraph;
import com.mxgraph.analysis.mxGraphProperties;
import com.mxgraph.analysis.mxTraversal;
import com.mxgraph.costfunction.mxCostFunction;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGraphModel;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class mxGraphStructure {
    private static String basicVertexStyleString = "ellipse;strokeColor=black;fillColor=orange;gradientColor=none";
    private static String basicEdgeStyleString = "strokeColor=red;noEdgeStyle=1;";
    private static String basicArrowStyleString = "endArrow=block;";

    public static boolean isConnected(mxAnalysisGraph aGraph) {
        Object[] vertices = aGraph.getChildVertices(aGraph.getGraph().getDefaultParent());
        int vertexNum = vertices.length;
        if (vertexNum == 0) {
            throw new IllegalArgumentException();
        }
        int connectedVertices = 1;
        int[] visited = new int[vertexNum];
        visited[0] = 1;
        for (int i = 1; i < vertexNum; ++i) {
            visited[i] = 0;
        }
        ArrayList<Object> queue = new ArrayList<Object>();
        queue.add(vertices[0]);
        while (queue.size() > 0) {
            Object currVertex = queue.get(0);
            queue.remove(0);
            Object[] neighborVertices = aGraph.getOpposites(aGraph.getEdges(currVertex, null, true, true, false, true), currVertex, true, true);
            for (int j = 0; j < neighborVertices.length; ++j) {
                int index = 0;
                for (int k = 0; k < vertexNum; ++k) {
                    if (!vertices[k].equals(neighborVertices[j])) continue;
                    index = k;
                }
                if (visited[index] != 0) continue;
                queue.add(vertices[index]);
                visited[index] = 1;
                ++connectedVertices;
            }
        }
        return connectedVertices == vertexNum;
    }

    public static boolean isCyclicUndirected(mxAnalysisGraph aGraph) {
        mxGraph graph = aGraph.getGraph();
        mxIGraphModel model = graph.getModel();
        Object[] cells = model.cloneCells(aGraph.getChildCells(graph.getDefaultParent(), true, true), true);
        mxGraphModel modelCopy = new mxGraphModel();
        mxGraph graphCopy = new mxGraph(modelCopy);
        Object parentCopy = graphCopy.getDefaultParent();
        graphCopy.addCells(cells);
        mxAnalysisGraph aGraphCopy = new mxAnalysisGraph();
        aGraphCopy.setGraph(graphCopy);
        aGraphCopy.setGenerator(aGraph.getGenerator());
        aGraphCopy.setProperties(aGraph.getProperties());
        Object[] leaf = new Object[]{mxGraphStructure.getUndirectedLeaf(aGraphCopy)};
        do {
            if (leaf[0] == null) continue;
            graphCopy.removeCells(leaf);
        } while (leaf[0] != null);
        int vertexNum = aGraphCopy.getChildVertices(parentCopy).length;
        return vertexNum > 0;
    }

    private static Object getUndirectedLeaf(mxAnalysisGraph aGraph) {
        Object parent = aGraph.getGraph().getDefaultParent();
        for (Object currVertex : aGraph.getChildVertices(parent)) {
            int edgeCount = aGraph.getEdges(currVertex, parent, true, true, false, true).length;
            if (edgeCount > 1) continue;
            return currVertex;
        }
        return null;
    }

    public static boolean isSimple(mxAnalysisGraph aGraph) {
        Object parent = aGraph.getGraph().getDefaultParent();
        Object[] edges = aGraph.getChildEdges(parent);
        for (int i = 0; i < edges.length; ++i) {
            Object currEdge = edges[i];
            if (aGraph.getTerminal(currEdge, true) == aGraph.getTerminal(currEdge, false)) {
                return false;
            }
            for (int j = 0; j < edges.length; ++j) {
                Object currEdge2 = edges[j];
                if (currEdge == currEdge2) continue;
                if (aGraph.getTerminal(currEdge, true) == aGraph.getTerminal(currEdge2, true) && aGraph.getTerminal(currEdge, false) == aGraph.getTerminal(currEdge2, false)) {
                    return false;
                }
                if (aGraph.getTerminal(currEdge, true) != aGraph.getTerminal(currEdge2, false) || aGraph.getTerminal(currEdge, false) != aGraph.getTerminal(currEdge2, true)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isTree(mxAnalysisGraph aGraph) {
        return mxGraphStructure.isConnected(aGraph) && !mxGraphStructure.isCyclicUndirected(aGraph) && mxGraphStructure.isSimple(aGraph);
    }

    public static Object getLowestDegreeVertex(mxAnalysisGraph aGraph, Object[] omitVertex) {
        Object[] vertices = aGraph.getChildVertices(aGraph.getGraph().getDefaultParent());
        int vertexCount = vertices.length;
        int lowestEdgeCount = Integer.MAX_VALUE;
        Object bestVertex = null;
        List<Object> omitList = null;
        if (omitVertex != null) {
            omitList = Arrays.asList(omitVertex);
        }
        for (int i = 0; i < vertexCount; ++i) {
            if (omitVertex != null && omitList.contains(vertices[i])) continue;
            int currEdgeCount = aGraph.getEdges(vertices[i], null, true, true, true, true).length;
            if (currEdgeCount == 0) {
                return vertices[i];
            }
            if (currEdgeCount >= lowestEdgeCount) continue;
            lowestEdgeCount = currEdgeCount;
            bestVertex = vertices[i];
        }
        return bestVertex;
    }

    public static boolean areConnected(mxAnalysisGraph aGraph, Object sourceVertex, Object targetVertex) {
        Object[] currEdges = aGraph.getEdges(sourceVertex, aGraph.getGraph().getDefaultParent(), true, true, false, true);
        List<Object> neighborList = Arrays.asList(aGraph.getOpposites(currEdges, sourceVertex, true, true));
        return neighborList.contains(targetVertex);
    }

    public static void makeSimple(mxAnalysisGraph aGraph) {
        mxGraph graph = aGraph.getGraph();
        Object parent = graph.getDefaultParent();
        Object[] edges = aGraph.getChildEdges(parent);
        for (int i = 0; i < edges.length; ++i) {
            Object currEdge = edges[i];
            if (aGraph.getTerminal(currEdge, true) != aGraph.getTerminal(currEdge, false)) continue;
            graph.removeCells(new Object[]{currEdge});
        }
        edges = graph.getChildEdges(parent);
        HashSet vertexSet = new HashSet();
        ArrayList<Object> duplicateEdges = new ArrayList<Object>();
        for (int i = 0; i < edges.length; ++i) {
            Object currEdge = edges[i];
            Object source = aGraph.getTerminal(currEdge, true);
            Object target = aGraph.getTerminal(currEdge, false);
            HashSet<Object> currSet = new HashSet<Object>();
            currSet.add(source);
            currSet.add(target);
            if (vertexSet.contains(currSet)) {
                duplicateEdges.add(currEdge);
                continue;
            }
            vertexSet.add(currSet);
        }
        Object[] duplEdges = duplicateEdges.toArray();
        graph.removeCells(duplEdges);
    }

    public static void makeConnected(mxAnalysisGraph aGraph) {
        if (mxGraphStructure.isConnected(aGraph)) {
            return;
        }
        Object[][] components = mxGraphStructure.getGraphComponents(aGraph);
        int componentNum = components.length;
        if (componentNum < 2) {
            return;
        }
        mxGraph graph = aGraph.getGraph();
        Object parent = graph.getDefaultParent();
        for (int i = 1; i < componentNum; ++i) {
            Object sourceVertex = components[i - 1][(int)Math.round(Math.random() * (double)(components[i - 1].length - 1))];
            Object targetVertex = components[i][(int)Math.round(Math.random() * (double)(components[i].length - 1))];
            graph.insertEdge(parent, null, aGraph.getGenerator().getNewEdgeValue(aGraph), sourceVertex, targetVertex);
        }
    }

    public static Object[][] getGraphComponents(mxAnalysisGraph aGraph) {
        Object parent = aGraph.getGraph().getDefaultParent();
        Object[] vertices = aGraph.getChildVertices(parent);
        int vertexCount = vertices.length;
        if (vertexCount == 0) {
            return null;
        }
        ArrayList componentList = new ArrayList();
        ArrayList<Object> unvisitedVertexList = new ArrayList<Object>(Arrays.asList(vertices));
        boolean oldDirectedness = mxGraphProperties.isDirected(aGraph.getProperties(), mxGraphProperties.DEFAULT_DIRECTED);
        mxGraphProperties.setDirected(aGraph.getProperties(), false);
        while (unvisitedVertexList.size() > 0) {
            Object currVertex = unvisitedVertexList.remove(0);
            int componentCount = componentList.size();
            boolean isInComponent = false;
            for (int i = 0; i < componentCount; ++i) {
                if (!((ArrayList)componentList.get(i)).contains(currVertex)) continue;
                isInComponent = true;
            }
            if (isInComponent) continue;
            final ArrayList currVertexList = new ArrayList();
            mxTraversal.bfs(aGraph, currVertex, new mxGraph.mxICellVisitor(){

                @Override
                public boolean visit(Object vertex, Object edge) {
                    currVertexList.add(vertex);
                    return false;
                }
            });
            for (int i = 0; i < currVertexList.size(); ++i) {
                unvisitedVertexList.remove(currVertexList.get(i));
            }
            componentList.add(currVertexList);
        }
        mxGraphProperties.setDirected(aGraph.getProperties(), oldDirectedness);
        Object[][] result = new Object[componentList.size()][];
        for (int i = 0; i < componentList.size(); ++i) {
            result[i] = ((ArrayList)componentList.get(i)).toArray();
        }
        return result;
    }

    public static void makeTreeDirected(mxAnalysisGraph aGraph, Object startVertex) throws StructuralException {
        if (mxGraphStructure.isTree(aGraph)) {
            mxGraphProperties.setDirected(aGraph.getProperties(), false);
            final ArrayList bFSList = new ArrayList();
            mxGraph graph = aGraph.getGraph();
            mxIGraphModel model = graph.getModel();
            Object parent = graph.getDefaultParent();
            mxTraversal.bfs(aGraph, startVertex, new mxGraph.mxICellVisitor(){

                @Override
                public boolean visit(Object vertex, Object edge) {
                    bFSList.add(vertex);
                    return false;
                }
            });
            for (int i = 0; i < bFSList.size(); ++i) {
                Object parentVertex = bFSList.get(i);
                Object[] currEdges = aGraph.getEdges(parentVertex, parent, true, true, false, true);
                Object[] neighbors = aGraph.getOpposites(currEdges, parentVertex, true, true);
                for (int j = 0; j < neighbors.length; ++j) {
                    Object currVertex = neighbors[j];
                    int childIndex = bFSList.indexOf(currVertex);
                    if (childIndex <= i) continue;
                    Object currEdge = mxGraphStructure.getConnectingEdge(aGraph, parentVertex, currVertex);
                    model.setTerminal(currEdge, parentVertex, true);
                    model.setTerminal(currEdge, currVertex, false);
                }
            }
        } else {
            throw new StructuralException("The graph is not a tree");
        }
        mxGraphProperties.setDirected(aGraph.getProperties(), true);
        mxGraphStructure.setDefaultGraphStyle(aGraph, false);
    }

    public static Object getConnectingEdge(mxAnalysisGraph aGraph, Object vertexOne, Object vertexTwo) {
        mxIGraphModel model = aGraph.getGraph().getModel();
        Object[] edges = aGraph.getEdges(vertexOne, null, true, true, false, true);
        for (int i = 0; i < edges.length; ++i) {
            Object currEdge = edges[i];
            Object source = model.getTerminal(currEdge, true);
            Object target = model.getTerminal(currEdge, false);
            if (source.equals(vertexOne) && target.equals(vertexTwo)) {
                return currEdge;
            }
            if (!source.equals(vertexTwo) || !target.equals(vertexOne)) continue;
            return currEdge;
        }
        return null;
    }

    public static boolean isCyclicDirected(mxAnalysisGraph aGraph) {
        mxGraph graph = aGraph.getGraph();
        mxIGraphModel model = graph.getModel();
        Object[] cells = model.cloneCells(aGraph.getChildCells(graph.getDefaultParent(), true, true), true);
        mxGraphModel modelCopy = new mxGraphModel();
        mxGraph graphCopy = new mxGraph(modelCopy);
        Object parentCopy = graphCopy.getDefaultParent();
        graphCopy.addCells(cells);
        mxAnalysisGraph aGraphCopy = new mxAnalysisGraph();
        aGraphCopy.setGraph(graphCopy);
        aGraphCopy.setGenerator(aGraph.getGenerator());
        aGraphCopy.setProperties(aGraph.getProperties());
        Object[] leaf = new Object[]{mxGraphStructure.getDirectedLeaf(aGraphCopy, parentCopy)};
        do {
            if (leaf[0] == null) continue;
            graphCopy.removeCells(leaf);
        } while (leaf[0] != null);
        int vertexNum = aGraphCopy.getChildVertices(parentCopy).length;
        return vertexNum > 0;
    }

    public static Object getDirectedLeaf(mxAnalysisGraph aGraph, Object parent) {
        for (Object currVertex : aGraph.getChildVertices(parent)) {
            int inEdgeCount = aGraph.getEdges(currVertex, parent, true, false, false, true).length;
            int outEdgeCount = aGraph.getEdges(currVertex, parent, false, true, false, true).length;
            if (outEdgeCount != 0 && inEdgeCount != 0) continue;
            return currVertex;
        }
        return null;
    }

    public static void complementaryGraph(mxAnalysisGraph aGraph) {
        ArrayList oldConnections = new ArrayList();
        mxGraph graph = aGraph.getGraph();
        Object parent = graph.getDefaultParent();
        Object[] vertices = aGraph.getChildVertices(parent);
        int vertexCount = vertices.length;
        for (int i = 0; i < vertexCount; ++i) {
            mxCell currVertex = (mxCell)vertices[i];
            int edgeCount = currVertex.getEdgeCount();
            mxCell currEdge = new mxCell();
            ArrayList<mxCell> neighborVertexes = new ArrayList<mxCell>();
            for (int j = 0; j < edgeCount; ++j) {
                currEdge = (mxCell)currVertex.getEdgeAt(j);
                mxCell source = (mxCell)currEdge.getSource();
                mxCell destination = (mxCell)currEdge.getTarget();
                if (!source.equals(currVertex)) {
                    neighborVertexes.add(j, source);
                    continue;
                }
                neighborVertexes.add(j, destination);
            }
            oldConnections.add(i, neighborVertexes);
        }
        Object[] edges = aGraph.getChildEdges(parent);
        graph.removeCells(edges);
        for (int i = 0; i < vertexCount; ++i) {
            ArrayList oldNeighbors = new ArrayList();
            oldNeighbors = (ArrayList)oldConnections.get(i);
            mxCell currVertex = (mxCell)vertices[i];
            for (int j = 0; j < vertexCount; ++j) {
                mxCell targetVertex = (mxCell)vertices[j];
                boolean shouldConnect = true;
                if (oldNeighbors.contains(targetVertex)) {
                    shouldConnect = false;
                } else if (targetVertex.equals(currVertex)) {
                    shouldConnect = false;
                } else if (mxGraphStructure.areConnected(aGraph, currVertex, targetVertex)) {
                    shouldConnect = false;
                }
                if (!shouldConnect) continue;
                graph.insertEdge(parent, null, null, currVertex, targetVertex);
            }
        }
    }

    public static Object getVertexWithValue(mxAnalysisGraph aGraph, int value) {
        mxGraph graph = aGraph.getGraph();
        Object[] vertices = aGraph.getChildVertices(aGraph.getGraph().getDefaultParent());
        int childNum = vertices.length;
        int vertexValue = 0;
        mxCostFunction costFunction = aGraph.getGenerator().getCostFunction();
        mxGraphView view = graph.getView();
        for (int i = 0; i < childNum; ++i) {
            Object currVertex = vertices[i];
            vertexValue = (int)costFunction.getCost(new mxCellState(view, currVertex, null));
            if (vertexValue != value) continue;
            return currVertex;
        }
        return null;
    }

    public static void setDefaultGraphStyle(mxAnalysisGraph aGraph, boolean resetEdgeValues) {
        int i;
        mxGraph graph = aGraph.getGraph();
        Object parent = graph.getDefaultParent();
        Object[] vertices = aGraph.getChildVertices(parent);
        mxIGraphModel model = graph.getModel();
        for (int i2 = 0; i2 < vertices.length; ++i2) {
            model.setStyle(vertices[i2], basicVertexStyleString);
        }
        Object[] edges = aGraph.getChildEdges(parent);
        boolean isDirected = mxGraphProperties.isDirected(aGraph.getProperties(), mxGraphProperties.DEFAULT_DIRECTED);
        String edgeString = basicEdgeStyleString;
        edgeString = isDirected ? edgeString + basicArrowStyleString : edgeString + "endArrow=none";
        for (i = 0; i < edges.length; ++i) {
            model.setStyle(edges[i], edgeString);
        }
        if (resetEdgeValues) {
            for (i = 0; i < edges.length; ++i) {
                model.setValue(edges[i], null);
            }
            for (i = 0; i < edges.length; ++i) {
                model.setValue(edges[i], aGraph.getGenerator().getNewEdgeValue(aGraph));
            }
        }
    }

    public static int regularity(mxAnalysisGraph aGraph) throws StructuralException {
        mxGraph graph = aGraph.getGraph();
        Object[] vertices = aGraph.getChildVertices(graph.getDefaultParent());
        int vertexCount = vertices.length;
        Object currVertex = vertices[0];
        int regularity = aGraph.getEdges(currVertex, null, true, true).length;
        for (int i = 1; i < vertexCount; ++i) {
            currVertex = vertices[i];
            if (regularity == aGraph.getEdges(currVertex, null, true, true).length) continue;
            throw new StructuralException("The graph is irregular.");
        }
        return regularity;
    }

    public static int indegree(mxAnalysisGraph aGraph, Object vertex) {
        if (vertex == null) {
            throw new IllegalArgumentException();
        }
        if (mxGraphProperties.isDirected(aGraph.getProperties(), mxGraphProperties.DEFAULT_DIRECTED)) {
            return aGraph.getEdges(vertex, aGraph.getGraph().getDefaultParent(), true, false, true, true).length;
        }
        return aGraph.getEdges(vertex, aGraph.getGraph().getDefaultParent(), true, true, true, true).length;
    }

    public static int outdegree(mxAnalysisGraph aGraph, Object vertex) {
        if (mxGraphProperties.isDirected(aGraph.getProperties(), mxGraphProperties.DEFAULT_DIRECTED)) {
            return aGraph.getEdges(vertex, aGraph.getGraph().getDefaultParent(), false, true, true, true).length;
        }
        return aGraph.getEdges(vertex, aGraph.getGraph().getDefaultParent(), true, true, true, true).length;
    }

    public static boolean isCutVertex(mxAnalysisGraph aGraph, Object vertex) {
        mxGraph graph = aGraph.getGraph();
        mxIGraphModel model = graph.getModel();
        if (aGraph.getEdges(vertex, null, true, true, false, true).length >= 2) {
            Object[] cells = model.cloneCells(aGraph.getChildCells(graph.getDefaultParent(), true, true), true);
            mxGraphModel modelCopy = new mxGraphModel();
            mxGraph graphCopy = new mxGraph(modelCopy);
            graphCopy.addCells(cells);
            mxAnalysisGraph aGraphCopy = new mxAnalysisGraph();
            aGraphCopy.setGraph(graphCopy);
            aGraphCopy.setGenerator(aGraph.getGenerator());
            aGraphCopy.setProperties(aGraph.getProperties());
            Object newVertex = mxGraphStructure.getVertexWithValue(aGraphCopy, (int)aGraph.getGenerator().getCostFunction().getCost(new mxCellState(graph.getView(), vertex, null)));
            graphCopy.removeCells(new Object[]{newVertex}, true);
            Object[][] oldComponents = mxGraphStructure.getGraphComponents(aGraph);
            Object[][] newComponents = mxGraphStructure.getGraphComponents(aGraphCopy);
            if (newComponents.length > oldComponents.length) {
                return true;
            }
        }
        return false;
    }

    public static Object[] getCutVertices(mxAnalysisGraph aGraph) {
        ArrayList<Object> cutVertexList = new ArrayList<Object>();
        Object[] vertexes = aGraph.getChildVertices(aGraph.getGraph().getDefaultParent());
        int vertexNum = vertexes.length;
        for (int i = 0; i < vertexNum; ++i) {
            if (!mxGraphStructure.isCutVertex(aGraph, vertexes[i])) continue;
            cutVertexList.add(vertexes[i]);
        }
        return cutVertexList.toArray();
    }

    public static boolean isCutEdge(mxAnalysisGraph aGraph, Object edge) {
        mxGraph graph = aGraph.getGraph();
        mxIGraphModel model = graph.getModel();
        mxCostFunction costFunction = aGraph.getGenerator().getCostFunction();
        mxGraphView view = graph.getView();
        int srcValue = (int)costFunction.getCost(new mxCellState(view, aGraph.getTerminal(edge, true), null));
        int destValue = (int)costFunction.getCost(new mxCellState(view, aGraph.getTerminal(edge, false), null));
        if (aGraph.getTerminal(edge, false) != null || aGraph.getTerminal(edge, true) != null) {
            Object[] cells = model.cloneCells(aGraph.getChildCells(graph.getDefaultParent(), true, true), true);
            mxGraphModel modelCopy = new mxGraphModel();
            mxGraph graphCopy = new mxGraph(modelCopy);
            graphCopy.addCells(cells);
            mxAnalysisGraph aGraphCopy = new mxAnalysisGraph();
            aGraphCopy.setGraph(graphCopy);
            aGraphCopy.setGenerator(aGraph.getGenerator());
            aGraphCopy.setProperties(aGraph.getProperties());
            Object[] edges = aGraphCopy.getChildEdges(aGraphCopy.getGraph().getDefaultParent());
            Object currEdge = edges[0];
            mxCostFunction costFunctionCopy = aGraphCopy.getGenerator().getCostFunction();
            mxGraphView viewCopy = graphCopy.getView();
            int currSrcValue = (int)costFunctionCopy.getCost(new mxCellState(viewCopy, aGraphCopy.getTerminal(currEdge, true), null));
            int currDestValue = (int)costFunctionCopy.getCost(new mxCellState(viewCopy, aGraphCopy.getTerminal(currEdge, false), null));
            int i = 0;
            while (currSrcValue != srcValue || currDestValue != destValue) {
                currEdge = edges[++i];
                currSrcValue = Integer.parseInt((String)modelCopy.getValue(aGraphCopy.getTerminal(currEdge, true)));
                currDestValue = Integer.parseInt((String)modelCopy.getValue(aGraphCopy.getTerminal(currEdge, false)));
            }
            graphCopy.removeCells(new Object[]{currEdge}, true);
            Object[][] oldComponents = mxGraphStructure.getGraphComponents(aGraph);
            Object[][] newComponents = mxGraphStructure.getGraphComponents(aGraphCopy);
            if (newComponents.length > oldComponents.length) {
                return true;
            }
        }
        return false;
    }

    public static Object[] getCutEdges(mxAnalysisGraph aGraph) {
        ArrayList<Object> cutEdgeList = new ArrayList<Object>();
        Object[] edges = aGraph.getChildEdges(aGraph.getGraph().getDefaultParent());
        int edgeNum = edges.length;
        for (int i = 0; i < edgeNum; ++i) {
            if (!mxGraphStructure.isCutEdge(aGraph, edges[i])) continue;
            cutEdgeList.add(edges[i]);
        }
        return cutEdgeList.toArray();
    }

    public static Object[] getSourceVertices(mxAnalysisGraph aGraph) throws StructuralException {
        if (!mxGraphProperties.isDirected(aGraph.getProperties(), mxGraphProperties.DEFAULT_DIRECTED)) {
            throw new StructuralException("The graph is undirected, so it can't have source vertices.");
        }
        ArrayList<Object> sourceList = new ArrayList<Object>();
        Object[] vertices = aGraph.getChildVertices(aGraph.getGraph().getDefaultParent());
        for (int i = 0; i < vertices.length; ++i) {
            Object currVertex = vertices[i];
            Object[] outEdges = aGraph.getEdges(vertices[i], null, false, true, true, true);
            Object[] inEdges = aGraph.getEdges(vertices[i], null, true, false, true, true);
            if (inEdges.length != 0 || outEdges.length <= 0) continue;
            sourceList.add(currVertex);
        }
        return sourceList.toArray();
    }

    public static Object[] getSinkVertices(mxAnalysisGraph aGraph) throws StructuralException {
        if (!mxGraphProperties.isDirected(aGraph.getProperties(), mxGraphProperties.DEFAULT_DIRECTED)) {
            throw new StructuralException("The graph is undirected, so it can't have sink vertices.");
        }
        ArrayList<Object> sourceList = new ArrayList<Object>();
        Object[] vertices = aGraph.getChildVertices(aGraph.getGraph().getDefaultParent());
        for (int i = 0; i < vertices.length; ++i) {
            Object currVertex = vertices[i];
            Object[] outEdges = aGraph.getEdges(vertices[i], null, false, true, true, true);
            Object[] inEdges = aGraph.getEdges(vertices[i], null, true, false, true, true);
            if (inEdges.length <= 0 || outEdges.length != 0) continue;
            sourceList.add(currVertex);
        }
        return sourceList.toArray();
    }

    public static boolean isBiconnected(mxAnalysisGraph aGraph) {
        int edgeCount = aGraph.getChildEdges(aGraph.getGraph().getDefaultParent()).length;
        return mxGraphStructure.getCutVertices(aGraph).length == 0 && edgeCount >= 1;
    }
}

