/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.scene.layout.responsivepane;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import jfxtras.scene.layout.responsivepane.ResponsivePane;

public class Ref
extends StackPane {
    private final SimpleObjectProperty<String> toProperty = new SimpleObjectProperty((Object)this, "to", null);
    private ResponsivePane lResponsivePane = null;

    public Ref() {
        this.construct();
    }

    public Ref(String to) {
        this.setTo(to);
        this.construct();
    }

    public Ref(String to, String id) {
        this.setTo(to);
        this.setId(id);
        this.construct();
    }

    private void construct() {
        this.sceneProperty().addListener(observable -> {
            this.getChildren().clear();
            if (this.sceneProperty().get() != null) {
                this.pullRef();
            }
        });
    }

    public ObjectProperty<String> toProperty() {
        return this.toProperty;
    }

    public String getTo() {
        return (String)this.toProperty.getValue();
    }

    public void setTo(String value) {
        this.toProperty.setValue((Object)value);
    }

    public Ref withTo(String value) {
        this.setTo(value);
        return this;
    }

    void pullRef() {
        if (this.lResponsivePane == null) {
            Parent parent;
            for (parent = this.getParent(); parent != null && !(parent instanceof ResponsivePane); parent = parent.getParent()) {
            }
            this.lResponsivePane = (ResponsivePane)parent;
        }
        String lRefTo = this.getTo();
        Node lReferredNode = this.lResponsivePane.findResuableNode(lRefTo);
        if (this.lResponsivePane.getTrace().booleanValue()) {
            System.out.println("Ref " + this.getId() + " referring to " + lRefTo + " becomes " + lReferredNode);
        }
        this.getChildren().clear();
        if (lReferredNode != null) {
            this.getChildren().add((Object)lReferredNode);
        }
        if (!this.lResponsivePane.getDebug().booleanValue() && !this.lResponsivePane.getTrace().booleanValue()) {
            this.setStyle(null);
        } else {
            this.setStyle("-fx-border-color: red; -fx-border-width: 1; -fx-border-style: dashed;");
            Text label = new Text((String)(this.getId() == null ? "" : this.getId() + "->") + this.getTo());
            label.setStyle("-fx-fill:RED; -fx-effect: dropshadow(gaussian, WHITE, 3,1.0, 0,0);");
            label.setManaged(false);
            label.setLayoutX(3.0);
            label.setLayoutY(label.prefHeight(0.0));
            label.setMouseTransparent(true);
            this.getChildren().add((Object)label);
            Rectangle lClip = new Rectangle(0.0, -label.prefHeight(0.0), 0.0, 0.0);
            lClip.widthProperty().bind((ObservableValue)this.widthProperty().subtract((ObservableNumberValue)label.layoutXProperty()));
            lClip.heightProperty().bind((ObservableValue)this.heightProperty());
            label.setClip((Node)lClip);
        }
    }
}

