/*
 * Decompiled with CFR 0.152.
 */
package jcifs.pac.kerberos;

import java.io.IOException;
import javax.security.auth.kerberos.KerberosKey;
import jcifs.pac.ASN1Util;
import jcifs.pac.PACDecodingException;
import jcifs.pac.kerberos.KerberosApRequest;
import jcifs.pac.kerberos.KerberosTicket;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;

public class KerberosToken {
    private KerberosApRequest apRequest;

    public KerberosToken(byte[] token) throws PACDecodingException {
        this(token, null);
    }

    public KerberosToken(byte[] token, KerberosKey[] keys) throws PACDecodingException {
        byte[] content;
        Throwable throwable;
        ASN1InputStream stream;
        if (token.length <= 0) {
            throw new PACDecodingException("Empty kerberos token");
        }
        try {
            stream = new ASN1InputStream(token);
            throwable = null;
            try {
                content = ASN1Util.readUnparsedTagged(0, 32768, stream);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new PACDecodingException("Malformed kerberos token", e);
        }
        try {
            stream = new ASN1InputStream(content);
            throwable = null;
            try {
                ASN1ObjectIdentifier kerberosOid = (ASN1ObjectIdentifier)stream.readObject();
                if (!kerberosOid.getId().equals("1.2.840.113554.1.2.2")) {
                    throw new PACDecodingException("Not a kerberos token");
                }
                int read = 0;
                int readLow = stream.read() & 0xFF;
                int readHigh = stream.read() & 0xFF;
                read = (readHigh << 8) + readLow;
                if (read != 1) {
                    throw new PACDecodingException("Malformed kerberos token");
                }
                ASN1TaggedObject mechToken = ASN1Util.as(ASN1TaggedObject.class, stream.readObject());
                if (mechToken == null || mechToken.getTagClass() != 64 || !(mechToken.getBaseObject() instanceof ASN1Sequence)) {
                    throw new PACDecodingException("Malformed kerberos token");
                }
                this.apRequest = new KerberosApRequest((ASN1Sequence)mechToken.getBaseObject(), keys);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new PACDecodingException("Malformed kerberos token", e);
        }
    }

    public KerberosTicket getTicket() {
        return this.apRequest.getTicket();
    }

    public KerberosApRequest getApRequest() {
        return this.apRequest;
    }
}

